local assets =
{
    Asset("ANIM", "anim/nightmarestaff.zip"),
    Asset("ANIM", "anim/swap_nightmarestaff.zip"),
}

local prefabs =
{
    -- "ice_projectile",
    -- "fire_projectile",
    "staffcastfx",
	"stafflight",
    -- "staff_tornado",
    "cutgrass",
}

--------- STAFF-----------

local function onblink(staff, pos, caster)

    caster.components.inventory:ConsumeByName("nightmarefuel",1)
    if caster.components.sanity then
        caster.components.sanity:DoDelta(-TUNING.SANITY_MED)
    end

    -- staff.components.finiteuses:Use(1)

end

---------COMMON FUNCTIONS---------

-- local function onfinished(inst)
--     inst.SoundEmitter:PlaySound("dontstarve/common/gem_shatter")
--     inst:Remove()
-- end

local function unimplementeditem(inst)
    local player = GetPlayer()
    player.components.talker:Say(GetString(player.prefab, "ANNOUNCE_UNIMPLEMENTED"))
    if player.components.health.currenthealth > 1 then
        player.components.health:DoDelta(-player.components.health.currenthealth * 0.5)
    end

    if inst.components.useableitem then
        inst.components.useableitem:StopUsingItem()
    end
end


---------COLOUR SPECIFIC CONSTRUCTIONS---------

local function fn()

    local onequip = function(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_nightmarestaff", "orangestaff")
        -- owner.AnimState:OverrideSymbol("swap_object", "swap_staffs", colour.."staff")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")
    end

    local onunequip = function(inst, owner)
        owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
    end

    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    local sound = inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
    if SaveGameIndex:IsModeShipwrecked() then
    MakeInventoryFloatable(inst, "nightmarestaff_water", "nightmarestaff")  end

    anim:SetBank("nightmarestaff")
    anim:SetBuild("nightmarestaff")
    anim:PlayAnimation("nightmarestaff")
    -------
    -- inst:AddComponent("finiteuses")
    -- inst.components.finiteuses:SetOnFinished( onfinished )

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "nightmarestaff"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/nightmarestaff.xml"

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    -- local inst = commonfn("nightmare")

    inst.fxcolour = {1, 145/255, 0}
    inst.castsound = "dontstarve/common/staffteleport"

    inst:AddComponent("blinkstaff")
    inst.components.blinkstaff.onblinkfn = onblink

    inst:AddComponent("reticule")
    inst.components.reticule.targetfn = function()
        return inst.components.blinkstaff:GetBlinkPoint()
    end
    inst.components.reticule.ease = true

    inst.components.equippable.walkspeedmult = TUNING.CANE_SPEED_MULT

    -- inst.components.finiteuses:SetMaxUses(TUNING.ORANGESTAFF_USES)
    -- inst.components.finiteuses:SetUses(TUNING.ORANGESTAFF_USES)
    inst:AddTag("nopunch")

    return inst
end

if TUNING.LANGA == 0 then
    STRINGS.NAMES.NIGHTMARESTAFF = "暗影法杖"
    STRINGS.RECIPE_DESC.NIGHTMARESTAFF = "在梦魇中穿行"
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.NIGHTMARESTAFF = "咻咻咻！"
else
    STRINGS.NAMES.NIGHTMARESTAFF = "Nightmare Staff"
    STRINGS.RECIPE_DESC.NIGHTMARESTAFF = "Travel in the nightmare!"
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.NIGHTMARESTAFF = "???"
end

return Prefab("nightmarestaff", fn, assets, prefabs)