local assets =
{
    Asset("ANIM", "anim/armor_sanity.zip"),
}

local function OnBlocked(owner)
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_nightarmour")
end

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_body", "armor_sanity", "swap_body")
    inst:ListenForEvent("blocked", OnBlocked, owner)
end

local function onunequip(inst, owner)
    owner.AnimState:ClearOverrideSymbol("swap_body")
    inst:RemoveEventCallback("blocked", OnBlocked, owner)
end
local defenseNow = 0.8
local maxConNow = 1300
local sanReduceNow = 0
local getPersent = 0

local function update(inst)
    local armorlevel = math.max(0,math.min(2,inst.level))
    if inst.level == 0 then
        defenseNow = 0.8
        maxConNow = 1300
    elseif inst.level == 1 then
        defenseNow = 0.9
        maxConNow = 1050
    elseif inst.level == 2 then
        defenseNow = 0.95
        maxConNow = 800
    end
    sanReduceNow = ( armorlevel / 20 )

    getPersent = inst.components.armor:GetPercent()
    inst.components.armor:SetMaxCondition(maxConNow)
    inst.components.armor:SetAbsorption(defenseNow)
    inst.components.armor:SetCondition(maxConNow * getPersent)
end

local function ShouldAcceptItem( inst, item)
    local owner = item.components.inventoryitem:GetGrandOwner()
    if item.prefab == "nightmarefuel" then
        if inst.components.armor:GetPercent() < 1 then
        return true
        else
            if TUNING.LANGA == 0 then
                owner.components.talker:Say("这件防具已经修好了！")
            else
                owner.components.talker:Say("It has been repaired!")
            end
            return false
        end
    elseif item.prefab == "nightmare_darkgem" then
        if inst.level < 2 then
            if TUNING.LANGA == 0 then
                owner.components.talker:Say("它好像更加邪恶了！")
            else
                owner.components.talker:Say("It became darker.")
            end
            return true
        else
            if TUNING.LANGA == 0 then
                owner.components.talker:Say("这件防具已经不能再升级了！")
            else
                owner.components.talker:Say("It can't upgrade anymore!")
            end
            return false
        end
    elseif item.prefab == "nightmare_lightgem" then
        if inst.level > 0 then
            if TUNING.LANGA == 0 then
                owner.components.talker:Say("它好像更加洁净了！")
            else
                owner.components.talker:Say("It became cleaner.")
            end
            return true
        else
            if TUNING.LANGA == 0 then
                owner.components.talker:Say("这件防具已经不能再降级了！")
            else
                owner.components.talker:Say("It can't degrade anymore!")
            end
            return false
        end
    else
        if TUNING.LANGA == 0 then
            owner.components.talker:Say("这玩意儿不能拿来修防具！")
        else
            owner.components.talker:Say("Can't repair with this.")
        end
    end
    return false
end
local function OnGetItemFromPlayer( inst, giver, item )

    if item.prefab == "nightmare_darkgem" then
        if inst.level < 2 then
            inst.level = inst.level + 1
        end
    elseif item.prefab == "nightmare_lightgem" then
        if inst.level > 0 then
            inst.level = inst.level - 1
        end
    elseif item.prefab == "nightmarefuel" then
    end
        update(inst)
        local RepairCondition = math.min (200, (maxConNow * (1 - getPersent)))
        inst.components.armor:SetCondition(math.min(maxConNow, ((maxConNow * getPersent) + RepairCondition)))
        -- giver.components.sanity:DoDelta(0)
        inst.SoundEmitter:PlaySound("dontstarve/common/nightmareAddFuel")
end

-- end
local function OnTakeDamage(inst, damage_amount)
    local owner = inst.components.inventoryitem.owner
    if owner then
        local sanity = owner.components.sanity
        if sanity then
            sanReduceNow = (inst.level / 20 )
            local unsaneness = damage_amount * sanReduceNow
            sanity:DoDelta(-unsaneness, false)
        end
    end
end

local function FackArmor(inst)
    inst.components.armor:SetAbsorption(0)
    local owner = inst.components.inventoryitem.owner or nil
    -- if owner ~= nil then
    --     if TUNING.LANGA == 0 then
    --         owner.components.talker:Say("这件防具变得普通了")
    --     else
    --         owner.components.talker:Say("The Armor needs to refuel.")
    --     end
    -- end
end

local function onUseChange( inst, data )
    if data.percent > 0 then
        if inst.level == 0 then
            defenseNow = 0.8
        elseif inst.level == 1 then
            defenseNow = 0.9
        elseif inst.level == 2 then
            defenseNow = 0.95
        end
        inst.components.armor:SetAbsorption(defenseNow)
        inst.components.armor:SetMaxCondition(maxConNow)
    else
        FackArmor(inst)
    end
end

local function onload(inst, data)
    if data then
        if data.level then
            inst.level = data.level
            update(inst)
            -- --re-set these from the save data, because of load-order clipping issues
            -- if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
            -- if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
            -- if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
            -- inst.components.health:DoDelta(0)
            -- inst.components.hunger:DoDelta(0)
            -- inst.components.sanity:DoDelta(0)
        end
    end
end

local function onsave(inst, data)
    data.level = inst.level

end

local function fn(sim)
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    -- inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("armor_sanity")
    inst.AnimState:SetBuild("armor_sanity")
    inst.AnimState:PlayAnimation("anim")
    --inst.AnimState:SetMultColour(1, 1, 1, 0.6)

    inst:AddTag("sanity")

    inst.foleysound = "dontstarve/movement/foley/nightarmour"

    -- inst.entity:SetPristine()

    -- if not TheWorld.ismastersim then
    --     return inst
    -- end

    inst.level = 0

    inst:AddComponent("inspectable")

    inst:AddComponent("trader")
    inst.components.trader.acceptnontradable = true
    inst.components.trader.onaccept = OnGetItemFromPlayer
    inst.components.trader:SetAcceptTest(ShouldAcceptItem)

    inst:ListenForEvent("percentusedchange", onUseChange)
    -- inst:ListenForEvent("attacked", OnAttacked)


    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "realnightarmor"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/realnightarmor.xml"

    inst:AddComponent("armor")
    -- inst.components.armor:InitCondition(INITMAXCON, INITDEFENSE)
    inst.components.armor.ontakedamage = OnTakeDamage

    inst.components.armor:SetMaxCondition(1300)
    inst.components.armor:SetCondition(1300)
    inst.components.armor:SetPercent(1)
    inst.components.armor:SetAbsorption(0.8)

    -- inst:AddComponent("finiteuses")
    -- inst.components.finiteuses:SetMaxUses(maxConNow)
    -- inst.components.finiteuses:SetUses(maxConNow)

    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
    -- inst.components.equippable.dapperness = TUNING.CRAZINESS_SMALL
    if SaveGameIndex:IsModeShipwrecked() then
        inst.components.equippable.poisonblocker = true
    end

    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
    inst.components.inventoryitem.keepondeath = true

    update(inst)
    -- MakeHauntableLaunch(inst)

    inst.OnSave = onsave
    inst.OnLoad = onload
    inst.OnPreLoad = onload

    return inst
end

if TUNING.LANGA == 0 then
    STRINGS.NAMES.REALNIGHTARMOR = "真·影甲"
        -- STRINGS.NAMES.REALNIGHTSWORD = "真·影刀（Lv. "..swordlevel.."）"
    STRINGS.RECIPE_DESC.REALNIGHTARMOR = "在光与暗中徘徊的战甲"
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.REALNIGHTARMOR = "这是真实存在的吗？"
else
    STRINGS.NAMES.REALNIGHTARMOR = "Real Night Armor"
    -- STRINGS.NAMES.REALNIGHTSWORD = "Dark Gem (Lv. "..swordlevel..")"
    STRINGS.RECIPE_DESC.REALNIGHTARMOR = "Light and Dark bless you."
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.REALNIGHTARMOR = "Is it real?"
end

return Prefab("realnightarmor", fn, assets)