local assets =
{
    Asset("ANIM", "anim/nightmaresword.zip"),
    Asset("ANIM", "anim/swap_nightmaresword.zip"),

}

local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_nightmaresword", "swap_nightmaresword")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

local function update( inst )
    inst.components.weapon:SetDamage(60 * ( 1 + math.max(0,math.min(1,inst.components.finiteuses:GetPercent()))))
    inst.components.finiteuses:SetPercent(math.max(0,math.min(1,inst.components.finiteuses:GetPercent())))
end

local function onAttack( inst, attacker, target)
    if attacker and attacker.components.sanity then
      if inst.components.finiteuses:GetPercent() > 0 then
        attacker.components.sanity:DoDelta(-1 * ( inst.components.finiteuses:GetPercent()))
      end
    end
end
local function ShouldAcceptItem( inst, item)
    local owner = item.components.inventoryitem:GetGrandOwner()
    if item.prefab == "nightmarefuel" then
        if inst.components.finiteuses:GetPercent() < 1 then
        return true
        else
            if TUNING.LANGA == 0 then
                owner.components.talker:Say("这把刀已经修好了！")
            else
                owner.components.talker:Say("It's sharp enough now!")
            end
            return false
        end
    -- elseif item.prefab == "nightmare_darkgem" then
    --     if inst.level < 2 then
    --         if TUNING.LANGA == 0 then
    --             owner.components.talker:Say("它好像更加邪恶了！")
    --         else
    --             owner.components.talker:Say("It became darker.")
    --         end
    --         return true
    --     else
    --         if TUNING.LANGA == 0 then
    --             owner.components.talker:Say("这把刀已经不能再升级了！")
    --         else
    --             owner.components.talker:Say("It can't upgrade anymore!")
    --         end
    --         return false
    --     end
    -- elseif item.prefab == "nightmare_lightgem" then
        -- if inst.level > 0 then
        --     if TUNING.LANGA == 0 then
        --         owner.components.talker:Say("它好像更加洁净了！")
        --     else
        --         owner.components.talker:Say("It became cleaner.")
        --     end
        --     return true
        -- else
        --     if TUNING.LANGA == 0 then
        --         owner.components.talker:Say("这把刀已经不能再降级了！")
        --     else
        --         owner.components.talker:Say("It can't degrade anymore!")
        --     end
        --     return false
        -- end
    else
        if TUNING.LANGA == 0 then
            owner.components.talker:Say("这玩意儿不能拿来修刀！")
        else
            owner.components.talker:Say("Can't repair with this.")
        end
    end
    return false
end

local function OnGetItemFromPlayer( inst, giver, item )
    -- if item.prefab == "nightmare_darkgem" then
    --     if inst.level < 2 then
    --         inst.level = inst.level + 1
    --     end
    --     update(inst)
    --     inst.components.finiteuses:SetUses(maxUsesNow)
    --     return
    -- elseif item.prefab == "nightmare_lightgem" then
    --     if inst.level > 0 then
    --         inst.level = inst.level - 1
    --     end
    --     update(inst)
    --     inst.components.finiteuses:SetUses(maxUsesNow)
    --     return
    -- end
    inst.components.finiteuses:SetUses(math.min(100,(inst.components.finiteuses:GetUses()+20)))
    inst.components.finiteuses:SetPercent(math.max(0,math.min(1,inst.components.finiteuses:GetPercent())))
    update(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/nightmareAddFuel")
end
local function FackSword(inst)
    inst.components.weapon:SetDamage(10)
    local owner = inst.components.inventoryitem.owner or nil
    if owner ~= nil then
        if TUNING.LANGA == 0 then
            owner.components.talker:Say("这把刀变得普通了.")
        else
            owner.components.talker:Say("The Sword became dull.")
        end
    end
end
local function onUseChange( inst, data )
    if data.percent > 1 then
        inst.components.finiteuses:SetUses(100)
        inst.components.finiteuses:SetPercent(1)
    elseif data.percent < 0 then
        inst.components.finiteuses:SetUses(0)
        inst.components.finiteuses:SetPercent(0)
        data.percent = 0
    end

    if data.percent > 0 and data.percent <= 1 then
      inst.components.weapon:SetDamage(60 * ( 1 + data.percent))
    end

    if data.percent == 0 then
      FackSword(inst)
    end

end

local function onload(inst, data)
  if data then
    if data.level then
      inst.level = data.level
      update(inst)
    end
  end
end

local function onsave(inst, data)
  data.level = inst.level
end

local function fn(sim)
  local inst = CreateEntity()
  local trans = inst.entity:AddTransform()
  local anim = inst.entity:AddAnimState()

  MakeInventoryPhysics(inst)

  inst.AnimState:SetBank("nightmaresword")
  inst.AnimState:SetBuild("nightmaresword")
  inst.AnimState:PlayAnimation("idle")
  inst.AnimState:SetMultColour(1, 1, 1, 0.6)

  inst:AddTag("shadow")
  inst:AddTag("sharp")

  inst:AddComponent("weapon")
  inst.components.weapon:SetDamage(120)

  inst.components.weapon:SetOnAttack(onAttack)

  inst:AddComponent("inspectable")

  inst:AddComponent("trader")
  inst.components.trader.acceptnontradable = true
  inst.components.trader.onaccept = OnGetItemFromPlayer
  inst.components.trader:SetAcceptTest(ShouldAcceptItem)

  inst:ListenForEvent("percentusedchange", onUseChange)

  inst:AddComponent("inventoryitem")
  inst.components.inventoryitem.imagename = "realnightsword"
  inst.components.inventoryitem.atlasname = "images/inventoryimages/realnightsword.xml"

  inst:AddComponent("equippable")
  inst.components.equippable:SetOnEquip(onequip)
  inst.components.equippable:SetOnUnequip(onunequip)
  inst.components.inventoryitem.keepondeath = true

  inst:AddComponent("finiteuses")
  inst.components.finiteuses:SetMaxUses(100)
  inst.components.finiteuses:SetUses(100)
  inst.components.finiteuses:SetPercent(1)

  update(inst)

  inst.OnSave = onsave
  inst.OnLoad = onload
  inst.OnPreLoad = onload
  return inst
end

if TUNING.LANGA == 0 then
  STRINGS.NAMES.REALNIGHTSWORD = "真·影刀"
  STRINGS.RECIPE_DESC.REALNIGHTSWORD = "在光与暗中徘徊的武器"
  STRINGS.CHARACTERS.GENERIC.DESCRIBE.REALNIGHTSWORD = "这是真实存在的吗？"
else
  STRINGS.NAMES.REALNIGHTSWORD = "Real Night Sowrd"
  STRINGS.RECIPE_DESC.REALNIGHTSWORD = "Light and Dark bless you."
  STRINGS.CHARACTERS.GENERIC.DESCRIBE.REALNIGHTSWORD = "Is it real?"
end

return Prefab("realnightsword", fn, assets)