GLOBAL.setmetatable(env, { __index = function(t, k)
    return GLOBAL.rawget(GLOBAL, k)
end })

local SERVER_SIDE
local CLIENT_SIDE
if TheNet:GetIsServer() then
    SERVER_SIDE = true
    if not TheNet:IsDedicated() then
        CLIENT_SIDE = true
    end
elseif TheNet:GetIsClient() then
    SERVER_SIDE = false
    CLIENT_SIDE = true
end

PrefabFiles = {
    "multiple_roles"
}

Assets = {
    Asset("IMAGE", "images/mr_ghost.tex"),
    Asset("ATLAS", "images/mr_ghost.xml"),
}

if GetModConfigData("LANGUAGE") == 'en' then
    GLOBAL.STRINGS.RECIPE_DESC.SPIRIT_SPLIT = 'Find a new body!'
    GLOBAL.STRINGS.NAMES.SPIRIT_SPLIT = "Spirit Out"
    GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.NO_SPIRIT_BODY = 'There is no spirit in this body.'
    GLOBAL.STRINGS.NAMES.NO_SPIRIT_BODY = 'Body without spirit'
else
    GLOBAL.STRINGS.RECIPE_DESC.SPIRIT_SPLIT = '寻找一个新的肉体！'
    GLOBAL.STRINGS.NAMES.SPIRIT_SPLIT = "灵魂出窍"
    GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.NO_SPIRIT_BODY = '灵魂出窍了'
    GLOBAL.STRINGS.NAMES.NO_SPIRIT_BODY = '没有灵魂的身体'
end

local rec = AddRecipe("spirit_split", { Ingredient("moonrockidol", 1) }, RECIPETABS.MAGIC, TECH.CELESTIAL_ONE, nil, nil, nil, nil, nil, "images/mr_ghost.xml", "mr_ghost.tex")
rec.sortkey = 0.046799

AddAction("SPIRIT_IN", "灵魂附身", function(act)
    if act.target ~= nil and act.target.components.spirit_in ~= nil then
        return act.target.components.spirit_in:SpiritIn(act.doer, act.target)
    end
end)

AddComponentAction("SCENE", "spirit_in", function(_, _, actions, right)
    if right then
        table.insert(actions, ACTIONS.SPIRIT_IN)
    end
end)

AddStategraphActionHandler("wilson", GLOBAL.ActionHandler(GLOBAL.ACTIONS.SPIRIT_IN, "give"))
AddStategraphActionHandler("wilson_client", GLOBAL.ActionHandler(GLOBAL.ACTIONS.SPIRIT_IN, "give"))

AddPrefabPostInit("world", function(inst)
    if not TheWorld.ismastersim then
        return
    end
    inst:AddComponent("multiple_roles")
end)
