local MultipleRoles = Class(function(self, inst)
    self.inst = inst
    self.data = {}
    local component = self

    inst:ListenForEvent("ms_playerjoined", function(_, player)
        if component.data[player.userid] ~= nil then
            if player.LoadForReroll ~= nil then
                player:LoadForReroll(component.data[player.userid])
            end
            component.data[player.userid] = nil
        end
    end, TheWorld)
end)

function MultipleRoles:SaveRollData(player)
    self.data[player.userid] = player.SaveForReroll ~= nil and player:SaveForReroll() or nil
end

function MultipleRoles:OnSave()
    return self.data
end

function MultipleRoles:OnLoad(data)
    self.data = data or {}
end

return MultipleRoles
