require "prefabutil"

--local assets = {}

local function no_spirit_body_fn()
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddSoundEmitter()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
    inst.entity:AddDynamicShadow()
    inst.entity:AddMiniMapEntity()

    local physics = inst.entity:AddPhysics()
    physics:SetMass(0)
    physics:SetCollisionGroup(COLLISION.WORLD)
    physics:ClearCollisionMask()
    for k, v in pairs(COLLISION) do
        if k ~= "SANITY" then
            physics:CollidesWith(v)
        end
    end
    physics:SetCapsule(0.5, 2)

    inst.AnimState:SetBuild("wilson")
    inst.AnimState:SetBank("wilson")
    inst.AnimState:PlayAnimation("hit")
    inst.AnimState:Hide("ARM_carry")
    inst.AnimState:Hide("HAT")
    inst.AnimState:Hide("HAIR_HAT")
    inst.AnimState:Show("HAIR_NOHAT")
    inst.AnimState:Show("HAIR")
    inst.AnimState:Show("HEAD")
    inst.AnimState:Hide("HEAD_HAT")

    inst.DynamicShadow:SetSize(1.3, .6)

    inst.MiniMapEntity:SetIcon("wilson.png")
    inst.MiniMapEntity:SetPriority(10)
    inst.MiniMapEntity:SetCanUseCache(true)
    inst.MiniMapEntity:SetDrawOverFogOfWar(true)

    if not TheWorld.ismastersim then
        return inst
    end

    inst.record_data = nil
    inst.build_name = nil

    inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(6)
    inst.components.workable:SetOnWorkCallback(function(_inst)
        if _inst.record_data then
            _inst.SoundEmitter:PlaySound("dontstarve/characters/" .. _inst.record_data.prefab .. "/hurt")
        end
        _inst.AnimState:PlayAnimation("hit")
    end)
    inst.components.workable:SetOnFinishCallback(function(_inst)
        if _inst.record_data then
            _inst.SoundEmitter:PlaySound("dontstarve/characters/" .. _inst.record_data.prefab .. "/death_voice")
        end
        _inst.AnimState:PlayAnimation("death")
        _inst:ListenForEvent("animover", _inst.Remove)
    end)

    inst:AddComponent("inspectable")
    inst:AddComponent("spirit_in")

    inst.OnSave = function(_inst, data)
        data.record_data = _inst.record_data
        data.build_name = _inst.build_name
    end

    inst.OnLoad = function(_inst, data)
        _inst.record_data = data and data.record_data or nil
        _inst.build_name = data and data.build_name or nil
        if _inst.record_data then
            _inst.AnimState:SetBuild(_inst.build_name or _inst.record_data.prefab)
            if _inst.AnimState:GetBuild() ~= _inst.build_name then
                _inst.AnimState:SetBuild(_inst.record_data.prefab)
            end
            _inst.MiniMapEntity:SetIcon(_inst.record_data.prefab .. ".png")
        end
    end
    return inst
end

local function spirit_split_fn()
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst:AddTag("CLASSIFIED")
    inst.persists = false
    inst:DoTaskInTime(0, inst.Remove)
    if not TheWorld.ismastersim then
        return inst
    end
    inst.OnBuiltFn = function(_, builder)
        local body = SpawnPrefab('no_spirit_body')
        local x, _, z = builder:GetPosition():Get()
        body.Transform:SetPosition(x, 0, z)
        body.record_data = builder:GetSaveRecord()
        body.record_data.data.builder = {}
        body.build_name = builder.AnimState:GetBuild()
        body.AnimState:SetBuild(body.build_name or body.record_data.prefab)
        if body.AnimState:GetBuild() ~= body.build_name then
            body.AnimState:SetBuild(body.record_data.prefab)
        end
        body.MiniMapEntity:SetIcon(body.record_data.prefab .. ".png")
        TheWorld.components.multiple_roles:SaveRollData(builder)
        TheWorld:PushEvent("ms_playerdespawnanddelete", builder)
    end
    return inst
end

local multiple_roles_prefabs = {
    Prefab("no_spirit_body", no_spirit_body_fn, nil, {}),
    Prefab("spirit_split", spirit_split_fn, nil, {}),
}

return unpack(multiple_roles_prefabs)
-------------------------------------------------
