-- check out modinfo first.
TUNING.TUNGSTEN_SPEAR_USES = 200
TUNING.TUNGSTEN_SPEAR_DAMAGE = (GetModConfigData("tungsten_spear_DMG"))
TUNING.TUNGSTEN_AXE_DAMAGE = (GetModConfigData("tungsten_tools_DMG"))
TUNING.TUNGSTEN_AXE_USES=275 --Blaze it
TUNING.FIREBLADE_DAMAGE = (GetModConfigData("fireblade_DMG"))
TUNING.FIREBLADE_USES=250
TUNING.ARMORTUNGSTEN_ABSORPTION=0.90
TUNING.TUNGSTEN_PICKAXE_DAMAGE = (GetModConfigData("tungsten_tools_DMG"))
TUNING.TUNGSTEN_PICKAXE_USES=275 --Blaze it
TUNING.SHIRUKEN_DAMAGE=(GetModConfigData("shiruken_DMG"))
TUNING.TESLATRAP_DAMAGE=(GetModConfigData("teslatrap_DMG"))
TUNING.TRAP_TESLA_RADIUS = TUNING.TRAP_TEETH_RADIUS*1.5

PrefabFiles = 
{
	"additional_walls",
	"energy_fire",
	"tungstenore",
	"tungsten_spear",
	"rock_tough",
	"tungsten_firepit",
	"tungsten_axe",
	"armor_tungsten",
	"fireblade",
	"tungsten_pickaxe",
	"tungsten_spear_projectile",
	"tungsten_hardhat",
	"thermal_tetrahedron",
	"shiruken",
	"trap_tesla",
}

Assets = 
{
	Asset("ATLAS", "tungstenimages/inventoryimages.xml"),
	Asset("ATLAS", "tungstenimages/minimapicons.xml"),
}

--Please don't get confused. If you've got any question about modding, just ask on the Steamworkshop page, if I've got some spare time, I don't mind helping anyone with LUA or modding in general

local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local TECH = GLOBAL.TECH

GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.TUNGSTEN_SPEAR = "It looks so sharp"
GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.TUNGSTEN_SPEAR="C HOW # IT IS?"
GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.TUNGSTEN_SPEAR = "This is better than some flint weapon!"
GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.TUNGSTEN_SPEAR = "I feel like impaling something..."
GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.TUNGSTEN_SPEAR = "It's not like I'd need this thing"
GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.TUNGSTEN_SPEAR = "Would be better if it burned, though"

GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.TUNGSTENORE = "What a tough stone"
GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.TUNGSTENORE="HARDNESS > 8"
GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.TUNGSTENORE = "Tungsten... also referred to as Wolfram"
GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.TUNGSTENORE = "It's harder than all the other rocks"
GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.TUNGSTENORE = "Hard materials for a hard man"
GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.TUNGSTENORE = "Time to create something dangerous with it"

GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.ROCK_TOUGH = "Is it better than gold?"
GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.ROCK_TOUGH="HARD ROCK CONTAINS HEAVY METAL"
GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.ROCK_TOUGH = "Where have I seen this kind of boulders before..?"
GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.ROCK_TOUGH = "Let's smash it into pieces"
GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.ROCK_TOUGH = "Not as tough as me!"
GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.ROCK_TOUGH = "These look kind of funny"

GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.TUNGSTEN_FIREPIT = "This makes me wonder if I could harness the power of the sun..."
GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.TUNGSTEN_FIREPIT="WARNING! TEMPERATURE ON CONSTANT HIGH LEVEL!"
GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.TUNGSTEN_FIREPIT = "This fire seems to be highly effecient."
GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.TUNGSTEN_FIREPIT = "A portal to Hell!"
GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.TUNGSTEN_FIREPIT = "Fire makes my muscles weep! Is good!"
GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.TUNGSTEN_FIREPIT = "That's a little hot even for ME!"

GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.TUNGSTEN_AXE ="Made from 50% real Treeguard!" 
GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.TUNGSTEN_AXE="RUN COMMAND; DEFORESTATION.EXE"
GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.TUNGSTEN_AXE = "Not Environmentally Friendly"
GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.TUNGSTEN_AXE = "Everything dies eventually. Even Trees."
GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.TUNGSTEN_AXE = "Wood is WEAK, I am MIGHTY!"
GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.TUNGSTEN_AXE = "Where do Trees go when they die? ON THE FIRE!"

GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.ARMOR_TUNGSTEN ="Hmm, so safety can be cool? Who knew!"
GLOBAL.STRINGS.CHARACTERS.WX78.DESCRIBE.ARMOR_TUNGSTEN="THE COLD IS IRRELEVANT"
GLOBAL.STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.ARMOR_TUNGSTEN = "A low temperature protective device"
GLOBAL.STRINGS.CHARACTERS.WENDY.DESCRIBE.ARMOR_TUNGSTEN = "Cold deep inside, like Abigail."
GLOBAL.STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.ARMOR_TUNGSTEN = "Stay Safe, Stay Cool, Stay MIGHTY!"
GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.ARMOR_TUNGSTEN = "Safe AND Cold, That's no fun!"

GLOBAL.STRINGS.CHARACTERS.WILLOW.DESCRIBE.FIREBLADE = "I don't mind the heat"

GLOBAL.STRINGS.NAMES.TUNGSTEN_SPEAR = "Tungsten Spear"
GLOBAL.STRINGS.RECIPE_DESC.TUNGSTEN_SPEAR = "Forged in fire"

GLOBAL.STRINGS.NAMES.THERMAL_TETRAHEDRON = "Thermal Tetrahedron"
GLOBAL.STRINGS.RECIPE_DESC.THERMAL_TETRAHEDRON = "Best way to store energy"

GLOBAL.STRINGS.NAMES.SHIRUKEN = "Batarang"
GLOBAL.STRINGS.RECIPE_DESC.SHIRUKEN = "High damage single use weapon"

GLOBAL.STRINGS.NAMES.TUNGSTENORE = "Tungsten Nugget"
GLOBAL.STRINGS.RECIPE_DESC.TUNGSTENORE = "Metallic Material"

GLOBAL.STRINGS.NAMES.ROCK_TOUGH = "Tough Stone"

GLOBAL.STRINGS.NAMES.TUNGSTEN_FIREPIT = "Tungsten Firepit"
GLOBAL.STRINGS.RECIPE_DESC.TUNGSTEN_FIREPIT = "Improved Firepit that gives off more heat"

GLOBAL.STRINGS.NAMES.TUNGSTEN_AXE = "Corrupt Cutter"
GLOBAL.STRINGS.RECIPE_DESC.TUNGSTEN_AXE = "It hates Trees"

GLOBAL.STRINGS.NAMES.ARMOR_TUNGSTEN = "Zero Kelvin Suit"
GLOBAL.STRINGS.RECIPE_DESC.ARMOR_TUNGSTEN = "Cold as deep space"

GLOBAL.STRINGS.NAMES.FIREBLADE = "Fire Fleur"
GLOBAL.STRINGS.RECIPE_DESC.FIREBLADE = "Might be too hot for you"

GLOBAL.STRINGS.NAMES.WALL_TUNGSTEN_ITEM = "Tungsten Wall"
GLOBAL.STRINGS.RECIPE_DESC.WALL_TUNGSTEN_ITEM = "Better protection for your Base"

GLOBAL.STRINGS.NAMES.WALL_TUNGSTEN = "Tungsten Wall"

GLOBAL.STRINGS.NAMES.TUNGSTEN_PICKAXE = "Infiniminer"
GLOBAL.STRINGS.RECIPE_DESC.TUNGSTEN_PICKAXE = "Feasts upon the blood of your foes"

GLOBAL.STRINGS.NAMES.TUNGSTEN_HARDHAT = "Tungsten Hardhat"
GLOBAL.STRINGS.RECIPE_DESC.TUNGSTEN_HARDHAT = "Burns your nightmares"

GLOBAL.STRINGS.NAMES.TRAP_TESLA = "Tesla Trap"
GLOBAL.STRINGS.RECIPE_DESC.TRAP_TESLA = "Efficient base defense"

AddMinimapAtlas("tungstenimages/minimapicons.xml")

--were doing this so we dont have to type out the image path for each recipe but rather just change the amount
local tungsten = Ingredient("tungstenore", 1, "tungstenimages/inventoryimages.xml")
local tungsten2 = Ingredient("tungstenore", 2, "tungstenimages/inventoryimages.xml")
local tungsten3 = Ingredient("tungstenore", 3, "tungstenimages/inventoryimages.xml")
local tungsten4 = Ingredient("tungstenore", 4, "tungstenimages/inventoryimages.xml")
local tungsten5 = Ingredient("tungstenore", 5, "tungstenimages/inventoryimages.xml")
local tungsten6 = Ingredient("tungstenore", 6, "tungstenimages/inventoryimages.xml")

AddRecipe("tungsten_spear", {Ingredient("twigs", 3), Ingredient("rope", 1), tungsten2}, RECIPETABS.WAR, TECH.SCIENCE_TWO, nil, nil, nil, nil, nil, "tungstenimages/inventoryimages.xml")

AddRecipe("tungsten_axe", {Ingredient("axe", 1), Ingredient("livinglog", 1), tungsten4}, RECIPETABS.TOOLS, TECH.MAGIC_TWO, nil, nil, nil, nil, nil, "tungstenimages/inventoryimages.xml")

AddRecipe("armor_tungsten", {Ingredient("bluegem", 1), Ingredient("ice", 4), tungsten5}, RECIPETABS.WAR, TECH.MAGIC_TWO, nil, nil, nil, nil, nil, "tungstenimages/inventoryimages.xml")

AddRecipe("fireblade", {Ingredient("heatrock", 1), tungsten4, Ingredient("redgem", 1)}, RECIPETABS.WAR, TECH.MAGIC_TWO, nil, nil, nil, nil, nil, "tungstenimages/inventoryimages.xml")

AddRecipe("wall_tungsten_item", {Ingredient("cutstone", 2), tungsten3}, RECIPETABS.TOWN, TECH.SCIENCE_TWO, nil, nil, nil, 4, nil, "tungstenimages/inventoryimages.xml")

AddRecipe("tungsten_pickaxe", {Ingredient("pickaxe", 1), Ingredient("livinglog", 1), tungsten4}, RECIPETABS.TOOLS, TECH.MAGIC_TWO, nil, nil, nil, nil, nil, "tungstenimages/inventoryimages.xml")

AddRecipe("tungsten_hardhat", {Ingredient("minerhat", 1), tungsten4, Ingredient("purplegem", 1)}, RECIPETABS.LIGHT, TECH.SCIENCE_TWO, nil, nil, nil, nil, nil, "tungstenimages/inventoryimages.xml")

AddRecipe("thermal_tetrahedron", {Ingredient("heatrock", 1), tungsten6, Ingredient("purplegem", 1)}, RECIPETABS.SURVIVAL, TECH.MAGIC_TWO, nil, nil, nil, nil, nil, "tungstenimages/inventoryimages.xml", "tetrahedron3.tex")

AddRecipe("shiruken", {Ingredient("batwing", 1), Ingredient("goldnugget", 2), tungsten2}, RECIPETABS.WAR, TECH.SCIENCE_TWO, nil, nil, nil, 6, nil, "tungstenimages/inventoryimages.xml")

AddRecipe("trap_tesla", {Ingredient("lightninggoathorn", 1), tungsten6, Ingredient("transistor", 3)}, RECIPETABS.WAR, TECH.MAGIC_THREE, nil, nil, nil, nil, nil, "tungstenimages/inventoryimages.xml")

AddRecipe("tungsten_firepit", {tungsten6, Ingredient("boards", 3), Ingredient("redgem", 2)}, RECIPETABS.LIGHT, TECH.SCIENCE_TWO, "tungsten_firepit_placer", nil, nil, nil, nil, "tungstenimages/inventoryimages.xml")

--prefab migration
--this will convert the old "tungsten" spear with the new "tungsten_spear" spear
local old_SpawnPrefab = GLOBAL.SpawnPrefab
GLOBAL.SpawnPrefab = function(name, skin, skin_id, creator)
	return old_SpawnPrefab(name == "tungsten" and "tungsten_spear" or name, skin, skin_id, creator)
end

-- OK, listen: The following code was copied from "Throwable Spears". My modifications are minor. This is supposed to enable compatibility with Throwable Spears.
-- I do not claim the following code to be my own code, it's just there to assure compatibility!
if GLOBAL.KnownModIndex:IsModEnabled(GLOBAL.KnownModIndex:GetModActualName("Throwable Spears")) then
	local SMALL_MISS_CHANCE =  GLOBAL.GetModConfigData("SMALL_MISS_CHANCE", GLOBAL.KnownModIndex:GetModActualName("Throwable Spears"))
	local SMALL_USES =  GLOBAL.GetModConfigData("SMALL_USES", GLOBAL.KnownModIndex:GetModActualName("Throwable Spears"))
	local LARGE_USES =  GLOBAL.GetModConfigData("LARGE_USES", GLOBAL.KnownModIndex:GetModActualName("Throwable Spears"))
	local RANGE_CHECK =  GLOBAL.GetModConfigData("RANGE_CHECK", GLOBAL.KnownModIndex:GetModActualName("Throwable Spears"))

	local smallhits =
	{
		frog = true,
		penguin = true,
		eyeplant = true,
	}

	local function spearthrow_onattack(inst, attacker, target, skipsanity)
	    local smalltarget = target:HasTag("smallcreature")
	                and not target:HasTag("spider")
	                and not smallhits[target.prefab]
	    local missed = false
	    local spear = GLOBAL.SpawnSaveRecord(inst._spear)
	    spear.Transform:SetPosition(inst:GetPosition():Get())
	    if math.random() < SMALL_MISS_CHANCE and smalltarget then
	        missed = true
	        if attacker.components and attacker.components.talker then
	            local miss_message = "Ugh, I don't think I can hit something that small!"
	            if attacker.prefab == 'wx78' then miss_message = "INSUFFICIENT ACCURACY" end
	            attacker.components.talker:Say(miss_message)
	            target:PushEvent("attacked", {attacker = attacker, damage = 0, weapon = spear})
	        end
	    else
	        if target.components.combat then
	            spear.projectile = true
	            target.components.combat:GetAttacked(attacker, attacker.components.combat:CalcDamage(target, spear), spear)
	        end			
	    end
	    if spear.components.finiteuses then
	        spear.components.finiteuses:Use((smalltarget and not missed)
	            and GLOBAL.TUNING.SPEAR_USES/SMALL_USES
	            or GLOBAL.TUNING.SPEAR_USES/LARGE_USES)
	    end
	    spear:AddTag("scarytoprey")
	    spear:DoTaskInTime(1, function(inst) inst:RemoveTag("scarytoprey") end)
	    inst:Remove()

	    attacker.SoundEmitter:PlaySound("dontstarve/wilson/attack_weapon", nil, nil, true)
	end

	AddPrefabPostInit("tungsten_spear", function(inst)
		if not GLOBAL.TheWorld.ismastersim then return end
		
		inst:AddComponent('spearthrowable')
		inst.components.spearthrowable:SetRange(8, 10)
		inst.components.spearthrowable:SetOnAttack(spearthrow_onattack)
		inst.components.spearthrowable:SetProjectile("tungsten_spear_projectile")
	end)
end