local assets =
{
	Asset("ANIM", "anim/armor_tungsten.zip"),
}

local function OnBlocked(owner) 
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_armour") 
end

local function freezefn(attacked,data)
	if data and data.attacker and data.attacker.components.freezable then
        data.attacker.components.freezable:AddColdness(0.6)
        data.attacker.components.freezable:SpawnShatterFX()
    end 
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_body", "armor_tungsten", "swap_body")

    inst:ListenForEvent("attacked", freezefn, owner)
	
    inst:ListenForEvent("blocked", OnBlocked, owner)
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
    inst:RemoveEventCallback("blocked", OnBlocked, owner)
	inst:RemoveEventCallback("attacked", freezefn, owner)
end

local function fn()
	local inst = CreateEntity()
    
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("armor_ruins")
    inst.AnimState:SetBuild("armor_tungsten")
    inst.AnimState:PlayAnimation("anim")
	
	inst:AddComponent("heater")
    inst.components.heater.iscooler = true
	inst.components.heater.carriedheat=TUNING.BLUEGEM_COOLER
    inst.components.heater.equippedheat = TUNING.BLUEGEM_COOLER*3
    
    inst:AddTag("metal")

    inst.foleysound = "dontstarve/movement/foley/metalarmour"
    
    if not TheWorld.ismastersim then
        return inst
    end

    inst.entity:SetPristine()
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "tungstenimages/inventoryimages.xml"
    
    inst:AddComponent("armor")
    inst.components.armor:InitCondition(2100, TUNING.ARMORTUNGSTEN_ABSORPTION)
    
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY
	inst.components.equippable.walkspeedmult = 0.8
    
    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    MakeHauntableLaunch(inst)
    
    return inst
end

return Prefab("common/inventory/armor_tungsten", fn, assets)