require "prefabutil"

local assets =
{
	Asset("ANIM", "anim/rock_tough.zip"),
}

local prefabs =
{
    "rocks",
	"tungstenore",
	"flint",
}    

SetSharedLootTable( 'rock_tough',
{
    {'rocks',  1.00},
    {'rocks',  1.00},
    {'rocks',  1.00},
    {'tungstenore',  1.00},
    {'flint',  1.00},
    {'tungstenore',  0.25},
    {'flint',  0.60},
})

local MAXWORK = 10
local MEDIUM  = 6
local LOW     = 3

local function CurrentlyWorking(inst, worker, workleft)
    local pt = Point(inst.Transform:GetWorldPosition())
		if workleft <= 0 then
			inst.SoundEmitter:PlaySound("dontstarve/wilson/rock_break")
			inst.components.lootdropper:DropLoot(pt)
			inst:Remove()
    elseif workleft < TUNING.ROCKS_MINE / 3 then
        inst.AnimState:PlayAnimation("low")
    elseif workleft < TUNING.ROCKS_MINE * 2 / 3 then
        inst.AnimState:PlayAnimation("med")
    else
        inst.AnimState:PlayAnimation("full")
    end
end

local function prerock_fn(bank, build, anim, icon)
--entirely copied from rocks.lua
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    inst.entity:AddMiniMapEntity()
    inst.entity:AddNetwork()
	
	MakeObstaclePhysics(inst, 1)

    inst.MiniMapEntity:SetIcon(icon or "rock_tough.tex")

    inst.AnimState:SetBank(bank)
    inst.AnimState:SetBuild(build)
    inst.AnimState:PlayAnimation(anim)

    MakeSnowCoveredPristine(inst)

    if not TheWorld.ismastersim then
        return inst
    end

    inst.entity:SetPristine()

	inst:AddComponent("lootdropper") 
	
	inst:AddComponent("workable")
	inst.components.workable:SetWorkAction(ACTIONS.MINE)
	inst.components.workable:SetWorkLeft(TUNING.ROCKS_MINE)
		inst.components.workable:SetOnWorkCallback(CurrentlyWorking)

    local color = 0.5 + math.random() * 0.5
    inst.AnimState:SetMultColour(color, color, color, 1)

	inst:AddComponent("inspectable")
	inst.components.inspectable.nameoverride = "ROCK_TOUGH"
	MakeSnowCovered(inst)

    MakeHauntableWork(inst)

	return inst
end


local function rock_tough_fn()
	local inst = prerock_fn("rock_flintless", "rock_tough", "full","rock_tough.tex")

    if not TheWorld.ismastersim then
        return inst
    end
	
	inst.AnimState:SetBank("rock_flintless")
    inst.AnimState:SetBuild("rock_tough")
    inst.AnimState:PlayAnimation("full")

	
	inst.components.lootdropper:SetChanceLootTable('rock_tough')

	return inst
end


return Prefab( "forest/objects/rock_tough", rock_tough_fn, assets, prefabs)
--fuck that thing was a lot of work
