local assets =
{
    Asset("ANIM", "anim/trap_tesla.zip"),
	Asset("ATLAS", "tungstenimages/inventoryimages.xml"),
	Asset("SOUND", "sound/common.fsb"),
}

local function onfinished_normal(inst)
    inst:RemoveComponent("inventoryitem")
    inst:RemoveComponent("mine")
    inst.persists = false
    inst.AnimState:PushAnimation("used", false)
    inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
    inst:DoTaskInTime(3, inst.Remove)
end

local function onreset_tesla(inst)
	inst.components.mine:Reset()
end

local function OnExplode(inst, target)
    inst.AnimState:PlayAnimation("trap")
    if target then
        inst.SoundEmitter:PlaySound("dontstarve_DLC001/common/morningstar", "torch")
        target.components.combat:GetAttacked(inst, TUNING.TESLATRAP_DAMAGE)
    end
	inst:DoTaskInTime(4, inst.components.mine:Reset())
end



local function OnReset(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/trap_teeth_reset")
    inst.AnimState:PlayAnimation("reset")
    inst.AnimState:PushAnimation("idle", false)
end

local function SetSprung(inst)
    inst.AnimState:PlayAnimation("trap_idle")
end

local function SetInactive(inst)
    inst.AnimState:PlayAnimation("inactive")
end

local function OnDropped(inst)
    inst.components.mine:Deactivate()
end

local function ondeploy(inst, pt, deployer)
    inst.components.mine:Reset()
    inst.Physics:Teleport(pt:Get())
end

--legacy save support - mines used to start out activated
local function onload(inst, data)
    if not data or not data.mine then
        inst.components.mine:Reset()
    end
end

local function common_fn(build)
	--minimapicon ändern
	--Atlas textur ändern
	--inventoryimage ändern
	--autoretrap mit verzögerung
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddMiniMapEntity()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.MiniMapEntity:SetIcon("teslatrap.tex")

    inst.AnimState:SetBank("trap_teeth")
    inst.AnimState:SetBuild(build)
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("trap")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("inspectable")


    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "tungstenimages/inventoryimages.xml"
    inst.components.inventoryitem.nobounce = true
    inst.components.inventoryitem:SetOnDroppedFn(OnDropped)

    inst:AddComponent("mine")
    inst.components.mine:SetRadius(TUNING.TRAP_TESLA_RADIUS)
    inst.components.mine:SetAlignment("player")
    inst.components.mine:SetOnExplodeFn(OnExplode)
    inst.components.mine:SetOnResetFn(OnReset)
    inst.components.mine:SetOnSprungFn(SetSprung)
    inst.components.mine:SetOnDeactivateFn(SetInactive)
    --inst.components.mine:StartTesting()

    inst:AddComponent("deployable")
    inst.components.deployable.ondeploy = ondeploy
    inst.components.deployable:SetDeploySpacing(DEPLOYSPACING.LESS)

    inst:AddComponent("hauntable")
    inst.components.hauntable:SetOnHauntFn(function(inst, haunter)
        if inst.components.mine then
            if not inst.components.mine.inactive and not inst.components.mine.issprung then
                if math.random() <= TUNING.HAUNT_CHANCE_HALF then
                    inst.components.hauntable.hauntvalue = TUNING.HAUNT_MEDIUM
                    local target = FindEntity(inst, TUNING.TRAP_TESLA_RADIUS*1.5, 
                        function(dude, inst) 
                            return not (dude.components.health and dude.components.health:IsDead() and dude.components.combat:CanBeAttacked(inst)) 
                        end,
                        {"_combat"}, -- see entityscript.lua
                        {"notraptrigger", "flying", "playerghost"}, 
                        {"monster", "character", "animal"}
                    )
                    inst.components.mine:Explode(target)
                    return true
                end
            elseif not inst.components.mine.inactive and inst.components.mine.issprung then
                if math.random() <= TUNING.HAUNT_CHANCE_OFTEN then
                    inst.components.hauntable.hauntvalue = TUNING.HAUNT_SMALL
                    inst.components.mine:Reset()
                    return true
                end
            elseif inst.components.mine.inactive then
                Launch(inst, haunter, TUNING.LAUNCH_SPEED_SMALL)
                inst.components.hauntable.hauntvalue = TUNING.HAUNT_TINY
                return true
            end
        end
        return false
    end)

    inst.components.mine:Deactivate()
    inst.OnLoad = onload
    return inst
end

local function MakeTeethTrapNormal()
    return common_fn("trap_tesla")
end

return Prefab("common/inventory/trap_tesla", MakeTeethTrapNormal, assets),
    MakePlacer("common/trap_tesla_placer", "trap_tesla", "trap_tesla", "idle")