local assets=
{
	Asset("ANIM", "anim/tungsten_axe.zip"),
	Asset("ANIM", "anim/swap_tungsten_axe.zip"),
    Asset("ATLAS", "tungstenimages/inventoryimages.xml"),
}

local function onfinished(inst)
    inst:Remove()
end

local function sanityupfn(chop,owner)
	if owner and owner.components and owner.components.sanity then
		owner.components.sanity:DoDelta(3)
		--print("Sanity Regain by Corrupt Cutter")
	end
	--print("sanityupfn ausgeführt")
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_tungsten_axe", "swap_axe")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
	inst:ListenForEvent("percentusedchange", sanityupfn,owner)
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
	inst:RemoveEventCallback("percentusedchange",sanityupfn,owner)
end

local function onattack(weapon, attacker, target)
    if target ~= nil then
        weapon.components.finiteuses:Use(-1.5)
    end
end


local function fn(Sim)
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("axe")
    inst.AnimState:SetBuild("tungsten_axe")
    inst.AnimState:PlayAnimation("idle")
    
    if not TheWorld.ismastersim then
        return inst
    end

    MakeHauntableLaunchAndSmash(inst)	

    inst:AddTag("sharp")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.TUNGSTEN_AXE_DAMAGE)
    inst.components.weapon:SetAttackCallback(onattack)
    -------
    
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(TUNING.TUNGSTEN_AXE_USES)
    inst.components.finiteuses:SetUses(TUNING.TUNGSTEN_AXE_USES)
    
    inst.components.finiteuses:SetOnFinished(onfinished)

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "tungstenimages/inventoryimages.xml"
	
	inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.CHOP,4)
	inst.components.finiteuses:SetConsumption(ACTIONS.CHOP, 1)
	inst.components.finiteuses:SetConsumption(ACTIONS.ATTACK, -5)

    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    
    return inst
end

return Prefab("common/inventory/tungsten_axe", fn, assets) 
