--- << UNDER DEVELOPMENT >> ---

local Assets=
{
    Asset("ANIM", "anim/tungsten_hardhat.zip"),
	Asset("ANIM", "anim/tungsten_hardhat_off.zip"),
}
	
local function onequip(inst, owner, fname_override)
    local build =fname_override or "tungsten_hardhat"
    inst.build=fname_override or "tungsten_hardhat"
    owner.AnimState:OverrideSymbol("swap_hat", build, "swap_hat")

    owner.AnimState:Show("HAT")
    owner.AnimState:Show("HAT_HAIR")
    owner.AnimState:Hide("HAIR_NOHAT")
    owner.AnimState:Hide("HAIR")
    
    if inst.components.fueled then
        inst.components.fueled:StartConsuming()        
    end
end

local function miner_turnon(inst)
    local owner = inst.components.inventoryitem ~= nil and inst.components.inventoryitem.owner or nil
    if not inst.components.fueled:IsEmpty() then
        if inst._light == nil or not inst._light:IsValid() then
            inst._light = SpawnPrefab("tungstenlight")
        end
        if owner ~= nil then
            onequip(inst, owner)
            inst._light.entity:SetParent(owner.entity)
        end
        inst.components.fueled:StartConsuming()
        inst.SoundEmitter:PlaySound("dontstarve/common/minerhatAddFuel")
    elseif owner ~= nil then
        onequip(inst, owner, "tungsten_hardhat_off")
    end
end

local function miner_turnoff(inst)
    if inst.components.equippable ~= nil and inst.components.equippable:IsEquipped() then
        local owner = inst.components.inventoryitem ~= nil and inst.components.inventoryitem.owner or nil
        if owner ~= nil then
            onequip(inst, owner, "tungsten_hardhat_off")
        end
    end
    inst.components.fueled:StopConsuming()
    inst.SoundEmitter:PlaySound("dontstarve/common/minerhatOut")
    if inst._light ~= nil then
        if inst._light:IsValid() then
            inst._light:Remove()
        end
        inst._light = nil
    end
end

local function onunequip(inst, owner)
    
    owner.AnimState:Hide("HAT")
    owner.AnimState:Hide("HAT_HAIR")
    owner.AnimState:Show("HAIR_NOHAT")
    owner.AnimState:Show("HAIR")

    if owner:HasTag("player") then
        owner.AnimState:Show("HEAD")
        owner.AnimState:Hide("HEAD_HAIR")
    end

    if inst.components.fueled then
        inst.components.fueled:StopConsuming()        
    end
end

local function miner_unequip(inst, owner)
    onunequip(inst, owner)
    miner_turnoff(inst)
end

local function miner_perish(inst)
    local owner = inst.components.inventoryitem ~= nil and inst.components.inventoryitem.owner or nil
    if owner ~= nil then
        owner:PushEvent("torchranout", { torch = inst })
    end
    miner_turnoff(inst)
end

local function miner_takefuel(inst)
    if inst.components.equippable ~= nil and inst.components.equippable:IsEquipped() then
        miner_turnon(inst)
    end
end

local function miner_custom_init(inst)
    inst.entity:AddSoundEmitter()
end

local function miner_onremove(inst)
    if inst._light ~= nil and inst._light:IsValid() then
        inst._light:Remove()
    end
end
	
local function tungstenlightfn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddLight()
    inst.entity:AddNetwork()

    inst:AddTag("FX")

    inst.Light:SetFalloff(0.4)
    inst.Light:SetIntensity(.8)
    inst.Light:SetRadius(3.5)
    inst.Light:SetColour(245 / 255, 135 / 255, 255 / 255)

    if not TheWorld.ismastersim then
        return inst
    end

    inst.entity:SetPristine()

    inst.persists = false

    return inst
end

function prototype_fn()
	local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("minerhat")
    inst.AnimState:SetBuild("tungsten_hardhat")
    inst.AnimState:PlayAnimation("anim")

    inst:AddTag("hat")
    inst:AddTag("waterproofer")

	inst.entity:AddSoundEmitter()

    if not TheWorld.ismastersim then
        return inst
    end

    inst.entity:SetPristine()

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "tungstenimages/inventoryimages.xml"	
    inst:AddComponent("inspectable")
	inst:AddComponent("fueled")
	
    inst:AddComponent("tradable")

    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD

    inst:AddComponent("waterproofer")
    inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_SMALL)

    MakeHauntableLaunch(inst)
	
	inst.components.inventoryitem:SetOnDroppedFn(miner_turnoff)
    inst.components.equippable:SetOnEquip(miner_turnon)
	inst.components.equippable:SetOnUnequip(miner_unequip)
	
    
    inst.components.fueled.fueltype = FUELTYPE.NIGHTMARE
    inst.components.fueled:InitializeFuelLevel(TUNING.LARGE_FUEL/0.33)
    inst.components.fueled:SetDepletedFn(miner_perish)
    inst.components.fueled.ontakefuelfn = miner_takefuel
    inst.components.fueled.accepting = true
	inst.components.fueled.rate = 0.6
    inst._light = nil
    inst.OnRemoveEntity = miner_onremove

    return inst
end
	
return Prefab("common/inventory/tungsten_hardhat", prototype_fn, Assets),
        Prefab("common/inventory/tungstenlight", tungstenlightfn)