Assets = {
	Asset("ATLAS", "images/inventoryimages/quiche.xml"), -- if you use the asset you must list it here
    Asset("IMAGE", "images/inventoryimages/quiche.tex"),
}

PrefabFiles = { -- list all your prefabs here
	"quiche", 
}

local Ingredient = GLOBAL.Ingredient -- save time typing

local function templateRecipeTest(cooker, names, tags) -- this must be defined before it's called
	if tags.egg and tags.veggie then -- This is the ingredient values from above
		if not tags.inedible and not tags.monster then -- no monster meat or sticks
			if tags.egg >= 2 and tags.veggie >= 1 then
				-- must have at least egg and one veggie
				return true
			end
		end
	end
	return false
end

local quiche_recipe = {
	name = "quiche", -- name of the prefab
	test = templateRecipeTest, -- the function to test. must be true or false
	priority = 10,
	weight = 1,
	cooktime = .5,
}

AddCookerRecipe("cookpot", quiche_recipe) -- add the recipe to the game

local STRINGS = GLOBAL.STRINGS -- again just saving time.
STRINGS.NAMES.QUICHE = "Quiche" -- the name of the item
STRINGS.CHARACTERS.GENERIC.DESCRIBE.QUICHE = "It's and egg pie!" -- the description for the item