local assets = { -- list your assets here
	Asset("ANIM", "anim/quiche.zip"), -- this is what it looks like on the ground
	
	Asset("ATLAS", "images/inventoryimages/quiche.xml"), -- this is it in your inventory
    Asset("IMAGE", "images/inventoryimages/quiche.tex"),
}

prefabs = {} -- unneeded just here as a reminder


local function fn() -- this function is called every time one of these things is created
    local inst = CreateEntity() -- create the bare bones
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst) -- make it go in your inventory
     
    anim:SetBank("quiche") -- this is the name of the scml file
    anim:SetBuild("quiche") -- this is the name of the character in the file
    anim:PlayAnimation("idle") -- this is the name of the animation in the character

	inst:AddComponent("edible") -- make it edible and give it values
    inst.components.edible.healthvalue = 20
	inst.components.edible.hungervalue = 40
    inst.components.edible.sanityvalue = 20
	inst.components.edible.foodtype = "MEAT" -- this has to be one of the game types. you are not allowed to make up your own.
	-- inst:AddComponent("tradable") -- allow the player to give this to a pigman
	
	inst:AddComponent("perishable") -- make the item spoil
	inst.components.perishable:SetPerishTime(TUNING.TOTAL_DAY_TIME * 2) --take two days to rot
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
	
    inst:AddComponent("inspectable") -- allow the player to inspect the item
	
    inst:AddComponent("inventoryitem") -- make it an inventory item
    inst.components.inventoryitem.atlasname = "images/inventoryimages/quiche.xml" -- what it looks like in the inventory
 
    return inst
end
--      What kind of item is this? The function to call. This is the assets and prefabs from the top
return  Prefab("common/inventory/quiche", fn, assets, prefabs) -- send the prefab to the game				