﻿' Konverter (UTF-8/Unicode-) Liste nach Vokabular-Format (XML)
' verarbeitet z.B. VokabularZusatzDemo.txt, VokabularZusatz3.txt
' Teil der Decaleon-Software (gearwheelsoft2@hotmail.com)
' Mar 2015 M.P. Start-Version (Fachwortschatz)
' Mai 2016 M.P. Dynamische Arrays, Sortierung, Semant.Gruppen
' Jun 2016 M.P. Gruppen-Information, Statistik, Sprachauswahl
' Mar 2018 M.P. Kookkurrenzen (Tabellarisch)

Option Explicit On

Imports System.IO
Imports System.Xml

Public Class FormConvert
    ' Haupt-Klasse Konverter

    ' Zaehler
    Dim cdone As Integer
    Dim wcnt(10) As Integer ' parts of speech
    Dim ncnt(7) As Long     ' niveau of words
    Dim tcnt(26) As Long    ' topics of words
    Dim gcnt(26) As Long    ' topics of groups
    Dim fcnt(11) As Long    ' types of groups

    ' Wortarten
    Dim wordPro As List(Of wordtype)    '500
    Dim wordNom As List(Of wordtype)    '20000
    Dim wordVer As List(Of wordtype)    '10000
    Dim wordAdv As List(Of wordtype)    '1000
    Dim wordAdj As List(Of wordtype)    '10000
    Dim wordPre As List(Of wordtype)    '500
    Dim wordPar As List(Of wordtype)    '1000
    Dim wordJun As List(Of wordtype)    '500
    Dim wordExp As List(Of wordtype)    '1000
    Dim wordCoo As List(Of wordtype)    '10000

    ' Semant. Gruppen
    Dim groupMax As Integer
    Dim groupAll As List(Of grouptype)

    ' Globale Settings
    Dim setactive As Boolean
    Dim setting As String
    Dim setLevel As String
    Dim setTheme As String
    Dim setLang As Integer

    ' XML
    Dim vocaDOM As XmlDocument
    Dim linkDOM As XmlDocument
    Dim dataDOM
    Dim root
    Dim node
    Dim frag
    Dim elem
    Dim attr

    Private Sub FormConvert_Load(sender As System.Object, e As System.EventArgs) Handles MyBase.Load
        ' Form Settings

        ' Globalisation
        If (Application.CurrentCulture.TextInfo.CultureName = "de-AT" Or _
            Application.CurrentCulture.TextInfo.CultureName = "de-CH" Or _
            Application.CurrentCulture.TextInfo.CultureName = "de-DE" Or _
            Application.CurrentCulture.TextInfo.CultureName = "de-LI" Or _
            Application.CurrentCulture.TextInfo.CultureName = "de-LU") Then
            Me.Text = "List2Voca"
            Me.CheckBoxSort.Text = "Sortieren"
            Me.ButtonStart.Text = "Auswahl und Start"
            Me.LabelResult.Text = "Ergebnis"
            Me.Text = "Konverter Liste -> Vokabular"
        Else
            Me.Text = "List2Voca"
            Me.CheckBoxSort.Text = "Sort"
            Me.ButtonStart.Text = "Select and Start"
            Me.LabelResult.Text = "Result"
            Me.Text = "Converter List -> Vocabulary"
        End If

        ' Language
        Me.ComboBoxLang.Items.Add("de")
        Me.ComboBoxLang.Items.Add("en")
        Me.ComboBoxLang.Items.Add("fr")
        Me.ComboBoxLang.Items.Add("es")
        Me.ComboBoxLang.Items.Add("it")
        Me.ComboBoxLang.Items.Add("pt")
        Me.ComboBoxLang.Items.Add("da")
        Me.ComboBoxLang.Items.Add("sv")
        Me.ComboBoxLang.Items.Add("el")
        Me.ComboBoxLang.Items.Add("ru")
        Me.ComboBoxLang.Items.Add("pl")
        Me.ComboBoxLang.Items.Add("hr")
        Me.ComboBoxLang.Items.Add("xy")
        Me.ComboBoxLang.SelectedIndex = 0
        Me.ComboBoxLang.Enabled = False
        Me.CheckBoxSort.Enabled = False

    End Sub

    Private Sub ButtonStart_Click(sender As System.Object, e As System.EventArgs) Handles ButtonStart.Click
        Dim file As String
        Dim par As Integer
        Dim sortpar As Boolean
        Dim reti As Integer

        ' Auswahl
        Me.OpenFileDialog1.InitialDirectory = Application.StartupPath
        Me.OpenFileDialog1.Filter = "*.txt" & "|*.txt"
        Me.OpenFileDialog1.Title = "Open List to process"
        Me.OpenFileDialog1.FileName = ""
        reti = Me.OpenFileDialog1.ShowDialog()
        If (reti = vbCancel) Then
            Exit Sub
        End If
        file = Me.OpenFileDialog1.FileName
        par = 0
        sortpar = Me.CheckBoxSort.Checked
        setLang = Me.ComboBoxLang.SelectedIndex

        ' Init
        vocaDOM = New XmlDocument
        linkDOM = New XmlDocument
        wordPro = New List(Of wordtype)    '500
        wordNom = New List(Of wordtype)    '20000
        wordVer = New List(Of wordtype)    '10000
        wordAdv = New List(Of wordtype)    '1000
        wordAdj = New List(Of wordtype)    '10000
        wordPre = New List(Of wordtype)    '500
        wordPar = New List(Of wordtype)    '1000
        wordJun = New List(Of wordtype)    '500
        wordExp = New List(Of wordtype)    '1000
        wordCoo = New List(Of wordtype)    '10000
        For i = 0 To 10
            wcnt(i) = 0
        Next
        For i = 0 To 6
            ncnt(i) = 0
        Next
        For i = 0 To 26
            tcnt(i) = 0
        Next
        For i = 0 To 26
            gcnt(i) = 0
        Next
        For i = 0 To 11
            fcnt(i) = 0
        Next
        groupMax = 35
        groupAll = New List(Of grouptype)

        ' Konversion
        reti = conv2voka(file, par, sortpar)

        ' Ergebnis
        Me.TextBoxResult.Text = reti.ToString

    End Sub

    Public Function conv2voka(UnicodeFile As String, par As Integer, sortpar As Boolean) As Integer
        ' Format-Umwandlung
        Dim XMLfile As String
        Dim XMLlinkfile As String
        Dim num As Integer
        Dim marker(10) As String
        Dim counter(10) As Integer
        Dim increment As Integer
        Dim grpinfo As String
        Dim wordinfo(9) As String
        Dim inputstr As String

        ' Init
        XMLfile = "VocaAutoGen.xml"
        XMLlinkfile = "VocaCoocLink.xml"

        num = 0
        cdone = 0
        marker = initmarkers(0)
        setactive = False
        setLevel = "--"
        setTheme = "00"
        initInstanz()

        ' Txt Lesen
        Dim fsi As New FileStream(UnicodeFile, FileMode.Open, FileAccess.Read)
        Dim sr As New StreamReader(fsi, System.Text.Encoding.Unicode)
        ' Zeilen-Parsen
        While (sr.EndOfStream = False)
            ' ... Zeile
            inputstr = sr.ReadLine()
            If (cdone < 10) Then
                ' ... Zaehler
                counter = checkcounters(inputstr, marker, counter)
            Else
                ' ... Gruppen
                grpinfo = getgroupinfo(inputstr, marker)
                ' ... Wort
                wordinfo = checkword(inputstr, marker)
                ' ... Merken
                If (wordinfo(0) <> "none" And wordinfo(0) <> "Setting") Then
                    registerword(wordinfo, marker)
                ElseIf (wordinfo(0) = "Setting") Then
                    ' setting
                Else
                    If (cdone = 10 And inputstr.Contains("---") = False And inputstr.Contains("Gp:") = False) Then
                        MsgBox(inputstr, MsgBoxStyle.Exclamation, "No parsing!")
                    End If
                End If
            End If
        End While
        ' close
        sr.Close()
        fsi.Close()
        ' Meldung
        Me.TextBoxResult.Text = "Import"
        Application.DoEvents()

        ' optional: Sortieren
        sortwords(sortpar)
        ' Semant. Gruppen
        buildgroups(counter)
        ' Meldung
        Me.TextBoxResult.Text = "Sort&Build"
        Application.DoEvents()

        ' XML Schreiben
        ' ... Header
        'dataDOM = vocaDOM.CreateProcessingInstruction("xml", "version='1.0'")
        dataDOM = vocaDOM.CreateXmlDeclaration("1.0", "UTF-16", "yes")
        vocaDOM.AppendChild(dataDOM)
        createheader(0)
        ' ... Root-Start
        root = vocaDOM.CreateElement("Esperanto")
        attr = vocaDOM.CreateAttribute("xmlns:ns1")
        attr.Value = "http://www.esperanto.de"
        root.setAttributeNode(attr)
        vocaDOM.AppendChild(root)
        ' ... Wortarten
        If (counter(1) > 0) Then
            increment = 1
        Else
            increment = -1
        End If
        createwords(counter, increment)
        creategroups(0)
        ' ... Root-Ende
        ' ... XML-Baum fertig
        'vocaDOM.Save(XMLfile)
        Using sw As New StreamWriter(XMLfile, False, System.Text.Encoding.Unicode) ' Set encoding
            vocaDOM.Save(sw)
        End Using

        ' XML Links schreiben
        ' ... Header
        'dataDOM = linkDOM.CreateProcessingInstruction("xml", "version='1.0'")
        dataDOM = linkDOM.CreateXmlDeclaration("1.0", "UTF-16", "yes")
        linkDOM.AppendChild(dataDOM)
        dataDOM = linkDOM.CreateComment("Link of words an cooccurrence expressions")
        ' ... Root-Start
        root = linkDOM.CreateElement("Esperanto")
        attr = linkDOM.CreateAttribute("xmlns:ns1")
        attr.Value = "http://www.esperanto.de"
        root.setAttributeNode(attr)
        linkDOM.AppendChild(root)
        ' ... Links
        If (counter(1) > 0) Then
            increment = 1
        Else
            increment = -1
        End If
        createlinks(counter, increment)
        ' ... Root-Ende
        ' ... XML-Baum fertig
        'linkDOM.Save(XMLfile)
        Using sw As New StreamWriter(XMLlinkfile, False, System.Text.Encoding.Unicode) ' Set encoding
            linkDOM.Save(sw)
        End Using

        ' Rueckgabe
        conv2voka = wcnt(0)

    End Function

    Private Function initmarkers(par As Integer) As String()
        ' Marker-Init
        Dim marker(10) As String
        marker(1) = "Pro"
        marker(2) = "Nom"
        marker(3) = "Ver"
        marker(4) = "Adv"
        marker(5) = "Adj"
        marker(6) = "Pre"
        marker(7) = "Par"
        marker(8) = "Jun"
        marker(9) = "Exp"
        marker(10) = "Coo"
        '
        setting = "Set"

        ' Rueckgabe
        initmarkers = marker

    End Function

    Private Function checkcounters(cline As String, marker() As String, counter() As Integer) As Integer()
        ' Zaehler-Init
        Dim i As Integer

        ' Parsen
        For i = 1 To 10
            If (cline.StartsWith(marker(i) & "#") = True) Then
                counter(i) = CInt(Val(cline.Substring(cline.LastIndexOf("#") + 1)))
                cdone = cdone + 1
                Exit For
            End If
        Next

        ' Rueckgabe
        checkcounters = counter

    End Function

    Private Function getgroupinfo(cline As String, marker() As String) As Integer
        ' Gruppeninfo
        Dim grpID As String
        Dim grpName As String
        Dim grpThm As String
        Dim grpLnk As String
        Dim grpType As String
        Dim hashind1 As Integer
        Dim hashind2 As Integer
        Dim starind As Integer
        Dim grpcnt As Integer

        grpcnt = 0
        If (cline.StartsWith("Gp:") = True) Then
            grpcnt = grpcnt + 1
            ' read
            hashind1 = cline.IndexOf("#")
            hashind2 = cline.LastIndexOf("#")
            starind = cline.IndexOf("*")
            If (hashind1 = -1 Or hashind2 = -1) Then
                MsgBox(cline & " enthält zuwenige Trenner (#)!", MsgBoxStyle.Critical, "Missing Separators")
                Return 0
            End If
            If (hashind1 = hashind2) Then
                MsgBox(cline & " enthält zuwenige Trenner (#)!", MsgBoxStyle.Critical, "Missing Separators")
                Return 0
            End If
            If (starind = -1) Then
                MsgBox(cline & " enthält zuwenige Trenner (*)!", MsgBoxStyle.Critical, "Missing Separators")
                Return 0
            End If
            grpID = cline.Substring(3, hashind1 - 3)
            grpName = cline.Substring(hashind1 + 1, hashind2 - hashind1 - 1)
            grpThm = cline.Substring(hashind2 + 1, starind - hashind2 - 1)
            grpLnk = cline.Substring(starind + 1)

            ' Arten
            grpType = "---"
            If (grpID.StartsWith("F") = True Or grpID.StartsWith("G") = True Or grpID.StartsWith("C") = True Or grpID.StartsWith("D") = True) Then
                fcnt(1) = fcnt(1) + 1
                grpType = "Field"
            ElseIf (grpID.StartsWith("K") = True) Then
                fcnt(2) = fcnt(2) + 1
                grpType = "Complement"
            ElseIf (grpID.StartsWith("H") = True) Then
                fcnt(3) = fcnt(3) + 1
                grpType = "Hierarchy"
            ElseIf (grpID.StartsWith("S") = True) Then
                fcnt(4) = fcnt(4) + 1
                grpType = "Synonym"
            ElseIf (grpID.StartsWith("Y") = True) Then
                fcnt(5) = fcnt(5) + 1
                grpType = "Synonym"
            ElseIf (grpID.StartsWith("Z") = True) Then
                fcnt(6) = fcnt(6) + 1
                grpType = "Synonym"
            ElseIf (grpID.StartsWith("X") = True) Then
                fcnt(7) = fcnt(7) + 1
                grpType = "Synonym"
            ElseIf (grpID.StartsWith("A") = True) Then
                fcnt(8) = fcnt(8) + 1
                grpType = "Antonym"
            ElseIf (grpID.StartsWith("U") = True) Then
                fcnt(9) = fcnt(9) + 1
                grpType = "Antonym"
            ElseIf (grpID.StartsWith("V") = True) Then
                fcnt(10) = fcnt(10) + 1
                grpType = "Antonym"
            ElseIf (grpID.StartsWith("W") = True) Then
                fcnt(11) = fcnt(11) + 1
                grpType = "Antonym"
            End If

            ' register
            ' neue Gruppe anlegen, Wort hinzufuegen
            Dim tmpitem2 As grouptype
            tmpitem2 = New grouptype
            tmpitem2.ID = grpID
            tmpitem2.thm = grpThm
            tmpitem2.nam = grpName
            tmpitem2.type = grpType
            tmpitem2.link = grpLnk
            tmpitem2.count = 1
            tmpitem2.partofspeech(1) = "XXX"
            tmpitem2.index(1) = Format("0", "00000")
            groupAll.Add(tmpitem2)
            tmpitem2 = Nothing

            ' statistics
            ' Themen
            If (grpThm = "01") Then
                gcnt(1) = gcnt(1) + 1
            ElseIf (grpThm = "02") Then
                gcnt(2) = gcnt(2) + 1
            ElseIf (grpThm = "03") Then
                gcnt(3) = gcnt(3) + 1
            ElseIf (grpThm = "04") Then
                gcnt(4) = gcnt(4) + 1
            ElseIf (grpThm = "05") Then
                gcnt(5) = gcnt(5) + 1
            ElseIf (grpThm = "06") Then
                gcnt(6) = gcnt(6) + 1
            ElseIf (grpThm = "07") Then
                gcnt(7) = gcnt(7) + 1
            ElseIf (grpThm = "08") Then
                gcnt(8) = gcnt(8) + 1
            ElseIf (grpThm = "09") Then
                gcnt(9) = gcnt(9) + 1
            ElseIf (grpThm = "10") Then
                gcnt(10) = gcnt(10) + 1
            ElseIf (grpThm = "11") Then
                gcnt(11) = gcnt(11) + 1
            ElseIf (grpThm = "12") Then
                gcnt(12) = gcnt(12) + 1
            ElseIf (grpThm = "13") Then
                gcnt(13) = gcnt(13) + 1
            ElseIf (grpThm = "14") Then
                gcnt(14) = gcnt(14) + 1
            ElseIf (grpThm = "15") Then
                gcnt(15) = gcnt(15) + 1
            ElseIf (grpThm = "16") Then
                gcnt(16) = gcnt(16) + 1
            ElseIf (grpThm = "17") Then
                gcnt(17) = gcnt(17) + 1
            ElseIf (grpThm = "18") Then
                gcnt(18) = gcnt(18) + 1
            ElseIf (grpThm = "19") Then
                gcnt(19) = gcnt(19) + 1
            ElseIf (grpThm = "20") Then
                gcnt(20) = gcnt(20) + 1
            ElseIf (grpThm = "21") Then
                gcnt(21) = gcnt(21) + 1
            ElseIf (grpThm = "22") Then
                gcnt(22) = gcnt(22) + 1
            ElseIf (grpThm = "23") Then
                gcnt(23) = gcnt(23) + 1
            ElseIf (grpThm = "24") Then
                gcnt(24) = gcnt(24) + 1
            ElseIf (grpThm = "25") Then
                gcnt(25) = gcnt(25) + 1
            ElseIf (grpThm = "26") Then
                gcnt(26) = gcnt(26) + 1
            End If

        End If

        ' Rueckgabe
        getgroupinfo = grpcnt.ToString

    End Function

    Private Function checkword(cline As String, marker() As String) As String()
        ' Wort-Info
        Dim tmpid, wordinfo(9), csplitx(), csplit(9) As String
        Dim startind, stopind As Integer
        Dim open1ind, open2ind, open3ind, open4ind, open5ind As Integer
        Dim close1ind, close2ind, close3ind, close4ind, close5ind As Integer
        Dim tmplen As Integer
        Dim i, j, c As Integer

        ' Init
        wordinfo(0) = "empty"

        ' Parsen
        For i = 1 To 10
            If (cline.StartsWith(marker(i) & vbTab) = True) Then
                wordinfo(0) = marker(i)
                ' Tab-separated lines
                csplitx = cline.Split(vbTab)
                c = 0
                ' eliminate empty entries
                For j = 0 To csplitx.Length - 1
                    If (csplitx(j) <> "") Then
                        csplit(c) = csplitx(j)
                        c = c + 1
                    End If
                Next
                wordinfo(0) = csplit(0)     ' Wortart
                wordinfo(1) = csplit(3)     ' Wort
                wordinfo(2) = ""    ' reflexiv -> nix
                wordinfo(3) = csplit(4)     ' Kontext
                wordinfo(4) = csplit(1) & (Integer.Parse(Val(csplit(2)))).ToString("00000")     ' Synomym
                wordinfo(5) = ""    ' Niveau -> Set
                wordinfo(6) = csplit(5)     ' Thema
                wordinfo(7) = csplit(6)     ' Gruppe
                wordinfo(8) = csplit(7)     ' Coo-Deu
                wordinfo(9) = csplit(8)     ' Coo-Eng

                ' Init Wort-Laenge
                startind = 4
                stopind = cline.Length - 1
                open1ind = cline.IndexOf("(")
                open2ind = cline.IndexOf("[")
                open3ind = cline.LastIndexOf("[")
                open4ind = cline.IndexOf("{")
                open5ind = cline.IndexOf("<")
                close1ind = cline.IndexOf(")")
                close2ind = cline.IndexOf("]")
                close3ind = cline.LastIndexOf("]")
                close4ind = cline.IndexOf("}")
                close5ind = cline.IndexOf(">")
                '' Ende Wort festlegen
                'If (open1ind > 0) Then
                '    If (open1ind - 1 < stopind) Then
                '        stopind = open1ind - 1
                '    End If
                'End If
                'If (open2ind > 0) Then
                '    If (open2ind - 1 < stopind) Then
                '        stopind = open2ind - 1
                '    End If
                'End If
                'If (open4ind > 0) Then
                '    If (open4ind - 1 < stopind) Then
                '        stopind = open4ind - 1
                '    End If
                'End If
                'If (open5ind > 0) Then
                '    If (open5ind - 1 < stopind) Then
                '        stopind = open5ind - 1
                '    End If
                'End If
                '' Wort
                'wordinfo(1) = cline.Substring(startind, stopind - startind + 1).Trim
                '' reflexiv?
                'If (cline.Contains("(r)") = True) Then
                '    wordinfo(2) = "sich" & " "
                'Else
                '    wordinfo(2) = ""
                'End If
                ' Setting?
                If (setactive = True) Then
                    wordinfo(5) = setLevel
                    wordinfo(6) = setTheme
                Else
                    wordinfo(5) = "--"
                    wordinfo(6) = "00"
                End If
                '' Niveau?
                'If (cline.Contains("(A1)") = True) Then
                '    wordinfo(5) = "A1"
                'End If
                'If (cline.Contains("(A2)") = True) Then
                '    wordinfo(5) = "A2"
                'End If
                'If (cline.Contains("(B1)") = True) Then
                '    wordinfo(5) = "B1"
                'End If
                'If (cline.Contains("(B2)") = True) Then
                '    wordinfo(5) = "B2"
                'End If
                'If (cline.Contains("(C1)") = True) Then
                '    wordinfo(5) = "C1"
                'End If
                'If (cline.Contains("(C2)") = True) Then
                '    wordinfo(5) = "C2"
                'End If
                ' Thema?
                If (open4ind > 0) Then
                    ' Check
                    If (close4ind - open4ind = 3) Then
                        wordinfo(6) = cline.Substring(open4ind + 1, (close4ind - 1) - (open4ind + 1) + 1).Trim
                    Else
                        wordinfo(6) = "00"
                    End If
                    If (close4ind - open4ind = 1) Then MsgBox("Thema-ID von " & wordinfo(1) & " ist leer!", MsgBoxStyle.Exclamation, "Thematic ID is empty")
                    If (close4ind - open4ind = 2 Or close4ind - open4ind > 3) Then MsgBox("Thema-ID von " & wordinfo(1) & " hat falsche Länge!", MsgBoxStyle.Exclamation, "Thematic ID has wrong length")
                    If (CInt(Val(wordinfo(6))) < 1) Then MsgBox("Thema-ID von " & wordinfo(1) & " hat falschen Code!", MsgBoxStyle.Exclamation, "Thematic ID has wrong code")
                    If (CInt(Val(wordinfo(6))) > 26) Then MsgBox("Thema-ID von " & wordinfo(1) & " hat falschen Code!", MsgBoxStyle.Exclamation, "Thematic ID has wrong code")
                End If
                ' Gruppe?
                If (open5ind > 0) Then
                    tmpid = cline.Substring(open5ind + 1, (close5ind - 1) - (open5ind + 1) + 1).Trim
                    tmplen = close5ind - open5ind - 1
                    If (tmplen = 4 Or (tmplen > 4 And (tmplen - 4) Mod 5 = 0) Or (tmpid.StartsWith("E") = True And tmplen = 5) Or (tmplen > 5 And (tmplen - 5) Mod 6 = 0)) Then
                        wordinfo(7) = cline.Substring(open5ind + 1, (close5ind - 1) - (open5ind + 1) + 1).Trim
                    Else
                        wordinfo(7) = "-"
                        MsgBox("Gruppen-ID von " & wordinfo(1) & " hat falsche Länge!", MsgBoxStyle.Exclamation, "Group ID to has wrong length")
                    End If
                Else
                    wordinfo(7) = "-"
                End If
                '' Kontext und Synonym-Info
                'If (open2ind > 0 Or open3ind > 0) Then
                '    If (open2ind = open3ind) Then
                '        ' nur Kontext
                '        wordinfo(3) = cline.Substring(open2ind + 1, (close2ind - 1) - (open2ind + 1) + 1).Trim
                '        wordinfo(4) = ""
                '    Else
                '        ' Kontext und Synomym
                '        wordinfo(3) = cline.Substring(open2ind + 1, (close2ind - 1) - (open2ind + 1) + 1).Trim
                '        wordinfo(4) = cline.Substring(open3ind + 1, (close3ind - 1) - (open3ind + 1) + 1).Trim
                '    End If
                'Else
                '    wordinfo(3) = ""
                '    wordinfo(4) = ""
                'End If
                Exit For
            ElseIf (cline.StartsWith(setting & " ") = True) Then
                If (cline.Contains("Nv") = True) Then
                    setLevel = cline.Substring(cline.LastIndexOf(":") + 1)
                    setactive = True
                End If
                If (cline.Contains("Th") = True) Then
                    setTheme = cline.Substring(cline.LastIndexOf(":") + 1)
                    setactive = True
                End If
                If (cline.Contains("Off") = True) Then
                    setLevel = "--"
                    setTheme = "00"
                    setactive = False
                End If
                wordinfo(0) = "Setting"
                Exit For
            Else
                wordinfo(0) = "none"

            End If
        Next

        ' Rueckgabe
        checkword = wordinfo

    End Function

    Private Sub registerword(wordinfo() As String, marker() As String)
        ' Word-Liste
        If (wordinfo(0) = marker(1)) Then
            wcnt(1) = wcnt(1) + 1
            wcnt(0) = wcnt(0) + 1
            Dim tmpitem As New wordtype
            wordPro.Add(tmpitem)
            wordPro(wcnt(1)).textword = wordinfo(1)
            wordPro(wcnt(1)).textrefl = wordinfo(2)
            wordPro(wcnt(1)).textkon = wordinfo(3)
            wordPro(wcnt(1)).textsyn = wordinfo(4)
            wordPro(wcnt(1)).textlev = wordinfo(5)
            wordPro(wcnt(1)).textthm = wordinfo(6)
            wordPro(wcnt(1)).textgrp = wordinfo(7)
            wordPro(wcnt(1)).textcdeu = wordinfo(8)
            wordPro(wcnt(1)).textceng = wordinfo(9)
            tmpitem = Nothing

        ElseIf (wordinfo(0) = marker(2)) Then
            wcnt(2) = wcnt(2) + 1
            wcnt(0) = wcnt(0) + 1
            Dim tmpitem As New wordtype
            wordNom.Add(tmpitem)
            wordNom(wcnt(2)).textword = wordinfo(1)
            wordNom(wcnt(2)).textrefl = wordinfo(2)
            wordNom(wcnt(2)).textkon = wordinfo(3)
            wordNom(wcnt(2)).textsyn = wordinfo(4)
            wordNom(wcnt(2)).textlev = wordinfo(5)
            wordNom(wcnt(2)).textthm = wordinfo(6)
            wordNom(wcnt(2)).textgrp = wordinfo(7)
            wordNom(wcnt(2)).textcdeu = wordinfo(8)
            wordNom(wcnt(2)).textceng = wordinfo(9)
            tmpitem = Nothing

        ElseIf (wordinfo(0) = marker(3)) Then
            wcnt(3) = wcnt(3) + 1
            wcnt(0) = wcnt(0) + 1
            Dim tmpitem As New wordtype
            wordVer.Add(tmpitem)
            wordVer(wcnt(3)).textword = wordinfo(1)
            wordVer(wcnt(3)).textrefl = wordinfo(2)
            wordVer(wcnt(3)).textkon = wordinfo(3)
            wordVer(wcnt(3)).textsyn = wordinfo(4)
            wordVer(wcnt(3)).textlev = wordinfo(5)
            wordVer(wcnt(3)).textthm = wordinfo(6)
            wordVer(wcnt(3)).textgrp = wordinfo(7)
            wordVer(wcnt(3)).textcdeu = wordinfo(8)
            wordVer(wcnt(3)).textceng = wordinfo(9)
            tmpitem = Nothing

        ElseIf (wordinfo(0) = marker(4)) Then
            wcnt(4) = wcnt(4) + 1
            wcnt(0) = wcnt(0) + 1
            Dim tmpitem As New wordtype
            wordAdv.Add(tmpitem)
            wordAdv(wcnt(4)).textword = wordinfo(1)
            wordAdv(wcnt(4)).textrefl = wordinfo(2)
            wordAdv(wcnt(4)).textkon = wordinfo(3)
            wordAdv(wcnt(4)).textsyn = wordinfo(4)
            wordAdv(wcnt(4)).textlev = wordinfo(5)
            wordAdv(wcnt(4)).textthm = wordinfo(6)
            wordAdv(wcnt(4)).textgrp = wordinfo(7)
            wordAdv(wcnt(4)).textcdeu = wordinfo(8)
            wordAdv(wcnt(4)).textceng = wordinfo(9)
            tmpitem = Nothing

        ElseIf (wordinfo(0) = marker(5)) Then
            wcnt(5) = wcnt(5) + 1
            wcnt(0) = wcnt(0) + 1
            Dim tmpitem As New wordtype
            wordAdj.Add(tmpitem)
            wordAdj(wcnt(5)).textword = wordinfo(1)
            wordAdj(wcnt(5)).textrefl = wordinfo(2)
            wordAdj(wcnt(5)).textkon = wordinfo(3)
            wordAdj(wcnt(5)).textsyn = wordinfo(4)
            wordAdj(wcnt(5)).textlev = wordinfo(5)
            wordAdj(wcnt(5)).textthm = wordinfo(6)
            wordAdj(wcnt(5)).textgrp = wordinfo(7)
            wordAdj(wcnt(5)).textcdeu = wordinfo(8)
            wordAdj(wcnt(5)).textceng = wordinfo(9)
            tmpitem = Nothing

        ElseIf (wordinfo(0) = marker(6)) Then
            wcnt(6) = wcnt(6) + 1
            wcnt(0) = wcnt(0) + 1
            Dim tmpitem As New wordtype
            wordPre.Add(tmpitem)
            wordPre(wcnt(6)).textword = wordinfo(1)
            wordPre(wcnt(6)).textrefl = wordinfo(2)
            wordPre(wcnt(6)).textkon = wordinfo(3)
            wordPre(wcnt(6)).textsyn = wordinfo(4)
            wordPre(wcnt(6)).textlev = wordinfo(5)
            wordPre(wcnt(6)).textthm = wordinfo(6)
            wordPre(wcnt(6)).textgrp = wordinfo(7)
            wordPre(wcnt(6)).textcdeu = wordinfo(8)
            wordPre(wcnt(6)).textceng = wordinfo(9)
            tmpitem = Nothing

        ElseIf (wordinfo(0) = marker(7)) Then
            wcnt(7) = wcnt(7) + 1
            wcnt(0) = wcnt(0) + 1
            Dim tmpitem As New wordtype
            wordPar.Add(tmpitem)
            wordPar(wcnt(7)).textword = wordinfo(1)
            wordPar(wcnt(7)).textrefl = wordinfo(2)
            wordPar(wcnt(7)).textkon = wordinfo(3)
            wordPar(wcnt(7)).textsyn = wordinfo(4)
            wordPar(wcnt(7)).textlev = wordinfo(5)
            wordPar(wcnt(7)).textthm = wordinfo(6)
            wordPar(wcnt(7)).textgrp = wordinfo(7)
            wordPar(wcnt(7)).textcdeu = wordinfo(8)
            wordPar(wcnt(7)).textceng = wordinfo(9)
            tmpitem = Nothing

        ElseIf (wordinfo(0) = marker(8)) Then
            wcnt(8) = wcnt(8) + 1
            wcnt(0) = wcnt(0) + 1
            Dim tmpitem As New wordtype
            wordJun.Add(tmpitem)
            wordJun(wcnt(8)).textword = wordinfo(1)
            wordJun(wcnt(8)).textrefl = wordinfo(2)
            wordJun(wcnt(8)).textkon = wordinfo(3)
            wordJun(wcnt(8)).textsyn = wordinfo(4)
            wordJun(wcnt(8)).textlev = wordinfo(5)
            wordJun(wcnt(8)).textthm = wordinfo(6)
            wordJun(wcnt(8)).textgrp = wordinfo(7)
            wordJun(wcnt(8)).textcdeu = wordinfo(8)
            wordJun(wcnt(8)).textceng = wordinfo(9)
            tmpitem = Nothing

        ElseIf (wordinfo(0) = marker(9)) Then
            wcnt(9) = wcnt(9) + 1
            wcnt(0) = wcnt(0) + 1
            Dim tmpitem As New wordtype
            wordExp.Add(tmpitem)
            wordExp(wcnt(9)).textword = wordinfo(1)
            wordExp(wcnt(9)).textrefl = wordinfo(2)
            wordExp(wcnt(9)).textkon = wordinfo(3)
            wordExp(wcnt(9)).textsyn = wordinfo(4)
            wordExp(wcnt(9)).textlev = wordinfo(5)
            wordExp(wcnt(9)).textthm = wordinfo(6)
            wordExp(wcnt(9)).textgrp = wordinfo(7)
            wordExp(wcnt(9)).textcdeu = wordinfo(8)
            wordExp(wcnt(9)).textceng = wordinfo(9)
            tmpitem = Nothing

        ElseIf (wordinfo(0) = marker(10)) Then
            wcnt(10) = wcnt(10) + 1
            wcnt(0) = wcnt(0) + 1
            Dim tmpitem As New wordtype
            wordCoo.Add(tmpitem)
            wordCoo(wcnt(10)).textword = wordinfo(1)
            wordCoo(wcnt(10)).textrefl = wordinfo(2)
            wordCoo(wcnt(10)).textkon = wordinfo(3)
            wordCoo(wcnt(10)).textsyn = wordinfo(4)
            wordCoo(wcnt(10)).textlev = wordinfo(5)
            wordCoo(wcnt(10)).textthm = wordinfo(6)
            wordCoo(wcnt(10)).textgrp = wordinfo(7)
            wordCoo(wcnt(10)).textcdeu = wordinfo(8)
            wordCoo(wcnt(10)).textceng = wordinfo(9)
            tmpitem = Nothing

        End If

        ' Statistik
        ' Niveaus
        If (wordinfo(5) = "A1") Then
            ncnt(1) = ncnt(1) + 1
        ElseIf (wordinfo(5) = "A2") Then
            ncnt(2) = ncnt(2) + 1
        ElseIf (wordinfo(5) = "B1") Then
            ncnt(3) = ncnt(3) + 1
        ElseIf (wordinfo(5) = "B2") Then
            ncnt(4) = ncnt(4) + 1
        ElseIf (wordinfo(5) = "C1") Then
            ncnt(5) = ncnt(5) + 1
        ElseIf (wordinfo(5) = "C2") Then
            ncnt(6) = ncnt(6) + 1
        ElseIf (wordinfo(5).StartsWith("E") = True) Then
            ncnt(7) = ncnt(7) + 1
        End If
        ' Themen
        If (wordinfo(6) = "01") Then
            tcnt(1) = tcnt(1) + 1
        ElseIf (wordinfo(6) = "02") Then
            tcnt(2) = tcnt(2) + 1
        ElseIf (wordinfo(6) = "03") Then
            tcnt(3) = tcnt(3) + 1
        ElseIf (wordinfo(6) = "04") Then
            tcnt(4) = tcnt(4) + 1
        ElseIf (wordinfo(6) = "05") Then
            tcnt(5) = tcnt(5) + 1
        ElseIf (wordinfo(6) = "06") Then
            tcnt(6) = tcnt(6) + 1
        ElseIf (wordinfo(6) = "07") Then
            tcnt(7) = tcnt(7) + 1
        ElseIf (wordinfo(6) = "08") Then
            tcnt(8) = tcnt(8) + 1
        ElseIf (wordinfo(6) = "09") Then
            tcnt(9) = tcnt(9) + 1
        ElseIf (wordinfo(6) = "10") Then
            tcnt(10) = tcnt(10) + 1
        ElseIf (wordinfo(6) = "11") Then
            tcnt(11) = tcnt(11) + 1
        ElseIf (wordinfo(6) = "12") Then
            tcnt(12) = tcnt(12) + 1
        ElseIf (wordinfo(6) = "13") Then
            tcnt(13) = tcnt(13) + 1
        ElseIf (wordinfo(6) = "14") Then
            tcnt(14) = tcnt(14) + 1
        ElseIf (wordinfo(6) = "15") Then
            tcnt(15) = tcnt(15) + 1
        ElseIf (wordinfo(6) = "16") Then
            tcnt(16) = tcnt(16) + 1
        ElseIf (wordinfo(6) = "17") Then
            tcnt(17) = tcnt(17) + 1
        ElseIf (wordinfo(6) = "18") Then
            tcnt(18) = tcnt(18) + 1
        ElseIf (wordinfo(6) = "19") Then
            tcnt(19) = tcnt(19) + 1
        ElseIf (wordinfo(6) = "20") Then
            tcnt(20) = tcnt(20) + 1
        ElseIf (wordinfo(6) = "21") Then
            tcnt(21) = tcnt(21) + 1
        ElseIf (wordinfo(6) = "22") Then
            tcnt(22) = tcnt(22) + 1
        ElseIf (wordinfo(6) = "23") Then
            tcnt(23) = tcnt(23) + 1
        ElseIf (wordinfo(6) = "24") Then
            tcnt(24) = tcnt(24) + 1
        ElseIf (wordinfo(6) = "25") Then
            tcnt(25) = tcnt(25) + 1
        ElseIf (wordinfo(6) = "26") Then
            tcnt(26) = tcnt(26) + 1
        End If

    End Sub

    Private Sub sortwords(par As Boolean)
        ' Sortierung nach Alphabet

        If (par = False) Then
            Exit Sub

        End If

        ' Sortierung nach wordtext
        ' siehe Class wordtype
        wordPro.Sort()
        wordNom.Sort()
        wordVer.Sort()
        wordAdv.Sort()
        wordAdj.Sort()
        wordPre.Sort()
        wordPar.Sort()
        wordJun.Sort()
        wordExp.Sort()
        wordCoo.Sort()

    End Sub

    Private Sub buildgroups(counter() As Integer)
        ' Semant. Gruppen erfassen
        Dim grpID As String
        Dim wtype As String
        Dim index As Long
        Dim i As Integer

        ' Gruppenzuweisung
        For i = 1 To wcnt(1)
            ' Pronomen
            grpID = wordPro(i).textgrp
            wtype = "Pro"
            index = counter(1) + i
            If (grpID <> "-") Then checkgroup(grpID, wtype, index)
        Next
        For i = 1 To wcnt(2)
            ' Nomen
            grpID = wordNom(i).textgrp
            wtype = "Nom"
            index = counter(2) + i
            If (grpID <> "-") Then checkgroup(grpID, wtype, index)
        Next
        For i = 1 To wcnt(3)
            ' Verb
            grpID = wordVer(i).textgrp
            wtype = "Ver"
            index = counter(3) + i
            If (grpID <> "-") Then checkgroup(grpID, wtype, index)
        Next
        For i = 1 To wcnt(4)
            ' Adverb
            grpID = wordAdv(i).textgrp
            wtype = "Adv"
            index = counter(4) + i
            If (grpID <> "-") Then checkgroup(grpID, wtype, index)
        Next
        For i = 1 To wcnt(5)
            ' Adjektiv
            grpID = wordAdj(i).textgrp
            wtype = "Adj"
            index = counter(5) + i
            If (grpID <> "-") Then checkgroup(grpID, wtype, index)
        Next
        For i = 1 To wcnt(6)
            ' Praeposition
            grpID = wordPre(i).textgrp
            wtype = "Pre"
            index = counter(6) + i
            If (grpID <> "-") Then checkgroup(grpID, wtype, index)
        Next
        For i = 1 To wcnt(7)
            ' Partikel
            grpID = wordPar(i).textgrp
            wtype = "Par"
            index = counter(7) + i
            If (grpID <> "-") Then checkgroup(grpID, wtype, index)
        Next
        For i = 1 To wcnt(8)
            ' Junktion
            grpID = wordJun(i).textgrp
            wtype = "Jun"
            index = counter(8) + i
            If (grpID <> "-") Then checkgroup(grpID, wtype, index)
        Next
        For i = 1 To wcnt(9)
            ' Ausdruck
            grpID = wordExp(i).textgrp
            wtype = "Exp"
            index = counter(9) + i
            If (grpID <> "-") Then checkgroup(grpID, wtype, index)
        Next
        For i = 1 To wcnt(10)
            ' Kookkurrenz
            grpID = wordCoo(i).textgrp
            wtype = "Coo"
            index = counter(10) + i
            If (grpID <> "-") Then checkgroup(grpID, wtype, index)
        Next

    End Sub

    Private Sub checkgroup(grpID As String, wtype As String, index As Long)
        ' Gruppen-Erfassung
        Dim found As Boolean
        Dim find(10) As Integer
        Dim fmax As Integer
        Dim c As Integer
        Dim i, j As Integer

        ' Init
        found = False

        fmax = Math.Floor(grpID.Length / 5)
        If (fmax > 10) Then fmax = 10
        For j = 0 To fmax
            For i = 1 To groupAll.Count - 1
                ' Test, ob Gruppe vorhanden
                If (grpID.Substring(j * 5, 4) = groupAll(i).ID) Then
                    found = True
                    find(j) = i
                    Exit For

                End If

            Next
        Next

        If (found = False) Then
            ' neue Gruppe anlegen, Wort hinzufuegen
            Dim tmpitem2 As grouptype
            tmpitem2 = New grouptype
            tmpitem2.ID = grpID
            tmpitem2.thm = "-"
            tmpitem2.nam = "-"
            tmpitem2.type = "-"
            tmpitem2.link = "-"
            tmpitem2.count = 1
            tmpitem2.partofspeech(1) = wtype
            tmpitem2.index(1) = Format(index, "00000")
            groupAll.Add(tmpitem2)
            tmpitem2 = Nothing
            ' Statistik
            ' Arten
            If (grpID.StartsWith("F") = True Or grpID.StartsWith("G") = True Or grpID.StartsWith("C") = True Or grpID.StartsWith("D") = True) Then
                fcnt(1) = fcnt(1) + 1
            ElseIf (grpID.StartsWith("K") = True) Then
                fcnt(2) = fcnt(2) + 1
            ElseIf (grpID.StartsWith("H") = True) Then
                fcnt(3) = fcnt(3) + 1
            ElseIf (grpID.StartsWith("S") = True) Then
                fcnt(4) = fcnt(4) + 1
            ElseIf (grpID.StartsWith("Y") = True) Then
                fcnt(5) = fcnt(5) + 1
            ElseIf (grpID.StartsWith("Z") = True) Then
                fcnt(6) = fcnt(6) + 1
            ElseIf (grpID.StartsWith("X") = True) Then
                fcnt(7) = fcnt(7) + 1
            ElseIf (grpID.StartsWith("A") = True) Then
                fcnt(8) = fcnt(8) + 1
            ElseIf (grpID.StartsWith("U") = True) Then
                fcnt(9) = fcnt(9) + 1
            ElseIf (grpID.StartsWith("V") = True) Then
                fcnt(10) = fcnt(10) + 1
            ElseIf (grpID.StartsWith("W") = True) Then
                fcnt(11) = fcnt(11) + 1
            End If

        ElseIf (found = True) Then
            ' Wort zu bestehender Gruppe hinzufuegen
            For j = 0 To fmax
                If (groupAll(find(j)).count < 33) Then
                    groupAll(find(j)).count = groupAll(find(j)).count + 1
                    c = groupAll(find(j)).count
                    groupAll(find(j)).partofspeech(c) = wtype
                    groupAll(find(j)).index(c) = Format(index, "00000")
                Else
                    'MsgBox("Gruppe " & grpID & " hat zu viel Elemente!", MsgBoxStyle.Exclamation, "Group has to much elements")
                End If

            Next

        End If

    End Sub

    Private Sub createwords(counter() As Integer, increment As Integer)
        ' Wort-XML
        Dim wordinfo(9) As String
        Dim wordempty(12) As String
        Dim i As Integer

        ' Init
        For i = 1 To 12
            wordempty(i) = ""
        Next

        ' Componieren
        For i = 1 To wcnt(1)
            ' Pronomen
            counter(1) = counter(1) + increment
            wordinfo(1) = wordPro(i).textword   ' nix
            wordinfo(2) = wordPro(i).textrefl   ' nix
            wordinfo(3) = wordPro(i).textkon    ' Kontext
            wordinfo(4) = wordPro(i).textsyn    ' Synonym
            wordinfo(5) = wordPro(i).textlev    ' Nivea
            wordinfo(6) = wordPro(i).textthm    ' Thema
            wordinfo(7) = wordPro(i).textgrp    ' Gruppe
            wordinfo(8) = wordPro(i).textcdeu   ' Deu
            wordinfo(9) = wordPro(i).textceng   ' Eng
            wordempty(setLang) = ""     ' wordinfo(2) & wordinfo(1)
            root.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab))
            node = vocaDOM.CreateElement("ns1:Pronomen")
            ' Attribute
            attr = vocaDOM.CreateAttribute("Nr")
            attr.Value = counter(1).ToString
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Nv")
            attr.Value = wordinfo(5)
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Th")
            attr.Value = wordinfo(6)
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Gr")
            attr.Value = wordinfo(7)
            node.setAttributeNode(attr)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ProGer")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(8)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ProEsp")
            elem.appendChild(vocaDOM.CreateTextNode(""))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ProEng")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(9)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ProFra")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(2)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ProSpa")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(3)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ProIta")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(4)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ProPor")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(5)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ProDan")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(6)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ProSwe")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(7)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ProGre")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(8)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ProRus")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(9)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ProPol")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(10)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ProCro")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(11)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ProSyn")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(4)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ProKon")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(3)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ProAny")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(12)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Ende
            node.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab))
            root.appendChild(node)
        Next
        For i = 1 To wcnt(2)
            ' Nomen
            counter(2) = counter(2) + increment
            wordinfo(1) = wordNom(i).textword
            wordinfo(2) = wordNom(i).textrefl
            wordinfo(3) = wordNom(i).textkon
            wordinfo(4) = wordNom(i).textsyn
            wordinfo(5) = wordNom(i).textlev
            wordinfo(6) = wordNom(i).textthm
            wordinfo(7) = wordNom(i).textgrp
            wordinfo(8) = wordNom(i).textcdeu
            wordinfo(9) = wordNom(i).textceng
            wordempty(setLang) = ""     ' wordinfo(2) & wordinfo(1)
            root.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab))
            node = vocaDOM.CreateElement("ns1:Nomen")
            ' Attribute
            attr = vocaDOM.CreateAttribute("Nr")
            attr.Value = counter(2).ToString
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Nv")
            attr.Value = wordinfo(5)
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Th")
            attr.Value = wordinfo(6)
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Gr")
            attr.Value = wordinfo(7)
            node.setAttributeNode(attr)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:NomGer")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(8)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:NomEsp")
            elem.appendChild(vocaDOM.CreateTextNode("**o"))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:NomEng")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(9)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:NomFra")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(2)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:NomSpa")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(3)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:NomIta")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(4)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:NomPor")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(5)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:NomDan")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(6)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:NomSwe")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(7)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:NomGre")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(8)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:NomRus")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(9)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:NomPol")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(10)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:NomCro")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(11)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:NomSyn")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(4)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:NomKon")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(3)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:NomAny")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(12)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Ende
            node.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab))
            root.appendChild(node)
        Next
        For i = 1 To wcnt(3)
            ' Verb
            counter(3) = counter(3) + increment
            wordinfo(1) = wordVer(i).textword
            wordinfo(2) = wordVer(i).textrefl
            wordinfo(3) = wordVer(i).textkon
            wordinfo(4) = wordVer(i).textsyn
            wordinfo(5) = wordVer(i).textlev
            wordinfo(6) = wordVer(i).textthm
            wordinfo(7) = wordVer(i).textgrp
            wordinfo(8) = wordVer(i).textcdeu
            wordinfo(9) = wordVer(i).textceng
            wordempty(setLang) = ""     ' wordinfo(2) & wordinfo(1)
            root.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab))
            node = vocaDOM.CreateElement("ns1:Verb")
            ' Attribute
            attr = vocaDOM.CreateAttribute("Nr")
            attr.Value = counter(3).ToString
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Nv")
            attr.Value = wordinfo(5)
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Th")
            attr.Value = wordinfo(6)
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Gr")
            attr.Value = wordinfo(7)
            node.setAttributeNode(attr)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:VerGer")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(8)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:VerEsp")
            elem.appendChild(vocaDOM.CreateTextNode("**i"))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:VerEng")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(9)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:VerFra")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(2)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:VerSpa")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(3)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:VerIta")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(4)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:VerPor")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(5)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:VerDan")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(6)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:VerSwe")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(7)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:VerGre")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(8)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:VerRus")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(9)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:VerPol")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(10)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:VerCro")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(11)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:VerSyn")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(4)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:VerKon")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(3)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:VerAny")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(12)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Ende
            node.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab))
            root.appendChild(node)
        Next
        For i = 1 To wcnt(4)
            ' Adverb
            counter(4) = counter(4) + increment
            wordinfo(1) = wordAdv(i).textword
            wordinfo(2) = wordAdv(i).textrefl
            wordinfo(3) = wordAdv(i).textkon
            wordinfo(4) = wordAdv(i).textsyn
            wordinfo(5) = wordAdv(i).textlev
            wordinfo(6) = wordAdv(i).textthm
            wordinfo(7) = wordAdv(i).textgrp
            wordinfo(8) = wordAdv(i).textcdeu
            wordinfo(9) = wordAdv(i).textceng
            wordempty(setLang) = ""     ' wordinfo(2) & wordinfo(1)
            root.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab))
            node = vocaDOM.CreateElement("ns1:Adverb")
            ' Attribute
            attr = vocaDOM.CreateAttribute("Nr")
            attr.Value = counter(4).ToString
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Nv")
            attr.Value = wordinfo(5)
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Th")
            attr.Value = wordinfo(6)
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Gr")
            attr.Value = wordinfo(7)
            node.setAttributeNode(attr)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdvGer")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(8)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdvEsp")
            elem.appendChild(vocaDOM.CreateTextNode(""))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdvEng")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(9)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdvFra")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(2)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdvSpa")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(3)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdvIta")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(4)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdvPor")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(5)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdvDan")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(6)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdvSwe")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(7)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdvGre")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(8)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdvRus")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(9)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdvPol")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(10)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdvCro")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(11)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdvSyn")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(4)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdvKon")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(3)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdvAny")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(12)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Ende
            node.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab))
            root.appendChild(node)
        Next
        For i = 1 To wcnt(5)
            ' Adjektiv
            counter(5) = counter(5) + increment
            wordinfo(1) = wordAdj(i).textword
            wordinfo(2) = wordAdj(i).textrefl
            wordinfo(3) = wordAdj(i).textkon
            wordinfo(4) = wordAdj(i).textsyn
            wordinfo(5) = wordAdj(i).textlev
            wordinfo(6) = wordAdj(i).textthm
            wordinfo(7) = wordAdj(i).textgrp
            wordinfo(8) = wordAdj(i).textcdeu
            wordinfo(9) = wordAdj(i).textceng
            wordempty(setLang) = ""     ' wordinfo(2) & wordinfo(1)
            root.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab))
            node = vocaDOM.CreateElement("ns1:Adjektiv")
            ' Attribute
            attr = vocaDOM.CreateAttribute("Nr")
            attr.Value = counter(5).ToString
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Nv")
            attr.Value = wordinfo(5)
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Th")
            attr.Value = wordinfo(6)
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Gr")
            attr.Value = wordinfo(7)
            node.setAttributeNode(attr)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdjGer")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(8)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdjEsp")
            elem.appendChild(vocaDOM.CreateTextNode("**a"))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdjEng")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(9)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdjFra")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(2)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdjSpa")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(3)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdjIta")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(4)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdjPor")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(5)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdjDan")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(6)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdjSwe")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(7)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdjGre")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(8)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdjRus")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(9)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdjPol")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(10)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdjCro")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(11)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdjSyn")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(4)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdjKon")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(3)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:AdjAny")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(12)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Ende
            node.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab))
            root.appendChild(node)
        Next
        For i = 1 To wcnt(6)
            ' Praeposition
            counter(6) = counter(6) + increment
            wordinfo(1) = wordPre(i).textword
            wordinfo(2) = wordPre(i).textrefl
            wordinfo(3) = wordPre(i).textkon
            wordinfo(4) = wordPre(i).textsyn
            wordinfo(5) = wordPre(i).textlev
            wordinfo(6) = wordPre(i).textthm
            wordinfo(7) = wordPre(i).textgrp
            wordinfo(8) = wordPre(i).textcdeu
            wordinfo(9) = wordPre(i).textceng
            wordempty(setLang) = ""     ' wordinfo(2) & wordinfo(1)
            root.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab))
            node = vocaDOM.CreateElement("ns1:Praeposition")
            ' Attribute
            attr = vocaDOM.CreateAttribute("Nr")
            attr.Value = counter(6).ToString
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Nv")
            attr.Value = wordinfo(5)
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Th")
            attr.Value = wordinfo(6)
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Gr")
            attr.Value = wordinfo(7)
            node.setAttributeNode(attr)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:PreGer")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(8)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:PreEsp")
            elem.appendChild(vocaDOM.CreateTextNode(""))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:PreEng")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(9)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:PreFra")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(2)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:PreSpa")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(3)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:PreIta")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(4)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:PrePor")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(5)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:PreDan")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(6)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:PreSwe")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(7)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:PreGre")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(8)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:PreRus")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(9)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:PrePol")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(10)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:PreCro")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(11)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:PreSyn")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(4)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:PreKon")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(3)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:PreAny")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(12)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Ende
            node.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab))
            root.appendChild(node)
        Next
        For i = 1 To wcnt(7)
            ' Partikel
            counter(7) = counter(7) + increment
            wordinfo(1) = wordPar(i).textword
            wordinfo(2) = wordPar(i).textrefl
            wordinfo(3) = wordPar(i).textkon
            wordinfo(4) = wordPar(i).textsyn
            wordinfo(5) = wordPar(i).textlev
            wordinfo(6) = wordPar(i).textthm
            wordinfo(7) = wordPar(i).textgrp
            wordinfo(8) = wordPar(i).textcdeu
            wordinfo(9) = wordPar(i).textceng
            wordempty(setLang) = ""     ' wordinfo(2) & wordinfo(1)
            root.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab))
            node = vocaDOM.CreateElement("ns1:Partikel")
            ' Attribute
            attr = vocaDOM.CreateAttribute("Nr")
            attr.Value = counter(7).ToString
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Nv")
            attr.Value = wordinfo(5)
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Th")
            attr.Value = wordinfo(6)
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Gr")
            attr.Value = wordinfo(7)
            node.setAttributeNode(attr)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ParGer")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(8)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ParEsp")
            elem.appendChild(vocaDOM.CreateTextNode(""))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ParEng")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(9)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ParFra")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(2)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ParSpa")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(3)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ParIta")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(4)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ParPor")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(5)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ParDan")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(6)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ParSwe")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(7)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ParGre")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(8)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ParRus")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(9)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ParPol")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(10)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ParCro")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(11)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ParSyn")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(4)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ParKon")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(3)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ParAny")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(12)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Ende
            node.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab))
            root.appendChild(node)
        Next
        For i = 1 To wcnt(8)
            ' Junktion
            counter(8) = counter(8) + increment
            wordinfo(1) = wordJun(i).textword
            wordinfo(2) = wordJun(i).textrefl
            wordinfo(3) = wordJun(i).textkon
            wordinfo(4) = wordJun(i).textsyn
            wordinfo(5) = wordJun(i).textlev
            wordinfo(6) = wordJun(i).textthm
            wordinfo(7) = wordJun(i).textgrp
            wordinfo(8) = wordJun(i).textcdeu
            wordinfo(9) = wordJun(i).textceng
            wordempty(setLang) = ""     ' wordinfo(2) & wordinfo(1)
            root.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab))
            node = vocaDOM.CreateElement("ns1:Junktion")
            ' Attribute
            attr = vocaDOM.CreateAttribute("Nr")
            attr.Value = counter(8).ToString
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Nv")
            attr.Value = wordinfo(5)
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Th")
            attr.Value = wordinfo(6)
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Gr")
            attr.Value = wordinfo(7)
            node.setAttributeNode(attr)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:JunGer")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(8)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:JunEsp")
            elem.appendChild(vocaDOM.CreateTextNode(""))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:JunEng")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(9)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:JunFra")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(2)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:JunSpa")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(3)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:JunIta")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(4)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:JunPor")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(5)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:JunDan")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(6)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:JunSwe")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(7)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:JunGre")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(8)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:JunRus")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(9)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:JunPol")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(10)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:JunCro")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(11)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:JunSyn")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(4)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:JunKon")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(3)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:JunAny")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(12)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Ende
            node.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab))
            root.appendChild(node)
        Next
        For i = 1 To wcnt(9)
            ' Ausdruck
            counter(9) = counter(9) + increment
            wordinfo(1) = wordExp(i).textword
            wordinfo(2) = wordExp(i).textrefl
            wordinfo(3) = wordExp(i).textkon
            wordinfo(4) = wordExp(i).textsyn
            wordinfo(5) = wordExp(i).textlev
            wordinfo(6) = wordExp(i).textthm
            wordinfo(7) = wordExp(i).textgrp
            wordinfo(8) = wordExp(i).textcdeu
            wordinfo(9) = wordExp(i).textceng
            wordempty(setLang) = ""     ' wordinfo(2) & wordinfo(1)
            root.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab))
            node = vocaDOM.CreateElement("ns1:Ausdruck")
            ' Attribute
            attr = vocaDOM.CreateAttribute("Nr")
            attr.Value = counter(9).ToString
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Nv")
            attr.Value = wordinfo(5)
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Th")
            attr.Value = wordinfo(6)
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Gr")
            attr.Value = wordinfo(7)
            node.setAttributeNode(attr)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ExpGer")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(8)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ExpEsp")
            elem.appendChild(vocaDOM.CreateTextNode(""))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ExpEng")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(9)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ExpFra")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(2)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ExpSpa")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(3)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ExpIta")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(4)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ExpPor")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(5)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ExpDan")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(6)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ExpSwe")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(7)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ExpGre")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(8)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ExpRus")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(9)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ExpPol")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(10)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ExpCro")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(11)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ExpSyn")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(4)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ExpKon")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(3)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:ExpAny")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(12)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Ende
            node.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab))
            root.appendChild(node)
        Next
        For i = 1 To wcnt(10)
            ' Kookkurrenz
            counter(10) = counter(10) + increment
            wordinfo(1) = wordCoo(i).textword
            wordinfo(2) = wordCoo(i).textrefl
            wordinfo(3) = wordCoo(i).textkon
            wordinfo(4) = wordCoo(i).textsyn
            wordinfo(5) = wordCoo(i).textlev
            wordinfo(6) = wordCoo(i).textthm
            wordinfo(7) = wordCoo(i).textgrp
            wordinfo(8) = wordCoo(i).textcdeu
            wordinfo(9) = wordCoo(i).textceng
            wordempty(setLang) = ""     ' wordinfo(2) & wordinfo(1)
            root.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab))
            node = vocaDOM.CreateElement("ns1:Kookkurrenz")
            ' Attribute
            attr = vocaDOM.CreateAttribute("Nr")
            attr.Value = counter(10).ToString
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Nv")
            attr.Value = wordinfo(5)
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Th")
            attr.Value = wordinfo(6)
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Gr")
            attr.Value = wordinfo(7)
            node.setAttributeNode(attr)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:CooGer")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(8)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:CooEsp")
            elem.appendChild(vocaDOM.CreateTextNode(""))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:CooEng")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(9)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:CooFra")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(2)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:CooSpa")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(3)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:CooIta")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(4)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:CooPor")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(5)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:CooDan")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(6)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:CooSwe")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(7)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:CooGre")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(8)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:CooRus")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(9)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:CooPol")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(10)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:CooCro")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(11)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:CooSyn")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(4)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:CooKon")
            elem.appendChild(vocaDOM.CreateTextNode(wordinfo(3)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Unterelemente: .
            frag = vocaDOM.CreateDocumentFragment
            frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            elem = vocaDOM.CreateElement("ns1:CooAny")
            elem.appendChild(vocaDOM.CreateTextNode(wordempty(12)))
            frag.appendChild(elem)
            node.appendChild(frag)
            ' Ende
            node.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab))
            root.appendChild(node)
        Next

    End Sub

    Private Sub createheader(par As Integer)
        ' Header XML
        Dim Datum As Date
        Dim Zeit As Date
        Dim strDatum As String
        Dim strZeit As String
        Dim wcntstr(12) As Long
        Dim ccnt(4, 2) As Long
        Dim i As Integer

        ' aktuelles Datum
        Datum = System.DateTime.Today.Date
        strDatum = Format(Datum.Day, "00") & "." & Format(Datum.Month, "00") & "." & Format(Datum.Year, "0000")

        ' aktuelle Uhrzeit
        Zeit = Now()
        strZeit = Format(Zeit.Hour, "00") & ":" & Format(Zeit.Minute, "00") & ":" & Format(Zeit.Second, "00")

        ' Init
        For i = 1 To 12
            wcntstr(12) = "0"
        Next
        wcntstr(setLang) = wcnt(0)

        ' Theme and Group Count Sum
        ccnt(1, 1) = tcnt(1) + tcnt(2) + tcnt(3) + tcnt(4) + tcnt(5) + tcnt(6) + tcnt(7)
        ccnt(2, 1) = tcnt(8) + tcnt(9) + tcnt(10) + tcnt(11) + tcnt(12) + tcnt(13) + tcnt(14) + tcnt(15)
        ccnt(3, 1) = tcnt(16) + tcnt(17) + tcnt(18) + tcnt(19)
        ccnt(4, 1) = tcnt(20) + tcnt(21) + tcnt(22) + tcnt(23) + tcnt(24) + tcnt(25)
        ccnt(1, 2) = gcnt(1) + gcnt(2) + gcnt(3) + gcnt(4) + gcnt(5) + gcnt(6) + gcnt(7)
        ccnt(2, 2) = gcnt(8) + gcnt(9) + gcnt(10) + gcnt(11) + gcnt(12) + gcnt(13) + gcnt(14) + gcnt(15)
        ccnt(3, 2) = gcnt(16) + gcnt(17) + gcnt(18) + gcnt(19)
        ccnt(4, 2) = gcnt(20) + gcnt(21) + gcnt(22) + gcnt(23) + gcnt(24) + gcnt(25)

        dataDOM = vocaDOM.CreateComment(" Extensible Multilingual Vocabulary ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Esperanto: Vokabular aus Wortprofi " & wcnt(0).ToString & " Einträge, " & (groupAll.Count - 1).ToString & " Gruppen ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Sources: Dictionaries von Langenscheidt, PONS, u.a. ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Internet Dictionaries: ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" * http://de.pons.com/übersetzung ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" * http://depl.dict.cc/ ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" * https://dict.leo.org/ ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" * http://www.woxikon.de/ ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" * http://dict.tu-chemnitz.de/ ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" * http://www.crodict.de/ ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" * http://www.albertmartin.de/esperanto/ ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Decaleon plus 6.0 ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Deutsch : xx.xx.2018 : " & wcntstr(0).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" English : xx.xx.2018 : " & wcntstr(1).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Italiano: xx.xx.2018 : " & wcntstr(4).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Francais: xx.xx.2018 : " & wcntstr(2).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Espanol : xx.xx.2018 : " & wcntstr(3).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Portoges: xx.xx.2018 : " & wcntstr(5).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Ellenika: xx.xx.2018 : " & wcntstr(8).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Russkij : xx.xx.2018 : " & wcntstr(9).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Polski  : xx.xx.2018 : " & wcntstr(10).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Dansk   : xx.xx.2018 : " & wcntstr(6).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Svenska : xx.xx.2018 : " & wcntstr(7).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Hrvatski: xx.xx.2018 : " & wcntstr(11).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Context : xx.xx.2018 ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Synonyms: xx.xx.2018 ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Niveaus : xx.xx.2018 ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Themes  : xx.xx.2018 ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Addition: xx.xx.2018 ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Groups  : xx.xx.2018 ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" LastEdit: " & strDatum & " at " & strZeit)
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" currTask: Niveaus, Themes ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" nextTask: English, Esperanto ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Version 1.0 Juli 2009 - November 2009 ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Version 2.0 Januar 2010 - April 2011 ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Version 3.0 November 2011 - Dezember 2013 ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Version 4.0 Januar 2014 - Juni 2015 ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Version 5.0 Februar 2015 - Dezember 2016 ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Version 6.0 Februar 2016 - Dezember 2018 ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" by gearwheelsoft2@hotmail.com ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" gearwheelsoft2/sourceforge.net ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Wortarten ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	Pronomen       " & wcnt(1).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	Nomen [ok]     " & wcnt(2).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	Verb [ok]      " & wcnt(3).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	Adverb [ok]    " & wcnt(4).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	Adjektiv [ok]  " & wcnt(5).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	Praeposition   " & wcnt(6).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	Partikel       " & wcnt(7).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	Junktion       " & wcnt(8).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	Ausdruck       " & wcnt(9).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	Kookkurrenz    " & wcnt(10).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Wortarten ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Niveaus ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	A1/basic         " & ncnt(1).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	A2/essential     " & ncnt(2).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	B1/extended      " & ncnt(3).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	B2/comprehensive " & ncnt(4).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	C1/extensive     " & ncnt(5).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	C2/all-embracing " & ncnt(6).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	EX/technical     " & ncnt(7).ToString("00000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Niveaus ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Themen ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	A/Privates Leben                       " & ccnt(1, 1).ToString("00000") & " / " & ccnt(1, 2).ToString("000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	B/Öffentliches Leben                   " & ccnt(2, 1).ToString("00000") & " / " & ccnt(2, 2).ToString("000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	C/Kultur und Wissenschaften            " & ccnt(3, 1).ToString("00000") & " / " & ccnt(3, 2).ToString("000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	D/Allgemeine und Strukturelle Begriffe " & ccnt(4, 1).ToString("00000") & " / " & ccnt(4, 2).ToString("000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	A/01 Herkunft und Sprachen                " & tcnt(1).ToString("0000") & " / " & gcnt(1).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	A/02 Menschlicher Körper und Sinne        " & tcnt(2).ToString("0000") & " / " & gcnt(2).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	A/03 Gesundheit und Medizin               " & tcnt(3).ToString("0000") & " / " & gcnt(3).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	A/04 Psyche, Geist und Verhalten          " & tcnt(4).ToString("0000") & " / " & gcnt(4).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	A/05 Einkaufen, Ernährung und Kleidung    " & tcnt(5).ToString("0000") & " / " & gcnt(5).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	A/06 Wohnen und Haushalt                  " & tcnt(6).ToString("0000") & " / " & gcnt(6).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	A/07 Familie und Privatleben              " & tcnt(7).ToString("0000") & " / " & gcnt(7).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	B/08 Erziehung und Bildungswesen          " & tcnt(8).ToString("0000") & " / " & gcnt(8).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	B/09 Berufs- und Arbeitswelt              " & tcnt(9).ToString("0000") & " / " & gcnt(9).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	B/10 Freizeit, Unterhaltung und Sport     " & tcnt(10).ToString("0000") & " / " & gcnt(10).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	B/11 Reisen und Gastronomie               " & tcnt(11).ToString("0000") & " / " & gcnt(11).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	B/12 Verkehr und Transport                " & tcnt(12).ToString("0000") & " / " & gcnt(12).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	B/13 Staat, Gesetz und Gesellschaft       " & tcnt(13).ToString("0000") & " / " & gcnt(13).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	B/14 Wirtschaft und Finanzen              " & tcnt(14).ToString("0000") & " / " & gcnt(14).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	B/15 Kommunikation und Medien             " & tcnt(15).ToString("0000") & " / " & gcnt(15).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	C/16 Kunst, Musik und Literatur           " & tcnt(16).ToString("0000") & " / " & gcnt(16).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	C/17 Geschichte, Religion und Philosophie " & tcnt(17).ToString("0000") & " / " & gcnt(17).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	C/18 Erde, Natur und Umwelt               " & tcnt(18).ToString("0000") & " / " & gcnt(18).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	C/19 Naturwissenschaft und Technik        " & tcnt(19).ToString("0000") & " / " & gcnt(19).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	D/20 Raum und Zeit                        " & tcnt(20).ToString("0000") & " / " & gcnt(20).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	D/21 Farben und Formen                    " & tcnt(21).ToString("0000") & " / " & gcnt(21).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	D/22 Menge, Zahlen und Maße               " & tcnt(22).ToString("0000") & " / " & gcnt(22).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	D/23 Eigenschaften und Modalitäten        " & tcnt(23).ToString("0000") & " / " & gcnt(23).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	D/24 Sprachliche Konstrukte               " & tcnt(24).ToString("0000") & " / " & gcnt(24).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	D/25 Funktionswörter                      " & tcnt(25).ToString("0000") & " / " & gcnt(25).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	D/26 Ausdrücke und Wendungen              " & tcnt(26).ToString("0000") & " / " & gcnt(26).ToString("00") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Themen ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Gruppen ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	F,G,C,D/Wortfeld" & fcnt(1).ToString("000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	K/Komplement    " & fcnt(2).ToString("000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	H/Hierarchie    " & fcnt(3).ToString("000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	S/Synonym Nomen " & fcnt(4).ToString("000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	Y/Synonym Verb  " & fcnt(5).ToString("000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	Z/Synonym Adj   " & fcnt(6).ToString("000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	X/Synonym Adv   " & fcnt(7).ToString("000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	A/Antonym Nomen " & fcnt(8).ToString("000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	U/Antonym Verb  " & fcnt(9).ToString("000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	V/Antonym Adj   " & fcnt(10).ToString("000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	W/Antonym Adv   " & fcnt(11).ToString("000") & " ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Gruppen ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Bemerkungen ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	Empty Entries usually are designated by *** (unknown) or ### (not common) ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	Empty Entries in Esperanto differ for Nouns (**o), Verbs (**i) and Adjectives (**a) ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" 	Group Members in Format LLLXXXXX[#LLL] (5-digit Index!) ")
        vocaDOM.AppendChild(dataDOM)
        dataDOM = vocaDOM.CreateComment(" Bemerkungen ")
        vocaDOM.AppendChild(dataDOM)

    End Sub

    Private Sub creategroups(par As Integer)
        ' Semant.Gruppen schreiben
        Dim c As Integer
        Dim i As Integer

        For i = 1 To groupAll.Count - 1

            ' Gruppen-Ele
            root.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab))
            node = vocaDOM.CreateElement("ns1:Gruppe")
            ' Attribute
            attr = vocaDOM.CreateAttribute("Nr")
            attr.Value = groupAll(i).ID
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Tp")
            attr.Value = groupAll(i).type
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Nm")
            attr.Value = groupAll(i).nam
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Th")
            attr.Value = groupAll(i).thm
            node.setAttributeNode(attr)
            attr = vocaDOM.CreateAttribute("Lk")
            attr.Value = groupAll(i).link
            node.setAttributeNode(attr)

            For c = 1 To groupAll(i).count
                ' check
                If (groupAll(i).partofspeech(c).StartsWith("XXX") = False) Then
                    ' Unterelemente: 
                    frag = vocaDOM.CreateDocumentFragment
                    frag.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
                    elem = vocaDOM.CreateElement("ns1:GrpMem")
                    elem.appendChild(vocaDOM.CreateTextNode(groupAll(i).partofspeech(c) & groupAll(i).index(c)))
                    frag.appendChild(elem)
                    node.appendChild(frag)

                End If

            Next

            ' Ende
            node.appendChild(vocaDOM.CreateTextNode(vbNewLine + vbTab))
            root.appendChild(node)

        Next
        root.appendChild(vocaDOM.CreateTextNode(vbNewLine))

    End Sub

    Private Sub createlinks(counter() As Integer, increment As Integer)
        ' Cooc Links schreiben
        Dim wordinfo(9) As String
        Dim wordempty(12) As String
        Dim i As Integer
        Dim c As Integer

        ' Init
        For i = 1 To 12
            wordempty(i) = ""
        Next

        c = 0
        ' Componieren
        For i = 1 To wcnt(10)
            c = c + 1
            ' Kookkurrenzen
            counter(1) = counter(1) + increment
            wordinfo(1) = wordCoo(i).textword   ' nix
            wordinfo(2) = wordCoo(i).textrefl   ' nix
            wordinfo(3) = wordCoo(i).textkon    ' Kontext
            wordinfo(4) = wordCoo(i).textsyn    ' Synonym
            wordinfo(5) = wordCoo(i).textlev    ' Nivea
            wordinfo(6) = wordCoo(i).textthm    ' Thema
            wordinfo(7) = wordCoo(i).textgrp    ' Gruppe
            wordinfo(8) = wordCoo(i).textcdeu   ' Deu
            wordinfo(9) = wordCoo(i).textceng   ' Eng
            wordempty(setLang) = ""     ' wordinfo(2) & wordinfo(1)

            ' Gruppen-Ele
            root.appendChild(linkDOM.CreateTextNode(vbNewLine + vbTab))
            node = linkDOM.CreateElement("ns1:Kookkurrenz")
            node.appendChild(linkDOM.CreateTextNode(c.ToString))
            ' Attribute
            attr = linkDOM.CreateAttribute("Nr")
            attr.Value = i.ToString
            node.setAttributeNode(attr)
            attr = linkDOM.CreateAttribute("PoS")
            attr.Value = wordinfo(4).Substring(0, 3)
            node.setAttributeNode(attr)
            attr = linkDOM.CreateAttribute("Num")
            attr.Value = wordinfo(4).Substring(3, 5)
            node.setAttributeNode(attr)

            ' Ende
            'node.appendChild(linkDOM.CreateTextNode(vbNewLine + vbTab))
            root.appendChild(node)

        Next
        root.appendChild(linkDOM.CreateTextNode(vbNewLine))

    End Sub

    Private Sub initInstanz()
        ' Init Instanzen
        ' Woerter
        Dim tmpitem As wordtype
        tmpitem = New wordtype
        wordPro.Add(tmpitem)
        tmpitem = Nothing
        tmpitem = New wordtype
        wordNom.Add(tmpitem)
        tmpitem = Nothing
        tmpitem = New wordtype
        wordVer.Add(tmpitem)
        tmpitem = Nothing
        tmpitem = New wordtype
        wordAdv.Add(tmpitem)
        tmpitem = Nothing
        tmpitem = New wordtype
        wordAdj.Add(tmpitem)
        tmpitem = Nothing
        tmpitem = New wordtype
        wordPre.Add(tmpitem)
        tmpitem = Nothing
        tmpitem = New wordtype
        wordPar.Add(tmpitem)
        tmpitem = Nothing
        tmpitem = New wordtype
        wordJun.Add(tmpitem)
        tmpitem = Nothing
        tmpitem = New wordtype
        wordExp.Add(tmpitem)
        tmpitem = Nothing
        tmpitem = New wordtype
        wordCoo.Add(tmpitem)
        tmpitem = Nothing
        ' Gruppen
        Dim tmpitem2 As grouptype
        tmpitem2 = New grouptype
        groupAll.Add(tmpitem2)
        tmpitem2 = Nothing

    End Sub

End Class


Class wordtype : Implements IComparable
    ' Daten-Klasse Woerter

    Public textword As String
    Public textrefl As String
    Public textkon As String
    Public textsyn As String
    Public textlev As String
    Public textthm As String
    Public textgrp As String
    Public textcdeu As String
    Public textceng As String

    Private Class WordListElementSortingHelper : Implements IComparer
        Public Function Compare(ByVal a As Object, ByVal b As Object) As Integer Implements System.Collections.IComparer.Compare
            Dim c1 As wordtype = CType(a, wordtype)
            Dim c2 As wordtype = CType(b, wordtype)

            'If (c1._wordListSort > c2._wordListSort) Then
            '    Return 1
            'End If
            'If (c1._wordListSort < c2._wordListSort) Then
            '    Return -1
            'Else
            '    Return 0
            'End If

            Dim result As Integer = StringComparer.CurrentCulture.Compare(c1.textword, c2.textword)
            If (result = 0) Then result = StringComparer.Ordinal.Compare(c1.textword, c2.textword)
            Return result

        End Function
    End Class

    Function CompareTo(ByVal obj As Object) As Integer Implements IComparable.CompareTo
        Dim c As wordtype = CType(obj, wordtype)

        Return String.Compare(Me.textword, c.textword)
    End Function

    Public Shared Function sortYearAscending() As IComparer
        Return CType(New WordListElementSortingHelper(), IComparer)
    End Function

End Class


Public Class grouptype
    ' Daten-Klasse Gruppen
    Dim groupMax As Integer = 35

    Public ID As String
    Public thm As String
    Public nam As String
    Public type As String
    Public link As String
    Public count As Integer
    Public partofspeech(groupMax) As String
    Public index(groupMax) As String

End Class

