﻿Option Explicit On

' Translation of Sentences from 12 Languages to Esperanto
'
' Graphical User Interface
'
' MP Jun /Nov  2009 Version 1.0 - Vokabular.xml bilingual
' MP Jan /Jun  2010 Version 2.0 - Vokabular.xml preliminary
' MP Mar /Apr  2011 Version 2.0 - Vokabular.xml 5 Languages completed
' MP Jan /Dec  2012 Version 3.0 - Vocabulary.xml 10 Languages in UTF-8/Unicode
' MP Oct /Dec  2013 Version 3.0 - Vocabulary.xml Grammar Vocagram.xml (TEXminer)
' MP Jan /Dec  2014 Version 4.0 - Vocabulary.xml 12 Languages, 4000 more Words, Semantic Groups
' MP Feb /Mar  2015 Version 5.0 - VocaAddition.xml 8500 Words Addition, extra Technical Vocabulary Extensions
' MP Mar /Apr  2016 Version 6.0 - VocaAddition2.xml 24000 Words Addition, Import Files for another 12 Languages (AnyLanguage)
' MP May /Aug  2018 Version 6.0 - VocaAddition3.xml 12000 Words Addition, Cooccurrences Database inclusive Links


Imports System.IO


Public Class Decaleon

    Private Sub Esperanto_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Dim ret As Boolean

        initDone = False

        ' Splash Screen anzeigen
        FormSplash.Show()
        Application.DoEvents()

        ' Test auf passende Font-Dateien
        If (File.Exists(pubFontRoot & pubFont1) = False Or File.Exists(pubFontRoot & pubFont2) = False Or _
            File.Exists(pubFontRoot & pubFont3) = False Or File.Exists(pubFontRoot & pubFont4) = False) Then
            MsgBox("Special characters of Esperanto not available!" & vbCrLf & _
            "Please unpack eve-ttf.zip and copy the four Orion-TTFs into C:\Windows\Fonts", MsgBoxStyle.Exclamation, "Missing Fonts")
        End If

        ' Redimensionierung der globalen Grammatik-Stuktur
        redimGrammar(0)

        ' Redimensionierung der globalen Vokabular-Stuktur
        initVocabulary(0)

        ' Initialisierung der Sprachen-Namen
        initLanguages(0)

        ' Initialisierung der Themen-Bezeichnungen
        initThemes(0)

        ' Initialisierung der Fachbereiche
        initExtNames(0)

        ' Flaggen-Info lesen
        initFlagInfo(0)

        ' Form-Objekt
        frmEsperanto = Me

        ' Standard-Vokabular lesen
        ret = readVocabulary("standard")

        ' Zusatz-Vokabular lesen
        ret = readVocabulary("addition")

        ' Zusatz-Vokabular (2) lesen
        ret = readVocabulary("addition2")

        ' Zusatz-Vokabular (3) lesen
        ret = readVocabulary("addition3")

        ' Kookkurrenz-Vokabular lesen
        ret = readVocabulary("cooccurrence")

        ' Extra-Vokabular lesen
        ret = readVocabulary("extra")

        ' Cooc-Links lesen
        ret = readCoocLink(0)

        ' Subthemen-Information lesen
        ret = importSemanticGroupAll("SemantischeGruppenAll.txt", 0)

        ' Sprachen-Auswahl
        'frmEsperanto.ComboBoxLanguage.Text = "Bitte wählen!"
        frmEsperanto.ComboBoxLanguage.Items.Add("Deutsch")
        frmEsperanto.ComboBoxLanguage.Items.Add("English")
        frmEsperanto.ComboBoxLanguage.Items.Add("Français")
        frmEsperanto.ComboBoxLanguage.Items.Add("Español")
        frmEsperanto.ComboBoxLanguage.Items.Add("Italiano")
        frmEsperanto.ComboBoxLanguage.Items.Add("Português")
        frmEsperanto.ComboBoxLanguage.Items.Add("Dansk")
        frmEsperanto.ComboBoxLanguage.Items.Add("Svenska")
        frmEsperanto.ComboBoxLanguage.Items.Add("Ελληνικά")
        frmEsperanto.ComboBoxLanguage.Items.Add("Русский")
        frmEsperanto.ComboBoxLanguage.Items.Add("Polski")
        frmEsperanto.ComboBoxLanguage.Items.Add("Hrvatski")
        frmEsperanto.ComboBoxLanguage.Items.Add("Any Language")
        frmEsperanto.ComboBoxLanguage.SelectedIndex = 1

        ' Edit loeschen
        clearEdit(0)

        ' Window
        frmEsperanto.Text = "DecaleonPlus Esperanto Translator V6.0"
        Dim fnt As Font = frmEsperanto.ButtonHelp.Font
        frmEsperanto.ButtonHelp.Font = New Font(fnt.Name, 14, FontStyle.Bold)

        initDone = True

    End Sub

    Private Sub ButtonLoadXML_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonLoadXML.Click
        ' Laden der XML-Grammatik
        Dim fileName As String
        Dim language As Integer
        Dim reti As Integer
        Dim ret As Boolean

        ' Datei-Auswahl
        frmEsperanto.OpenFileDialog1.InitialDirectory = Application.StartupPath
        frmEsperanto.OpenFileDialog1.Filter = "*.xml" & "|*.xml"
        frmEsperanto.OpenFileDialog1.Title = "Import Grammatik"
        frmEsperanto.OpenFileDialog1.FileName = ""
        reti = frmEsperanto.OpenFileDialog1.ShowDialog()
        If (reti = vbCancel) Then
            Exit Sub
        End If
        fileName = frmEsperanto.OpenFileDialog1.FileName

        ' Laden
        pubDataGrammar = readGrammar(fileName)

        ' Anzeige Dateiname
        frmEsperanto.TextBoxFile.Text = fileName
        ' Anzeige Orginal
        frmEsperanto.RichTextBoxOriginal.Text = pubDataGrammar._Original
        ' Anzeige Uebersetzung leeren
        frmEsperanto.RichTextBoxEsperanto.Text = ""

        ' Anzeige TreeView
        frmEsperanto.TreeViewGrammatik.Nodes.Clear()
        ret = showGrammarAsTreeview(0)

        ' Feststellung der Sprache
        language = checkLanguage(0)
        If (language > -1) Then
            MsgBox("The Language is probably " & pubLanguage(language), MsgBoxStyle.Information, "Language Analysis")
        End If

        ' Focus
        frmEsperanto.ButtonTranslate.Focus()

    End Sub

    Private Sub ButtonTranslate_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonTranslate.Click
        ' Uebersetzen in Esperanto
        Dim uebersetzung As String
        Dim language As Integer

        ' Fehler
        If (pubDataGrammar._Done = False) Then
            MsgBox("Nothing imported! Please use one of the example XML grammar files or create a new one.", MsgBoxStyle.Information, "Translator")
            Exit Sub
        End If

        ' Sprache
        language = frmEsperanto.ComboBoxLanguage.SelectedIndex + 1

        ' Uebersetzung
        uebersetzung = TranslateEsperanto.translateToEsperanto(language)

        ' Anzeige aufbereiten
        uebersetzung = TranslateEsperanto.printPretty(uebersetzung)

        ' Anzeige Uebersetzung
        frmEsperanto.RichTextBoxEsperanto.Text = uebersetzung

    End Sub

    Private Sub ButtonSaveXML_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonSaveXML.Click
        ' Speichern der XML-Grammatik
        Dim fileName As String
        Dim reti As Integer
        Dim ret As Boolean

        ' Datei-Auswahl
        frmEsperanto.SaveFileDialog1.InitialDirectory = Application.StartupPath
        frmEsperanto.SaveFileDialog1.Filter = "*.xml" & "|*.xml"
        frmEsperanto.SaveFileDialog1.Title = "Export Grammatik"
        frmEsperanto.SaveFileDialog1.FileName = ""
        reti = frmEsperanto.SaveFileDialog1.ShowDialog()
        If (reti = vbCancel) Then
            Exit Sub
        End If
        fileName = frmEsperanto.SaveFileDialog1.FileName

        ' Sichern
        ret = writeGrammar(fileName)

    End Sub

    Private Sub ComboBoxLanguage_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboBoxLanguage.SelectedIndexChanged
        ' Anzeige nach Sprache
        Dim sumOfSize As Integer
        Dim sumOfCount As Integer
        Dim langInd As Integer
        Dim langStr As String
        Dim langIco As String
        Dim cnt As Integer

        langStr = "xxxxx"
        If (ComboBoxLanguage.SelectedIndex = 0) Then
            pubFromLanguage = LangName.Deutsch
            langStr = "German"
            frmEsperanto.ButtonLoadXML.Text = "XML-Grammatik laden ..."
            frmEsperanto.ButtonTranslate.Text = "Übersetzen"
            frmEsperanto.ButtonSaveXML.Text = "XML-Grammatik speichern ..."
            frmEsperanto.ButtonDictionary.Text = "Wörterbuch"
            frmEsperanto.LabelFile.Text = "Datei"
            frmEsperanto.LabelOriginal.Text = "Original"
            frmEsperanto.LabelEsperanto.Text = "Esperanto"
            frmEsperanto.LabelFehler.Text = "Fehlermeldung"
        ElseIf (ComboBoxLanguage.SelectedIndex = 1) Then
            pubFromLanguage = LangName.English
            langStr = "English"
            frmEsperanto.ButtonLoadXML.Text = "Load XML Grammar ..."
            frmEsperanto.ButtonTranslate.Text = "Translate"
            frmEsperanto.ButtonSaveXML.Text = "Save XML Grammar ..."
            frmEsperanto.ButtonDictionary.Text = "Dictionary"
            frmEsperanto.LabelFile.Text = "File"
            frmEsperanto.LabelOriginal.Text = "Original"
            frmEsperanto.LabelEsperanto.Text = "Esperanto"
            frmEsperanto.LabelFehler.Text = "Error Message"
        ElseIf (ComboBoxLanguage.SelectedIndex = 2) Then
            pubFromLanguage = LangName.Francais
            langStr = "French"
            frmEsperanto.ButtonLoadXML.Text = "Import XML Gramaire ..."
            frmEsperanto.ButtonTranslate.Text = "Traducteur"
            frmEsperanto.ButtonSaveXML.Text = "Export XML Gramaire ..."
            frmEsperanto.ButtonDictionary.Text = "Dictionnaire"
            frmEsperanto.LabelFile.Text = "File"
            frmEsperanto.LabelOriginal.Text = "Original"
            frmEsperanto.LabelEsperanto.Text = "Esperanto"
            frmEsperanto.LabelFehler.Text = "Message d'Erreur"
        ElseIf (ComboBoxLanguage.SelectedIndex = 3) Then
            pubFromLanguage = LangName.Espanol
            langStr = "Spanish"
            frmEsperanto.ButtonLoadXML.Text = "Import XML Gramatica ..."
            frmEsperanto.ButtonTranslate.Text = "Traducir"
            frmEsperanto.ButtonSaveXML.Text = "Export XML Gramatica ..."
            frmEsperanto.ButtonDictionary.Text = "Diccionario"
            frmEsperanto.LabelFile.Text = "File"
            frmEsperanto.LabelOriginal.Text = "Original"
            frmEsperanto.LabelEsperanto.Text = "Esperanto"
            frmEsperanto.LabelFehler.Text = "Mensaje de Error"
        ElseIf (ComboBoxLanguage.SelectedIndex = 4) Then
            pubFromLanguage = LangName.Italiano
            langStr = "Italian"
            frmEsperanto.ButtonLoadXML.Text = "Import XML Grammatica ..."
            frmEsperanto.ButtonTranslate.Text = "Tradurre"
            frmEsperanto.ButtonSaveXML.Text = "Export XML Grammatica ..."
            frmEsperanto.ButtonDictionary.Text = "Dizionario"
            frmEsperanto.LabelFile.Text = "File"
            frmEsperanto.LabelOriginal.Text = "Original"
            frmEsperanto.LabelEsperanto.Text = "Esperanto"
            frmEsperanto.LabelFehler.Text = "Messaggio d'Errore"
        ElseIf (ComboBoxLanguage.SelectedIndex = 5) Then
            pubFromLanguage = LangName.Portoguese
            langStr = "Portoguese"
            frmEsperanto.ButtonLoadXML.Text = "Load XML Gramatica ..."
            frmEsperanto.ButtonTranslate.Text = "Traduzir"
            frmEsperanto.ButtonSaveXML.Text = "Gravar XML Gramatica ..."
            frmEsperanto.ButtonDictionary.Text = "Dicionário"
            frmEsperanto.LabelFile.Text = "Ficheiro"
            frmEsperanto.LabelOriginal.Text = "Original"
            frmEsperanto.LabelEsperanto.Text = "Esperanto"
            frmEsperanto.LabelFehler.Text = "Error Message"
        ElseIf (ComboBoxLanguage.SelectedIndex = 6) Then
            pubFromLanguage = LangName.Dansk
            langStr = "Danish"
            frmEsperanto.ButtonLoadXML.Text = "Åbne XML Grammatik ..."
            frmEsperanto.ButtonTranslate.Text = "Oversætte"
            frmEsperanto.ButtonSaveXML.Text = "Skabe XML Grammatik ..."
            frmEsperanto.ButtonDictionary.Text = "Ordbog"
            frmEsperanto.LabelFile.Text = "Fil"
            frmEsperanto.LabelOriginal.Text = "Oprindelige"
            frmEsperanto.LabelEsperanto.Text = "Esperanto"
            frmEsperanto.LabelFehler.Text = "Fejl Budskab"
        ElseIf (ComboBoxLanguage.SelectedIndex = 7) Then
            pubFromLanguage = LangName.Svenska
            langStr = "Swedish"
            frmEsperanto.ButtonLoadXML.Text = "Öppna XML Grammatik ..."
            frmEsperanto.ButtonTranslate.Text = "Översätta"
            frmEsperanto.ButtonSaveXML.Text = "Spara XML Grammatik ..."
            frmEsperanto.ButtonDictionary.Text = "Ordbok"
            frmEsperanto.LabelFile.Text = "Arkiv"
            frmEsperanto.LabelOriginal.Text = "Original"
            frmEsperanto.LabelEsperanto.Text = "Esperanto"
            frmEsperanto.LabelFehler.Text = "Fel Meddelande"
        ElseIf (ComboBoxLanguage.SelectedIndex = 8) Then
            pubFromLanguage = LangName.Ellenika
            langStr = "Greek"
            frmEsperanto.ButtonLoadXML.Text = "Ανοιγω XML Γραμματικμ ..."
            frmEsperanto.ButtonTranslate.Text = "Μεταφραζω"
            frmEsperanto.ButtonSaveXML.Text = "Αποφηκευω XML Γραμματικμ ..."
            frmEsperanto.ButtonDictionary.Text = "Λεξικο"
            frmEsperanto.LabelFile.Text = "Αρχειο"
            frmEsperanto.LabelOriginal.Text = "Πρωτοτυλο"
            frmEsperanto.LabelEsperanto.Text = "Esperanto"
            frmEsperanto.LabelFehler.Text = "Μηνυμα λανφασμενης λειτουργιας"
        ElseIf (ComboBoxLanguage.SelectedIndex = 9) Then
            pubFromLanguage = LangName.Russkij
            langStr = "Russian"
            frmEsperanto.ButtonLoadXML.Text = "открывать XML Грамматика ..."
            frmEsperanto.ButtonTranslate.Text = "Ререводить"
            frmEsperanto.ButtonSaveXML.Text = "Записывать XML Грамматика ..."
            frmEsperanto.ButtonDictionary.Text = "Словарь"
            frmEsperanto.LabelFile.Text = "Файл"
            frmEsperanto.LabelOriginal.Text = "Оригинал"
            frmEsperanto.LabelEsperanto.Text = "Esperanto"
            frmEsperanto.LabelFehler.Text = "Сообщение об ошибке"
        ElseIf (ComboBoxLanguage.SelectedIndex = 10) Then
            pubFromLanguage = LangName.Polski
            langStr = "Polish"
            frmEsperanto.ButtonLoadXML.Text = "Otwierać XML Gramatyka ..."
            frmEsperanto.ButtonTranslate.Text = "Przekładać"
            frmEsperanto.ButtonSaveXML.Text = "Zapisywać XML Gramatyka ..."
            frmEsperanto.ButtonDictionary.Text = "Słownik"
            frmEsperanto.LabelFile.Text = "Plik"
            frmEsperanto.LabelOriginal.Text = "Oryginał"
            frmEsperanto.LabelEsperanto.Text = "Esperanto"
            frmEsperanto.LabelFehler.Text = "Komunikat o błędzie"
        ElseIf (ComboBoxLanguage.SelectedIndex = 11) Then
            pubFromLanguage = LangName.Hrvatski
            langStr = "Croatian"
            frmEsperanto.ButtonLoadXML.Text = "Otvoriti XML Grammatik ..."
            frmEsperanto.ButtonTranslate.Text = "Prevesti"
            frmEsperanto.ButtonSaveXML.Text = "Pohraniti XML Grammatik ..."
            frmEsperanto.ButtonDictionary.Text = "Rječnik"
            frmEsperanto.LabelFile.Text = "Datoteka"
            frmEsperanto.LabelOriginal.Text = "Original"
            frmEsperanto.LabelEsperanto.Text = "Esperanto"
            frmEsperanto.LabelFehler.Text = "Obavijest o Greška"
        ElseIf (ComboBoxLanguage.SelectedIndex = 12) Then
            pubFromLanguage = LangName.AnyLang
            langStr = "xxxxx"
            frmEsperanto.ButtonLoadXML.Text = "Load XML Grammar ..."
            frmEsperanto.ButtonTranslate.Text = "Translate"
            frmEsperanto.ButtonSaveXML.Text = "Save XML Grammar ..."
            frmEsperanto.ButtonDictionary.Text = "Dictionary"
            frmEsperanto.LabelFile.Text = "File"
            frmEsperanto.LabelOriginal.Text = "Original"
            frmEsperanto.LabelEsperanto.Text = "Esperanto"
            frmEsperanto.LabelFehler.Text = "Error Message"
        End If

        ' ...

        ' Info
        If (initDone = True) Then
            langInd = ComboBoxLanguage.SelectedIndex + 1
            sumOfSize = pubSizePronomen(langInd) + pubSizeNomen(langInd) + pubSizeVerb(langInd) + pubSizeAdverb(langInd) + pubSizeAdjective(langInd) + _
            pubSizePreposition(langInd) + pubSizeParticle(langInd) + pubSizeJunction(langInd) + pubSizeExpression(langInd) + pubSizeCooccurrence(langInd)
            sumOfCount = countVocPronomen + countVocNomen + countVocVerb + countVocAdverb + countVocAdjective + _
            countVocPreposition + countVocParticle + countVocJunction + countVocExpression + countVocCooccurrence
            MsgBox(formatPretty(pubSizePronomen(langInd), 5) & " (" & formatPretty(CInt(pubSizePronomen(langInd) / countVocPronomen * 100), 3) & "%) Pronouns " & vbCrLf & _
                   formatPretty(pubSizeNomen(langInd), 5) & " (" & formatPretty(CInt(pubSizeNomen(langInd) / countVocNomen * 100), 3) & "%) Nouns" & vbCrLf & _
                   formatPretty(pubSizeVerb(langInd), 5) & " (" & formatPretty(CInt(pubSizeVerb(langInd) / countVocVerb * 100), 3) & "%) Verbs" & vbCrLf & _
                   formatPretty(pubSizeAdverb(langInd), 5) & " (" & formatPretty(CInt(pubSizeAdverb(langInd) / countVocAdverb * 100), 3) & "%) Adverbs" & vbCrLf & _
                   formatPretty(pubSizeAdjective(langInd), 5) & " (" & formatPretty(CInt(pubSizeAdjective(langInd) / countVocAdjective * 100), 3) & "%) Adjectives" & vbCrLf & _
                   formatPretty(pubSizePreposition(langInd), 5) & " (" & formatPretty(CInt(pubSizePreposition(langInd) / countVocPreposition * 100), 3) & "%) Prepositions" & vbCrLf & _
                   formatPretty(pubSizeParticle(langInd), 5) & " (" & formatPretty(CInt(pubSizeParticle(langInd) / countVocParticle * 100), 3) & "%) Particles" & vbCrLf & _
                   formatPretty(pubSizeJunction(langInd), 5) & " (" & formatPretty(CInt(pubSizeJunction(langInd) / countVocJunction * 100), 3) & "%) Junctions" & vbCrLf & _
                   formatPretty(pubSizeExpression(langInd), 5) & " (" & formatPretty(CInt(pubSizeExpression(langInd) / countVocExpression * 100), 3) & "%) Expressions" & vbCrLf & _
                   formatPretty(pubSizeCooccurrence(langInd), 5) & " (" & formatPretty(CInt(pubSizeCooccurrence(langInd) / countVocCooccurrence * 100), 3) & "%) Cooccurrences" & vbCrLf & _
                    " " & vbCrLf & _
                   formatPretty(pubSizeNiveau(1, langInd), 5) & " (" & formatPretty(CInt(pubSizeNiveau(1, langInd) / pubSizeNiveau(1, LangName.Deutsch) * 100), 3) & "%) A1 (basic)" & vbCrLf & _
                   formatPretty(pubSizeNiveau(2, langInd), 5) & " (" & formatPretty(CInt(pubSizeNiveau(2, langInd) / pubSizeNiveau(2, LangName.Deutsch) * 100), 3) & "%) A2 (essential)" & vbCrLf & _
                   formatPretty(pubSizeNiveau(3, langInd), 5) & " (" & formatPretty(CInt(pubSizeNiveau(3, langInd) / pubSizeNiveau(3, LangName.Deutsch) * 100), 3) & "%) B1 (extended)" & vbCrLf & _
                   formatPretty(pubSizeNiveau(4, langInd), 5) & " (" & formatPretty(CInt(pubSizeNiveau(4, langInd) / pubSizeNiveau(4, LangName.Deutsch) * 100), 3) & "%) B2 (comprehensive)" & vbCrLf & _
                   formatPretty(pubSizeNiveau(5, langInd), 5) & " (" & formatPretty(CInt(pubSizeNiveau(5, langInd) / pubSizeNiveau(5, LangName.Deutsch) * 100), 3) & "%) C1 (extensive)" & vbCrLf & _
                   formatPretty(pubSizeNiveau(6, langInd), 5) & " (" & formatPretty(CInt(pubSizeNiveau(6, langInd) / pubSizeNiveau(6, LangName.Deutsch) * 100), 3) & "%) C2 (all-embracing)" & vbCrLf & _
                    " " & vbCrLf & _
                   formatPretty(sumOfSize, 5) & " (" & formatPretty(CInt(sumOfSize / sumOfCount * 100), 3) & "%) Words & Expressions", MsgBoxStyle.Information, "Language Vocabulary")
        End If

        If (ComboBoxLanguage.SelectedIndex = 12) Then
            Dim result As Integer
            Dim fileName As String
            Dim reti As Integer
            Dim numWords As Long

            result = MsgBox("Do you want to import Vocabulary from a Text File?", MsgBoxStyle.YesNoCancel, "Optional Import")
            If (result = DialogResult.Yes) Then
                ' Datei-Auswahl
                frmEsperanto.OpenFileDialog1.InitialDirectory = pubDirImportFiles
                frmEsperanto.OpenFileDialog1.Filter = "*.txt" & "|*.txt"
                frmEsperanto.OpenFileDialog1.Title = "Import Grammatik"
                frmEsperanto.OpenFileDialog1.FileName = ""
                reti = frmEsperanto.OpenFileDialog1.ShowDialog()
                If (reti = vbCancel) Then
                    Exit Sub
                End If
                fileName = frmEsperanto.OpenFileDialog1.FileName

                numWords = importAnyFromTextFile(fileName, 0)
                langStr = pubImpLang
                MsgBox(numWords.ToString & " Words imported!", MsgBoxStyle.Information, "Import done")

            End If

        End If

        ' set Flag-Icon
        langIco = "xxx"
        For cnt = 1 To pubFlagInfo(0, 0)
            If (pubFlagInfo(1, cnt) = langStr) Then
                langIco = pubFlagInfo(2, cnt)
                Exit For

            End If

        Next

        If (langIco <> "xxx") Then
            Me.ButtonHelp.Image = Bitmap.FromFile(pubDirFlagIcons & "\" & langIco)
        Else
            Me.ButtonHelp.Image = Nothing
        End If

    End Sub

    Private Sub TreeViewGrammatik_AfterSelect(ByVal sender As System.Object, ByVal e As System.Windows.Forms.TreeViewEventArgs) Handles TreeViewGrammatik.AfterSelect
        ' Editier-Funktion: Anzeige eines Elements
        Dim ret As Boolean

        clearEdit(0)
        Try
            ret = showNode(e.Node.Tag.ToString, e.Node)
        Catch
            '
        End Try

    End Sub

    Private Sub ButtonSaveEdit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonSaveEdit.Click
        ' Speichern des Editier-Elements
        Dim ret As Boolean

        ret = saveNode(0)

    End Sub

    Private Sub ButtonHelp_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonHelp.Click
        ' HTML Help
        Help.ShowHelp(Me, "DecaleonHelp.htm")

    End Sub

    Private Sub ButtonDict_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonDictionary.Click
        ' Dictionary
        frmDictionary = New FDictionary
        frmDictionary.Show()

    End Sub

    Private Sub ButtonTrainer_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonTrainer.Click
        ' Vocabulary Trainer
        Dim choiceValue As Integer
        Dim inputStr As String

        ' Option: Additional Vocabulary
        choiceValue = -1
        While (choiceValue < 0 Or choiceValue > 1)
            inputStr = InputBox("Please choose Action !" & vbCrLf & _
                                "(0) Use Vocabulary Trainer" & vbCrLf & _
                                "(1) Register additional Vocabulary", "Vocabulary Trainer", "0")
            If (inputStr = "") Then
                Exit Sub
            End If
            choiceValue = CInt(Val(inputStr))
        End While

        ' Additional Vocabulary
        If (choiceValue = 1) Then
            frmWordManager = New FWordManager
            frmWordManager.ShowDialog()     ' modal

        End If

        ' Vocabulary Trainer
        frmTrainer = New FTrainer
        frmTrainer.Show()

    End Sub

    Private Sub Decaleon_Shown(sender As Object, e As System.EventArgs) Handles Me.Shown
        ' Splash Screen schließen
        FormSplash.Close()

    End Sub

End Class
