﻿Option Explicit On

' Translation between 12 Languages, Any Language and Esperanto
'
' MP Nov / Dez 2011: Program 3.0
' MP Nov / Dez 2011: Word Search
' MP Aug / Sep 2012: Vocabulary List
' MP Nov / Dez 2013: Word Dictionary
' MP Mar / Dez 2014: Semantic Groups
' MP Mar / Dez 2015: Extra Vocabulary
' MP Mar / Dez 2016: Thematic Dictionary


Imports iTextSharp
Imports iTextSharp.text
Imports iTextSharp.text.pdf


Public Class FDictionary

    Private Sub Dictionary_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load

        ' Texte von Labels and Buttons
        ' Word Search
        frmDictionary.GroupBoxSingleWord.Text = "Word Search"
        frmDictionary.ComboBoxTo.Text = "Please select!"
        frmDictionary.LabelFrom.Text = "from"
        frmDictionary.LabelTo.Text = "to"
        frmDictionary.LabelWord.Text = "Word"
        frmDictionary.LabelTranslation.Text = "Translation"
        frmDictionary.GroupBoxMode.Text = "Search Mode"
        frmDictionary.RadioButtonStrict.Text = "Strict"
        frmDictionary.RadioButtonStart.Text = "Starts with"
        frmDictionary.ButtonSearch.Text = "Search"
        ' Word List
        frmDictionary.GroupBoxWordList.Text = "Vocabulary List"
        frmDictionary.ComboBoxTo2.Text = "Please select!"
        frmDictionary.LabelFrom2.Text = "from"
        frmDictionary.LabelTo2.Text = "to"
        frmDictionary.GroupBoxCriterion.Text = "Selection Criterion"
        frmDictionary.RadioButtonNiveau.Text = "Niveau"
        frmDictionary.RadioButtonTheme.Text = "Theme"
        frmDictionary.GroupBoxOutput.Text = "Output Format"
        frmDictionary.RadioButtonHtml.Text = "HTML"
        frmDictionary.RadioButtonUnicode.Text = "Unicode"
        frmDictionary.ButtonList.Text = "List"
        ' Word Dictionary
        frmDictionary.GroupBoxDictionary.Text = "Word Dictionary"
        frmDictionary.ComboBoxTo3.Text = "Please select!"
        frmDictionary.LabelFrom3.Text = "from"
        frmDictionary.LabelTo3.Text = "to"
        frmDictionary.ButtonDict.Text = "Dictionary"
        frmDictionary.GroupBoxFormat.Text = "Output Format"
        frmDictionary.RadioButtonLatex.Text = "LaTeX"
        frmDictionary.RadioButtonPDF.Text = "PDF"
        frmDictionary.GroupBoxDictType.Text = "Type of Dictionary"
        frmDictionary.RadioButtonDict.Text = "Lexical"
        frmDictionary.RadioButtonLexikon.Text = "Thematic"
        frmDictionary.CheckBoxBook.Text = "Divide"

        ' Suchmodus
        frmDictionary.RadioButtonStrict.Checked = True

        ' Auswahlkriterium Liste
        frmDictionary.RadioButtonTheme.Checked = True

        ' Ausgabeformat Liste
        frmDictionary.RadioButtonUnicode.Checked = True

        ' Ausgabeformat Dictionary
        frmDictionary.RadioButtonPDF.Checked = True

        ' Ausgabetyp Dictionary
        frmDictionary.RadioButtonDict.Checked = True

        ' Sprachen-Auswahl from
        frmDictionary.ComboBoxFrom.Items.Clear()
        frmDictionary.ComboBoxFrom.Items.Add("Esperanto")
        frmDictionary.ComboBoxFrom.Items.Add("Deutsch")
        frmDictionary.ComboBoxFrom.Items.Add("English")
        frmDictionary.ComboBoxFrom.Items.Add("Français")
        frmDictionary.ComboBoxFrom.Items.Add("Español")
        frmDictionary.ComboBoxFrom.Items.Add("Italiano")
        frmDictionary.ComboBoxFrom.Items.Add("Português")
        frmDictionary.ComboBoxFrom.Items.Add("Dansk")
        frmDictionary.ComboBoxFrom.Items.Add("Svenska")
        frmDictionary.ComboBoxFrom.Items.Add("Ελληνικά")
        frmDictionary.ComboBoxFrom.Items.Add("Русский")
        frmDictionary.ComboBoxFrom.Items.Add("Polski")
        frmDictionary.ComboBoxFrom.Items.Add("Hrvatski")
        frmDictionary.ComboBoxFrom.Items.Add("Any Language")
        frmDictionary.ComboBoxFrom.SelectedIndex = pubFromLanguage

        ' Sprachen-Auswahl to
        frmDictionary.ComboBoxTo.Items.Clear()
        frmDictionary.ComboBoxTo.Items.Add("Esperanto")
        frmDictionary.ComboBoxTo.Items.Add("Deutsch")
        frmDictionary.ComboBoxTo.Items.Add("English")
        frmDictionary.ComboBoxTo.Items.Add("Français")
        frmDictionary.ComboBoxTo.Items.Add("Español")
        frmDictionary.ComboBoxTo.Items.Add("Italiano")
        frmDictionary.ComboBoxTo.Items.Add("Português")
        frmDictionary.ComboBoxTo.Items.Add("Dansk")
        frmDictionary.ComboBoxTo.Items.Add("Svenska")
        frmDictionary.ComboBoxTo.Items.Add("Ελληνικά")
        frmDictionary.ComboBoxTo.Items.Add("Русский")
        frmDictionary.ComboBoxTo.Items.Add("Polski")
        frmDictionary.ComboBoxTo.Items.Add("Hrvatski")
        frmDictionary.ComboBoxTo.Items.Add("Any Language")
        frmDictionary.ComboBoxTo.SelectedIndex = -1

        ' Sprachen-Auswahl from2
        frmDictionary.ComboBoxFrom2.Items.Clear()
        frmDictionary.ComboBoxFrom2.Items.Add("Esperanto")
        frmDictionary.ComboBoxFrom2.Items.Add("Deutsch")
        frmDictionary.ComboBoxFrom2.Items.Add("English")
        frmDictionary.ComboBoxFrom2.Items.Add("Français")
        frmDictionary.ComboBoxFrom2.Items.Add("Español")
        frmDictionary.ComboBoxFrom2.Items.Add("Italiano")
        frmDictionary.ComboBoxFrom2.Items.Add("Português")
        frmDictionary.ComboBoxFrom2.Items.Add("Dansk")
        frmDictionary.ComboBoxFrom2.Items.Add("Svenska")
        frmDictionary.ComboBoxFrom2.Items.Add("Ελληνικά")
        frmDictionary.ComboBoxFrom2.Items.Add("Русский")
        frmDictionary.ComboBoxFrom2.Items.Add("Polski")
        frmDictionary.ComboBoxFrom2.Items.Add("Hrvatski")
        frmDictionary.ComboBoxFrom2.Items.Add("Any Language")
        frmDictionary.ComboBoxFrom2.SelectedIndex = pubFromLanguage

        ' Sprachen-Auswahl to2
        frmDictionary.ComboBoxTo2.Items.Clear()
        frmDictionary.ComboBoxTo2.Items.Add("Esperanto")
        frmDictionary.ComboBoxTo2.Items.Add("Deutsch")
        frmDictionary.ComboBoxTo2.Items.Add("English")
        frmDictionary.ComboBoxTo2.Items.Add("Français")
        frmDictionary.ComboBoxTo2.Items.Add("Español")
        frmDictionary.ComboBoxTo2.Items.Add("Italiano")
        frmDictionary.ComboBoxTo2.Items.Add("Português")
        frmDictionary.ComboBoxTo2.Items.Add("Dansk")
        frmDictionary.ComboBoxTo2.Items.Add("Svenska")
        frmDictionary.ComboBoxTo2.Items.Add("Ελληνικά")
        frmDictionary.ComboBoxTo2.Items.Add("Русский")
        frmDictionary.ComboBoxTo2.Items.Add("Polski")
        frmDictionary.ComboBoxTo2.Items.Add("Hrvatski")
        frmDictionary.ComboBoxTo2.Items.Add("Any Language")
        frmDictionary.ComboBoxTo2.SelectedIndex = -1

        ' Sprachen-Auswahl from3
        frmDictionary.ComboBoxFrom3.Items.Clear()
        frmDictionary.ComboBoxFrom3.Items.Add("Esperanto")
        frmDictionary.ComboBoxFrom3.Items.Add("Deutsch")
        frmDictionary.ComboBoxFrom3.Items.Add("English")
        frmDictionary.ComboBoxFrom3.Items.Add("Français")
        frmDictionary.ComboBoxFrom3.Items.Add("Español")
        frmDictionary.ComboBoxFrom3.Items.Add("Italiano")
        frmDictionary.ComboBoxFrom3.Items.Add("Português")
        frmDictionary.ComboBoxFrom3.Items.Add("Dansk")
        frmDictionary.ComboBoxFrom3.Items.Add("Svenska")
        frmDictionary.ComboBoxFrom3.Items.Add("Ελληνικά")
        frmDictionary.ComboBoxFrom3.Items.Add("Русский")
        frmDictionary.ComboBoxFrom3.Items.Add("Polski")
        frmDictionary.ComboBoxFrom3.Items.Add("Hrvatski")
        frmDictionary.ComboBoxFrom3.Items.Add("Any Language")
        frmDictionary.ComboBoxFrom3.SelectedIndex = pubFromLanguage

        ' Sprachen-Auswahl to3
        frmDictionary.ComboBoxTo3.Items.Clear()
        frmDictionary.ComboBoxTo3.Items.Add("Esperanto")
        frmDictionary.ComboBoxTo3.Items.Add("Deutsch")
        frmDictionary.ComboBoxTo3.Items.Add("English")
        frmDictionary.ComboBoxTo3.Items.Add("Français")
        frmDictionary.ComboBoxTo3.Items.Add("Español")
        frmDictionary.ComboBoxTo3.Items.Add("Italiano")
        frmDictionary.ComboBoxTo3.Items.Add("Português")
        frmDictionary.ComboBoxTo3.Items.Add("Dansk")
        frmDictionary.ComboBoxTo3.Items.Add("Svenska")
        frmDictionary.ComboBoxTo3.Items.Add("Ελληνικά")
        frmDictionary.ComboBoxTo3.Items.Add("Русский")
        frmDictionary.ComboBoxTo3.Items.Add("Polski")
        frmDictionary.ComboBoxTo3.Items.Add("Hrvatski")
        frmDictionary.ComboBoxTo3.Items.Add("Any Language")
        frmDictionary.ComboBoxTo3.SelectedIndex = -1

        frmDictionary.ButtonSearch.TabIndex = 11

        ' LaTeX Thematischer Wortschatz
        frmDictionary.ComboBoxBook.Items.Add("DEU/ENG/FRA")
        frmDictionary.ComboBoxBook.Items.Add("DEU/ENG/SPA")
        frmDictionary.ComboBoxBook.Items.Add("DEU/ENG/ITA")
        frmDictionary.ComboBoxBook.Items.Add("DEU/FRA/SPA")
        frmDictionary.ComboBoxBook.Items.Add("DEU/FRA/ITA")
        frmDictionary.ComboBoxBook.Items.Add("DEU/SPA/ITA")
        frmDictionary.ComboBoxBook.Items.Add("DEU/SPA/POR")
        frmDictionary.ComboBoxBook.Items.Add("DEU/DAN/SWE")
        frmDictionary.ComboBoxBook.Items.Add("DEU/POL/KRO")
        frmDictionary.ComboBoxBook.Items.Add("DEU/ENG")
        frmDictionary.ComboBoxBook.Items.Add("DEU/RUS")
        frmDictionary.ComboBoxBook.Items.Add("DEU/GRE")
        frmDictionary.ComboBoxBook.Items.Add("DEU/any")
        frmDictionary.ComboBoxBook.Items.Add("ENG/FRA/SPA")
        frmDictionary.ComboBoxBook.Items.Add("ENG/FRA/ITA")
        frmDictionary.ComboBoxBook.Items.Add("ENG/SPA/ITA")
        frmDictionary.ComboBoxBook.Items.Add("ENG/SPA/POR")
        frmDictionary.ComboBoxBook.Items.Add("ENG/DAN/SWE")
        frmDictionary.ComboBoxBook.Items.Add("ENG/POL/KRO")
        frmDictionary.ComboBoxBook.Items.Add("ENG/DEU")
        frmDictionary.ComboBoxBook.Items.Add("ENG/RUS")
        frmDictionary.ComboBoxBook.Items.Add("ENG/GRE")
        frmDictionary.ComboBoxBook.Items.Add("ENG/any")

    End Sub

    ' Word Search (1st Function)

    Private Sub ButtonSearch_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonSearch.Click
        ' Search
        Dim searchWord As String
        Dim searchMode As Integer
        Dim fromLanguage As Integer
        Dim toLanguage As Integer
        Dim i As Integer

        ' Suchbegriff
        searchWord = TextBoxWord.Text

        ' Suchmodus
        searchMode = 0
        If (frmDictionary.RadioButtonStrict.Checked = True) Then
            searchMode = 0
        ElseIf (frmDictionary.RadioButtonStart.Checked = True) Then
            If (searchWord.Length >= 3) Then
                searchMode = 1
            Else
                searchMode = 0
                RichTextBoxTranslation.Text = "Option needs at least 3 letters!"
            End If
        End If

        ' Indices
        fromLanguage = frmDictionary.ComboBoxFrom.SelectedIndex
        toLanguage = frmDictionary.ComboBoxTo.SelectedIndex

        ' check
        If (searchWord = "") Then
            MsgBox("Please enter Search Term!", MsgBoxStyle.Information, "Missing Choice")
            Exit Sub
        End If
        If (toLanguage = -1) Then
            MsgBox("Please select to which Language!", MsgBoxStyle.Information, "Missing Choice")
            Exit Sub
        End If

        ' Suche
        If (fromLanguage = LangName.Esperanto) Then
            For i = 1 To countVocPronomen
                If (testEntry(searchMode, pubVocabularyPro(i)._EspPronomen, searchWord) = True) Then
                    report("Pro", i, pubVocabularyPro(i)._EspPronomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocNomen
                If (testEntry(searchMode, pubVocabularyNom(i)._EspNomen, searchWord) = True) Then
                    report("Nom", i, pubVocabularyNom(i)._EspNomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocVerb
                If (testEntry(searchMode, pubVocabularyVer(i)._EspVerb, searchWord) = True) Then
                    report("Ver", i, pubVocabularyVer(i)._EspVerb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdverb
                If (testEntry(searchMode, pubVocabularyAdv(i)._EspAdverb, searchWord) = True) Then
                    report("Adv", i, pubVocabularyAdv(i)._EspAdverb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdjective
                If (testEntry(searchMode, pubVocabularyAdj(i)._EspAdjective, searchWord) = True) Then
                    report("Adj", i, pubVocabularyAdj(i)._EspAdjective, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocPreposition
                If (testEntry(searchMode, pubVocabularyPre(i)._EspPreposition, searchWord) = True) Then
                    report("Pre", i, pubVocabularyPre(i)._EspPreposition, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocParticle
                If (testEntry(searchMode, pubVocabularyPar(i)._EspParticle, searchWord) = True) Then
                    report("Par", i, pubVocabularyPar(i)._EspParticle, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocJunction
                If (testEntry(searchMode, pubVocabularyJun(i)._EspJunction, searchWord) = True) Then
                    report("Jun", i, pubVocabularyJun(i)._EspJunction, fromLanguage, toLanguage)
                End If
            Next

        ElseIf (fromLanguage = LangName.Deutsch) Then
            For i = 1 To countVocPronomen
                If (testEntry(searchMode, pubVocabularyPro(i)._GerPronomen, searchWord) = True) Then
                    report("Pro", i, pubVocabularyPro(i)._GerPronomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocNomen
                If (testEntry(searchMode, pubVocabularyNom(i)._GerNomen, searchWord) = True) Then
                    report("Nom", i, pubVocabularyNom(i)._GerNomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocVerb
                If (testEntry(searchMode, pubVocabularyVer(i)._GerVerb, searchWord) = True) Then
                    report("Ver", i, pubVocabularyVer(i)._GerVerb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdverb
                If (testEntry(searchMode, pubVocabularyAdv(i)._GerAdverb, searchWord) = True) Then
                    report("Adv", i, pubVocabularyAdv(i)._GerAdverb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdjective
                If (testEntry(searchMode, pubVocabularyAdj(i)._GerAdjective, searchWord) = True) Then
                    report("Adj", i, pubVocabularyAdj(i)._GerAdjective, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocPreposition
                If (testEntry(searchMode, pubVocabularyPre(i)._GerPreposition, searchWord) = True) Then
                    report("Pre", i, pubVocabularyPre(i)._GerPreposition, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocParticle
                If (testEntry(searchMode, pubVocabularyPar(i)._GerParticle, searchWord) = True) Then
                    report("Par", i, pubVocabularyPar(i)._GerParticle, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocJunction
                If (testEntry(searchMode, pubVocabularyJun(i)._GerJunction, searchWord) = True) Then
                    report("Jun", i, pubVocabularyJun(i)._GerJunction, fromLanguage, toLanguage)
                End If
            Next

        ElseIf (fromLanguage = LangName.English) Then
            For i = 1 To countVocPronomen
                If (testEntry(searchMode, pubVocabularyPro(i)._EngPronomen, searchWord) = True) Then
                    report("Pro", i, pubVocabularyPro(i)._EngPronomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocNomen
                If (testEntry(searchMode, pubVocabularyNom(i)._EngNomen, searchWord) = True) Then
                    report("Nom", i, pubVocabularyNom(i)._EngNomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocVerb
                If (testEntry(searchMode, pubVocabularyVer(i)._EngVerb, searchWord) = True) Then
                    report("Ver", i, pubVocabularyVer(i)._EngVerb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdverb
                If (testEntry(searchMode, pubVocabularyAdv(i)._EngAdverb, searchWord) = True) Then
                    report("Adv", i, pubVocabularyAdv(i)._EngAdverb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdjective
                If (testEntry(searchMode, pubVocabularyAdj(i)._EngAdjective, searchWord) = True) Then
                    report("Adj", i, pubVocabularyAdj(i)._EngAdjective, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocPreposition
                If (testEntry(searchMode, pubVocabularyPre(i)._EngPreposition, searchWord) = True) Then
                    report("Pre", i, pubVocabularyPre(i)._EngPreposition, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocParticle
                If (testEntry(searchMode, pubVocabularyPar(i)._EngParticle, searchWord) = True) Then
                    report("Par", i, pubVocabularyPar(i)._EngParticle, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocJunction
                If (testEntry(searchMode, pubVocabularyJun(i)._EngJunction, searchWord) = True) Then
                    report("Jun", i, pubVocabularyJun(i)._EngJunction, fromLanguage, toLanguage)
                End If
            Next

        ElseIf (fromLanguage = LangName.Francais) Then
            For i = 1 To countVocPronomen
                If (testEntry(searchMode, pubVocabularyPro(i)._FraPronomen, searchWord) = True) Then
                    report("Pro", i, pubVocabularyPro(i)._FraPronomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocNomen
                If (testEntry(searchMode, pubVocabularyNom(i)._FraNomen, searchWord) = True) Then
                    report("Nom", i, pubVocabularyNom(i)._FraNomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocVerb
                If (testEntry(searchMode, pubVocabularyVer(i)._FraVerb, searchWord) = True) Then
                    report("Ver", i, pubVocabularyVer(i)._FraVerb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdverb
                If (testEntry(searchMode, pubVocabularyAdv(i)._FraAdverb, searchWord) = True) Then
                    report("Adv", i, pubVocabularyAdv(i)._FraAdverb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdjective
                If (testEntry(searchMode, pubVocabularyAdj(i)._FraAdjective, searchWord) = True) Then
                    report("Adj", i, pubVocabularyAdj(i)._FraAdjective, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocPreposition
                If (testEntry(searchMode, pubVocabularyPre(i)._FraPreposition, searchWord) = True) Then
                    report("Pre", i, pubVocabularyPre(i)._FraPreposition, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocParticle
                If (testEntry(searchMode, pubVocabularyPar(i)._FraParticle, searchWord) = True) Then
                    report("Par", i, pubVocabularyPar(i)._FraParticle, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocJunction
                If (testEntry(searchMode, pubVocabularyJun(i)._FraJunction, searchWord) = True) Then
                    report("Jun", i, pubVocabularyJun(i)._FraJunction, fromLanguage, toLanguage)
                End If
            Next

        ElseIf (fromLanguage = LangName.Espanol) Then
            For i = 1 To countVocPronomen
                If (testEntry(searchMode, pubVocabularyPro(i)._SpaPronomen, searchWord) = True) Then
                    report("Pro", i, pubVocabularyPro(i)._SpaPronomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocNomen
                If (testEntry(searchMode, pubVocabularyNom(i)._SpaNomen, searchWord) = True) Then
                    report("Nom", i, pubVocabularyNom(i)._SpaNomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocVerb
                If (testEntry(searchMode, pubVocabularyVer(i)._SpaVerb, searchWord) = True) Then
                    report("Ver", i, pubVocabularyVer(i)._SpaVerb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdverb
                If (testEntry(searchMode, pubVocabularyAdv(i)._SpaAdverb, searchWord) = True) Then
                    report("Adv", i, pubVocabularyAdv(i)._SpaAdverb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdjective
                If (testEntry(searchMode, pubVocabularyAdj(i)._SpaAdjective, searchWord) = True) Then
                    report("Adj", i, pubVocabularyAdj(i)._SpaAdjective, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocPreposition
                If (testEntry(searchMode, pubVocabularyPre(i)._SpaPreposition, searchWord) = True) Then
                    report("Pre", i, pubVocabularyPre(i)._SpaPreposition, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocParticle
                If (testEntry(searchMode, pubVocabularyPar(i)._SpaParticle, searchWord) = True) Then
                    report("Par", i, pubVocabularyPar(i)._SpaParticle, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocJunction
                If (testEntry(searchMode, pubVocabularyJun(i)._SpaJunction, searchWord) = True) Then
                    report("Jun", i, pubVocabularyJun(i)._SpaJunction, fromLanguage, toLanguage)
                End If
            Next

        ElseIf (fromLanguage = LangName.Italiano) Then
            For i = 1 To countVocPronomen
                If (testEntry(searchMode, pubVocabularyPro(i)._ItaPronomen, searchWord) = True) Then
                    report("Pro", i, pubVocabularyPro(i)._ItaPronomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocNomen
                If (testEntry(searchMode, pubVocabularyNom(i)._ItaNomen, searchWord) = True) Then
                    report("Nom", i, pubVocabularyNom(i)._ItaNomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocVerb
                If (testEntry(searchMode, pubVocabularyVer(i)._ItaVerb, searchWord) = True) Then
                    report("Ver", i, pubVocabularyVer(i)._ItaVerb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdverb
                If (testEntry(searchMode, pubVocabularyAdv(i)._ItaAdverb, searchWord) = True) Then
                    report("Adv", i, pubVocabularyAdv(i)._ItaAdverb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdjective
                If (testEntry(searchMode, pubVocabularyAdj(i)._ItaAdjective, searchWord) = True) Then
                    report("Adj", i, pubVocabularyAdj(i)._ItaAdjective, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocPreposition
                If (testEntry(searchMode, pubVocabularyPre(i)._ItaPreposition, searchWord) = True) Then
                    report("Pre", i, pubVocabularyPre(i)._ItaPreposition, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocParticle
                If (testEntry(searchMode, pubVocabularyPar(i)._ItaParticle, searchWord) = True) Then
                    report("Par", i, pubVocabularyPar(i)._ItaParticle, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocJunction
                If (testEntry(searchMode, pubVocabularyJun(i)._ItaJunction, searchWord) = True) Then
                    report("Jun", i, pubVocabularyJun(i)._ItaJunction, fromLanguage, toLanguage)
                End If
            Next

        ElseIf (fromLanguage = LangName.Portoguese) Then
            For i = 1 To countVocPronomen
                If (testEntry(searchMode, pubVocabularyPro(i)._PorPronomen, searchWord) = True) Then
                    report("Pro", i, pubVocabularyPro(i)._PorPronomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocNomen
                If (testEntry(searchMode, pubVocabularyNom(i)._PorNomen, searchWord) = True) Then
                    report("Nom", i, pubVocabularyNom(i)._PorNomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocVerb
                If (testEntry(searchMode, pubVocabularyVer(i)._PorVerb, searchWord) = True) Then
                    report("Ver", i, pubVocabularyVer(i)._PorVerb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdverb
                If (testEntry(searchMode, pubVocabularyAdv(i)._PorAdverb, searchWord) = True) Then
                    report("Adv", i, pubVocabularyAdv(i)._PorAdverb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdjective
                If (testEntry(searchMode, pubVocabularyAdj(i)._PorAdjective, searchWord) = True) Then
                    report("Adj", i, pubVocabularyAdj(i)._PorAdjective, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocPreposition
                If (testEntry(searchMode, pubVocabularyPre(i)._PorPreposition, searchWord) = True) Then
                    report("Pre", i, pubVocabularyPre(i)._PorPreposition, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocParticle
                If (testEntry(searchMode, pubVocabularyPar(i)._PorParticle, searchWord) = True) Then
                    report("Par", i, pubVocabularyPar(i)._PorParticle, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocJunction
                If (testEntry(searchMode, pubVocabularyJun(i)._PorJunction, searchWord) = True) Then
                    report("Jun", i, pubVocabularyJun(i)._PorJunction, fromLanguage, toLanguage)
                End If
            Next

        ElseIf (fromLanguage = LangName.Dansk) Then
            For i = 1 To countVocPronomen
                If (testEntry(searchMode, pubVocabularyPro(i)._DanPronomen, searchWord) = True) Then
                    report("Pro", i, pubVocabularyPro(i)._DanPronomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocNomen
                If (testEntry(searchMode, pubVocabularyNom(i)._DanNomen, searchWord) = True) Then
                    report("Nom", i, pubVocabularyNom(i)._DanNomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocVerb
                If (testEntry(searchMode, pubVocabularyVer(i)._DanVerb, searchWord) = True) Then
                    report("Ver", i, pubVocabularyVer(i)._DanVerb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdverb
                If (testEntry(searchMode, pubVocabularyAdv(i)._DanAdverb, searchWord) = True) Then
                    report("Adv", i, pubVocabularyAdv(i)._DanAdverb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdjective
                If (testEntry(searchMode, pubVocabularyAdj(i)._DanAdjective, searchWord) = True) Then
                    report("Adj", i, pubVocabularyAdj(i)._DanAdjective, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocPreposition
                If (testEntry(searchMode, pubVocabularyPre(i)._DanPreposition, searchWord) = True) Then
                    report("Pre", i, pubVocabularyPre(i)._DanPreposition, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocParticle
                If (testEntry(searchMode, pubVocabularyPar(i)._DanParticle, searchWord) = True) Then
                    report("Par", i, pubVocabularyPar(i)._DanParticle, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocJunction
                If (testEntry(searchMode, pubVocabularyJun(i)._DanJunction, searchWord) = True) Then
                    report("Jun", i, pubVocabularyJun(i)._DanJunction, fromLanguage, toLanguage)
                End If
            Next

        ElseIf (fromLanguage = LangName.Svenska) Then
            For i = 1 To countVocPronomen
                If (testEntry(searchMode, pubVocabularyPro(i)._SwePronomen, searchWord) = True) Then
                    report("Pro", i, pubVocabularyPro(i)._SwePronomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocNomen
                If (testEntry(searchMode, pubVocabularyNom(i)._SweNomen, searchWord) = True) Then
                    report("Nom", i, pubVocabularyNom(i)._SweNomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocVerb
                If (testEntry(searchMode, pubVocabularyVer(i)._SweVerb, searchWord) = True) Then
                    report("Ver", i, pubVocabularyVer(i)._SweVerb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdverb
                If (testEntry(searchMode, pubVocabularyAdv(i)._SweAdverb, searchWord) = True) Then
                    report("Adv", i, pubVocabularyAdv(i)._SweAdverb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdjective
                If (testEntry(searchMode, pubVocabularyAdj(i)._SweAdjective, searchWord) = True) Then
                    report("Adj", i, pubVocabularyAdj(i)._SweAdjective, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocPreposition
                If (testEntry(searchMode, pubVocabularyPre(i)._SwePreposition, searchWord) = True) Then
                    report("Pre", i, pubVocabularyPre(i)._SwePreposition, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocParticle
                If (testEntry(searchMode, pubVocabularyPar(i)._SweParticle, searchWord) = True) Then
                    report("Par", i, pubVocabularyPar(i)._SweParticle, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocJunction
                If (testEntry(searchMode, pubVocabularyJun(i)._SweJunction, searchWord) = True) Then
                    report("Jun", i, pubVocabularyJun(i)._SweJunction, fromLanguage, toLanguage)
                End If
            Next

        ElseIf (fromLanguage = LangName.Ellenika) Then
            For i = 1 To countVocPronomen
                If (testEntry(searchMode, pubVocabularyPro(i)._GrePronomen, searchWord) = True) Then
                    report("Pro", i, pubVocabularyPro(i)._GrePronomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocNomen
                If (testEntry(searchMode, pubVocabularyNom(i)._GreNomen, searchWord) = True) Then
                    report("Nom", i, pubVocabularyNom(i)._GreNomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocVerb
                If (testEntry(searchMode, pubVocabularyVer(i)._GreVerb, searchWord) = True) Then
                    report("Ver", i, pubVocabularyVer(i)._GreVerb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdverb
                If (testEntry(searchMode, pubVocabularyAdv(i)._GreAdverb, searchWord) = True) Then
                    report("Adv", i, pubVocabularyAdv(i)._GreAdverb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdjective
                If (testEntry(searchMode, pubVocabularyAdj(i)._GreAdjective, searchWord) = True) Then
                    report("Adj", i, pubVocabularyAdj(i)._GreAdjective, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocPreposition
                If (testEntry(searchMode, pubVocabularyPre(i)._GrePreposition, searchWord) = True) Then
                    report("Pre", i, pubVocabularyPre(i)._GrePreposition, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocParticle
                If (testEntry(searchMode, pubVocabularyPar(i)._GreParticle, searchWord) = True) Then
                    report("Par", i, pubVocabularyPar(i)._GreParticle, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocJunction
                If (testEntry(searchMode, pubVocabularyJun(i)._GreJunction, searchWord) = True) Then
                    report("Jun", i, pubVocabularyJun(i)._GreJunction, fromLanguage, toLanguage)
                End If
            Next

        ElseIf (fromLanguage = LangName.Russkij) Then
            For i = 1 To countVocPronomen
                If (testEntry(searchMode, pubVocabularyPro(i)._RusPronomen, searchWord) = True) Then
                    report("Pro", i, pubVocabularyPro(i)._RusPronomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocNomen
                If (testEntry(searchMode, pubVocabularyNom(i)._RusNomen, searchWord) = True) Then
                    report("Nom", i, pubVocabularyNom(i)._RusNomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocVerb
                If (testEntry(searchMode, pubVocabularyVer(i)._RusVerb, searchWord) = True) Then
                    report("Ver", i, pubVocabularyVer(i)._RusVerb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdverb
                If (testEntry(searchMode, pubVocabularyAdv(i)._RusAdverb, searchWord) = True) Then
                    report("Adv", i, pubVocabularyAdv(i)._RusAdverb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdjective
                If (testEntry(searchMode, pubVocabularyAdj(i)._RusAdjective, searchWord) = True) Then
                    report("Adj", i, pubVocabularyAdj(i)._RusAdjective, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocPreposition
                If (testEntry(searchMode, pubVocabularyPre(i)._RusPreposition, searchWord) = True) Then
                    report("Pre", i, pubVocabularyPre(i)._RusPreposition, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocParticle
                If (testEntry(searchMode, pubVocabularyPar(i)._RusParticle, searchWord) = True) Then
                    report("Par", i, pubVocabularyPar(i)._RusParticle, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocJunction
                If (testEntry(searchMode, pubVocabularyJun(i)._RusJunction, searchWord) = True) Then
                    report("Jun", i, pubVocabularyJun(i)._RusJunction, fromLanguage, toLanguage)
                End If
            Next

        ElseIf (fromLanguage = LangName.Polski) Then
            For i = 1 To countVocPronomen
                If (testEntry(searchMode, pubVocabularyPro(i)._PolPronomen, searchWord) = True) Then
                    report("Pro", i, pubVocabularyPro(i)._PolPronomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocNomen
                If (testEntry(searchMode, pubVocabularyNom(i)._PolNomen, searchWord) = True) Then
                    report("Nom", i, pubVocabularyNom(i)._PolNomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocVerb
                If (testEntry(searchMode, pubVocabularyVer(i)._PolVerb, searchWord) = True) Then
                    report("Ver", i, pubVocabularyVer(i)._PolVerb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdverb
                If (testEntry(searchMode, pubVocabularyAdv(i)._PolAdverb, searchWord) = True) Then
                    report("Adv", i, pubVocabularyAdv(i)._PolAdverb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdjective
                If (testEntry(searchMode, pubVocabularyAdj(i)._PolAdjective, searchWord) = True) Then
                    report("Adj", i, pubVocabularyAdj(i)._PolAdjective, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocPreposition
                If (testEntry(searchMode, pubVocabularyPre(i)._PolPreposition, searchWord) = True) Then
                    report("Pre", i, pubVocabularyPre(i)._PolPreposition, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocParticle
                If (testEntry(searchMode, pubVocabularyPar(i)._PolParticle, searchWord) = True) Then
                    report("Par", i, pubVocabularyPar(i)._PolParticle, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocJunction
                If (testEntry(searchMode, pubVocabularyJun(i)._PolJunction, searchWord) = True) Then
                    report("Jun", i, pubVocabularyJun(i)._PolJunction, fromLanguage, toLanguage)
                End If
            Next

        ElseIf (fromLanguage = LangName.Hrvatski) Then
            For i = 1 To countVocPronomen
                If (testEntry(searchMode, pubVocabularyPro(i)._CroPronomen, searchWord) = True) Then
                    report("Pro", i, pubVocabularyPro(i)._CroPronomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocNomen
                If (testEntry(searchMode, pubVocabularyNom(i)._CroNomen, searchWord) = True) Then
                    report("Nom", i, pubVocabularyNom(i)._CroNomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocVerb
                If (testEntry(searchMode, pubVocabularyVer(i)._CroVerb, searchWord) = True) Then
                    report("Ver", i, pubVocabularyVer(i)._CroVerb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdverb
                If (testEntry(searchMode, pubVocabularyAdv(i)._CroAdverb, searchWord) = True) Then
                    report("Adv", i, pubVocabularyAdv(i)._CroAdverb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdjective
                If (testEntry(searchMode, pubVocabularyAdj(i)._CroAdjective, searchWord) = True) Then
                    report("Adj", i, pubVocabularyAdj(i)._CroAdjective, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocPreposition
                If (testEntry(searchMode, pubVocabularyPre(i)._CroPreposition, searchWord) = True) Then
                    report("Pre", i, pubVocabularyPre(i)._CroPreposition, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocParticle
                If (testEntry(searchMode, pubVocabularyPar(i)._CroParticle, searchWord) = True) Then
                    report("Par", i, pubVocabularyPar(i)._CroParticle, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocJunction
                If (testEntry(searchMode, pubVocabularyJun(i)._CroJunction, searchWord) = True) Then
                    report("Jun", i, pubVocabularyJun(i)._CroJunction, fromLanguage, toLanguage)
                End If
            Next

        ElseIf (fromLanguage = LangName.AnyLang) Then
            For i = 1 To countVocPronomen
                If (testEntry(searchMode, pubVocabularyPro(i)._AnyPronomen, searchWord) = True) Then
                    report("Pro", i, pubVocabularyPro(i)._AnyPronomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocNomen
                If (testEntry(searchMode, pubVocabularyNom(i)._AnyNomen, searchWord) = True) Then
                    report("Nom", i, pubVocabularyNom(i)._AnyNomen, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocVerb
                If (testEntry(searchMode, pubVocabularyVer(i)._AnyVerb, searchWord) = True) Then
                    report("Ver", i, pubVocabularyVer(i)._AnyVerb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdverb
                If (testEntry(searchMode, pubVocabularyAdv(i)._AnyAdverb, searchWord) = True) Then
                    report("Adv", i, pubVocabularyAdv(i)._AnyAdverb, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocAdjective
                If (testEntry(searchMode, pubVocabularyAdj(i)._AnyAdjective, searchWord) = True) Then
                    report("Adj", i, pubVocabularyAdj(i)._AnyAdjective, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocPreposition
                If (testEntry(searchMode, pubVocabularyPre(i)._AnyPreposition, searchWord) = True) Then
                    report("Pre", i, pubVocabularyPre(i)._AnyPreposition, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocParticle
                If (testEntry(searchMode, pubVocabularyPar(i)._AnyParticle, searchWord) = True) Then
                    report("Par", i, pubVocabularyPar(i)._AnyParticle, fromLanguage, toLanguage)
                End If
            Next
            For i = 1 To countVocJunction
                If (testEntry(searchMode, pubVocabularyJun(i)._AnyJunction, searchWord) = True) Then
                    report("Jun", i, pubVocabularyJun(i)._AnyJunction, fromLanguage, toLanguage)
                End If
            Next

        Else
            ' error

        End If

        ' check
        If (RichTextBoxTranslation.Text = "") Then
            RichTextBoxTranslation.Text = "No entry!"
        End If

    End Sub

    Private Function testEntry(ByVal searchMode As Integer, ByVal searchEntry As String, ByVal searchWord As String) As Boolean
        ' Test

        If (searchMode = 0 And searchEntry = searchWord Or searchMode = 1 And searchEntry.StartsWith(searchWord) = True) Then
            testEntry = True
        Else
            testEntry = False
        End If

    End Function

    Private Sub report(ByVal wordtype As String, ByVal wordIndex As Integer, ByVal searchEntry As String, ByVal fromLanguage As Integer, ByVal toLanguage As Integer)
        ' Report
        Dim context As String
        Dim synomym As String
        Dim niveau As String
        Dim topic As String
        Dim grpid As String
        Dim translation As String
        Dim indexStr As String

        RichTextBoxTranslation.Text = RichTextBoxTranslation.Text & vbCrLf & "------------------------------"

        If (wordtype = "Pro") Then
            ' Pronomen
            context = pubVocabularyPro(wordIndex)._KonPronomen
            synomym = pubVocabularyPro(wordIndex)._SynPronomen
            niveau = pubVocabularyPro(wordIndex)._NivPronomen
            topic = pubVocabularyPro(wordIndex)._ThmPronomen
            grpid = pubVocabularyPro(wordIndex)._GrpPronomen
            translation = ""
            indexStr = pubVocabularyPro(wordIndex)._CooPronomen
            If (toLanguage = LangName.Esperanto) Then
                translation = pubVocabularyPro(wordIndex)._EspPronomen

            ElseIf (toLanguage = LangName.Deutsch) Then
                translation = pubVocabularyPro(wordIndex)._GerPronomen

            ElseIf (toLanguage = LangName.English) Then
                translation = pubVocabularyPro(wordIndex)._EngPronomen

            ElseIf (toLanguage = LangName.Francais) Then
                translation = pubVocabularyPro(wordIndex)._FraPronomen

            ElseIf (toLanguage = LangName.Espanol) Then
                translation = pubVocabularyPro(wordIndex)._SpaPronomen

            ElseIf (toLanguage = LangName.Italiano) Then
                translation = pubVocabularyPro(wordIndex)._ItaPronomen

            ElseIf (toLanguage = LangName.Portoguese) Then
                translation = pubVocabularyPro(wordIndex)._PorPronomen

            ElseIf (toLanguage = LangName.Dansk) Then
                translation = pubVocabularyPro(wordIndex)._DanPronomen

            ElseIf (toLanguage = LangName.Svenska) Then
                translation = pubVocabularyPro(wordIndex)._SwePronomen

            ElseIf (toLanguage = LangName.Ellenika) Then
                translation = pubVocabularyPro(wordIndex)._GrePronomen

            ElseIf (toLanguage = LangName.Russkij) Then
                translation = pubVocabularyPro(wordIndex)._RusPronomen

            ElseIf (toLanguage = LangName.Polski) Then
                translation = pubVocabularyPro(wordIndex)._PolPronomen

            ElseIf (toLanguage = LangName.Hrvatski) Then
                translation = pubVocabularyPro(wordIndex)._CroPronomen

            ElseIf (toLanguage = LangName.AnyLang) Then
                translation = pubVocabularyPro(wordIndex)._AnyPronomen

            Else
                ' error

            End If

            ' Anzeige
            If (translation <> "" And translation <> "***" And translation <> "###") Then
                RichTextBoxTranslation.Text = RichTextBoxTranslation.Text & vbCrLf & "[Pro] " & translation & vbCrLf & "   [got] " & searchEntry & vbCrLf & "   [con] " & context & vbCrLf & "   [syn] " & synomym & vbCrLf & "   [niv] " & niveau & vbCrLf & "   [top] " & topic & vbCrLf & "   [grp] " & grpid
                If (indexStr <> "") Then cooccurrence(indexStr, toLanguage)
            End If

        ElseIf (wordtype = "Nom") Then
            ' Nomen
            context = pubVocabularyNom(wordIndex)._KonNomen
            synomym = pubVocabularyNom(wordIndex)._SynNomen
            niveau = pubVocabularyNom(wordIndex)._NivNomen
            topic = pubVocabularyNom(wordIndex)._ThmNomen
            grpid = pubVocabularyNom(wordIndex)._GrpNomen
            translation = ""
            indexStr = pubVocabularyNom(wordIndex)._CooNomen
            If (toLanguage = LangName.Esperanto) Then
                translation = pubVocabularyNom(wordIndex)._EspNomen

            ElseIf (toLanguage = LangName.Deutsch) Then
                translation = pubVocabularyNom(wordIndex)._GerNomen

            ElseIf (toLanguage = LangName.English) Then
                translation = pubVocabularyNom(wordIndex)._EngNomen

            ElseIf (toLanguage = LangName.Francais) Then
                translation = pubVocabularyNom(wordIndex)._FraNomen

            ElseIf (toLanguage = LangName.Espanol) Then
                translation = pubVocabularyNom(wordIndex)._SpaNomen

            ElseIf (toLanguage = LangName.Italiano) Then
                translation = pubVocabularyNom(wordIndex)._ItaNomen

            ElseIf (toLanguage = LangName.Portoguese) Then
                translation = pubVocabularyNom(wordIndex)._PorNomen

            ElseIf (toLanguage = LangName.Dansk) Then
                translation = pubVocabularyNom(wordIndex)._DanNomen

            ElseIf (toLanguage = LangName.Svenska) Then
                translation = pubVocabularyNom(wordIndex)._SweNomen

            ElseIf (toLanguage = LangName.Ellenika) Then
                translation = pubVocabularyNom(wordIndex)._GreNomen

            ElseIf (toLanguage = LangName.Russkij) Then
                translation = pubVocabularyNom(wordIndex)._RusNomen

            ElseIf (toLanguage = LangName.Polski) Then
                translation = pubVocabularyNom(wordIndex)._PolNomen

            ElseIf (toLanguage = LangName.Hrvatski) Then
                translation = pubVocabularyNom(wordIndex)._CroNomen

            ElseIf (toLanguage = LangName.AnyLang) Then
                translation = pubVocabularyNom(wordIndex)._AnyNomen

            Else
                ' error

            End If

            ' Anzeige
            If (translation <> "" And translation <> "***" And translation <> "###") Then
                RichTextBoxTranslation.Text = RichTextBoxTranslation.Text & vbCrLf & "[Nom] " & translation & vbCrLf & "   [got] " & searchEntry & vbCrLf & "   [con] " & context & vbCrLf & "   [syn] " & synomym & vbCrLf & "   [niv] " & niveau & vbCrLf & "   [top] " & topic & vbCrLf & "   [grp] " & grpid
                If (indexStr <> "") Then cooccurrence(indexStr, toLanguage)
            End If

        ElseIf (wordtype = "Ver") Then
            ' Verb
            context = pubVocabularyVer(wordIndex)._KonVerb
            synomym = pubVocabularyVer(wordIndex)._SynVerb
            niveau = pubVocabularyVer(wordIndex)._NivVerb
            topic = pubVocabularyVer(wordIndex)._ThmVerb
            grpid = pubVocabularyVer(wordIndex)._GrpVerb
            translation = ""
            indexStr = pubVocabularyVer(wordIndex)._CooVerb
            If (toLanguage = LangName.Esperanto) Then
                translation = pubVocabularyVer(wordIndex)._EspVerb

            ElseIf (toLanguage = LangName.Deutsch) Then
                translation = pubVocabularyVer(wordIndex)._GerVerb

            ElseIf (toLanguage = LangName.English) Then
                translation = pubVocabularyVer(wordIndex)._EngVerb

            ElseIf (toLanguage = LangName.Francais) Then
                translation = pubVocabularyVer(wordIndex)._FraVerb

            ElseIf (toLanguage = LangName.Espanol) Then
                translation = pubVocabularyVer(wordIndex)._SpaVerb

            ElseIf (toLanguage = LangName.Italiano) Then
                translation = pubVocabularyVer(wordIndex)._ItaVerb

            ElseIf (toLanguage = LangName.Portoguese) Then
                translation = pubVocabularyVer(wordIndex)._PorVerb

            ElseIf (toLanguage = LangName.Dansk) Then
                translation = pubVocabularyVer(wordIndex)._DanVerb

            ElseIf (toLanguage = LangName.Svenska) Then
                translation = pubVocabularyVer(wordIndex)._SweVerb

            ElseIf (toLanguage = LangName.Ellenika) Then
                translation = pubVocabularyVer(wordIndex)._GreVerb

            ElseIf (toLanguage = LangName.Russkij) Then
                translation = pubVocabularyVer(wordIndex)._RusVerb

            ElseIf (toLanguage = LangName.Polski) Then
                translation = pubVocabularyVer(wordIndex)._PolVerb

            ElseIf (toLanguage = LangName.Hrvatski) Then
                translation = pubVocabularyVer(wordIndex)._CroVerb

            ElseIf (toLanguage = LangName.AnyLang) Then
                translation = pubVocabularyVer(wordIndex)._AnyVerb

            Else
                ' error

            End If

            ' Anzeige
            If (translation <> "" And translation <> "***" And translation <> "###") Then
                RichTextBoxTranslation.Text = RichTextBoxTranslation.Text & vbCrLf & "[Ver] " & translation & vbCrLf & "   [got] " & searchEntry & vbCrLf & "   [con] " & context & vbCrLf & "   [syn] " & synomym & vbCrLf & "   [niv] " & niveau & vbCrLf & "   [top] " & topic & vbCrLf & "   [grp] " & grpid
                If (indexStr <> "") Then cooccurrence(indexStr, toLanguage)
            End If

        ElseIf (wordtype = "Adv") Then
            ' Adverb
            context = pubVocabularyAdv(wordIndex)._KonAdverb
            synomym = pubVocabularyAdv(wordIndex)._SynAdverb
            niveau = pubVocabularyAdv(wordIndex)._NivAdverb
            topic = pubVocabularyAdv(wordIndex)._ThmAdverb
            grpid = pubVocabularyAdv(wordIndex)._GrpAdverb
            translation = ""
            indexStr = pubVocabularyAdv(wordIndex)._CooAdverb
            If (toLanguage = LangName.Esperanto) Then
                translation = pubVocabularyAdv(wordIndex)._EspAdverb

            ElseIf (toLanguage = LangName.Deutsch) Then
                translation = pubVocabularyAdv(wordIndex)._GerAdverb

            ElseIf (toLanguage = LangName.English) Then
                translation = pubVocabularyAdv(wordIndex)._EngAdverb

            ElseIf (toLanguage = LangName.Francais) Then
                translation = pubVocabularyAdv(wordIndex)._FraAdverb

            ElseIf (toLanguage = LangName.Espanol) Then
                translation = pubVocabularyAdv(wordIndex)._SpaAdverb

            ElseIf (toLanguage = LangName.Italiano) Then
                translation = pubVocabularyAdv(wordIndex)._ItaAdverb

            ElseIf (toLanguage = LangName.Portoguese) Then
                translation = pubVocabularyAdv(wordIndex)._PorAdverb

            ElseIf (toLanguage = LangName.Dansk) Then
                translation = pubVocabularyAdv(wordIndex)._DanAdverb

            ElseIf (toLanguage = LangName.Svenska) Then
                translation = pubVocabularyAdv(wordIndex)._SweAdverb

            ElseIf (toLanguage = LangName.Ellenika) Then
                translation = pubVocabularyAdv(wordIndex)._GreAdverb

            ElseIf (toLanguage = LangName.Russkij) Then
                translation = pubVocabularyAdv(wordIndex)._RusAdverb

            ElseIf (toLanguage = LangName.Polski) Then
                translation = pubVocabularyAdv(wordIndex)._PolAdverb

            ElseIf (toLanguage = LangName.Hrvatski) Then
                translation = pubVocabularyAdv(wordIndex)._CroAdverb

            ElseIf (toLanguage = LangName.AnyLang) Then
                translation = pubVocabularyAdv(wordIndex)._AnyAdverb

            Else
                ' error

            End If

            ' Anzeige
            If (translation <> "" And translation <> "***" And translation <> "###") Then
                RichTextBoxTranslation.Text = RichTextBoxTranslation.Text & vbCrLf & "[Adv] " & translation & vbCrLf & "   [got] " & searchEntry & vbCrLf & "   [con] " & context & vbCrLf & "   [syn] " & synomym & vbCrLf & "   [niv] " & niveau & vbCrLf & "   [top] " & topic & vbCrLf & "   [grp] " & grpid
                If (indexStr <> "") Then cooccurrence(indexStr, toLanguage)
            End If

        ElseIf (wordtype = "Adj") Then
            ' Adjektiv
            context = pubVocabularyAdj(wordIndex)._KonAdjective
            synomym = pubVocabularyAdj(wordIndex)._SynAdjective
            niveau = pubVocabularyAdj(wordIndex)._NivAdjective
            topic = pubVocabularyAdj(wordIndex)._ThmAdjective
            grpid = pubVocabularyAdj(wordIndex)._GrpAdjective
            translation = ""
            indexStr = pubVocabularyAdj(wordIndex)._CooAdjective
            If (toLanguage = LangName.Esperanto) Then
                translation = pubVocabularyAdj(wordIndex)._EspAdjective

            ElseIf (toLanguage = LangName.Deutsch) Then
                translation = pubVocabularyAdj(wordIndex)._GerAdjective

            ElseIf (toLanguage = LangName.English) Then
                translation = pubVocabularyAdj(wordIndex)._EngAdjective

            ElseIf (toLanguage = LangName.Francais) Then
                translation = pubVocabularyAdj(wordIndex)._FraAdjective

            ElseIf (toLanguage = LangName.Espanol) Then
                translation = pubVocabularyAdj(wordIndex)._SpaAdjective

            ElseIf (toLanguage = LangName.Italiano) Then
                translation = pubVocabularyAdj(wordIndex)._ItaAdjective

            ElseIf (toLanguage = LangName.Portoguese) Then
                translation = pubVocabularyAdj(wordIndex)._PorAdjective

            ElseIf (toLanguage = LangName.Dansk) Then
                translation = pubVocabularyAdj(wordIndex)._DanAdjective

            ElseIf (toLanguage = LangName.Svenska) Then
                translation = pubVocabularyAdj(wordIndex)._SweAdjective

            ElseIf (toLanguage = LangName.Ellenika) Then
                translation = pubVocabularyAdj(wordIndex)._GreAdjective

            ElseIf (toLanguage = LangName.Russkij) Then
                translation = pubVocabularyAdj(wordIndex)._RusAdjective

            ElseIf (toLanguage = LangName.Polski) Then
                translation = pubVocabularyAdj(wordIndex)._PolAdjective

            ElseIf (toLanguage = LangName.Hrvatski) Then
                translation = pubVocabularyAdj(wordIndex)._CroAdjective

            ElseIf (toLanguage = LangName.AnyLang) Then
                translation = pubVocabularyAdj(wordIndex)._AnyAdjective

            Else
                ' error

            End If

            ' Anzeige
            If (translation <> "" And translation <> "***" And translation <> "###") Then
                RichTextBoxTranslation.Text = RichTextBoxTranslation.Text & vbCrLf & "[Adj] " & translation & vbCrLf & "   [got] " & searchEntry & vbCrLf & "   [con] " & context & vbCrLf & "   [syn] " & synomym & vbCrLf & "   [niv] " & niveau & vbCrLf & "   [top] " & topic & vbCrLf & "   [grp] " & grpid
                If (indexStr <> "") Then cooccurrence(indexStr, toLanguage)
            End If

        ElseIf (wordtype = "Pre") Then
            ' Preposition
            context = pubVocabularyPre(wordIndex)._KonPreposition
            synomym = pubVocabularyPre(wordIndex)._SynPreposition
            niveau = pubVocabularyPre(wordIndex)._NivPreposition
            topic = pubVocabularyPre(wordIndex)._ThmPreposition
            grpid = pubVocabularyPre(wordIndex)._GrpPreposition
            translation = ""
            indexStr = pubVocabularyPre(wordIndex)._CooPreposition
            If (toLanguage = LangName.Esperanto) Then
                translation = pubVocabularyPre(wordIndex)._EspPreposition

            ElseIf (toLanguage = LangName.Deutsch) Then
                translation = pubVocabularyPre(wordIndex)._GerPreposition

            ElseIf (toLanguage = LangName.English) Then
                translation = pubVocabularyPre(wordIndex)._EngPreposition

            ElseIf (toLanguage = LangName.Francais) Then
                translation = pubVocabularyPre(wordIndex)._FraPreposition

            ElseIf (toLanguage = LangName.Espanol) Then
                translation = pubVocabularyPre(wordIndex)._SpaPreposition

            ElseIf (toLanguage = LangName.Italiano) Then
                translation = pubVocabularyPre(wordIndex)._ItaPreposition

            ElseIf (toLanguage = LangName.Portoguese) Then
                translation = pubVocabularyPre(wordIndex)._PorPreposition

            ElseIf (toLanguage = LangName.Dansk) Then
                translation = pubVocabularyPre(wordIndex)._DanPreposition

            ElseIf (toLanguage = LangName.Svenska) Then
                translation = pubVocabularyPre(wordIndex)._SwePreposition

            ElseIf (toLanguage = LangName.Ellenika) Then
                translation = pubVocabularyPre(wordIndex)._GrePreposition

            ElseIf (toLanguage = LangName.Russkij) Then
                translation = pubVocabularyPre(wordIndex)._RusPreposition

            ElseIf (toLanguage = LangName.Polski) Then
                translation = pubVocabularyPre(wordIndex)._PolPreposition

            ElseIf (toLanguage = LangName.Hrvatski) Then
                translation = pubVocabularyPre(wordIndex)._CroPreposition

            ElseIf (toLanguage = LangName.AnyLang) Then
                translation = pubVocabularyPre(wordIndex)._AnyPreposition

            Else
                ' error

            End If

            ' Anzeige
            If (translation <> "" And translation <> "***" And translation <> "###") Then
                RichTextBoxTranslation.Text = RichTextBoxTranslation.Text & vbCrLf & "[Pre] " & translation & vbCrLf & "   [got] " & searchEntry & vbCrLf & "   [con] " & context & vbCrLf & "   [syn] " & synomym & vbCrLf & "   [niv] " & niveau & vbCrLf & "   [top] " & topic & vbCrLf & "   [grp] " & grpid
                If (indexStr <> "") Then cooccurrence(indexStr, toLanguage)
            End If

        ElseIf (wordtype = "Par") Then
            ' Particle
            context = pubVocabularyPar(wordIndex)._KonParticle
            synomym = pubVocabularyPar(wordIndex)._SynParticle
            niveau = pubVocabularyPar(wordIndex)._NivParticle
            topic = pubVocabularyPar(wordIndex)._ThmParticle
            grpid = pubVocabularyPar(wordIndex)._GrpParticle
            translation = ""
            indexStr = pubVocabularyPar(wordIndex)._CooParticle
            If (toLanguage = LangName.Esperanto) Then
                translation = pubVocabularyPar(wordIndex)._EspParticle

            ElseIf (toLanguage = LangName.Deutsch) Then
                translation = pubVocabularyPar(wordIndex)._GerParticle

            ElseIf (toLanguage = LangName.English) Then
                translation = pubVocabularyPar(wordIndex)._EngParticle

            ElseIf (toLanguage = LangName.Francais) Then
                translation = pubVocabularyPar(wordIndex)._FraParticle

            ElseIf (toLanguage = LangName.Espanol) Then
                translation = pubVocabularyPar(wordIndex)._SpaParticle

            ElseIf (toLanguage = LangName.Italiano) Then
                translation = pubVocabularyPar(wordIndex)._ItaParticle

            ElseIf (toLanguage = LangName.Portoguese) Then
                translation = pubVocabularyPar(wordIndex)._PorParticle

            ElseIf (toLanguage = LangName.Dansk) Then
                translation = pubVocabularyPar(wordIndex)._DanParticle

            ElseIf (toLanguage = LangName.Svenska) Then
                translation = pubVocabularyPar(wordIndex)._SweParticle

            ElseIf (toLanguage = LangName.Ellenika) Then
                translation = pubVocabularyPar(wordIndex)._GreParticle

            ElseIf (toLanguage = LangName.Russkij) Then
                translation = pubVocabularyPar(wordIndex)._RusParticle

            ElseIf (toLanguage = LangName.Polski) Then
                translation = pubVocabularyPar(wordIndex)._PolParticle

            ElseIf (toLanguage = LangName.Hrvatski) Then
                translation = pubVocabularyPar(wordIndex)._CroParticle

            ElseIf (toLanguage = LangName.AnyLang) Then
                translation = pubVocabularyPar(wordIndex)._AnyParticle

            Else
                ' error

            End If

            ' Anzeige
            If (translation <> "" And translation <> "***" And translation <> "###") Then
                RichTextBoxTranslation.Text = RichTextBoxTranslation.Text & vbCrLf & "[Par] " & translation & vbCrLf & "   [got] " & searchEntry & vbCrLf & "   [con] " & context & vbCrLf & "   [syn] " & synomym & vbCrLf & "   [niv] " & niveau & vbCrLf & "   [top] " & topic & vbCrLf & "   [grp] " & grpid
                If (indexStr <> "") Then cooccurrence(indexStr, toLanguage)
            End If

        ElseIf (wordtype = "Jun") Then
            ' Junktion
            context = pubVocabularyJun(wordIndex)._KonJunction
            synomym = pubVocabularyJun(wordIndex)._SynJunction
            niveau = pubVocabularyJun(wordIndex)._NivJunction
            topic = pubVocabularyJun(wordIndex)._ThmJunction
            grpid = pubVocabularyJun(wordIndex)._GrpJunction
            translation = ""
            indexStr = pubVocabularyJun(wordIndex)._CooJunction
            If (toLanguage = LangName.Esperanto) Then
                translation = pubVocabularyJun(wordIndex)._EspJunction

            ElseIf (toLanguage = LangName.Deutsch) Then
                translation = pubVocabularyJun(wordIndex)._GerJunction

            ElseIf (toLanguage = LangName.English) Then
                translation = pubVocabularyJun(wordIndex)._EngJunction

            ElseIf (toLanguage = LangName.Francais) Then
                translation = pubVocabularyJun(wordIndex)._FraJunction

            ElseIf (toLanguage = LangName.Espanol) Then
                translation = pubVocabularyJun(wordIndex)._SpaJunction

            ElseIf (toLanguage = LangName.Italiano) Then
                translation = pubVocabularyJun(wordIndex)._ItaJunction

            ElseIf (toLanguage = LangName.Portoguese) Then
                translation = pubVocabularyJun(wordIndex)._PorJunction

            ElseIf (toLanguage = LangName.Dansk) Then
                translation = pubVocabularyJun(wordIndex)._DanJunction

            ElseIf (toLanguage = LangName.Svenska) Then
                translation = pubVocabularyJun(wordIndex)._SweJunction

            ElseIf (toLanguage = LangName.Ellenika) Then
                translation = pubVocabularyJun(wordIndex)._GreJunction

            ElseIf (toLanguage = LangName.Russkij) Then
                translation = pubVocabularyJun(wordIndex)._RusJunction

            ElseIf (toLanguage = LangName.Polski) Then
                translation = pubVocabularyJun(wordIndex)._PolJunction

            ElseIf (toLanguage = LangName.Hrvatski) Then
                translation = pubVocabularyJun(wordIndex)._CroJunction

            ElseIf (toLanguage = LangName.AnyLang) Then
                translation = pubVocabularyJun(wordIndex)._AnyJunction

            Else
                ' error

            End If

            ' Anzeige
            If (translation <> "" And translation <> "***" And translation <> "###") Then
                RichTextBoxTranslation.Text = RichTextBoxTranslation.Text & vbCrLf & "[Jun] " & translation & vbCrLf & "   [got] " & searchEntry & vbCrLf & "   [con] " & context & vbCrLf & "   [syn] " & synomym & vbCrLf & "   [niv] " & niveau & vbCrLf & "   [top] " & topic & vbCrLf & "   [grp] " & grpid
                If (indexStr <> "") Then cooccurrence(indexStr, toLanguage)
            End If

        Else
            ' error

        End If

        ' check
        If (RichTextBoxTranslation.Text = "") Then
            RichTextBoxTranslation.Text = "Empty entry!"
            Exit Sub
        End If

        semanticGroup(wordtype, wordIndex, searchEntry, fromLanguage)

    End Sub

    Private Sub cooccurrence(indexStr As String, toLanguage As String)
        ' Cocccurrence Information
        Dim coocString As String
        Dim wordIndex As Integer
        Dim i As Integer
        Dim sind1, sind2 As Integer

        ' Check
        sind1 = 0
        sind2 = indexStr.IndexOf(";")
        ' Anzeige
        RichTextBoxTranslation.Text = RichTextBoxTranslation.Text & vbCrLf & "Cooccurrence: "
        While (sind2 < indexStr.Length)

            wordIndex = CInt(Val(indexStr.Substring(sind1, sind2 - sind1)))
            coocString = ""
            If (toLanguage = LangName.Esperanto) Then
                coocString = pubVocabularyCoo(wordIndex)._EspCooccurrence

            ElseIf (toLanguage = LangName.Deutsch) Then
                coocString = pubVocabularyCoo(wordIndex)._GerCooccurrence

            ElseIf (toLanguage = LangName.English) Then
                coocString = pubVocabularyCoo(wordIndex)._EngCooccurrence

            ElseIf (toLanguage = LangName.Francais) Then
                coocString = pubVocabularyCoo(wordIndex)._FraCooccurrence

            ElseIf (toLanguage = LangName.Espanol) Then
                coocString = pubVocabularyCoo(wordIndex)._SpaCooccurrence

            ElseIf (toLanguage = LangName.Italiano) Then
                coocString = pubVocabularyCoo(wordIndex)._ItaCooccurrence

            ElseIf (toLanguage = LangName.Portoguese) Then
                coocString = pubVocabularyCoo(wordIndex)._PorCooccurrence

            ElseIf (toLanguage = LangName.Dansk) Then
                coocString = pubVocabularyCoo(wordIndex)._DanCooccurrence

            ElseIf (toLanguage = LangName.Svenska) Then
                coocString = pubVocabularyCoo(wordIndex)._SweCooccurrence

            ElseIf (toLanguage = LangName.Ellenika) Then
                coocString = pubVocabularyCoo(wordIndex)._GreCooccurrence

            ElseIf (toLanguage = LangName.Russkij) Then
                coocString = pubVocabularyCoo(wordIndex)._RusCooccurrence

            ElseIf (toLanguage = LangName.Polski) Then
                coocString = pubVocabularyCoo(wordIndex)._PolCooccurrence

            ElseIf (toLanguage = LangName.Hrvatski) Then
                coocString = pubVocabularyCoo(wordIndex)._CroCooccurrence

            ElseIf (toLanguage = LangName.AnyLang) Then
                coocString = pubVocabularyCoo(wordIndex)._AnyCooccurrence

            Else
                ' error

            End If

            ' Anzeige
            If (coocString <> "") Then
                RichTextBoxTranslation.Text = RichTextBoxTranslation.Text & vbCrLf & "- " & coocString
            End If

            ' weiter?
            sind1 = sind2 + 1
            If (sind1 < indexStr.Length - 1) Then
                sind2 = indexStr.IndexOf(";", sind1)
            Else
                sind2 = indexStr.Length
            End If

        End While

    End Sub

    Private Sub semanticGroup(ByVal wordtype As String, ByVal wordIndex As Integer, ByVal searchEntry As String, ByVal fromLanguage As Integer)
        ' Semantic Group Information
        Dim semGrp As String
        Dim numgrp() As String
        Dim anzGrp As Integer
        Dim indGrp As Integer
        Dim typGrp As String
        Dim namGrp As String
        Dim wordTypeGrp As String
        Dim wordIndexGrp As Integer
        Dim wordHierarchyGrp As String
        Dim wordExprGrp As String
        Dim anzStr As String
        Dim i As Integer
        Dim j As Integer
        Dim k As Integer

        ' Group Attribute
        If (wordtype = "Pro") Then
            semGrp = pubVocabularyPro(wordIndex)._GrpPronomen
        ElseIf (wordtype = "Nom") Then
            semGrp = pubVocabularyNom(wordIndex)._GrpNomen
        ElseIf (wordtype = "Ver") Then
            semGrp = pubVocabularyVer(wordIndex)._GrpVerb
        ElseIf (wordtype = "Adv") Then
            semGrp = pubVocabularyAdv(wordIndex)._GrpAdverb
        ElseIf (wordtype = "Adj") Then
            semGrp = pubVocabularyAdj(wordIndex)._GrpAdjective
        ElseIf (wordtype = "Pre") Then
            semGrp = pubVocabularyPre(wordIndex)._GrpPreposition
        ElseIf (wordtype = "Par") Then
            semGrp = pubVocabularyPar(wordIndex)._GrpParticle
        ElseIf (wordtype = "Jun") Then
            semGrp = pubVocabularyJun(wordIndex)._GrpJunction
        Else
            semGrp = "X00000"
        End If

        ' Check
        If (semGrp = "" Or semGrp = "-" Or semGrp = "X00000") Then
            ' no Group
            'RichTextBoxTranslation.Text = RichTextBoxTranslation.Text & vbCrLf & "no Semantic Group Information"
            Exit Sub

        End If

        ' Number of Groups
        numgrp = semGrp.Split(";")
        anzGrp = numgrp.Count

        For k = 1 To anzGrp

            ' Group Index
            For i = 1 To countVocGroup
                If (numgrp(k - 1) = pubVocabularyGrp(i)._GrpNumber) Then
                    indGrp = i
                    Exit For

                End If
            Next

            ' Group Information
            ' Header
            typGrp = pubVocabularyGrp(indGrp)._GrpType
            namGrp = pubVocabularyGrp(indGrp)._GrpName
            If (anzGrp > 1) Then
                anzStr = k.ToString
            Else
                anzStr = ""
            End If
            RichTextBoxTranslation.Text = RichTextBoxTranslation.Text & vbCrLf & "Semantic Group Information " & anzStr & ": " & vbCrLf & "- Type: " & typGrp & vbCrLf & "- Name: " & namGrp & vbCrLf & "- Group Members: "
            ' Links
            For j = 1 To pubVocabularyGrp(indGrp)._GrpMember(0)
                wordTypeGrp = pubVocabularyGrp(indGrp)._GrpMember(j).Substring(0, 3)
                wordIndexGrp = CInt(Val(pubVocabularyGrp(indGrp)._GrpMember(j).Substring(3, 5)))
                wordHierarchyGrp = ""
                If (pubVocabularyGrp(indGrp)._GrpNumber.StartsWith("H") Or pubVocabularyGrp(indGrp)._GrpNumber.StartsWith("EH")) Then
                    wordHierarchyGrp = pubVocabularyGrp(indGrp)._GrpMember(j).Substring(9, 3)
                End If

                wordExprGrp = "---"

                If (wordTypeGrp = "Pro") Then
                    If (fromLanguage = LangName.Esperanto) Then
                        wordExprGrp = pubVocabularyPro(wordIndexGrp)._EspPronomen
                    ElseIf (fromLanguage = LangName.Deutsch) Then
                        wordExprGrp = pubVocabularyPro(wordIndexGrp)._GerPronomen
                    ElseIf (fromLanguage = LangName.English) Then
                        wordExprGrp = pubVocabularyPro(wordIndexGrp)._EngPronomen
                    ElseIf (fromLanguage = LangName.Francais) Then
                        wordExprGrp = pubVocabularyPro(wordIndexGrp)._FraPronomen
                    ElseIf (fromLanguage = LangName.Espanol) Then
                        wordExprGrp = pubVocabularyPro(wordIndexGrp)._SpaPronomen
                    ElseIf (fromLanguage = LangName.Italiano) Then
                        wordExprGrp = pubVocabularyPro(wordIndexGrp)._ItaPronomen
                    ElseIf (fromLanguage = LangName.Portoguese) Then
                        wordExprGrp = pubVocabularyPro(wordIndexGrp)._PorPronomen
                    ElseIf (fromLanguage = LangName.Dansk) Then
                        wordExprGrp = pubVocabularyPro(wordIndexGrp)._DanPronomen
                    ElseIf (fromLanguage = LangName.Svenska) Then
                        wordExprGrp = pubVocabularyPro(wordIndexGrp)._SwePronomen
                    ElseIf (fromLanguage = LangName.Ellenika) Then
                        wordExprGrp = pubVocabularyPro(wordIndexGrp)._GrePronomen
                    ElseIf (fromLanguage = LangName.Russkij) Then
                        wordExprGrp = pubVocabularyPro(wordIndexGrp)._RusPronomen
                    ElseIf (fromLanguage = LangName.Polski) Then
                        wordExprGrp = pubVocabularyPro(wordIndexGrp)._PolPronomen
                    ElseIf (fromLanguage = LangName.Hrvatski) Then
                        wordExprGrp = pubVocabularyPro(wordIndexGrp)._CroPronomen
                    ElseIf (fromLanguage = LangName.AnyLang) Then
                        wordExprGrp = pubVocabularyPro(wordIndexGrp)._AnyPronomen
                    End If

                ElseIf (wordTypeGrp = "Nom") Then
                    If (fromLanguage = LangName.Esperanto) Then
                        wordExprGrp = pubVocabularyNom(wordIndexGrp)._EspNomen
                    ElseIf (fromLanguage = LangName.Deutsch) Then
                        wordExprGrp = pubVocabularyNom(wordIndexGrp)._GerNomen
                    ElseIf (fromLanguage = LangName.English) Then
                        wordExprGrp = pubVocabularyNom(wordIndexGrp)._EngNomen
                    ElseIf (fromLanguage = LangName.Francais) Then
                        wordExprGrp = pubVocabularyNom(wordIndexGrp)._FraNomen
                    ElseIf (fromLanguage = LangName.Espanol) Then
                        wordExprGrp = pubVocabularyNom(wordIndexGrp)._SpaNomen
                    ElseIf (fromLanguage = LangName.Italiano) Then
                        wordExprGrp = pubVocabularyNom(wordIndexGrp)._ItaNomen
                    ElseIf (fromLanguage = LangName.Portoguese) Then
                        wordExprGrp = pubVocabularyNom(wordIndexGrp)._PorNomen
                    ElseIf (fromLanguage = LangName.Dansk) Then
                        wordExprGrp = pubVocabularyNom(wordIndexGrp)._DanNomen
                    ElseIf (fromLanguage = LangName.Svenska) Then
                        wordExprGrp = pubVocabularyNom(wordIndexGrp)._SweNomen
                    ElseIf (fromLanguage = LangName.Ellenika) Then
                        wordExprGrp = pubVocabularyNom(wordIndexGrp)._GreNomen
                    ElseIf (fromLanguage = LangName.Russkij) Then
                        wordExprGrp = pubVocabularyNom(wordIndexGrp)._RusNomen
                    ElseIf (fromLanguage = LangName.Polski) Then
                        wordExprGrp = pubVocabularyNom(wordIndexGrp)._PolNomen
                    ElseIf (fromLanguage = LangName.Hrvatski) Then
                        wordExprGrp = pubVocabularyNom(wordIndexGrp)._CroNomen
                    ElseIf (fromLanguage = LangName.AnyLang) Then
                        wordExprGrp = pubVocabularyNom(wordIndexGrp)._AnyNomen
                    End If

                ElseIf (wordTypeGrp = "Ver") Then
                    If (fromLanguage = LangName.Esperanto) Then
                        wordExprGrp = pubVocabularyVer(wordIndexGrp)._EspVerb
                    ElseIf (fromLanguage = LangName.Deutsch) Then
                        wordExprGrp = pubVocabularyVer(wordIndexGrp)._GerVerb
                    ElseIf (fromLanguage = LangName.English) Then
                        wordExprGrp = pubVocabularyVer(wordIndexGrp)._EngVerb
                    ElseIf (fromLanguage = LangName.Francais) Then
                        wordExprGrp = pubVocabularyVer(wordIndexGrp)._FraVerb
                    ElseIf (fromLanguage = LangName.Espanol) Then
                        wordExprGrp = pubVocabularyVer(wordIndexGrp)._SpaVerb
                    ElseIf (fromLanguage = LangName.Italiano) Then
                        wordExprGrp = pubVocabularyVer(wordIndexGrp)._ItaVerb
                    ElseIf (fromLanguage = LangName.Portoguese) Then
                        wordExprGrp = pubVocabularyVer(wordIndexGrp)._PorVerb
                    ElseIf (fromLanguage = LangName.Dansk) Then
                        wordExprGrp = pubVocabularyVer(wordIndexGrp)._DanVerb
                    ElseIf (fromLanguage = LangName.Svenska) Then
                        wordExprGrp = pubVocabularyVer(wordIndexGrp)._SweVerb
                    ElseIf (fromLanguage = LangName.Ellenika) Then
                        wordExprGrp = pubVocabularyVer(wordIndexGrp)._GreVerb
                    ElseIf (fromLanguage = LangName.Russkij) Then
                        wordExprGrp = pubVocabularyVer(wordIndexGrp)._RusVerb
                    ElseIf (fromLanguage = LangName.Polski) Then
                        wordExprGrp = pubVocabularyVer(wordIndexGrp)._PolVerb
                    ElseIf (fromLanguage = LangName.Hrvatski) Then
                        wordExprGrp = pubVocabularyVer(wordIndexGrp)._CroVerb
                    ElseIf (fromLanguage = LangName.AnyLang) Then
                        wordExprGrp = pubVocabularyVer(wordIndexGrp)._AnyVerb
                    End If

                ElseIf (wordTypeGrp = "Adv") Then
                    If (fromLanguage = LangName.Esperanto) Then
                        wordExprGrp = pubVocabularyAdv(wordIndexGrp)._EspAdverb
                    ElseIf (fromLanguage = LangName.Deutsch) Then
                        wordExprGrp = pubVocabularyAdv(wordIndexGrp)._GerAdverb
                    ElseIf (fromLanguage = LangName.English) Then
                        wordExprGrp = pubVocabularyAdv(wordIndexGrp)._EngAdverb
                    ElseIf (fromLanguage = LangName.Francais) Then
                        wordExprGrp = pubVocabularyAdv(wordIndexGrp)._FraAdverb
                    ElseIf (fromLanguage = LangName.Espanol) Then
                        wordExprGrp = pubVocabularyAdv(wordIndexGrp)._SpaAdverb
                    ElseIf (fromLanguage = LangName.Italiano) Then
                        wordExprGrp = pubVocabularyAdv(wordIndexGrp)._ItaAdverb
                    ElseIf (fromLanguage = LangName.Portoguese) Then
                        wordExprGrp = pubVocabularyAdv(wordIndexGrp)._PorAdverb
                    ElseIf (fromLanguage = LangName.Dansk) Then
                        wordExprGrp = pubVocabularyAdv(wordIndexGrp)._DanAdverb
                    ElseIf (fromLanguage = LangName.Svenska) Then
                        wordExprGrp = pubVocabularyAdv(wordIndexGrp)._SweAdverb
                    ElseIf (fromLanguage = LangName.Ellenika) Then
                        wordExprGrp = pubVocabularyAdv(wordIndexGrp)._GreAdverb
                    ElseIf (fromLanguage = LangName.Russkij) Then
                        wordExprGrp = pubVocabularyAdv(wordIndexGrp)._RusAdverb
                    ElseIf (fromLanguage = LangName.Polski) Then
                        wordExprGrp = pubVocabularyAdv(wordIndexGrp)._PolAdverb
                    ElseIf (fromLanguage = LangName.Hrvatski) Then
                        wordExprGrp = pubVocabularyAdv(wordIndexGrp)._CroAdverb
                    ElseIf (fromLanguage = LangName.AnyLang) Then
                        wordExprGrp = pubVocabularyAdv(wordIndexGrp)._AnyAdverb
                    End If

                ElseIf (wordTypeGrp = "Adj") Then
                    If (fromLanguage = LangName.Esperanto) Then
                        wordExprGrp = pubVocabularyAdj(wordIndexGrp)._EspAdjective
                    ElseIf (fromLanguage = LangName.Deutsch) Then
                        wordExprGrp = pubVocabularyAdj(wordIndexGrp)._GerAdjective
                    ElseIf (fromLanguage = LangName.English) Then
                        wordExprGrp = pubVocabularyAdj(wordIndexGrp)._EngAdjective
                    ElseIf (fromLanguage = LangName.Francais) Then
                        wordExprGrp = pubVocabularyAdj(wordIndexGrp)._FraAdjective
                    ElseIf (fromLanguage = LangName.Espanol) Then
                        wordExprGrp = pubVocabularyAdj(wordIndexGrp)._SpaAdjective
                    ElseIf (fromLanguage = LangName.Italiano) Then
                        wordExprGrp = pubVocabularyAdj(wordIndexGrp)._ItaAdjective
                    ElseIf (fromLanguage = LangName.Portoguese) Then
                        wordExprGrp = pubVocabularyAdj(wordIndexGrp)._PorAdjective
                    ElseIf (fromLanguage = LangName.Dansk) Then
                        wordExprGrp = pubVocabularyAdj(wordIndexGrp)._DanAdjective
                    ElseIf (fromLanguage = LangName.Svenska) Then
                        wordExprGrp = pubVocabularyAdj(wordIndexGrp)._SweAdjective
                    ElseIf (fromLanguage = LangName.Ellenika) Then
                        wordExprGrp = pubVocabularyAdj(wordIndexGrp)._GreAdjective
                    ElseIf (fromLanguage = LangName.Russkij) Then
                        wordExprGrp = pubVocabularyAdj(wordIndexGrp)._RusAdjective
                    ElseIf (fromLanguage = LangName.Polski) Then
                        wordExprGrp = pubVocabularyAdj(wordIndexGrp)._PolAdjective
                    ElseIf (fromLanguage = LangName.Hrvatski) Then
                        wordExprGrp = pubVocabularyAdj(wordIndexGrp)._CroAdjective
                    ElseIf (fromLanguage = LangName.AnyLang) Then
                        wordExprGrp = pubVocabularyAdj(wordIndexGrp)._AnyAdjective
                    End If

                ElseIf (wordTypeGrp = "Pre") Then
                    If (fromLanguage = LangName.Esperanto) Then
                        wordExprGrp = pubVocabularyPre(wordIndexGrp)._EspPreposition
                    ElseIf (fromLanguage = LangName.Deutsch) Then
                        wordExprGrp = pubVocabularyPre(wordIndexGrp)._GerPreposition
                    ElseIf (fromLanguage = LangName.English) Then
                        wordExprGrp = pubVocabularyPre(wordIndexGrp)._EngPreposition
                    ElseIf (fromLanguage = LangName.Francais) Then
                        wordExprGrp = pubVocabularyPre(wordIndexGrp)._FraPreposition
                    ElseIf (fromLanguage = LangName.Espanol) Then
                        wordExprGrp = pubVocabularyPre(wordIndexGrp)._SpaPreposition
                    ElseIf (fromLanguage = LangName.Italiano) Then
                        wordExprGrp = pubVocabularyPre(wordIndexGrp)._ItaPreposition
                    ElseIf (fromLanguage = LangName.Portoguese) Then
                        wordExprGrp = pubVocabularyPre(wordIndexGrp)._PorPreposition
                    ElseIf (fromLanguage = LangName.Dansk) Then
                        wordExprGrp = pubVocabularyPre(wordIndexGrp)._DanPreposition
                    ElseIf (fromLanguage = LangName.Svenska) Then
                        wordExprGrp = pubVocabularyPre(wordIndexGrp)._SwePreposition
                    ElseIf (fromLanguage = LangName.Ellenika) Then
                        wordExprGrp = pubVocabularyPre(wordIndexGrp)._GrePreposition
                    ElseIf (fromLanguage = LangName.Russkij) Then
                        wordExprGrp = pubVocabularyPre(wordIndexGrp)._RusPreposition
                    ElseIf (fromLanguage = LangName.Polski) Then
                        wordExprGrp = pubVocabularyPre(wordIndexGrp)._PolPreposition
                    ElseIf (fromLanguage = LangName.Hrvatski) Then
                        wordExprGrp = pubVocabularyPre(wordIndexGrp)._CroPreposition
                    ElseIf (fromLanguage = LangName.AnyLang) Then
                        wordExprGrp = pubVocabularyPre(wordIndexGrp)._AnyPreposition
                    End If

                ElseIf (wordTypeGrp = "Par") Then
                    If (fromLanguage = LangName.Esperanto) Then
                        wordExprGrp = pubVocabularyPar(wordIndexGrp)._EspParticle
                    ElseIf (fromLanguage = LangName.Deutsch) Then
                        wordExprGrp = pubVocabularyPar(wordIndexGrp)._GerParticle
                    ElseIf (fromLanguage = LangName.English) Then
                        wordExprGrp = pubVocabularyPar(wordIndexGrp)._EngParticle
                    ElseIf (fromLanguage = LangName.Francais) Then
                        wordExprGrp = pubVocabularyPar(wordIndexGrp)._FraParticle
                    ElseIf (fromLanguage = LangName.Espanol) Then
                        wordExprGrp = pubVocabularyPar(wordIndexGrp)._SpaParticle
                    ElseIf (fromLanguage = LangName.Italiano) Then
                        wordExprGrp = pubVocabularyPar(wordIndexGrp)._ItaParticle
                    ElseIf (fromLanguage = LangName.Portoguese) Then
                        wordExprGrp = pubVocabularyPar(wordIndexGrp)._PorParticle
                    ElseIf (fromLanguage = LangName.Dansk) Then
                        wordExprGrp = pubVocabularyPar(wordIndexGrp)._DanParticle
                    ElseIf (fromLanguage = LangName.Svenska) Then
                        wordExprGrp = pubVocabularyPar(wordIndexGrp)._SweParticle
                    ElseIf (fromLanguage = LangName.Ellenika) Then
                        wordExprGrp = pubVocabularyPar(wordIndexGrp)._GreParticle
                    ElseIf (fromLanguage = LangName.Russkij) Then
                        wordExprGrp = pubVocabularyPar(wordIndexGrp)._RusParticle
                    ElseIf (fromLanguage = LangName.Polski) Then
                        wordExprGrp = pubVocabularyPar(wordIndexGrp)._PolParticle
                    ElseIf (fromLanguage = LangName.Hrvatski) Then
                        wordExprGrp = pubVocabularyPar(wordIndexGrp)._CroParticle
                    ElseIf (fromLanguage = LangName.AnyLang) Then
                        wordExprGrp = pubVocabularyPar(wordIndexGrp)._AnyParticle
                    End If

                ElseIf (wordTypeGrp = "Jun") Then
                    If (fromLanguage = LangName.Esperanto) Then
                        wordExprGrp = pubVocabularyJun(wordIndexGrp)._EspJunction
                    ElseIf (fromLanguage = LangName.Deutsch) Then
                        wordExprGrp = pubVocabularyJun(wordIndexGrp)._GerJunction
                    ElseIf (fromLanguage = LangName.English) Then
                        wordExprGrp = pubVocabularyJun(wordIndexGrp)._EngJunction
                    ElseIf (fromLanguage = LangName.Francais) Then
                        wordExprGrp = pubVocabularyJun(wordIndexGrp)._FraJunction
                    ElseIf (fromLanguage = LangName.Espanol) Then
                        wordExprGrp = pubVocabularyJun(wordIndexGrp)._SpaJunction
                    ElseIf (fromLanguage = LangName.Italiano) Then
                        wordExprGrp = pubVocabularyJun(wordIndexGrp)._ItaJunction
                    ElseIf (fromLanguage = LangName.Portoguese) Then
                        wordExprGrp = pubVocabularyJun(wordIndexGrp)._PorJunction
                    ElseIf (fromLanguage = LangName.Dansk) Then
                        wordExprGrp = pubVocabularyJun(wordIndexGrp)._DanJunction
                    ElseIf (fromLanguage = LangName.Svenska) Then
                        wordExprGrp = pubVocabularyJun(wordIndexGrp)._SweJunction
                    ElseIf (fromLanguage = LangName.Ellenika) Then
                        wordExprGrp = pubVocabularyJun(wordIndexGrp)._GreJunction
                    ElseIf (fromLanguage = LangName.Russkij) Then
                        wordExprGrp = pubVocabularyJun(wordIndexGrp)._RusJunction
                    ElseIf (fromLanguage = LangName.Polski) Then
                        wordExprGrp = pubVocabularyJun(wordIndexGrp)._PolJunction
                    ElseIf (fromLanguage = LangName.Hrvatski) Then
                        wordExprGrp = pubVocabularyJun(wordIndexGrp)._CroJunction
                    ElseIf (fromLanguage = LangName.AnyLang) Then
                        wordExprGrp = pubVocabularyJun(wordIndexGrp)._AnyJunction
                    End If

                Else
                    wordExprGrp = "---"

                End If

                If (pubVocabularyGrp(indGrp)._GrpNumber.StartsWith("H") Or pubVocabularyGrp(indGrp)._GrpNumber.StartsWith("EH")) Then
                    RichTextBoxTranslation.Text = RichTextBoxTranslation.Text & vbCrLf & "--- " & wordExprGrp & " (" & wordHierarchyGrp & ")"
                Else
                    RichTextBoxTranslation.Text = RichTextBoxTranslation.Text & vbCrLf & "--- " & wordExprGrp
                End If

            Next    ' j

        Next    ' k

    End Sub

    Private Sub ButtonOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonOK.Click
        ' Close Window
        Close()

    End Sub

    Private Sub ComboBoxFrom_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboBoxFrom.SelectedIndexChanged
        ' Clear Input
        TextBoxWord.Text = ""
        ' Clear Output
        RichTextBoxTranslation.Text = ""

    End Sub

    Private Sub ComboBoxTo_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboBoxTo.SelectedIndexChanged
        ' Clear Output
        RichTextBoxTranslation.Text = ""

    End Sub

    Private Sub TextBoxWord_TextChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles TextBoxWord.TextChanged
        ' Clear Output
        RichTextBoxTranslation.Text = ""

    End Sub

    Private Sub TextBoxWord_KeyUp(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyEventArgs) Handles TextBoxWord.KeyUp
        ' Set Focus
        If (e.KeyValue = Keys.Return) Then
            ButtonSearch.Focus()
        End If

    End Sub

    Private Sub RadioButtonStrict_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButtonStrict.CheckedChanged
        ' Clear Output
        RichTextBoxTranslation.Text = ""
    End Sub

    Private Sub RadioButtonStart_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButtonStart.CheckedChanged
        ' Clear Output
        RichTextBoxTranslation.Text = ""
    End Sub

    ' Vocabulary List (2nd Function)

    Private Sub RadioButtonNiveau_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButtonNiveau.CheckedChanged
        ' Choice: Niveau
        frmDictionary.ComboBoxSortChoice.Items.Clear()
        frmDictionary.ComboBoxSortChoice.Items.Add("A1")
        frmDictionary.ComboBoxSortChoice.Items.Add("A2")
        frmDictionary.ComboBoxSortChoice.Items.Add("B1")
        frmDictionary.ComboBoxSortChoice.Items.Add("B2")
        frmDictionary.ComboBoxSortChoice.Items.Add("C1")
        frmDictionary.ComboBoxSortChoice.Items.Add("C2")
        frmDictionary.ComboBoxSortChoice.Items.Add("EA - Astronomy")
        frmDictionary.ComboBoxSortChoice.Items.Add("EB - Biology")
        frmDictionary.ComboBoxSortChoice.Items.Add("EC - Chemestry")
        frmDictionary.ComboBoxSortChoice.Items.Add("ED - Medicine")
        frmDictionary.ComboBoxSortChoice.Items.Add("EE - Economy")
        frmDictionary.ComboBoxSortChoice.Items.Add("EG - Geosciences")
        frmDictionary.ComboBoxSortChoice.Items.Add("EH - History")
        frmDictionary.ComboBoxSortChoice.Items.Add("EI - Informatics")
        frmDictionary.ComboBoxSortChoice.Items.Add("EJ - Jurisprudence")
        frmDictionary.ComboBoxSortChoice.Items.Add("EK - Art/Culture")
        frmDictionary.ComboBoxSortChoice.Items.Add("EL - Linguistics")
        frmDictionary.ComboBoxSortChoice.Items.Add("EM - Mathematics")
        frmDictionary.ComboBoxSortChoice.Items.Add("EP - Physics")
        frmDictionary.ComboBoxSortChoice.Items.Add("ER - Religion")
        frmDictionary.ComboBoxSortChoice.Items.Add("ES - Social Sciences")
        frmDictionary.ComboBoxSortChoice.Items.Add("ET - Technology")
        frmDictionary.ComboBoxSortChoice.Items.Add("EU - Music")
        frmDictionary.ComboBoxSortChoice.Items.Add("EW - Philosophy")
        frmDictionary.ComboBoxSortChoice.Items.Add("EY - Psychology")
        frmDictionary.ComboBoxSortChoice.Items.Add("EZ - Sports")
        frmDictionary.ComboBoxSortChoice.Text = "Please Select!"

    End Sub

    Private Sub RadioButtonTheme_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButtonTheme.CheckedChanged
        ' Choice: Theme
        Dim i As Integer

        frmDictionary.ComboBoxSortChoice.Items.Clear()
        For i = 1 To pubVocThemes(0)
            frmDictionary.ComboBoxSortChoice.Items.Add(pubVocThemes(i))
        Next
        frmDictionary.ComboBoxSortChoice.Text = "Please Select!"

    End Sub

    Private Sub ButtonList_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonList.Click
        ' Generate Vocabulary List
        ' HTML File / Unicode File
        Dim Datum As Date
        Dim Zeit As Date
        Dim tmpWordListEle As New WordListElement
        Dim wordListVoc As New List(Of WordListElement)
        Dim vocListFile As String
        Dim languages(2) As String
        Dim fromLanguage As Integer
        Dim toLanguage As Integer
        Dim selIndex As String
        Dim selString As String
        Dim nivString As String
        Dim thmString As String
        Dim fromString As String
        Dim toString As String
        Dim conString As String
        Dim synString As String
        Dim tmpString As String
        Dim strDatum As String
        Dim strZeit As String
        Dim wordlstcount As Integer
        Dim i As Integer

        ' Output Format - File Name
        vocListFile = "VocabularyList"
        If (RadioButtonHtml.Checked = True) Then
            vocListFile = "VocabularyList.htm"
        ElseIf (RadioButtonUnicode.Checked = True) Then
            vocListFile = "VocabularyList.txt"
        End If

        ' Indices
        fromLanguage = frmDictionary.ComboBoxFrom2.SelectedIndex
        toLanguage = frmDictionary.ComboBoxTo2.SelectedIndex
        selIndex = frmDictionary.ComboBoxSortChoice.SelectedIndex

        ' check
        If (toLanguage = -1) Then
            MsgBox("Please select to which Language!", MsgBoxStyle.Information, "Missing Choice")
            Exit Sub
        End If
        If (selIndex = -1) Then
            MsgBox("Please select which Selection!", MsgBoxStyle.Information, "Missing Choice")
            Exit Sub
        End If

        ' Selection String
        languages(1) = fromLanguage
        languages(2) = toLanguage
        selString = ""
        If (frmDictionary.RadioButtonNiveau.Checked = True) Then
            selString = frmDictionary.ComboBoxSortChoice.Items(selIndex).ToString.Substring(0, 2)
        ElseIf (frmDictionary.RadioButtonTheme.Checked = True) Then
            selString = selIndex.ToString + 1
        End If

        ' Make Selection

        ' Pronomen
        For i = 1 To countVocPronomen
            nivString = pubVocabularyPro(i)._NivPronomen
            thmString = Val(pubVocabularyPro(i)._ThmPronomen).ToString

            If ((frmDictionary.RadioButtonNiveau.Checked = True And nivString = selString) Or _
                (frmDictionary.RadioButtonTheme.Checked = True And thmString = selString)) Then
                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyPro(i)._EspPronomen
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyPro(i)._GerPronomen
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyPro(i)._EngPronomen
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyPro(i)._FraPronomen
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyPro(i)._SpaPronomen
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyPro(i)._ItaPronomen
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyPro(i)._DanPronomen
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyPro(i)._SwePronomen
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyPro(i)._PorPronomen
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyPro(i)._GrePronomen
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyPro(i)._RusPronomen
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyPro(i)._PolPronomen
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyPro(i)._CroPronomen
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyPro(i)._AnyPronomen
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyPro(i)._KonPronomen
                synString = pubVocabularyPro(i)._SynPronomen
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    tmpWordListEle._wordListFrom = fromString
                    tmpWordListEle._wordListTo = toString
                    tmpWordListEle._wordListCon = conString
                    tmpWordListEle._wordListSyn = synString
                    tmpWordListEle._wordListType = "Pro|Pronoun"
                    tmpWordListEle._wordListIndex = i.ToString
                    If (frmDictionary.RadioButtonNiveau.Checked = True) Then
                        tmpWordListEle._wordListSort = pubVocThemes(Val(thmString))
                    ElseIf (frmDictionary.RadioButtonTheme.Checked = True) Then
                        tmpWordListEle._wordListSort = nivString
                    End If
                    ' Hinzufuegen
                    wordListVoc.Add(tmpWordListEle)
                    ' neu Initialisieren
                    tmpWordListEle = Nothing
                    tmpWordListEle = New WordListElement
                End If
            End If

        Next

        ' Nomen
        For i = 1 To countVocNomen
            nivString = pubVocabularyNom(i)._NivNomen
            thmString = Val(pubVocabularyNom(i)._ThmNomen).ToString

            If ((frmDictionary.RadioButtonNiveau.Checked = True And nivString = selString) Or _
                (frmDictionary.RadioButtonTheme.Checked = True And thmString = selString)) Then
                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyNom(i)._EspNomen
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyNom(i)._GerNomen
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyNom(i)._EngNomen
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyNom(i)._FraNomen
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyNom(i)._SpaNomen
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyNom(i)._ItaNomen
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyNom(i)._DanNomen
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyNom(i)._SweNomen
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyNom(i)._PorNomen
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyNom(i)._GreNomen
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyNom(i)._RusNomen
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyNom(i)._PolNomen
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyNom(i)._CroNomen
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyNom(i)._AnyNomen
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyNom(i)._KonNomen
                synString = pubVocabularyNom(i)._SynNomen
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    tmpWordListEle._wordListFrom = fromString
                    tmpWordListEle._wordListTo = toString
                    tmpWordListEle._wordListCon = conString
                    tmpWordListEle._wordListSyn = synString
                    tmpWordListEle._wordListType = "Nom|Noun"
                    tmpWordListEle._wordListIndex = i.ToString
                    If (frmDictionary.RadioButtonNiveau.Checked = True) Then
                        tmpWordListEle._wordListSort = pubVocThemes(Val(thmString))
                    ElseIf (frmDictionary.RadioButtonTheme.Checked = True) Then
                        tmpWordListEle._wordListSort = nivString
                    End If
                    ' Hinzufuegen
                    wordListVoc.Add(tmpWordListEle)
                    ' neu Initialisieren
                    tmpWordListEle = Nothing
                    tmpWordListEle = New WordListElement
                End If
            End If

        Next

        ' Verben
        For i = 1 To countVocVerb
            nivString = pubVocabularyVer(i)._NivVerb
            thmString = Val(pubVocabularyVer(i)._ThmVerb).ToString

            If ((frmDictionary.RadioButtonNiveau.Checked = True And nivString = selString) Or _
                (frmDictionary.RadioButtonTheme.Checked = True And thmString = selString)) Then
                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyVer(i)._EspVerb
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyVer(i)._GerVerb
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyVer(i)._EngVerb
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyVer(i)._FraVerb
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyVer(i)._SpaVerb
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyVer(i)._ItaVerb
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyVer(i)._DanVerb
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyVer(i)._SweVerb
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyVer(i)._PorVerb
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyVer(i)._GreVerb
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyVer(i)._RusVerb
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyVer(i)._PolVerb
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyVer(i)._CroVerb
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyVer(i)._AnyVerb
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyVer(i)._KonVerb
                synString = pubVocabularyVer(i)._SynVerb
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    tmpWordListEle._wordListFrom = fromString
                    tmpWordListEle._wordListTo = toString
                    tmpWordListEle._wordListCon = conString
                    tmpWordListEle._wordListSyn = synString
                    tmpWordListEle._wordListType = "Ver|Verb"
                    tmpWordListEle._wordListIndex = i.ToString
                    If (frmDictionary.RadioButtonNiveau.Checked = True) Then
                        tmpWordListEle._wordListSort = pubVocThemes(Val(thmString))
                    ElseIf (frmDictionary.RadioButtonTheme.Checked = True) Then
                        tmpWordListEle._wordListSort = nivString
                    End If
                    ' Hinzufuegen
                    wordListVoc.Add(tmpWordListEle)
                    ' neu Initialisieren
                    tmpWordListEle = Nothing
                    tmpWordListEle = New WordListElement
                End If
            End If

        Next

        ' Adverben
        For i = 1 To countVocAdverb
            nivString = pubVocabularyAdv(i)._NivAdverb
            thmString = Val(pubVocabularyAdv(i)._ThmAdverb).ToString

            If ((frmDictionary.RadioButtonNiveau.Checked = True And nivString = selString) Or _
                (frmDictionary.RadioButtonTheme.Checked = True And thmString = selString)) Then
                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyAdv(i)._EspAdverb
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyAdv(i)._GerAdverb
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyAdv(i)._EngAdverb
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyAdv(i)._FraAdverb
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyAdv(i)._SpaAdverb
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyAdv(i)._ItaAdverb
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyAdv(i)._DanAdverb
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyAdv(i)._SweAdverb
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyAdv(i)._PorAdverb
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyAdv(i)._GreAdverb
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyAdv(i)._RusAdverb
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyAdv(i)._PolAdverb
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyAdv(i)._CroAdverb
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyAdv(i)._AnyAdverb
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyAdv(i)._KonAdverb
                synString = pubVocabularyAdv(i)._SynAdverb
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    tmpWordListEle._wordListFrom = fromString
                    tmpWordListEle._wordListTo = toString
                    tmpWordListEle._wordListCon = conString
                    tmpWordListEle._wordListSyn = synString
                    tmpWordListEle._wordListType = "Adv|Adverb"
                    tmpWordListEle._wordListIndex = i.ToString
                    If (frmDictionary.RadioButtonNiveau.Checked = True) Then
                        tmpWordListEle._wordListSort = pubVocThemes(Val(thmString))
                    ElseIf (frmDictionary.RadioButtonTheme.Checked = True) Then
                        tmpWordListEle._wordListSort = nivString
                    End If
                    ' Hinzufuegen
                    wordListVoc.Add(tmpWordListEle)
                    ' neu Initialisieren
                    tmpWordListEle = Nothing
                    tmpWordListEle = New WordListElement
                End If
            End If

        Next

        ' Adjektive
        For i = 1 To countVocAdjective
            nivString = pubVocabularyAdj(i)._NivAdjective
            thmString = Val(pubVocabularyAdj(i)._ThmAdjective).ToString

            If ((frmDictionary.RadioButtonNiveau.Checked = True And nivString = selString) Or _
                (frmDictionary.RadioButtonTheme.Checked = True And thmString = selString)) Then
                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyAdj(i)._EspAdjective
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyAdj(i)._GerAdjective
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyAdj(i)._EngAdjective
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyAdj(i)._FraAdjective
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyAdj(i)._SpaAdjective
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyAdj(i)._ItaAdjective
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyAdj(i)._DanAdjective
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyAdj(i)._SweAdjective
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyAdj(i)._PorAdjective
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyAdj(i)._GreAdjective
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyAdj(i)._RusAdjective
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyAdj(i)._PolAdjective
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyAdj(i)._CroAdjective
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyAdj(i)._AnyAdjective
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyAdj(i)._KonAdjective
                synString = pubVocabularyAdj(i)._SynAdjective
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    tmpWordListEle._wordListFrom = fromString
                    tmpWordListEle._wordListTo = toString
                    tmpWordListEle._wordListCon = conString
                    tmpWordListEle._wordListSyn = synString
                    tmpWordListEle._wordListType = "Adj|Adjective"
                    tmpWordListEle._wordListIndex = i.ToString
                    If (frmDictionary.RadioButtonNiveau.Checked = True) Then
                        tmpWordListEle._wordListSort = pubVocThemes(Val(thmString))
                    ElseIf (frmDictionary.RadioButtonTheme.Checked = True) Then
                        tmpWordListEle._wordListSort = nivString
                    End If
                    ' Hinzufuegen
                    wordListVoc.Add(tmpWordListEle)
                    ' neu Initialisieren
                    tmpWordListEle = Nothing
                    tmpWordListEle = New WordListElement
                End If
            End If

        Next

        ' Preapositionen
        For i = 1 To countVocPreposition
            nivString = pubVocabularyPre(i)._NivPreposition
            thmString = Val(pubVocabularyPre(i)._ThmPreposition).ToString

            If ((frmDictionary.RadioButtonNiveau.Checked = True And nivString = selString) Or _
                (frmDictionary.RadioButtonTheme.Checked = True And thmString = selString)) Then
                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyPre(i)._EspPreposition
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyPre(i)._GerPreposition
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyPre(i)._EngPreposition
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyPre(i)._FraPreposition
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyPre(i)._SpaPreposition
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyPre(i)._ItaPreposition
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyPre(i)._DanPreposition
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyPre(i)._SwePreposition
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyPre(i)._PorPreposition
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyPre(i)._GrePreposition
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyPre(i)._RusPreposition
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyPre(i)._PolPreposition
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyPre(i)._CroPreposition
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyPre(i)._AnyPreposition
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyPre(i)._KonPreposition
                synString = pubVocabularyPre(i)._SynPreposition
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    tmpWordListEle._wordListFrom = fromString
                    tmpWordListEle._wordListTo = toString
                    tmpWordListEle._wordListCon = conString
                    tmpWordListEle._wordListSyn = synString
                    tmpWordListEle._wordListType = "Pre|Preposition"
                    tmpWordListEle._wordListIndex = i.ToString
                    If (frmDictionary.RadioButtonNiveau.Checked = True) Then
                        tmpWordListEle._wordListSort = pubVocThemes(Val(thmString))
                    ElseIf (frmDictionary.RadioButtonTheme.Checked = True) Then
                        tmpWordListEle._wordListSort = nivString
                    End If
                    ' Hinzufuegen
                    wordListVoc.Add(tmpWordListEle)
                    ' neu Initialisieren
                    tmpWordListEle = Nothing
                    tmpWordListEle = New WordListElement
                End If
            End If

        Next

        ' Partikel
        For i = 1 To countVocParticle
            nivString = pubVocabularyPar(i)._NivParticle
            thmString = Val(pubVocabularyPar(i)._ThmParticle).ToString

            If ((frmDictionary.RadioButtonNiveau.Checked = True And nivString = selString) Or _
                (frmDictionary.RadioButtonTheme.Checked = True And thmString = selString)) Then
                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyPar(i)._EspParticle
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyPar(i)._GerParticle
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyPar(i)._EngParticle
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyPar(i)._FraParticle
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyPar(i)._SpaParticle
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyPar(i)._ItaParticle
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyPar(i)._DanParticle
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyPar(i)._SweParticle
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyPar(i)._PorParticle
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyPar(i)._GreParticle
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyPar(i)._RusParticle
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyPar(i)._PolParticle
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyPar(i)._CroParticle
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyPar(i)._AnyParticle
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyPar(i)._KonParticle
                synString = pubVocabularyPar(i)._SynParticle
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    tmpWordListEle._wordListFrom = fromString
                    tmpWordListEle._wordListTo = toString
                    tmpWordListEle._wordListCon = conString
                    tmpWordListEle._wordListSyn = synString
                    tmpWordListEle._wordListType = "Par|Particle"
                    tmpWordListEle._wordListIndex = i.ToString
                    If (frmDictionary.RadioButtonNiveau.Checked = True) Then
                        tmpWordListEle._wordListSort = pubVocThemes(Val(thmString))
                    ElseIf (frmDictionary.RadioButtonTheme.Checked = True) Then
                        tmpWordListEle._wordListSort = nivString
                    End If
                    ' Hinzufuegen
                    wordListVoc.Add(tmpWordListEle)
                    ' neu Initialisieren
                    tmpWordListEle = Nothing
                    tmpWordListEle = New WordListElement
                End If
            End If

        Next

        ' Konjunktionen
        For i = 1 To countVocJunction
            nivString = pubVocabularyJun(i)._NivJunction
            thmString = Val(pubVocabularyJun(i)._ThmJunction).ToString

            If ((frmDictionary.RadioButtonNiveau.Checked = True And nivString = selString) Or _
                (frmDictionary.RadioButtonTheme.Checked = True And thmString = selString)) Then
                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyJun(i)._EspJunction
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyJun(i)._GerJunction
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyJun(i)._EngJunction
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyJun(i)._FraJunction
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyJun(i)._SpaJunction
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyJun(i)._ItaJunction
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyJun(i)._DanJunction
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyJun(i)._SweJunction
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyJun(i)._PorJunction
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyJun(i)._GreJunction
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyJun(i)._RusJunction
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyJun(i)._PolJunction
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyJun(i)._CroJunction
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyJun(i)._AnyJunction
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyJun(i)._KonJunction
                synString = pubVocabularyJun(i)._SynJunction
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    tmpWordListEle._wordListFrom = fromString
                    tmpWordListEle._wordListTo = toString
                    tmpWordListEle._wordListCon = conString
                    tmpWordListEle._wordListSyn = synString
                    tmpWordListEle._wordListType = "Jun|Junction"
                    tmpWordListEle._wordListIndex = i.ToString
                    If (frmDictionary.RadioButtonNiveau.Checked = True) Then
                        tmpWordListEle._wordListSort = pubVocThemes(Val(thmString))
                    ElseIf (frmDictionary.RadioButtonTheme.Checked = True) Then
                        tmpWordListEle._wordListSort = nivString
                    End If
                    ' Hinzufuegen
                    wordListVoc.Add(tmpWordListEle)
                    ' neu Initialisieren
                    tmpWordListEle = Nothing
                    tmpWordListEle = New WordListElement
                End If
            End If

        Next

        ' Expressions / Idioms
        For i = 1 To countVocExpression
            nivString = pubVocabularyExp(i)._NivExpression
            thmString = Val(pubVocabularyExp(i)._ThmExpression).ToString

            If ((frmDictionary.RadioButtonNiveau.Checked = True And nivString = selString) Or _
                (frmDictionary.RadioButtonTheme.Checked = True And thmString = selString)) Then
                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyExp(i)._EspExpression
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyExp(i)._GerExpression
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyExp(i)._EngExpression
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyExp(i)._FraExpression
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyExp(i)._SpaExpression
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyExp(i)._ItaExpression
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyExp(i)._DanExpression
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyExp(i)._SweExpression
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyExp(i)._PorExpression
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyExp(i)._GreExpression
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyExp(i)._RusExpression
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyExp(i)._PolExpression
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyExp(i)._CroExpression
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyExp(i)._AnyExpression
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyExp(i)._KonExpression
                synString = pubVocabularyExp(i)._SynExpression
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    tmpWordListEle._wordListFrom = fromString
                    tmpWordListEle._wordListTo = toString
                    tmpWordListEle._wordListCon = conString
                    tmpWordListEle._wordListSyn = synString
                    tmpWordListEle._wordListType = "Exp|Expression"
                    tmpWordListEle._wordListIndex = i.ToString
                    If (frmDictionary.RadioButtonNiveau.Checked = True) Then
                        tmpWordListEle._wordListSort = pubVocThemes(Val(thmString))
                    ElseIf (frmDictionary.RadioButtonTheme.Checked = True) Then
                        tmpWordListEle._wordListSort = nivString
                    End If
                    ' Hinzufuegen
                    wordListVoc.Add(tmpWordListEle)
                    ' neu Initialisieren
                    tmpWordListEle = Nothing
                    tmpWordListEle = New WordListElement
                End If
            End If

        Next


        ' Sorting by Theme / Niveau
        wordListVoc.Sort()


        ' aktuelles Datum
        Datum = System.DateTime.Today.Date
        strDatum = Datum.Day & "." & Datum.Month & "." & Datum.Year

        ' aktuelle Uhrzeit
        Zeit = Now()
        strZeit = Format(Zeit.Hour, "00") & ":" & Format(Zeit.Minute, "00") & ":" & Format(Zeit.Second, "00")

        ' Open File
        Using sw As System.IO.StreamWriter = New System.IO.StreamWriter(vocListFile, False, System.Text.Encoding.Unicode)

            If (RadioButtonHtml.Checked = True) Then

                ' Generate Vocabular List as HTML Tab
                sw.WriteLine("<!-- created by Decaleon at " & strDatum & " at " & strZeit & " -->")
                sw.WriteLine("<html>")
                sw.WriteLine("<head>")
                sw.WriteLine("<title>Vocabulary List " & pubLanguage(fromLanguage) & "-" & pubLanguage(toLanguage) & "</title>")
                sw.WriteLine("</head>")
                sw.WriteLine("<body>")
                If (frmDictionary.RadioButtonNiveau.Checked = True) Then
                    sw.WriteLine("<H1>Selection: Niveau " & selString & "</H1>")
                ElseIf (frmDictionary.RadioButtonTheme.Checked = True) Then
                    sw.WriteLine("<H1>Selection: Theme " & pubVocThemes(Val(selString)) & "</H1>")
                End If
                ' Start Table
                sw.WriteLine("<table border='1'>")
                sw.WriteLine("<th>No.</th><th>Sort</th><th>" & pubLanguage(fromLanguage) & "</th><th>" & pubLanguage(toLanguage) & "</th><th>Context/Synonym</th><th>Word Type</th>")
                sw.WriteLine("<tr>")
                sw.WriteLine("<th></th><th></th><th></th><th></th><th></th><th></th>")
                sw.WriteLine("</tr>")
                ' Words
                For i = 1 To wordlstcount
                    sw.WriteLine("<tr>")
                    sw.WriteLine("<th>" & i.ToString & _
                        "</th><th>" & wordListVoc.Item(i - 1)._wordListSort & _
                        "</th><th>" & wordListVoc.Item(i - 1)._wordListFrom & _
                        "</th><th>" & wordListVoc.Item(i - 1)._wordListTo & _
                        "</th><th>" & wordListVoc.Item(i - 1)._wordListCon & " / " & wordListVoc.Item(i - 1)._wordListSyn & _
                        "</th><th>" & wordListVoc.Item(i - 1)._wordListType.Substring(4) & _
                        "</th>")
                    sw.WriteLine("</tr>")
                Next
                ' End Table
                sw.WriteLine("</table>")
                sw.WriteLine("<P>")
                sw.WriteLine("</P>")
                sw.WriteLine("<BR>")
                sw.WriteLine("<BR>")
                sw.WriteLine("</body>")
                sw.WriteLine("</html>")

            ElseIf (RadioButtonUnicode.Checked = True) Then

                ' Generate Vocabular List as Unicode List
                Dim outName As String
                Dim cc As Long

                outName = "..."
                If (frmDictionary.RadioButtonNiveau.Checked = True) Then
                    outName = selString
                ElseIf (frmDictionary.RadioButtonTheme.Checked = True) Then
                    outName = pubVocThemes(CInt(selString))
                End If

                ' Words
                sw.WriteLine("#DecaleonExportFile#")
                'sw.WriteLine("#DecaleonImportFile#")
                sw.WriteLine(pubLanguage(languages(1)) & "/" & pubLanguage(languages(2)))
                sw.WriteLine("Export of " & outName & ", " & Date.Today.ToShortDateString)
                For i = 1 To wordlstcount
                    ' Context/Synonym Information
                    conString = wordListVoc.Item(i - 1)._wordListCon
                    synString = wordListVoc.Item(i - 1)._wordListSyn
                    tmpString = ""
                    If (conString <> "" And synString <> "") Then
                        tmpString = " (" & conString & "/" & synString & ")"
                    ElseIf (conString <> "") Then
                        tmpString = " (" & conString & ")"
                    ElseIf (synString <> "") Then
                        tmpString = " (" & synString & ")"
                    Else
                        tmpString = ""
                    End If
                    ' Line for general File
                    sw.WriteLine(i.ToString & vbTab & _
                        wordListVoc.Item(i - 1)._wordListFrom & vbTab & _
                        wordListVoc.Item(i - 1)._wordListTo & tmpString)
                    ' Line for Import File
                    'cc = 1588
                    'sw.WriteLine(String.Format(i + cc, "00000") & vbTab & _
                    '    wordListVoc.Item(i - 1)._wordListType.Substring(0, 3) & vbTab & _
                    '    String.Format(wordListVoc.Item(i - 1)._wordListIndex, "00000") & vbTab & _
                    '    "[" & wordListVoc.Item(i - 1)._wordListFrom.Replace(" ", "_") & tmpString.Replace(" ", "_") & "]" & vbTab & _
                    '    "***")
                Next

            End If

            ' Close File
            sw.Close()

        End Using

        ' Message
        MsgBox("List " & vocListFile & " generated and saved into /bin/Debug Directory!" & vbCrLf & _
               wordlstcount.ToString & " Entries", MsgBoxStyle.Information, "finished")

    End Sub

    Private Sub ComboBoxSortChoice_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboBoxSortChoice.SelectedIndexChanged
        ' Set Focus
        ButtonList.Focus()

    End Sub

    ' Word Dictionary (3rd Function)

    Private Sub ButtonDict_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonDict.Click
        ' Generate Dictionary or Thematic Book
        ' LaTeX: TeXnicCenter (MiKTeX needs Ultimate Codec Package and Cyrillic/Greek Packages; eliminate first three Signs of TEX File)
        ' PDF  : iTextSharp (DLLs ....dll / ....dll)
        Dim Datum As Date
        Dim Zeit As Date
        Dim tmpWordListEle As New WordListElement
        Dim wordListVoc As New List(Of WordListElement)
        Dim vocDictFile As String
        Dim sortType As String
        Dim bookActive As String
        Dim languages(2) As String
        Dim fromLanguage As Integer
        Dim toLanguage As Integer
        Dim fromString As String
        Dim toString As String
        Dim conString As String
        Dim synString As String
        Dim tmpString As String
        Dim lastLetter As String
        Dim lastWord As String
        Dim lastType As String
        Dim themeID As String
        Dim groupID As String
        Dim strDatum As String
        Dim strZeit As String
        Dim newPage As Boolean
        Dim wordlstcount As Integer
        Dim entrycount As Integer
        Dim fieldcount As Integer
        Dim i As Integer

        ' Output Format - File Name
        vocDictFile = "VocabularyDict"
        If (RadioButtonLatex.Checked = True) Then
            vocDictFile = "VocabularyDict.tex"
        ElseIf (RadioButtonPDF.Checked = True) Then
            vocDictFile = "VocabularyDict.pdf"
        End If

        ' Output Type - Lexical or Thematic
        sortType = "Lexical"
        If (RadioButtonDict.Checked = True) Then
            sortType = "Lexical"
        ElseIf (RadioButtonLexikon.Checked = True) Then
            sortType = "Thematic"
        End If

        ' Buch (extra)
        bookActive = False
        bookActive = ComboBoxBook.SelectedIndex > -1

        ' Indices
        fromLanguage = frmDictionary.ComboBoxFrom3.SelectedIndex
        toLanguage = frmDictionary.ComboBoxTo3.SelectedIndex

        ' check
        If (toLanguage = -1) Then
            MsgBox("Please select to which Language!", MsgBoxStyle.Information, "Missing Choice")
            Exit Sub
        End If

        ' Languages
        languages(1) = fromLanguage
        languages(2) = toLanguage

        If (bookActive = False) Then

            ' Get Entries

            ' Pronomen
            For i = 1 To countVocPronomen

                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyPro(i)._EspPronomen
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyPro(i)._GerPronomen
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyPro(i)._EngPronomen
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyPro(i)._FraPronomen
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyPro(i)._SpaPronomen
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyPro(i)._ItaPronomen
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyPro(i)._DanPronomen
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyPro(i)._SwePronomen
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyPro(i)._PorPronomen
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyPro(i)._GrePronomen
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyPro(i)._RusPronomen
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyPro(i)._PolPronomen
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyPro(i)._CroPronomen
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyPro(i)._AnyPronomen
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyPro(i)._KonPronomen
                synString = pubVocabularyPro(i)._SynPronomen
                themeID = pubVocabularyPro(i)._ThmPronomen
                groupID = pubVocabularyPro(i)._GrpPronomen
                If (themeID = "??") Then themeID = "25"
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    tmpWordListEle._wordListFrom = fromString
                    tmpWordListEle._wordListTo = toString
                    tmpWordListEle._wordListCon = conString
                    tmpWordListEle._wordListSyn = synString
                    tmpWordListEle._wordListType = "Pronoun"
                    If (sortType = "Lexical") Then
                        tmpWordListEle._wordListSort = fromString
                    ElseIf (sortType = "Thematic") Then
                        tmpWordListEle._wordListSort = checkGroupInfo(groupID)
                    End If
                    ' Hinzufuegen
                    wordListVoc.Add(tmpWordListEle)
                    ' neu Initialisieren
                    tmpWordListEle = Nothing
                    tmpWordListEle = New WordListElement
                End If

            Next

            ' Nomen
            For i = 1 To countVocNomen

                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyNom(i)._EspNomen
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyNom(i)._GerNomen
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyNom(i)._EngNomen
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyNom(i)._FraNomen
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyNom(i)._SpaNomen
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyNom(i)._ItaNomen
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyNom(i)._DanNomen
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyNom(i)._SweNomen
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyNom(i)._PorNomen
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyNom(i)._GreNomen
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyNom(i)._RusNomen
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyNom(i)._PolNomen
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyNom(i)._CroNomen
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyNom(i)._AnyNomen
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyNom(i)._KonNomen
                synString = pubVocabularyNom(i)._SynNomen
                themeID = pubVocabularyNom(i)._ThmNomen
                groupID = pubVocabularyNom(i)._GrpNomen
                If (themeID = "??") Then themeID = "25"
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    tmpWordListEle._wordListFrom = fromString
                    tmpWordListEle._wordListTo = toString
                    tmpWordListEle._wordListCon = conString
                    tmpWordListEle._wordListSyn = synString
                    tmpWordListEle._wordListType = "Noun"
                    If (sortType = "Lexical") Then
                        tmpWordListEle._wordListSort = fromString
                    ElseIf (sortType = "Thematic") Then
                        tmpWordListEle._wordListSort = checkGroupInfo(groupID)
                    End If
                    ' Hinzufuegen
                    wordListVoc.Add(tmpWordListEle)
                    ' neu Initialisieren
                    tmpWordListEle = Nothing
                    tmpWordListEle = New WordListElement
                End If

            Next

            ' Verben
            For i = 1 To countVocVerb

                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyVer(i)._EspVerb
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyVer(i)._GerVerb
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyVer(i)._EngVerb
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyVer(i)._FraVerb
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyVer(i)._SpaVerb
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyVer(i)._ItaVerb
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyVer(i)._DanVerb
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyVer(i)._SweVerb
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyVer(i)._PorVerb
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyVer(i)._GreVerb
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyVer(i)._RusVerb
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyVer(i)._PolVerb
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyVer(i)._CroVerb
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyVer(i)._AnyVerb
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyVer(i)._KonVerb
                synString = pubVocabularyVer(i)._SynVerb
                themeID = pubVocabularyVer(i)._ThmVerb
                groupID = pubVocabularyVer(i)._GrpVerb
                If (themeID = "??") Then themeID = "25"
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    tmpWordListEle._wordListFrom = fromString
                    tmpWordListEle._wordListTo = toString
                    tmpWordListEle._wordListCon = conString
                    tmpWordListEle._wordListSyn = synString
                    tmpWordListEle._wordListType = "Verb"
                    If (sortType = "Lexical") Then
                        tmpWordListEle._wordListSort = fromString
                    ElseIf (sortType = "Thematic") Then
                        tmpWordListEle._wordListSort = checkGroupInfo(groupID)
                    End If
                    ' Hinzufuegen
                    wordListVoc.Add(tmpWordListEle)
                    ' neu Initialisieren
                    tmpWordListEle = Nothing
                    tmpWordListEle = New WordListElement
                End If

            Next

            ' Adverben
            For i = 1 To countVocAdverb

                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyAdv(i)._EspAdverb
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyAdv(i)._GerAdverb
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyAdv(i)._EngAdverb
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyAdv(i)._FraAdverb
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyAdv(i)._SpaAdverb
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyAdv(i)._ItaAdverb
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyAdv(i)._DanAdverb
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyAdv(i)._SweAdverb
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyAdv(i)._PorAdverb
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyAdv(i)._GreAdverb
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyAdv(i)._RusAdverb
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyAdv(i)._PolAdverb
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyAdv(i)._CroAdverb
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyAdv(i)._AnyAdverb
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyAdv(i)._KonAdverb
                synString = pubVocabularyAdv(i)._SynAdverb
                themeID = pubVocabularyAdv(i)._ThmAdverb
                groupID = pubVocabularyAdv(i)._GrpAdverb
                If (themeID = "??") Then themeID = "25"
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    tmpWordListEle._wordListFrom = fromString
                    tmpWordListEle._wordListTo = toString
                    tmpWordListEle._wordListCon = conString
                    tmpWordListEle._wordListSyn = synString
                    tmpWordListEle._wordListType = "Adv."
                    If (sortType = "Lexical") Then
                        tmpWordListEle._wordListSort = fromString
                    ElseIf (sortType = "Thematic") Then
                        tmpWordListEle._wordListSort = checkGroupInfo(groupID)
                    End If
                    ' Hinzufuegen
                    wordListVoc.Add(tmpWordListEle)
                    ' neu Initialisieren
                    tmpWordListEle = Nothing
                    tmpWordListEle = New WordListElement
                End If

            Next

            ' Adjektive
            For i = 1 To countVocAdjective

                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyAdj(i)._EspAdjective
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyAdj(i)._GerAdjective
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyAdj(i)._EngAdjective
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyAdj(i)._FraAdjective
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyAdj(i)._SpaAdjective
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyAdj(i)._ItaAdjective
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyAdj(i)._DanAdjective
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyAdj(i)._SweAdjective
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyAdj(i)._PorAdjective
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyAdj(i)._GreAdjective
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyAdj(i)._RusAdjective
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyAdj(i)._PolAdjective
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyAdj(i)._CroAdjective
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyAdj(i)._AnyAdjective
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyAdj(i)._KonAdjective
                synString = pubVocabularyAdj(i)._SynAdjective
                themeID = pubVocabularyAdj(i)._ThmAdjective
                groupID = pubVocabularyAdj(i)._GrpAdjective
                If (themeID = "??") Then themeID = "25"
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    tmpWordListEle._wordListFrom = fromString
                    tmpWordListEle._wordListTo = toString
                    tmpWordListEle._wordListCon = conString
                    tmpWordListEle._wordListSyn = synString
                    tmpWordListEle._wordListType = "Adj."
                    If (sortType = "Lexical") Then
                        tmpWordListEle._wordListSort = fromString
                    ElseIf (sortType = "Thematic") Then
                        tmpWordListEle._wordListSort = checkGroupInfo(groupID)
                    End If
                    ' Hinzufuegen
                    wordListVoc.Add(tmpWordListEle)
                    ' neu Initialisieren
                    tmpWordListEle = Nothing
                    tmpWordListEle = New WordListElement
                End If

            Next

            ' Preapositionen
            For i = 1 To countVocPreposition

                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyPre(i)._EspPreposition
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyPre(i)._GerPreposition
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyPre(i)._EngPreposition
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyPre(i)._FraPreposition
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyPre(i)._SpaPreposition
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyPre(i)._ItaPreposition
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyPre(i)._DanPreposition
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyPre(i)._SwePreposition
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyPre(i)._PorPreposition
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyPre(i)._GrePreposition
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyPre(i)._RusPreposition
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyPre(i)._PolPreposition
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyPre(i)._CroPreposition
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyPre(i)._AnyPreposition
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyPre(i)._KonPreposition
                synString = pubVocabularyPre(i)._SynPreposition
                themeID = pubVocabularyPre(i)._ThmPreposition
                groupID = pubVocabularyPre(i)._GrpPreposition
                If (themeID = "??") Then themeID = "25"
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    tmpWordListEle._wordListFrom = fromString
                    tmpWordListEle._wordListTo = toString
                    tmpWordListEle._wordListCon = conString
                    tmpWordListEle._wordListSyn = synString
                    tmpWordListEle._wordListType = "Prep."
                    If (sortType = "Lexical") Then
                        tmpWordListEle._wordListSort = fromString
                    ElseIf (sortType = "Thematic") Then
                        tmpWordListEle._wordListSort = checkGroupInfo(groupID)
                    End If
                    ' Hinzufuegen
                    wordListVoc.Add(tmpWordListEle)
                    ' neu Initialisieren
                    tmpWordListEle = Nothing
                    tmpWordListEle = New WordListElement
                End If

            Next

            ' Partikel
            For i = 1 To countVocParticle

                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyPar(i)._EspParticle
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyPar(i)._GerParticle
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyPar(i)._EngParticle
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyPar(i)._FraParticle
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyPar(i)._SpaParticle
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyPar(i)._ItaParticle
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyPar(i)._DanParticle
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyPar(i)._SweParticle
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyPar(i)._PorParticle
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyPar(i)._GreParticle
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyPar(i)._RusParticle
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyPar(i)._PolParticle
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyPar(i)._CroParticle
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyPar(i)._AnyParticle
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyPar(i)._KonParticle
                synString = pubVocabularyPar(i)._SynParticle
                themeID = pubVocabularyPar(i)._ThmParticle
                groupID = pubVocabularyPar(i)._GrpParticle
                If (themeID = "??") Then themeID = "25"
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    tmpWordListEle._wordListFrom = fromString
                    tmpWordListEle._wordListTo = toString
                    tmpWordListEle._wordListCon = conString
                    tmpWordListEle._wordListSyn = synString
                    tmpWordListEle._wordListType = "Part."
                    If (sortType = "Lexical") Then
                        tmpWordListEle._wordListSort = fromString
                    ElseIf (sortType = "Thematic") Then
                        tmpWordListEle._wordListSort = checkGroupInfo(groupID)
                    End If
                    ' Hinzufuegen
                    wordListVoc.Add(tmpWordListEle)
                    ' neu Initialisieren
                    tmpWordListEle = Nothing
                    tmpWordListEle = New WordListElement
                End If

            Next

            ' Konjunktionen
            For i = 1 To countVocJunction

                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyJun(i)._EspJunction
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyJun(i)._GerJunction
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyJun(i)._EngJunction
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyJun(i)._FraJunction
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyJun(i)._SpaJunction
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyJun(i)._ItaJunction
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyJun(i)._DanJunction
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyJun(i)._SweJunction
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyJun(i)._PorJunction
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyJun(i)._GreJunction
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyJun(i)._RusJunction
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyJun(i)._PolJunction
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyJun(i)._CroJunction
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyJun(i)._AnyJunction
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyJun(i)._KonJunction
                synString = pubVocabularyJun(i)._SynJunction
                themeID = pubVocabularyJun(i)._ThmJunction
                groupID = pubVocabularyJun(i)._GrpJunction
                If (themeID = "??") Then themeID = "25"
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    tmpWordListEle._wordListFrom = fromString
                    tmpWordListEle._wordListTo = toString
                    tmpWordListEle._wordListCon = conString
                    tmpWordListEle._wordListSyn = synString
                    tmpWordListEle._wordListType = "Junc."
                    If (sortType = "Lexical") Then
                        tmpWordListEle._wordListSort = fromString
                    ElseIf (sortType = "Thematic") Then
                        tmpWordListEle._wordListSort = checkGroupInfo(groupID)
                    End If
                    ' Hinzufuegen
                    wordListVoc.Add(tmpWordListEle)
                    ' neu Initialisieren
                    tmpWordListEle = Nothing
                    tmpWordListEle = New WordListElement
                End If

            Next


            ' Sorting by From Language
            wordListVoc.Sort()


            ' aktuelles Datum
            Datum = System.DateTime.Today.Date
            strDatum = Datum.Day & "." & Datum.Month & "." & Datum.Year

            ' aktuelle Uhrzeit
            Zeit = Now()
            strZeit = Format(Zeit.Hour, "00") & ":" & Format(Zeit.Minute, "00") & ":" & Format(Zeit.Second, "00")

            If (RadioButtonLatex.Checked = True) Then

                ' Open File
                Using sw As System.IO.StreamWriter = New System.IO.StreamWriter(vocDictFile, False, System.Text.Encoding.UTF8)

                    ' Generate Vocabulary Dictionary as LaTeX Source File
                    sw.WriteLine("% created by Decaleon at " & strDatum & " at " & strZeit)
                    sw.WriteLine("% !TeX encoding = UTF-8")
                    sw.WriteLine("% compiling with LuaLaTeX or XeLaTeX recommended")
                    sw.WriteLine("\documentclass[10pt,a4paper]{article}")
                    sw.WriteLine("\usepackage[utf8]{inputenc}")
                    sw.WriteLine("")
                    sw.WriteLine("% Seitennumerierung")
                    sw.WriteLine("\pagestyle{plain}")
                    sw.WriteLine("")
                    sw.WriteLine("% Seitenlayout")
                    sw.WriteLine("\setlength{\oddsidemargin}{0cm}")
                    sw.WriteLine("\setlength{\textwidth}{14.5cm}")
                    sw.WriteLine("\addtolength{\topmargin}{-2cm}")
                    sw.WriteLine("\setlength{\textheight}{24cm}")
                    sw.WriteLine("\setlength{\headheight}{0.5cm}")
                    sw.WriteLine("\setlength{\headsep}{0.5cm}")
                    sw.WriteLine("\setlength{\topskip}{1cm}")
                    sw.WriteLine("\setlength{\footskip}{2cm}")
                    sw.WriteLine("%\setlength{\footheight}{1cm}")
                    sw.WriteLine("")
                    sw.WriteLine("% Absatzabstand")
                    sw.WriteLine("\setlength{\parskip}{1ex plus0.5ex minus0.2ex}")
                    sw.WriteLine("")
                    sw.WriteLine("% Absatzeinrueckung")
                    sw.WriteLine("\setlength{\parindent}{0cm}")
                    sw.WriteLine("")
                    sw.WriteLine("% Titel")
                    sw.WriteLine("\title{" & sortType & " Vocabulary Dictionary from " & pubLanguage(fromLanguage) & " to " & pubLanguage(toLanguage) & "}")
                    sw.WriteLine("\author{Decaleon V5.0}")
                    sw.WriteLine("\date{2014-2016}")
                    sw.WriteLine("")
                    sw.WriteLine("\begin{document}")
                    sw.WriteLine("")
                    sw.WriteLine("\maketitle")
                    sw.WriteLine("")
                    sw.WriteLine("% Inhaltsverzeichnis")
                    sw.WriteLine("\newpage")
                    sw.WriteLine("")
                    sw.WriteLine("\tableofcontents")
                    sw.WriteLine("")

                    ' Word Entries
                    lastLetter = ""
                    lastWord = ""
                    lastType = ""
                    entrycount = 0
                    fieldcount = 0
                    For i = 1 To wordlstcount

                        ' check Initial Letter
                        newPage = False
                        If ((sortType = "Lexical" And lastLetter <> wordListVoc.Item(i - 1)._wordListSort.Substring(0, 1).ToUpper) Or _
                            (sortType = "Thematic" And lastLetter <> wordListVoc.Item(i - 1)._wordListSort)) Then
                            ' begin new Page
                            sw.WriteLine("")
                            sw.WriteLine("\newpage")
                            sw.WriteLine("")
                            If (sortType = "Lexical") Then
                                sw.WriteLine("\section*{" & wordListVoc.Item(i - 1)._wordListSort.Substring(0, 1).ToUpper & "}")
                            ElseIf (sortType = "Thematic") Then
                                sw.WriteLine("\section*{" & getGroupName(wordListVoc.Item(i - 1)._wordListSort) & "}")
                            End If
                            sw.WriteLine("")
                            ' Flag
                            newPage = True
                            fieldcount = fieldcount + 1
                        End If

                        ' Synonym and Context Information
                        tmpString = ""
                        If (wordListVoc.Item(i - 1)._wordListCon <> "" And wordListVoc.Item(i - 1)._wordListSyn = "") Then
                            tmpString = "\textit{(" & wordListVoc.Item(i - 1)._wordListCon & ")}"
                        ElseIf (wordListVoc.Item(i - 1)._wordListCon = "" And wordListVoc.Item(i - 1)._wordListSyn <> "") Then
                            tmpString = "\textit{(" & wordListVoc.Item(i - 1)._wordListSyn & ")}"
                        ElseIf (wordListVoc.Item(i - 1)._wordListCon <> "" And wordListVoc.Item(i - 1)._wordListSyn <> "") Then
                            tmpString = "\textit{(" & wordListVoc.Item(i - 1)._wordListCon & " / " & wordListVoc.Item(i - 1)._wordListSyn & ")}"
                        End If

                        ' Dictionary Entry
                        If (sortType = "Thematic" Or lastWord <> wordListVoc.Item(i - 1)._wordListSort Or lastType <> wordListVoc.Item(i - 1)._wordListType) Then
                            If (newPage = False) Then
                                ' end other Entry
                                sw.WriteLine(" \\")
                            End If
                            ' write new Entry
                            fromString = replaceSpecialChars(wordListVoc.Item(i - 1)._wordListFrom, fromLanguage)
                            toString = replaceSpecialChars(wordListVoc.Item(i - 1)._wordListTo, toLanguage)
                            sw.WriteLine("\textbf{" & fromString & "} \textit{(" & wordListVoc.Item(i - 1)._wordListType & ")}" & ", " & tmpString & " " & toString)
                            ' Counter
                            entrycount = entrycount + 1
                        ElseIf (lastWord = wordListVoc.Item(i - 1)._wordListSort And lastType = wordListVoc.Item(i - 1)._wordListType) Then
                            ' append to same Word and Type
                            toString = replaceSpecialChars(wordListVoc.Item(i - 1)._wordListTo, toLanguage)
                            sw.Write(", " & tmpString & " " & toString)
                        End If

                        ' for next Iteration
                        If (sortType = "Lexical") Then
                            lastLetter = wordListVoc.Item(i - 1)._wordListSort.Substring(0, 1).ToUpper
                        ElseIf (sortType = "Thematic") Then
                            lastLetter = wordListVoc.Item(i - 1)._wordListSort
                        End If
                        lastWord = wordListVoc.Item(i - 1)._wordListSort
                        lastType = wordListVoc.Item(i - 1)._wordListType

                    Next

                    ' End Document
                    sw.WriteLine("")
                    sw.WriteLine("\end{document}")

                    ' Close File
                    sw.Close()

                End Using

            ElseIf (RadioButtonPDF.Checked = True) Then

                Try

                    ' File Stream
                    Dim fs As System.IO.FileStream = New System.IO.FileStream(vocDictFile, System.IO.FileMode.Create)

                    ' Generate Vocabulary Dictionary as PDF File
                    Dim doc As Document = New Document(PageSize.A4, 25, 25, 30, 30)
                    Dim writer As PdfWriter = PdfWriter.GetInstance(doc, fs)

                    ' Meta Data
                    doc.AddCreationDate()
                    doc.AddAuthor("gearwheelsoft2")
                    doc.AddCreator("Decaleon")
                    doc.AddKeywords(sortType & " Vocabulary Dictionary")
                    doc.AddSubject("Alphabetically sorted Dictionary")
                    doc.AddTitle("Vocabulary Dictionary from " & pubLanguage(fromLanguage) & " to " & pubLanguage(toLanguage))

                    ' Open Document
                    doc.Open()

                    ' Title Page
                    Dim caption As Paragraph
                    Dim fontBig As New iTextSharp.text.Font(iTextSharp.text.Font.FontFamily.TIMES_ROMAN, 20)
                    Dim fontSmall As New iTextSharp.text.Font(iTextSharp.text.Font.FontFamily.TIMES_ROMAN, 12)
                    For j = 1 To 8
                        doc.Add(New Paragraph(" ", fontBig))
                    Next
                    caption = New Paragraph(sortType & " Vocabulary Dictionary from " & pubLanguage(fromLanguage) & " to " & pubLanguage(toLanguage), fontBig)
                    caption.Alignment = Element.ALIGN_CENTER
                    doc.Add(caption)
                    caption = New Paragraph("Decaleon V5.0", fontSmall)
                    caption.Alignment = Element.ALIGN_CENTER
                    doc.Add(caption)
                    caption = New Paragraph("2014-2016", fontSmall)
                    caption.Alignment = Element.ALIGN_CENTER
                    doc.Add(caption)

                    ' Word Entries
                    lastLetter = ""
                    lastWord = ""
                    lastType = ""
                    entrycount = 0
                    fieldcount = 0

                    ' iTextSharp Variables
                    Dim totalEntry As Paragraph
                    Dim fromEntryWord As Chunk
                    Dim fromEntryType As Chunk
                    Dim toEntryConSyn As List(Of Chunk)
                    Dim toEntryWord As List(Of Chunk)
                    Dim endEntry As Chunk
                    Dim fontBold As New iTextSharp.text.Font
                    Dim fontItalic As New iTextSharp.text.Font
                    fontBold.SetStyle(iTextSharp.text.Font.BOLD)
                    fontItalic.SetStyle(iTextSharp.text.Font.ITALIC)

                    For i = 1 To wordlstcount

                        ' check Initial Letter
                        newPage = False
                        If ((sortType = "Lexical" And lastLetter <> wordListVoc.Item(i - 1)._wordListSort.Substring(0, 1).ToUpper) Or _
                            (sortType = "Thematic" And lastLetter <> wordListVoc.Item(i - 1)._wordListSort)) Then
                            ' begin new Page
                            doc.Add(New Paragraph(" "))
                            doc.NewPage()
                            doc.Add(New Paragraph(" "))
                            If (sortType = "Lexical") Then
                                doc.Add(New Paragraph(wordListVoc.Item(i - 1)._wordListSort.Substring(0, 1).ToUpper, fontBig))
                            ElseIf (sortType = "Thematic") Then
                                doc.Add(New Paragraph(getGroupName(wordListVoc.Item(i - 1)._wordListSort), fontBig))
                            End If
                            doc.Add(New Paragraph(" "))
                            ' Flag
                            newPage = True
                            fieldcount = fieldcount + 1
                        End If

                        ' Synonym and Context Information
                        tmpString = ""
                        If (wordListVoc.Item(i - 1)._wordListCon <> "" And wordListVoc.Item(i - 1)._wordListSyn = "") Then
                            tmpString = " (" & wordListVoc.Item(i - 1)._wordListCon & ") "
                        ElseIf (wordListVoc.Item(i - 1)._wordListCon = "" And wordListVoc.Item(i - 1)._wordListSyn <> "") Then
                            tmpString = " (" & wordListVoc.Item(i - 1)._wordListSyn & ") "
                        ElseIf (wordListVoc.Item(i - 1)._wordListCon <> "" And wordListVoc.Item(i - 1)._wordListSyn <> "") Then
                            tmpString = " (" & wordListVoc.Item(i - 1)._wordListCon & " / " & wordListVoc.Item(i - 1)._wordListSyn & ") "
                        End If

                        ' Dictionary Entry
                        If (sortType = "Thematic" Or lastWord <> wordListVoc.Item(i - 1)._wordListSort Or lastType <> wordListVoc.Item(i - 1)._wordListType) Then
                            If (newPage = False) Then
                                ' end other Entry
                                endEntry = New Chunk("")
                                totalEntry = New Paragraph
                                totalEntry.Add(fromEntryWord)
                                totalEntry.Add(fromEntryType)
                                For j = 0 To toEntryConSyn.Count - 1
                                    totalEntry.Add(toEntryConSyn(j))
                                    totalEntry.Add(toEntryWord(j))
                                Next
                                totalEntry.Add(endEntry)
                                doc.Add(totalEntry)
                            End If
                            ' write new Entry
                            toEntryConSyn = New List(Of Chunk)
                            toEntryWord = New List(Of Chunk)
                            fromString = replaceSpecialChars(wordListVoc.Item(i - 1)._wordListFrom, fromLanguage)
                            toString = replaceSpecialChars(wordListVoc.Item(i - 1)._wordListTo, toLanguage)
                            fromEntryWord = New Chunk(fromString, fontBold)
                            fromEntryType = New Chunk(" (" & wordListVoc.Item(i - 1)._wordListType & ")", fontItalic)
                            toEntryConSyn.Add(New Chunk(" " & tmpString, fontItalic))
                            toEntryWord.Add(New Chunk(toString))
                            ' Counter
                            entrycount = entrycount + 1
                        ElseIf (lastWord = wordListVoc.Item(i - 1)._wordListSort And lastType = wordListVoc.Item(i - 1)._wordListType) Then
                            ' append to same Word and Type
                            toString = replaceSpecialChars(wordListVoc.Item(i - 1)._wordListTo, toLanguage)
                            toEntryConSyn.Add(New Chunk(", " & tmpString, fontItalic))
                            toEntryWord.Add(New Chunk(toString))
                        End If

                        ' for next Iteration
                        If (sortType = "Lexical") Then
                            lastLetter = wordListVoc.Item(i - 1)._wordListSort.Substring(0, 1).ToUpper
                        ElseIf (sortType = "Thematic") Then
                            lastLetter = wordListVoc.Item(i - 1)._wordListSort
                        End If
                        lastWord = wordListVoc.Item(i - 1)._wordListSort
                        lastType = wordListVoc.Item(i - 1)._wordListType

                    Next

                    doc.Close()
                    writer.Close()
                    fs.Close()

                Catch ex As Exception

                    MsgBox("The File " & vocDictFile & " is opened by a Viewer. Please close it there.", MsgBoxStyle.Information, "Write Access denied")
                    Exit Sub

                Finally

                    'doc.Close()
                    'writer.Close()
                    'fs.Close()

                End Try

            End If

            ' Message
            MsgBox("Dictionary " & vocDictFile & " generated and saved into /bin/Debug Directory!" & vbCrLf & _
                   entrycount.ToString & " Entries", MsgBoxStyle.Information, "finished")
            frmDictionary.RichTextBoxDictionary.Text = fieldcount.ToString & " Chapters / " & entrycount.ToString & " Entries"

        Else

            Dim retval As ThemBook
            ' LaTeX Thematischer Wortschatz
            ' Function in TranslateEsperanto.vb
            ' not for Esperanto
            ' - texFile: Name der LaTeX-Datei
            ' - fontSize: 0 = 10pt, 1 = 11pt, 2 = 12pt
            ' - Titles: Ger:1, Eng:2
            ' - Lang1: From Language (Deutsch, Englisch)
            ' - Lang21: 1st To Language (Deutsch, Englisch, Französisch, Spanisch, Italienisch, Portogiesisch, Dänisch, Schwedisch, Griechisch, Russisch, Polnisch, Kroatisch) (1-12)
            ' - Lang22: 2nd To Language (Deutsch, Englisch, Französisch, Spanisch, Italienisch, Portogiesisch, Dänisch, Schwedisch, Griechisch, Russisch, Polnisch, Kroatisch) (1-12), -1 = inaktiv
            ' - val: minimum words per table: 1
            retval = Nothing
            If (CheckBoxBook.Checked = False) Then
                If (ComboBoxBook.SelectedIndex = 0) Then
                    retval = exportGroupsBySubthemes("ThematicBook.tex", 0, 1, LangName.Deutsch, LangName.English, LangName.Francais, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 1) Then
                    retval = exportGroupsBySubthemes("ThematicBook.tex", 0, 1, LangName.Deutsch, LangName.English, LangName.Espanol, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 2) Then
                    retval = exportGroupsBySubthemes("ThematicBook.tex", 0, 1, LangName.Deutsch, LangName.English, LangName.Italiano, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 3) Then
                    retval = exportGroupsBySubthemes("ThematicBook.tex", 0, 1, LangName.Deutsch, LangName.Francais, LangName.Espanol, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 4) Then
                    retval = exportGroupsBySubthemes("ThematicBook.tex", 0, 1, LangName.Deutsch, LangName.Francais, LangName.Italiano, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 5) Then
                    retval = exportGroupsBySubthemes("ThematicBook.tex", 0, 1, LangName.Deutsch, LangName.Espanol, LangName.Italiano, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 6) Then
                    retval = exportGroupsBySubthemes("ThematicBook.tex", 0, 1, LangName.Deutsch, LangName.Espanol, LangName.Portoguese, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 7) Then
                    retval = exportGroupsBySubthemes("ThematicBook.tex", 0, 1, LangName.Deutsch, LangName.Dansk, LangName.Svenska, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 8) Then
                    retval = exportGroupsBySubthemes("ThematicBook.tex", 0, 1, LangName.Deutsch, LangName.Polski, LangName.Hrvatski, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 9) Then
                    retval = exportGroupsBySubthemes("ThematicBook.tex", 0, 1, LangName.Deutsch, LangName.English, -1, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 10) Then
                    retval = exportGroupsBySubthemes("ThematicBook.tex", 2, 1, LangName.Deutsch, LangName.Russkij, -1, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 11) Then
                    retval = exportGroupsBySubthemes("ThematicBook.tex", 2, 1, LangName.Deutsch, LangName.Ellenika, -1, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 12) Then
                    retval = exportGroupsBySubthemes("ThematicBook.tex", 2, 1, LangName.Deutsch, LangName.AnyLang, -1, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 13) Then
                    retval = exportGroupsBySubthemes("ThematicBook.tex", 0, 2, LangName.English, LangName.Francais, LangName.Espanol, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 14) Then
                    retval = exportGroupsBySubthemes("ThematicBook.tex", 0, 2, LangName.English, LangName.Francais, LangName.Italiano, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 15) Then
                    retval = exportGroupsBySubthemes("ThematicBook.tex", 0, 2, LangName.English, LangName.Espanol, LangName.Italiano, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 16) Then
                    retval = exportGroupsBySubthemes("ThematicBook.tex", 0, 2, LangName.English, LangName.Espanol, LangName.Portoguese, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 17) Then
                    retval = exportGroupsBySubthemes("ThematicBook.tex", 0, 2, LangName.English, LangName.Dansk, LangName.Svenska, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 18) Then
                    retval = exportGroupsBySubthemes("ThematicBook.tex", 0, 2, LangName.English, LangName.Polski, LangName.Hrvatski, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 19) Then
                    retval = exportGroupsBySubthemes("ThematicBook.tex", 0, 2, LangName.English, LangName.Deutsch, -1, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 20) Then
                    retval = exportGroupsBySubthemes("ThematicBook.tex", 2, 2, LangName.English, LangName.Russkij, -1, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 21) Then
                    retval = exportGroupsBySubthemes("ThematicBook.tex", 2, 2, LangName.English, LangName.Ellenika, -1, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 22) Then
                    retval = exportGroupsBySubthemes("ThematicBook.tex", 2, 2, LangName.English, LangName.AnyLang, -1, 3)
                End If
                ' Message
                MsgBox("LaTeX Book " & "ThematicBook.tex" & " generated and saved into /bin/Debug Directory!" & vbCrLf & _
                       retval._Tables(0).ToString & " Tables / " & retval._Words(0).ToString & " Entries", MsgBoxStyle.Information, "finished")
                frmDictionary.RichTextBoxDictionary.Text = retval._Tables(0).ToString & " Tables / " & retval._Words(0).ToString & " Entries"

            ElseIf (CheckBoxBook.Checked = True) Then
                If (ComboBoxBook.SelectedIndex = 0) Then
                    retval = exportGroupsBySubthemesTwoParts("ThematicBook.tex", 0, 1, LangName.Deutsch, LangName.English, LangName.Francais, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 1) Then
                    retval = exportGroupsBySubthemesTwoParts("ThematicBook.tex", 0, 1, LangName.Deutsch, LangName.English, LangName.Espanol, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 2) Then
                    retval = exportGroupsBySubthemesTwoParts("ThematicBook.tex", 0, 1, LangName.Deutsch, LangName.English, LangName.Italiano, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 3) Then
                    retval = exportGroupsBySubthemesTwoParts("ThematicBook.tex", 0, 1, LangName.Deutsch, LangName.Francais, LangName.Espanol, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 4) Then
                    retval = exportGroupsBySubthemesTwoParts("ThematicBook.tex", 0, 1, LangName.Deutsch, LangName.Francais, LangName.Italiano, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 5) Then
                    retval = exportGroupsBySubthemesTwoParts("ThematicBook.tex", 0, 1, LangName.Deutsch, LangName.Espanol, LangName.Italiano, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 6) Then
                    retval = exportGroupsBySubthemesTwoParts("ThematicBook.tex", 0, 1, LangName.Deutsch, LangName.Espanol, LangName.Portoguese, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 7) Then
                    retval = exportGroupsBySubthemesTwoParts("ThematicBook.tex", 0, 1, LangName.Deutsch, LangName.Dansk, LangName.Svenska, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 8) Then
                    retval = exportGroupsBySubthemesTwoParts("ThematicBook.tex", 0, 1, LangName.Deutsch, LangName.Polski, LangName.Hrvatski, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 9) Then
                    retval = exportGroupsBySubthemesTwoParts("ThematicBook.tex", 0, 1, LangName.Deutsch, LangName.English, -1, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 10) Then
                    retval = exportGroupsBySubthemesTwoParts("ThematicBook.tex", 2, 1, LangName.Deutsch, LangName.Russkij, -1, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 11) Then
                    retval = exportGroupsBySubthemesTwoParts("ThematicBook.tex", 2, 1, LangName.Deutsch, LangName.Ellenika, -1, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 12) Then
                    retval = exportGroupsBySubthemesTwoParts("ThematicBook.tex", 2, 1, LangName.Deutsch, LangName.AnyLang, -1, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 13) Then
                    retval = exportGroupsBySubthemesTwoParts("ThematicBook.tex", 0, 2, LangName.English, LangName.Francais, LangName.Espanol, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 14) Then
                    retval = exportGroupsBySubthemesTwoParts("ThematicBook.tex", 0, 2, LangName.English, LangName.Francais, LangName.Italiano, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 15) Then
                    retval = exportGroupsBySubthemesTwoParts("ThematicBook.tex", 0, 2, LangName.English, LangName.Espanol, LangName.Italiano, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 16) Then
                    retval = exportGroupsBySubthemesTwoParts("ThematicBook.tex", 0, 2, LangName.English, LangName.Espanol, LangName.Portoguese, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 17) Then
                    retval = exportGroupsBySubthemesTwoParts("ThematicBook.tex", 0, 2, LangName.English, LangName.Dansk, LangName.Svenska, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 18) Then
                    retval = exportGroupsBySubthemesTwoParts("ThematicBook.tex", 0, 2, LangName.English, LangName.Polski, LangName.Hrvatski, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 19) Then
                    retval = exportGroupsBySubthemesTwoParts("ThematicBook.tex", 0, 2, LangName.English, LangName.Deutsch, -1, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 20) Then
                    retval = exportGroupsBySubthemesTwoParts("ThematicBook.tex", 2, 2, LangName.English, LangName.Russkij, -1, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 21) Then
                    retval = exportGroupsBySubthemesTwoParts("ThematicBook.tex", 2, 2, LangName.English, LangName.Ellenika, -1, 3)
                ElseIf (ComboBoxBook.SelectedIndex = 22) Then
                    retval = exportGroupsBySubthemesTwoParts("ThematicBook.tex", 2, 2, LangName.English, LangName.AnyLang, -1, 3)
                End If
                ' Message
                MsgBox("LaTeX Book " & "ThematicBook1.tex, ThematicBook3.tex and ThematicBook2.tex" & " generated and saved into /bin/Debug Directory!" & vbCrLf & _
                       "In sum: " & retval._Tables(0).ToString & " Tables / " & retval._Words(0).ToString & " Entries" & vbCrLf & _
                       "Book 1: " & retval._Tables(1).ToString & " Tables / " & retval._Words(1).ToString & " Entries" & vbCrLf & _
                       "Book 2: " & retval._Tables(2).ToString & " Tables / " & retval._Words(2).ToString & " Entries" & vbCrLf & _
                       "Book 3: " & retval._Tables(3).ToString & " Tables / " & retval._Words(3).ToString & " Entries", MsgBoxStyle.Information, "finished")
                frmDictionary.RichTextBoxDictionary.Text = retval._Tables(0).ToString & " Tables / " & retval._Words(0).ToString & " Entries"

            End If

        End If

    End Sub

    Private Function replaceSpecialChars(ByVal inString As String, ByVal lang As Integer) As String
        ' replace Special Characters
        Dim outString As String
        Dim zStr As String = Chr(34)

        outString = inString
        If (lang = LangName.Esperanto) Then
            outString = outString.Replace("|c", zStr & "ĉ").Replace("|C", zStr & "Ĉ")   ' U+0109 / U+0108
            outString = outString.Replace("|g", zStr & "ĝ").Replace("|G", zStr & "Ĝ")   ' U+011D / U+011C
            outString = outString.Replace("|h", zStr & "ĥ").Replace("|H", zStr & "Ĥ")   ' U+0125 / U+0124
            outString = outString.Replace("|j", zStr & "ĵ").Replace("|J", zStr & "Ĵ")   ' U+0135 / U+0134
            outString = outString.Replace("|s", zStr & "ŝ").Replace("|S", zStr & "Ŝ")   ' U+015D / U+015C
            outString = outString.Replace("|u", zStr & "ŭ").Replace("|U", zStr & "Ŭ")   ' U+016D / U+016C
        End If

        ' Rueckgabe
        replaceSpecialChars = outString

    End Function

    Private Function checkGroupInfo(grpInfo As String) As String
        ' check for Thematic Field Group
        Dim retString As String

        If (grpInfo.Length > 1 And (grpInfo.StartsWith("F") = True Or grpInfo.StartsWith("G") = True Or grpInfo.StartsWith("EF") = True Or grpInfo.StartsWith("C") Or grpInfo.StartsWith("D"))) Then
            If (grpInfo.Contains(";") = True) Then
                retString = grpInfo.Substring(0, grpInfo.IndexOf(";"))
            Else
                retString = grpInfo
            End If
        Else
            ' no Group
            retString = "XXXX"
        End If

        ' Rueckgabe
        checkGroupInfo = retString

    End Function

    Private Function getGroupName(grpID As String) As String
        ' return Thematic Group Name
        Dim retString As String
        Dim i As Integer

        retString = "Init"
        If (grpID <> "XXXX") Then
            For i = 1 To countVocGroup
                If (grpID = pubVocabularyGrp(i)._GrpNumber) Then
                    retString = pubVocabularyGrp(i)._GrpName
                    Exit For
                End If
            Next
        Else
            ' no Group
            retString = "Miscellaneous"
        End If

        ' Rueckgabe
        getGroupName = retString

    End Function

End Class

