﻿Option Explicit On

' Import of CSV Files / Register of Additional Words
'
' MP Jan 2013: Word Mangager
' MP Mar 2014: Program 4.0

' Functions:
' - initAdditional              Initialisation of the Data Structures of the Additional Vocabulary
' - readCSVdata                 Import Words from CSV File
' - generateTrainFileAdd        Generate new Training File from Imported/Registered Words

Imports System.IO
Imports System.Xml

Public Class FWordManager

    Dim maxIndex As Integer = 16
    Dim wordData(maxIndex) As String
    Dim separator As String
    Dim fileCSVname As String
    Dim countColumn As Integer
    Dim countPairs As Integer
    Dim indexCSV(maxIndex) As Integer
    Dim indexword(maxIndex) As Integer
    Dim countWord As Long
    Dim wordlstcount As Integer
    Dim exWordFrom As New List(Of String)
    Dim exWordTo As New List(Of String)
    Dim exWordCon As New List(Of String)
    Dim exWordSyn As New List(Of String)
    Dim exWordType As New List(Of String)
    Dim exWordTheme As New List(Of String)
    Dim exWordTime As New List(Of Long)
    Dim exWordCount As New List(Of Integer)
    Dim exWordScore As New List(Of Integer)
    Dim exSelected, exDone As Integer
    Dim exScore As Integer


    Private Sub FormWordManager_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' Default Werte, Anzeigen und Einstellungen
        Dim i As Integer

        ' Texte von Labels and Buttons
        frmWordManager.GroupBoxImport.Text = "Import"
        frmWordManager.LabelUser1.Text = "Please choose or enter Separator!"
        frmWordManager.ButtonImport.Text = "Open CSV File"
        frmWordManager.LabelUser2.Text = "Please assign 2 Languages and maybe Context and Synonym Information!"
        frmWordManager.ButtonAddPair.Text = "Add Pair"
        frmWordManager.ButtonClearDgrid.Text = "Clear"
        frmWordManager.DataGridViewMatch.Columns.Item(0).HeaderText = "Destination"
        frmWordManager.DataGridViewMatch.Columns.Item(1).HeaderText = "Source"
        frmWordManager.CheckBoxFirstLine.Text = "Ignore first Line"
        frmWordManager.ButtonImport.Text = "Start Import"
        frmWordManager.LabelResult.Text = "Result"

        ' Trennzeichen
        ComboBoxSeparator.Items.Clear()
        ComboBoxSeparator.Items.Add(",")
        ComboBoxSeparator.Items.Add(";")
        ComboBoxSeparator.Items.Add(" (Blank)")
        ComboBoxSeparator.Items.Add(">(Tab)")
        ComboBoxSeparator.Text = ""

        ' Hilfs-Objekte
        ListBoxIndexCSV.Visible = False
        ListBoxIndexWord.Visible = False

        ' Anzahl Zuordnungen
        countPairs = 0

        ' Wort-Daten
        wordData(0) = "L_Esperanto"
        wordData(1) = "L_Deutsch"
        wordData(2) = "L_English"
        wordData(3) = "L_Français"
        wordData(4) = "L_Español"
        wordData(5) = "L_Italiano"
        wordData(6) = "L_Português"
        wordData(7) = "L_Dansk"
        wordData(8) = "L_Svenska"
        wordData(9) = "L_Ελληνικά"
        wordData(10) = "L_Русский"
        wordData(11) = "L_Polski"
        wordData(12) = "L_Hrvatski"
        wordData(13) = "L_Any"
        wordData(14) = "Synonym"
        wordData(15) = "Context"
        wordData(16) = "Theme"

        ' Texte von Labels and Buttons
        frmWordManager.GroupBoxRegister.Text = "Register"
        frmWordManager.LabelUser3.Text = "Please choose 2 Languages! Context and Synonym Information optional!"
        frmWordManager.LabelContext.Text = "Context Information"
        frmWordManager.LabelSynonym.Text = "Synonym Information"
        frmWordManager.LabelTheme.Text = "Choose Theme!"
        frmWordManager.ButtonRegister.Text = "Register"
        frmWordManager.LabelCounter.Text = "Counter"
        frmWordManager.ButtonResetWreg.Text = "Reset"

        ' Sprachen-Auswahl 1st
        frmWordManager.ComboBox1stLang.Items.Clear()
        frmWordManager.ComboBox1stLang.Items.Add("Esperanto")
        frmWordManager.ComboBox1stLang.Items.Add("Deutsch")
        frmWordManager.ComboBox1stLang.Items.Add("English")
        frmWordManager.ComboBox1stLang.Items.Add("Français")
        frmWordManager.ComboBox1stLang.Items.Add("Español")
        frmWordManager.ComboBox1stLang.Items.Add("Italiano")
        frmWordManager.ComboBox1stLang.Items.Add("Português")
        frmWordManager.ComboBox1stLang.Items.Add("Dansk")
        frmWordManager.ComboBox1stLang.Items.Add("Svenska")
        frmWordManager.ComboBox1stLang.Items.Add("Ελληνικά")
        frmWordManager.ComboBox1stLang.Items.Add("Русский")
        frmWordManager.ComboBox1stLang.Items.Add("Polski")
        frmWordManager.ComboBox1stLang.Items.Add("Hrvatski")
        frmWordManager.ComboBox1stLang.Items.Add("Any Language")
        frmWordManager.ComboBox1stLang.SelectedIndex = -1
        frmWordManager.ComboBox1stLang.Text = "Please Select!"

        ' Sprachen-Auswahl 2nd
        frmWordManager.ComboBox2ndLang.Items.Clear()
        frmWordManager.ComboBox2ndLang.Items.Add("Esperanto")
        frmWordManager.ComboBox2ndLang.Items.Add("Deutsch")
        frmWordManager.ComboBox2ndLang.Items.Add("English")
        frmWordManager.ComboBox2ndLang.Items.Add("Français")
        frmWordManager.ComboBox2ndLang.Items.Add("Español")
        frmWordManager.ComboBox2ndLang.Items.Add("Italiano")
        frmWordManager.ComboBox2ndLang.Items.Add("Português")
        frmWordManager.ComboBox2ndLang.Items.Add("Dansk")
        frmWordManager.ComboBox2ndLang.Items.Add("Svenska")
        frmWordManager.ComboBox2ndLang.Items.Add("Ελληνικά")
        frmWordManager.ComboBox2ndLang.Items.Add("Русский")
        frmWordManager.ComboBox2ndLang.Items.Add("Polski")
        frmWordManager.ComboBox2ndLang.Items.Add("Hrvatski")
        frmWordManager.ComboBox2ndLang.Items.Add("Any Language")
        frmWordManager.ComboBox2ndLang.SelectedIndex = -1
        frmWordManager.ComboBox2ndLang.Text = "Please Select!"

        ' Choice: Theme
        frmWordManager.ComboBoxTheme.Items.Clear()
        For i = 1 To pubVocThemes(0)
            frmWordManager.ComboBoxTheme.Items.Add(pubVocThemes(i))
        Next
        frmWordManager.ComboBoxTheme.Text = "Please Select!"

        ' Training File
        frmWordManager.LabelUser4.Text = "Please choose 2 Languages!"
        frmWordManager.LabelFromLang.Text = "from"
        frmWordManager.LabelToLang.Text = "to"
        frmWordManager.ButtonOK.Text = "Generate Training File"

        ' Sprachen-Auswahl from
        frmWordManager.ComboBoxFromLang.Items.Clear()
        frmWordManager.ComboBoxFromLang.Items.Add("Esperanto")
        frmWordManager.ComboBoxFromLang.Items.Add("Deutsch")
        frmWordManager.ComboBoxFromLang.Items.Add("English")
        frmWordManager.ComboBoxFromLang.Items.Add("Français")
        frmWordManager.ComboBoxFromLang.Items.Add("Español")
        frmWordManager.ComboBoxFromLang.Items.Add("Italiano")
        frmWordManager.ComboBoxFromLang.Items.Add("Português")
        frmWordManager.ComboBoxFromLang.Items.Add("Dansk")
        frmWordManager.ComboBoxFromLang.Items.Add("Svenska")
        frmWordManager.ComboBoxFromLang.Items.Add("Ελληνικά")
        frmWordManager.ComboBoxFromLang.Items.Add("Русский")
        frmWordManager.ComboBoxFromLang.Items.Add("Polski")
        frmWordManager.ComboBoxFromLang.Items.Add("Hrvatski")
        frmWordManager.ComboBoxFromLang.Items.Add("Any Language")
        frmWordManager.ComboBoxFromLang.SelectedIndex = -1
        frmWordManager.ComboBoxFromLang.Text = "Please Select!"

        ' Sprachen-Auswahl to
        frmWordManager.ComboBoxToLang.Items.Clear()
        frmWordManager.ComboBoxToLang.Items.Add("Esperanto")
        frmWordManager.ComboBoxToLang.Items.Add("Deutsch")
        frmWordManager.ComboBoxToLang.Items.Add("English")
        frmWordManager.ComboBoxToLang.Items.Add("Français")
        frmWordManager.ComboBoxToLang.Items.Add("Español")
        frmWordManager.ComboBoxToLang.Items.Add("Italiano")
        frmWordManager.ComboBoxToLang.Items.Add("Português")
        frmWordManager.ComboBoxToLang.Items.Add("Dansk")
        frmWordManager.ComboBoxToLang.Items.Add("Svenska")
        frmWordManager.ComboBoxToLang.Items.Add("Ελληνικά")
        frmWordManager.ComboBoxToLang.Items.Add("Русский")
        frmWordManager.ComboBoxToLang.Items.Add("Polski")
        frmWordManager.ComboBoxToLang.Items.Add("Hrvatski")
        frmWordManager.ComboBoxToLang.Items.Add("Any Language")
        frmWordManager.ComboBoxToLang.SelectedIndex = -1
        frmWordManager.ComboBoxToLang.Text = "Please Select!"


        ' Init Data Structure
        initAdditional(0)

    End Sub

    Private Sub FWordManager_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        frmWordManager = New FWordManager

    End Sub

    Private Sub ButtonOpen_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonOpen.Click
        ' Prescan und Anzeigen in ListBoxen
        Dim reti As Integer
        Dim zeileStr As String
        Dim splitstr() As String
        Dim columnStr As String
        Dim i As Integer

        ' Check
        If (ComboBoxSeparator.SelectedIndex = -1 And ComboBoxSeparator.Text = "") Then
            MsgBox("Please choose or enter Separator at first!", MsgBoxStyle.Information, "Choice")
            Exit Sub

        End If
        If (ComboBoxSeparator.SelectedIndex = -1 And ComboBoxSeparator.Text.Length > 1) Then
            MsgBox("Please enter just one Character as Separator!", MsgBoxStyle.Information, "Separator")
            Exit Sub

        End If

        ' Trennzeichen
        If (ComboBoxSeparator.SelectedIndex = -1) Then
            separator = ComboBoxSeparator.Text
        Else
            If (ComboBoxSeparator.SelectedIndex = 0) Then
                separator = ","
            ElseIf (ComboBoxSeparator.SelectedIndex = 1) Then
                separator = ";"
            ElseIf (ComboBoxSeparator.SelectedIndex = 2) Then
                separator = " "
            ElseIf (ComboBoxSeparator.SelectedIndex = 3) Then
                separator = vbTab
            End If

        End If

        ' Datei-Auswahl
        frmWordManager.OpenFileDialog1.InitialDirectory = Application.StartupPath
        frmWordManager.OpenFileDialog1.Filter = "*.csv" & "|*.csv"
        frmWordManager.OpenFileDialog1.Title = "Import CSV File"
        frmWordManager.OpenFileDialog1.FileName = ""
        reti = frmWordManager.OpenFileDialog1.ShowDialog()
        If (reti = vbCancel) Then
            Exit Sub
        End If
        fileCSVname = frmWordManager.OpenFileDialog1.FileName

        ' Prescan und Anzeige
        ' via Unicode Reader
        Dim fs As New FileStream(fileCSVname, FileMode.Open, FileAccess.Read)
        Dim sr As New StreamReader(fs, System.Text.Encoding.UTF8)

        ' erste Zeile
        zeileStr = sr.ReadLine
        splitstr = zeileStr.Split(separator)
        ListBoxCSVdata.Items.Clear()
        ListBoxIndexCSV.Items.Clear()
        countColumn = 0
        For i = 0 To splitstr.Count - 1
            countColumn = countColumn + 1
            columnStr = splitstr(i)
            ListBoxCSVdata.Items.Add(columnStr)
            ListBoxIndexCSV.Items.Add(i + 1)
        Next

        ' weitere Zeilen
        While (Not sr.EndOfStream = True)
            zeileStr = sr.ReadLine
            splitstr = zeileStr.Split(separator)
            If (splitstr.Count <> countColumn) Then
                ' abort
                MsgBox("Not all Rows have the same Number of Columns!", MsgBoxStyle.Information, "CSV Data")
                ListBoxCSVdata.Items.Clear()
                ListBoxIndexCSV.Items.Clear()
                sr.Close()
                fs.Close()
                Exit Sub

            End If

        End While

        ' close
        sr.Close()
        fs.Close()

        ' Wort-Daten
        ListBoxWordData.Items.Clear()
        ListBoxIndexWord.Items.Clear()
        For i = 0 To maxIndex
            ListBoxWordData.Items.Add(wordData(i))
            ListBoxIndexWord.Items.Add(i)
        Next

    End Sub

    Private Sub ButtonAddPair_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonAddPair.Click
        ' Anzeige Paar-Zuordnung in DataGrid

        ' Check
        If (ListBoxCSVdata.SelectedIndex = -1 Or ListBoxWordData.SelectedIndex = -1) Then
            MsgBox("Please choose an Element at first!", MsgBoxStyle.Information, "Choice")

            Exit Sub

        End If

        ' Anzeige DataGrid
        countPairs = countPairs + 1
        DataGridViewMatch.Item(0, 0).Value = ListBoxCSVdata.Items(ListBoxCSVdata.SelectedIndex)
        DataGridViewMatch.Item(1, 0).Value = ListBoxWordData.Items(ListBoxWordData.SelectedIndex)
        DataGridViewMatch.Rows.Insert(0, 1)

        ' Indices der Attributnamen merken
        indexCSV(countPairs) = ListBoxIndexCSV.Items(ListBoxCSVdata.SelectedIndex)
        indexCSV(0) = countPairs
        indexword(countPairs) = ListBoxIndexWord.Items(ListBoxWordData.SelectedIndex)
        indexword(0) = countPairs

        ' ListBoxen vergebene Eintraege loeschen
        ListBoxIndexCSV.Items.RemoveAt(ListBoxCSVdata.SelectedIndex)
        ListBoxCSVdata.Items.RemoveAt(ListBoxCSVdata.SelectedIndex)
        ListBoxIndexWord.Items.RemoveAt(ListBoxWordData.SelectedIndex)
        ListBoxWordData.Items.RemoveAt(ListBoxWordData.SelectedIndex)

    End Sub

    Private Sub ButtonClear_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonClearDgrid.Click
        ' Alle Eintrage in DataGrid loeschen
        Dim ret As Integer

        ret = vbNo
        ret = MsgBox("Do you want to delete all Entries in DataView?", MsgBoxStyle.YesNoCancel, "Delete!")

        If (ret = vbYes) Then
            ' Loeschen
            DataGridViewMatch.Rows.Clear()
            ' Counter
            countPairs = 0
            indexCSV(0) = countPairs
            indexword(0) = countPairs
            ListBoxCSVdata.Items.Clear()
            ListBoxIndexCSV.Items.Clear()
            ListBoxWordData.Items.Clear()
            ListBoxIndexWord.Items.Clear()
        End If

    End Sub

    Private Sub ButtonImport_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonImport.Click
        ' Import
        Dim ignore1st As Boolean
        Dim countWord As Long
        Dim countCheck As Integer
        Dim i As Integer

        ' Check
        countCheck = 0
        For i = 0 To ListBoxWordData.Items.Count - 1
            If (ListBoxWordData.Items(i).startswith("L_") = True) Then
                countCheck = countCheck + 1

            End If
        Next
        If (countCheck > 10) Then
            MsgBox("Two Languages must be assigned!", MsgBoxStyle.Information, "Data Columns")
            Exit Sub

        End If
        If (countCheck < 10) Then
            MsgBox("No more than two Languages must be assigned!", MsgBoxStyle.Information, "Data Columns")
            Exit Sub

        End If

        ' Option Erste Zeile
        ignore1st = CheckBoxFirstLine.Checked

        ' Lesen und Speichern
        Try
            initDone = False
            countWord = readCSVdata(fileCSVname, separator, indexCSV, indexword, ignore1st)
            initDone = True

        Catch ex As Exception
            countWord = 0
            initDone = True
            MsgBox("The File could not be imported!", MsgBoxStyle.Information, "Import")

        End Try

        ' Anzeige
        LabelResult.Text = countWord & " Words imported."

    End Sub

    Private Function readCSVdata(ByVal filename, ByVal separator, ByVal indexCSV, ByVal indexWord, ByVal ignore1st) As Long
        ' Import Words from CSV File
        Dim tmpVocabularyAdd As clsVocabularyAdd
        Dim zeileStr As String
        Dim splitstr() As String
        Dim count As Long
        Dim i As Integer
        Dim j As Integer

        ' Init
        readCSVdata = -1

        ' Reader
        Dim fs As New FileStream(filename, FileMode.Open, FileAccess.Read)
        Dim sr As New StreamReader(fs, System.Text.Encoding.UTF8)

        count = 0
        countWord = 0

        While (Not sr.EndOfStream = True)

            zeileStr = sr.ReadLine
            count = count + 1

            ' Erste Zeile ggf. ignorieren
            If (count = 1 And ignore1st = True) Then
                Continue While

            End If

            splitstr = zeileStr.Split(separator)
            If (splitstr.Count <> countColumn) Then
                ' abort
                MsgBox("Not all Rows have the same Number of Columns!", MsgBoxStyle.Information, "CSV Data")
                ListBoxCSVdata.Items.Clear()
                ListBoxIndexCSV.Items.Clear()
                sr.Close()
                fs.Close()
                Exit Function

            End If

            ' temporaere Instanz
            tmpVocabularyAdd = Nothing
            tmpVocabularyAdd = New clsVocabularyAdd
            tmpVocabularyAdd._EspAdditional = ""
            tmpVocabularyAdd._GerAdditional = ""
            tmpVocabularyAdd._EngAdditional = ""
            tmpVocabularyAdd._FraAdditional = ""
            tmpVocabularyAdd._SpaAdditional = ""
            tmpVocabularyAdd._ItaAdditional = ""
            tmpVocabularyAdd._PorAdditional = ""
            tmpVocabularyAdd._DanAdditional = ""
            tmpVocabularyAdd._SweAdditional = ""
            tmpVocabularyAdd._GreAdditional = ""
            tmpVocabularyAdd._RusAdditional = ""
            tmpVocabularyAdd._PolAdditional = ""
            tmpVocabularyAdd._CroAdditional = ""
            tmpVocabularyAdd._AnyAdditional = ""
            tmpVocabularyAdd._SynAdditional = ""
            tmpVocabularyAdd._KonAdditional = ""
            tmpVocabularyAdd._ThmAdditional = ""

            For i = 0 To splitstr.Count - 1

                For j = 1 To indexCSV(0)

                    If (indexCSV(j) = i + 1) Then
                        ' Erfassen
                        If (indexWord(j) = LangName.Esperanto) Then
                            tmpVocabularyAdd._EspAdditional = splitstr(i)
                        ElseIf (indexWord(j) = LangName.Deutsch) Then
                            tmpVocabularyAdd._GerAdditional = splitstr(i)
                        ElseIf (indexWord(j) = LangName.English) Then
                            tmpVocabularyAdd._EngAdditional = splitstr(i)
                        ElseIf (indexWord(j) = LangName.Francais) Then
                            tmpVocabularyAdd._FraAdditional = splitstr(i)
                        ElseIf (indexWord(j) = LangName.Espanol) Then
                            tmpVocabularyAdd._SpaAdditional = splitstr(i)
                        ElseIf (indexWord(j) = LangName.Italiano) Then
                            tmpVocabularyAdd._ItaAdditional = splitstr(i)
                        ElseIf (indexWord(j) = LangName.Portoguese) Then
                            tmpVocabularyAdd._PorAdditional = splitstr(i)
                        ElseIf (indexWord(j) = LangName.Dansk) Then
                            tmpVocabularyAdd._DanAdditional = splitstr(i)
                        ElseIf (indexWord(j) = LangName.Svenska) Then
                            tmpVocabularyAdd._SweAdditional = splitstr(i)
                        ElseIf (indexWord(j) = LangName.Ellenika) Then
                            tmpVocabularyAdd._GreAdditional = splitstr(i)
                        ElseIf (indexWord(j) = LangName.Russkij) Then
                            tmpVocabularyAdd._RusAdditional = splitstr(i)
                        ElseIf (indexWord(j) = LangName.Polski) Then
                            tmpVocabularyAdd._PolAdditional = splitstr(i)
                        ElseIf (indexWord(j) = LangName.Hrvatski) Then
                            tmpVocabularyAdd._CroAdditional = splitstr(i)
                        ElseIf (indexWord(j) = LangName.AnyLang) Then
                            tmpVocabularyAdd._AnyAdditional = splitstr(i)
                        ElseIf (indexWord(j) = 12) Then
                            tmpVocabularyAdd._SynAdditional = splitstr(i)
                        ElseIf (indexWord(j) = 13) Then
                            tmpVocabularyAdd._KonAdditional = splitstr(i)
                        ElseIf (indexWord(j) = 14) Then
                            tmpVocabularyAdd._ThmAdditional = splitstr(i)
                        Else
                            ' nothing
                        End If

                    End If

                Next

            Next
            tmpVocabularyAdd._NivAdditional = "-"

            ' Hinzufuegen
            pubVocabularyAdd.Add(tmpVocabularyAdd)
            countVocAdditional = countVocAdditional + 1
            countWord = countWord + 1

        End While

        ' close
        sr.Close()
        fs.Close()

        ' Rueckgabe
        readCSVdata = countWord

    End Function


    Private Sub ButtonRegister_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonRegister.Click
        ' Register by typing
        Dim tmpVocabularyAdd As clsVocabularyAdd
        Dim languages(2) As Integer
        Dim fromLangStr As String
        Dim toLangStr As String
        Dim contextStr As String
        Dim synonymStr As String
        Dim themeStr As String
        Dim tmpStr As String
        Dim i As Integer

        ' Check: Sprachen
        If (ComboBox1stLang.SelectedIndex = -1 Or ComboBox2ndLang.SelectedIndex = -1) Then
            MsgBox("No 1st or 2nd Language selected!", MsgBoxStyle.Information)
            Exit Sub

        End If

        ' Check: Eingaben
        If (TextBoxFromLang.Text = "" Or TextBoxToLang.Text = "") Then
            MsgBox("Words for from and to Language must be typed in!", MsgBoxStyle.Information)
            Exit Sub

        End If

        ' Check: Themen
        If (ComboBoxTheme.SelectedIndex = -1) Then
            MsgBox("No Theme selected!", MsgBoxStyle.Information)
            Exit Sub

        End If

        ' Auswahl
        languages(1) = ComboBox1stLang.SelectedIndex
        languages(2) = ComboBox2ndLang.SelectedIndex

        ' Eingaben
        fromLangStr = TextBoxFromLang.Text
        toLangStr = TextBoxToLang.Text
        contextStr = TextBoxContext.Text
        synonymStr = TextBoxSynonym.Text
        themeStr = ComboBoxTheme.Items(ComboBoxTheme.SelectedIndex)

        ' temporaere Instanz
        tmpVocabularyAdd = Nothing
        tmpVocabularyAdd = New clsVocabularyAdd
        tmpVocabularyAdd._EspAdditional = ""
        tmpVocabularyAdd._GerAdditional = ""
        tmpVocabularyAdd._EngAdditional = ""
        tmpVocabularyAdd._FraAdditional = ""
        tmpVocabularyAdd._SpaAdditional = ""
        tmpVocabularyAdd._ItaAdditional = ""
        tmpVocabularyAdd._PorAdditional = ""
        tmpVocabularyAdd._DanAdditional = ""
        tmpVocabularyAdd._SweAdditional = ""
        tmpVocabularyAdd._GreAdditional = ""
        tmpVocabularyAdd._RusAdditional = ""
        tmpVocabularyAdd._PolAdditional = ""
        tmpVocabularyAdd._CroAdditional = ""
        tmpVocabularyAdd._AnyAdditional = ""
        tmpVocabularyAdd._SynAdditional = ""
        tmpVocabularyAdd._KonAdditional = ""
        tmpVocabularyAdd._ThmAdditional = ""

        ' Erfassen
        tmpStr = ""
        For i = 1 To 2
            If (i = 1) Then
                tmpStr = fromLangStr
            ElseIf (i = 2) Then
                tmpStr = toLangStr
            End If
            ' Reihenfolge identisch mit wordData!
            If (languages(i) = LangName.Esperanto) Then
                tmpVocabularyAdd._EspAdditional = tmpStr
            ElseIf (languages(i) = LangName.Deutsch) Then
                tmpVocabularyAdd._GerAdditional = tmpStr
            ElseIf (languages(i) = LangName.English) Then
                tmpVocabularyAdd._EngAdditional = tmpStr
            ElseIf (languages(i) = LangName.Francais) Then
                tmpVocabularyAdd._FraAdditional = tmpStr
            ElseIf (languages(i) = LangName.Espanol) Then
                tmpVocabularyAdd._SpaAdditional = tmpStr
            ElseIf (languages(i) = LangName.Italiano) Then
                tmpVocabularyAdd._ItaAdditional = tmpStr
            ElseIf (languages(i) = LangName.Portoguese) Then
                tmpVocabularyAdd._PorAdditional = tmpStr
            ElseIf (languages(i) = LangName.Dansk) Then
                tmpVocabularyAdd._DanAdditional = tmpStr
            ElseIf (languages(i) = LangName.Svenska) Then
                tmpVocabularyAdd._SweAdditional = tmpStr
            ElseIf (languages(i) = LangName.Ellenika) Then
                tmpVocabularyAdd._GreAdditional = tmpStr
            ElseIf (languages(i) = LangName.Russkij) Then
                tmpVocabularyAdd._RusAdditional = tmpStr
            ElseIf (languages(i) = LangName.Polski) Then
                tmpVocabularyAdd._PolAdditional = tmpStr
            ElseIf (languages(i) = LangName.Hrvatski) Then
                tmpVocabularyAdd._CroAdditional = tmpStr
            ElseIf (languages(i) = LangName.AnyLang) Then
                tmpVocabularyAdd._AnyAdditional = tmpStr
            Else
                ' nothing
            End If

        Next
        tmpVocabularyAdd._KonAdditional = contextStr
        tmpVocabularyAdd._SynAdditional = synonymStr
        tmpVocabularyAdd._ThmAdditional = themeStr
        tmpVocabularyAdd._NivAdditional = "-"

        ' Hinzufuegen
        pubVocabularyAdd.Add(tmpVocabularyAdd)
        countVocAdditional = countVocAdditional + 1
        countWord = countWord + 1

        ' Anzeige
        LabelCounter.Text = countWord & " Words registered."

    End Sub

    Private Sub ButtonClearWreg_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonResetWreg.Click
        ' Alle Eintrage in Erfassung loeschen/zuruecksetzen (auszer Sprachen)
        TextBoxFromLang.Text = ""
        TextBoxToLang.Text = ""
        TextBoxContext.Text = ""
        TextBoxSynonym.Text = ""
        ComboBoxTheme.SelectedIndex = -1
        ComboBoxTheme.Text = "Please Select!"

    End Sub


    Private Sub ButtonOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonOK.Click
        ' Training File erzeugen
        Dim languages(2) As Integer
        Dim trainFile As String
        Dim reti As Integer

        ' Check: Sprachen
        If (ComboBoxFromLang.SelectedIndex = -1 Or ComboBoxToLang.SelectedIndex = -1) Then
            MsgBox("No From or To Language selected!", MsgBoxStyle.Information)
            Exit Sub

        End If

        ' Auswahl: Sprachen
        languages(1) = ComboBoxFromLang.SelectedIndex
        languages(2) = ComboBoxToLang.SelectedIndex

        ' Datei-Auswahl
        frmEsperanto.SaveFileDialog1.InitialDirectory = Application.StartupPath
        frmEsperanto.SaveFileDialog1.Filter = "*.tml" & "|*.tml"
        frmEsperanto.SaveFileDialog1.Title = "Create Training File"
        frmEsperanto.SaveFileDialog1.FileName = ""
        reti = frmEsperanto.SaveFileDialog1.ShowDialog()
        If (reti = vbCancel) Then
            pubTrainerStart = False
            Exit Sub
        End If
        trainFile = frmEsperanto.SaveFileDialog1.FileName

        ' TrainFile erzeugen 
        Cursor.Current = Cursors.WaitCursor
        generateTrainFileAdd(trainFile, languages, True)
        Cursor.Current = Cursors.Default

        ' Beenden (modal -> Trainer folgt)
        Close()

    End Sub

    Private Function generateTrainFileAdd(ByVal trainfile As String, ByVal languages() As Integer, ByVal create As Boolean) As Boolean
        ' Generate new Training File from Imported/Registered Words
        Dim niveaus(4) As Boolean
        Dim nivString As String
        Dim fromString As String
        Dim toString As String
        Dim conString As String
        Dim synString As String
        Dim thmString As String
        Dim tmpString As String
        Dim i As Integer
        Dim j As Integer

        ' Init
        wordlstcount = 0

        ' Import/Eingabe Woerter
        For i = 1 To countVocAdditional
            nivString = pubVocabularyAdd(i)._NivAdditional
            ' From and to Word
            fromString = ""
            toString = ""
            tmpString = ""
            For j = 1 To 2
                If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyAdd(i)._EspAdditional
                If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyAdd(i)._GerAdditional
                If (languages(j) = LangName.English) Then tmpString = pubVocabularyAdd(i)._EngAdditional
                If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyAdd(i)._FraAdditional
                If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyAdd(i)._SpaAdditional
                If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyAdd(i)._ItaAdditional
                If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyAdd(i)._DanAdditional
                If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyAdd(i)._SweAdditional
                If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyAdd(i)._PorAdditional
                If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyAdd(i)._GreAdditional
                If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyAdd(i)._RusAdditional
                If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyAdd(i)._PolAdditional
                If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyAdd(i)._CroAdditional
                If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyAdd(i)._AnyAdditional
                If (j = 1) Then
                    fromString = tmpString
                ElseIf (j = 2) Then
                    toString = tmpString
                End If
            Next
            conString = pubVocabularyAdd(i)._KonAdditional
            synString = pubVocabularyAdd(i)._SynAdditional
            thmString = pubVocabularyAdd(i)._ThmAdditional
            ' Leereintraege abweisen
            If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                ' Word Counter
                wordlstcount = wordlstcount + 1
                ' Daten erfassen
                exWordFrom.Add(fromString)
                exWordTo.Add(toString)
                exWordCon.Add(conString)
                exWordSyn.Add(synString)
                exWordType.Add("User Import")
                exWordTheme.Add(thmString)
                exWordTime.Add(0)
                exWordCount.Add(0)
                exWordScore.Add(0)
            End If

        Next

        ' Auswahl: Niveaus
        niveaus(1) = False
        niveaus(2) = False
        niveaus(3) = False
        niveaus(4) = False

        ' Anzahl selektierter Worte
        exSelected = wordlstcount
        ' Anzahl Bearbeitet, Punkte
        exDone = 0
        exScore = 0

        ' TrainFile Schreiben
        writeTrainFileAdd(trainfile, niveaus, languages)

        ' Meldung
        MsgBox("Training File with " & wordlstcount.ToString & " Words generated!", MsgBoxStyle.Information)


        ' Rueckgabe
        generateTrainFileAdd = True

    End Function

    Private Function writeTrainFileAdd(ByVal trainFile As String, ByVal niveaus() As Boolean, ByVal languages() As Integer) As Boolean
        ' Write Training File
        Dim trainDOM As New XmlDocument
        Dim data00DOM
        Dim data01DOM
        Dim data02DOM
        Dim root
        Dim node
        Dim node0
        Dim frag
        Dim elem
        Dim attr
        'Dim fid As Integer
        Dim i As Integer

        ' DOM-Baum Training File erzeugen
        ' Header - wichtig: UTF-8
        data00DOM = trainDOM.CreateXmlDeclaration("1.0", "UTF-8", "yes")
        trainDOM.AppendChild(data00DOM)
        data01DOM = trainDOM.CreateComment("Esperanto: Training")
        data02DOM = trainDOM.CreateComment("Esperanto: exercise")
        trainDOM.AppendChild(data01DOM)
        trainDOM.AppendChild(data02DOM)
        ' Wurzel-Element
        root = trainDOM.CreateElement("Esperanto")
        attr = trainDOM.CreateAttribute("xmlns:esp")
        attr.Value = "http://www.esperanto.de"
        root.setAttributeNode(attr)
        trainDOM.AppendChild(root)
        ' Ergebnisse
        root.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab))
        node = trainDOM.CreateElement("Results")
        ' ... gewaehlt
        frag = trainDOM.CreateDocumentFragment
        frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
        elem = trainDOM.CreateElement("Selected")
        elem.appendChild(trainDOM.CreateTextNode(exSelected))
        frag.appendChild(elem)
        node.appendChild(frag)
        ' ... bearbeitet
        frag = trainDOM.CreateDocumentFragment
        frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
        elem = trainDOM.CreateElement("Done")
        elem.appendChild(trainDOM.CreateTextNode(exDone))
        frag.appendChild(elem)
        node.appendChild(frag)
        ' ... Wertung
        frag = trainDOM.CreateDocumentFragment
        frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
        elem = trainDOM.CreateElement("Score")
        elem.appendChild(trainDOM.CreateTextNode(exScore))
        frag.appendChild(elem)
        node.appendChild(frag)
        ' ... Ende Ergebnisse
        node.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab))
        root.appendChild(node)
        ' Auswahl
        root.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab))
        node = trainDOM.CreateElement("Selections")
        ' ... Niveau A1
        frag = trainDOM.CreateDocumentFragment
        frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
        elem = trainDOM.CreateElement("NiveauA1")
        elem.appendChild(trainDOM.CreateTextNode(niveaus(1)))
        frag.appendChild(elem)
        node.appendChild(frag)
        ' ... Niveau A2
        frag = trainDOM.CreateDocumentFragment
        frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
        elem = trainDOM.CreateElement("NiveauA2")
        elem.appendChild(trainDOM.CreateTextNode(niveaus(2)))
        frag.appendChild(elem)
        node.appendChild(frag)
        ' ... Niveau B1
        frag = trainDOM.CreateDocumentFragment
        frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
        elem = trainDOM.CreateElement("NiveauB1")
        elem.appendChild(trainDOM.CreateTextNode(niveaus(3)))
        frag.appendChild(elem)
        node.appendChild(frag)
        ' ... Niveau B2
        frag = trainDOM.CreateDocumentFragment
        frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
        elem = trainDOM.CreateElement("NiveauB2")
        elem.appendChild(trainDOM.CreateTextNode(niveaus(4)))
        frag.appendChild(elem)
        node.appendChild(frag)
        ' ... Sprache von
        frag = trainDOM.CreateDocumentFragment
        frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
        elem = trainDOM.CreateElement("FromLang")
        elem.appendChild(trainDOM.CreateTextNode(languages(1)))
        frag.appendChild(elem)
        node.appendChild(frag)
        ' ... Sprache nach
        frag = trainDOM.CreateDocumentFragment
        frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
        elem = trainDOM.CreateElement("ToLang")
        elem.appendChild(trainDOM.CreateTextNode(languages(2)))
        frag.appendChild(elem)
        node.appendChild(frag)
        ' ... Ende Auswahl
        node.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab))
        root.appendChild(node)
        ' Wortliste
        node = trainDOM.CreateElement("Wordlist")
        root.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab))
        ' Woerter
        For i = 1 To wordlstcount
            ' Wort
            node.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            node0 = trainDOM.CreateElement("Word")
            ' ... Wort-von
            frag = trainDOM.CreateDocumentFragment
            frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab + vbTab))
            elem = trainDOM.CreateElement("WordFrom")
            elem.appendChild(trainDOM.CreateTextNode(exWordFrom(i - 1)))
            frag.appendChild(elem)
            node0.appendChild(frag)
            ' ... Wort-nach
            frag = trainDOM.CreateDocumentFragment
            frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab + vbTab))
            elem = trainDOM.CreateElement("WordTo")
            elem.appendChild(trainDOM.CreateTextNode(exWordTo(i - 1)))
            frag.appendChild(elem)
            node0.appendChild(frag)
            ' ... Wort-Kontext
            frag = trainDOM.CreateDocumentFragment
            frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab + vbTab))
            elem = trainDOM.CreateElement("WordCon")
            elem.appendChild(trainDOM.CreateTextNode(exWordCon(i - 1)))
            frag.appendChild(elem)
            node0.appendChild(frag)
            ' ... Wort-Synonym
            frag = trainDOM.CreateDocumentFragment
            frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab + vbTab))
            elem = trainDOM.CreateElement("WordSyn")
            elem.appendChild(trainDOM.CreateTextNode(exWordSyn(i - 1)))
            frag.appendChild(elem)
            node0.appendChild(frag)
            ' ... Wort-Typ
            frag = trainDOM.CreateDocumentFragment
            frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab + vbTab))
            elem = trainDOM.CreateElement("WordType")
            elem.appendChild(trainDOM.CreateTextNode(exWordType(i - 1)))
            frag.appendChild(elem)
            node0.appendChild(frag)
            ' ... Wort-Thema
            frag = trainDOM.CreateDocumentFragment
            frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab + vbTab))
            elem = trainDOM.CreateElement("WordTheme")
            elem.appendChild(trainDOM.CreateTextNode(exWordTheme(i - 1)))
            frag.appendChild(elem)
            node0.appendChild(frag)
            ' ... Wort-Zeitstempel
            frag = trainDOM.CreateDocumentFragment
            frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab + vbTab))
            elem = trainDOM.CreateElement("WordTime")
            elem.appendChild(trainDOM.CreateTextNode(exWordTime(i - 1)))
            frag.appendChild(elem)
            node0.appendChild(frag)
            ' ... Wort-Benutzung
            frag = trainDOM.CreateDocumentFragment
            frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab + vbTab))
            elem = trainDOM.CreateElement("WordCount")
            elem.appendChild(trainDOM.CreateTextNode(exWordCount(i - 1)))
            frag.appendChild(elem)
            node0.appendChild(frag)
            ' ... Wort-Bewertung
            frag = trainDOM.CreateDocumentFragment
            frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab + vbTab))
            elem = trainDOM.CreateElement("WordScore")
            elem.appendChild(trainDOM.CreateTextNode(exWordScore(i - 1)))
            frag.appendChild(elem)
            node0.appendChild(frag)
            ' ... Ende Wort
            node0.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            node.appendChild(node0)
        Next
        ' Ende Wortliste
        node.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab))
        root.appendChild(node)
        ' Ende Wurzel-Element
        root.appendChild(trainDOM.CreateTextNode(vbNewLine))

        ' Freigeben
        attr = Nothing
        elem = Nothing
        frag = Nothing
        node0 = Nothing
        node = Nothing
        root = Nothing
        data00DOM = Nothing
        data01DOM = Nothing
        data02DOM = Nothing

        ' Zugriff: DOM-Baum speichern
        trainDOM.Save(trainFile)


        ' Rueckgabe
        writeTrainFileAdd = True

    End Function


    Private Function initAdditional(ByVal arg As Integer) As Boolean
        ' Initialisation of the Data Structures of the Additional Vocabulary
        Dim tmpVocAdditional As New clsVocabularyAdd

        countVocAdditional = 0
        pubVocabularyAdd.Add(tmpVocAdditional)

    End Function

End Class