﻿Option Explicit On

' Translation of Sentences from 12 Languages to Esperanto
'
' Global Variables, Constants and Enumerations
' keep in mind:
' - die Schluesselwoerter der XML-Codierung der Grammatik sind zusammen mit den Konstanten aufgefuehrt;
'   diese Schluesselwoerter sind durchgehend in lateinischer Form
'
' MP Jun / Jul 2009: Program 1.0
' MP Sep / Dez 2009: Vocabulary 1.0
' ----------------------------------
' MP Mar / Jun 2010: Program 2.0
' MP Jan / Dez 2010: Vocabulary 2.0
' ----------------------------------
' MP Nov / Dez 2011: Program 3.0
' MP Jan / Dez 2012: Vocabulary 3.0
' ----------------------------------
' MP Mar / Dez 2014: Program 4.0
' MP Jan / Dez 2014: Vocabulary 4.0
' ----------------------------------
' MP Mar / Dez 2015: Program 5.0
' MP Apr / Dez 2016: Vocabulary 5.0
' ----------------------------------
' MP Mar / Dez 2016: Program 6.0
' MP Jan / Dez 2018: Vocabulary 6.0


Module Globals
    ' Global Variables and Constants

    ' Form
    Public frmEsperanto As Decaleon
    Public frmDictionary As FDictionary
    Public frmTrainer As FTrainer
    Public frmResults As FResults
    Public frmWordManager As FWordManager
    Public initDone As Boolean

    ' XML Vocabulary (UTF-8)
    Public pubVocabularyFile = "Vocabulary.xml"
    Public pubVocabularyFile2 = "VocaAddition.xml"
    Public pubVocabularyFile3 = "VocaAddition2.xml"
    Public pubVocabularyFile4 = "VocaAddition3.xml"
    Public pubVocabularyFile5 = "VocaCooccurr.xml"
    Public pubVocaLinkingFile = "VocaCoocLink.xml"
    Public pubVocabularyPro As New List(Of clsVocabularyPro)
    Public pubVocabularyNom As New List(Of clsVocabularyNom)
    Public pubVocabularyVer As New List(Of clsVocabularyVer)
    Public pubVocabularyAdv As New List(Of clsVocabularyAdv)
    Public pubVocabularyAdj As New List(Of clsVocabularyAdj)
    Public pubVocabularyPre As New List(Of clsVocabularyPre)
    Public pubVocabularyPar As New List(Of clsVocabularyPar)
    Public pubVocabularyJun As New List(Of clsVocabularyJun)
    Public pubVocabularyExp As New List(Of clsVocabularyExp)
    Public pubVocabularyCoo As New List(Of clsVocabularyCoo)
    Public pubSizePronomen(13) As Long      ' Anzahl Pronomen
    Public pubSizeNomen(13) As Long         ' Anzahl Nomen
    Public pubSizeVerb(13) As Long          ' Anzahl Verben
    Public pubSizeAdverb(13) As Long        ' Anzahl Adverbien
    Public pubSizeAdjective(13) As Long     ' Anzahl Adjektive
    Public pubSizePreposition(13) As Long   ' Anzahl Preapositionen
    Public pubSizeParticle(13) As Long      ' Anzahl Partikeln
    Public pubSizeJunction(13) As Long      ' Anzahl Junktionen
    Public pubSizeExpression(13) As Long    ' Anzahl Expressions
    Public pubSizeCooccurrence(13) As Long  ' Anzahl Cooccurrences
    Public pubSizeNiveau(6, 13) As Long     ' Anzahl Worte (niv, lang)
    Public pubVocabularyGrp As New List(Of clsVocabularyGrp)
    Public pubDimGroupMembers As Integer = 32

    ' Grammar-Structure
    Public pubDataGrammar As Grammar
    Public pubSizeSentence As Long = 3      ' Anzahl (Teil-)Saetze
    Public pubSizeSubject As Long = 9       ' Anzahl Subjekte
    Public pubSizePredicate As Long = 9     ' Anzahl Praedikate
    Public pubSizeObject As Long = 30       ' Anzahl Objekte
    Public pubSizeGJunction As Long = 3     ' Anzahl Junktionen
    Public pubSizeGParticle As Long = 3     ' Anzahl Partikeln
    Public pubSizeInterpunct As Long = 3    ' Anzahl Satzzeichen


    ' Description of the defined Keywords of the XML-Coding of the Grammar
    '
    ' Subjekt-Nominativ (SubNominativ)
    ' - Angabe des Subjekts in erster Person, Einzahl, 1. Fall bzw. als Pronomen oder Eigenname
    ' Preadikat-Infinitiv (PreInfinitiv)
    ' - Angabe des Praedikats als Verb oder als Hilfsverb
    ' Objekt-Nominativ (ObjNominativ)
    ' - Angabe des Objekts in erster Person, Einzahl, 1. Fall bzw. als Pronomen oder Eigenname
    ' Adjektiv (SubAdjektiv/ObjAdjektiv)
    ' - Angabe des Eigenschaftworts in erster Person, Einzahl
    ' Adverb (SubAdverb/PreAdverb/ObjAdverb)
    ' - Angabe des Umstandsworts in originaerer Form oder als Adjektiv (zur Ableitung) in erster Person, Einzahl
    ' Partizipial-Ergaenzung (SubPartizip/ObjPartizip)
    ' - Angabe des Verbs im Infinitiv, von dem das Partizip gebildet werden soll
    ' Praeposition (ObjPraeposition)
    ' - Angabe der Praeposition
    ' Duplikate / Doppelte Satzbestandteile (SubDuplikat/PreDuplikat/ObjDuplikat)
    ' - Angabe des Verbindungswortes vor dem zweiten bzw. folgenden Bestandteil (i.d.R. und, oder)
    ' Junktion (JunText)
    ' - Angabe des Verbindungswortes vor dem Teil-Satz (beiordnend: und; nebenordnend: nachdem, weil, etc.)
    ' Partikel (ParText)
    ' - Angabe des Partikels vor dem Teil-Satz (Antwortpartikeln: ja, nein) 
    ' Interpunktion / Satzzeichen (IntText)
    ' - Angabe des Satzzeichens nach dem Teil-Satz (./!/?/,)
    '
    ' Subjekt- bzw. Objekt-Typ (SubType/ObjType)
    ' - Schluesselwort fuer persoenliches Fuerwort                          Pronomen
    ' - Schluesselwort fuer Hauptwort                                       Nomen
    ' - Schluesselwort fuer Eigenname                                       Name
    ' Genus / Geschlecht (SubGenus/ObjGenus) - fuer Esperanto nicht relevant
    ' - Schluesselwort fuer maennlich (maskulinum)                          m
    ' - Schluesselwort fuer weiblich (femininum)                            f
    ' - Schluesselwort fuer saechlich (neutrum)                             n
    ' - Schluesselwort fuer unbestimmt (Pronomen)                           0
    ' Numerus / Anzahl (SubNumerus/PreNumerus/ObjNumerus)
    ' - Zahl fuer Einzahl                                                   1
    ' - Zahl fuer Mehrzahl                                                  2
    ' Kasus / Fall (ObjKasus)
    ' - Zahl fuer Genitiv                                                   2
    ' - Zahl fuer Dativ                                                     3
    ' - Zahl fuer Akkusativ                                                 4
    ' Artikel (SubArtikel/ObjArtikel)
    ' - Zahl fuer ohne Artikel (Pronomen, Eigenname)                        0
    ' - Zahl fuer mit Artikel (Nomen)                                       1
    ' Person (PrePerson) - fuer Esperanto nicht relevant
    ' - Zahl fuer die 1. Person                                             1
    ' - Zahl fuer die 2. Person                                             2
    ' - Zahl fuer die 3. Person                                             3
    ' Tempus / Zeit (PreTempus)
    ' - Schluesselwort fuer Gegenwart                                       Praesens
    ' - Schluesselwort fuer Vergangenheit                                   Praeteritum
    ' - Schluesselwort fuer Zukunft                                         Futur
    ' Modus / Aussageweise (PreModus)
    ' - Schluesselwort fuer Wirklichkeitsform                               Indikativ
    ' - Schluesselwort fuer Moeglichkeitsform                               Konjunktiv
    ' - Schluesselwort fuer Aufforderung                                    Imperativ
    ' GenusVerbi / Handlungsweise (PreGenusVerbi)
    ' - Schluesselwort fuer Taetigkeitsform                                 Aktiv
    ' - Schluesselwort fuer Leideform                                       Passiv
    ' - Schluesselwort fuer Hilfsverb-Begleiter                             Auxiliarcomes
    ' Spezifische Valenz (PreSpezValenz)
    ' - Schluesselwort fuer ohne Objekt-Ergaenzung                          Intransitiv
    ' - Schluesselwort fuer mit Objekt-Ergaenzung                           Transitiv
    ' - Schluesselwort fuer Rueckbezug                                      Reflexiv
    ' - Schluesselwort fuer Hilfsverb                                       Auxiliarum
    ' Adjektiv-Typ (SubAdjType/ObjAdjType)
    ' - Schluesselwort fuer gewoehnliches Adjektiv                          Normal
    ' - Schluesselwort fuer Possesiv-Pronomen                               Possesiv
    ' Adjektiv-Form (SubAdjKomp/ObjAdjKomp)
    ' - Schluesselwort fuer Grundform                                       Positiv
    ' - Schluesselwort fuer 1. Steigerung                                   Komparativ
    ' - Schluesselwort fuer 2. Steigerung                                   Superlativ
    ' Adverb-Typ (SubAdvType/PreAdvType/ObjAdvType)
    ' - Schluesselwort fuer originaeres Adverb                              Original
    ' - Schluesselwort fuer abgeleitetes Adverb (von Adjektiv)              Derivat
    ' Adverb-Form (SubAdvKomp/PreAdvType/ObjAdvKomp)
    ' - Schluesselwort fuer Grundform                                       Positiv
    ' - Schluesselwort fuer 1. Steigerung                                   Komparativ
    ' - Schluesselwort fuer 2. Steigerung                                   Superlativ
    ' Partzip-Tempus / Zeit (ParTemp)
    ' - Schluesselwort fuer Gegenwart                                       Praesens
    ' - Schluesselwort fuer Vergangenheit                                   Praeteritum
    ' - Schluesselwort fuer Zukunft                                         Futur
    ' Partzip-Modus / Aussageweise (ParMod)
    ' - Schluesselwort fuer Wirklichkeitsform                               Indikativ
    ' - Schluesselwort fuer Moeglichkeitsform                               Konjunktiv (nicht implementiert)
    ' Partzip-GenusVerbi / Handlungsweise (ParGenV)
    ' - Schluesselwort fuer Taetigkeitsform                                 Aktiv
    ' - Schluesselwort fuer Leideform                                       Passiv
    ' Junktionen-Typ (JunType) - wird nicht ausgewertet
    ' - Schluesselwort fuer beiordnenden Bezug                              Konjunktion
    ' - Schluesselwort fuer unterordnenden Bezug                            Subjunktion
    ' Partikel-Typ (ParType) - wird nicht ausgewertet
    ' - Schluesselwort fuer Antwortpartikel (Entscheidungsfrage)            Decision
    ' - Schluesselwort fuer Ausrufewoerter                                  Interjektion
    ' Satzzeichen-Typ (IntType) - wird nicht ausgewertet
    ' - Schluesselwort fuer Aussagesetz                                     Deklarativ
    ' - Schluesselwort fuer Aufforderungssatz                               Imperativ
    ' - Schluesselwort fuer Fragessatz                                      Interrogativ
    ' - Schluesselwort fuer Teil-Satz                                       Partitiv

    ' selected Language
    Public pubFromLanguage As Integer

    ' Constants
    ' Nomen
    Public Const pubEspNoArticle = ""           ' kein Artikel              0
    Public Const pubEspArticle = "la"           ' bestimmter Artikel        1
    Public Const pubEspSingular = ""            ' Singular - keine Zeichen  1
    Public Const pubEspPlural = "j"             ' Plural-Kennzeichen        2
    ' Kasi / Faelle
    Public Const pubEspNominative = ""          ' Nominativ - keine Zeichen 1
    Public Const pubEspGenitive = "de"          ' Genitiv-Kennzeichen       2
    Public Const pubEspDative = "al"            ' Dativ-Kennzeichen         3
    Public Const pubEspAccusative = "n"         ' Akkusativ-Kennzeichen     4
    ' Verben: Indikativ                                                     Indikativ
    Public Const pubEspIndPresent = "as"        ' Gegenwarts-Endung         Praesens
    Public Const pubEspIndPraeteritum = "is"    ' Imperfekt-Endung          Praeteritum
    Public Const pubEspIndFutur = "os"          ' FuturI-Endung             Futur
    ' Verben: Konjunktiv                                                    Konjunktiv
    Public Const pubEspKonPresent = "us"        ' Gegenwarts-Endung         Praesens
    Public Const pubEspKonPraeteritum = "us"    ' Imperfekt-Endung          Praeteritum
    Public Const pubEspKonFutur = "us"          ' FuturI-Endung             Futur
    ' Verben: Imperativ
    Public Const pubEspImpImperative = "u"      ' Imperativ-Endung           Imperativ
    ' Verben: Partizip Aktiv                                                Partizip
    Public Const pubEspParAktiPresent = "anta"     ' Gegenwarts-Endung         Praesens
    Public Const pubEspParAktiPraeteritum = "inta" ' Imperfekt-Endung          Praeteritum
    Public Const pubEspParAktiFutur = "onta"       ' FuturI-Endung             Futur
    ' Verben: Partizip Passiv                                               Passiv
    Public Const pubEspParPassPresent = "ata"      ' Gegenwarts-Endung         Praesens
    Public Const pubEspParPassPraeteritum = "ita"  ' Imperfekt-Endung          Praeteritum
    Public Const pubEspParPassFutur = "ota"        ' FuturI-Endung             Futur
    ' Adjektive
    Public Const pubEspAdjPositive = ""         ' Positiv - kein Zeichen    Positiv
    Public Const pubEspAdjKomparative = "pli"   ' Komparativ-Kennzeichen    Komparativ
    Public Const pubEspAdjSuperlative = "plej"  ' Superlativ-Kennzeichen    Superlativ
    ' Adverbien
    Public Const strEspAdvOriginal = ""         ' originaeres Adverb        Original
    Public Const strEspAdvDerivat = "e"         ' abgeleitetes Adverb       Derivat
    Public Const pubEspAdvPositive = ""         ' Positiv - kein Zeichen    Positiv
    Public Const pubEspAdvKomparative = "pli"   ' Komparativ-Kennzeichen    Komparativ
    Public Const pubEspAdvSuperlative = "plej"  ' Superlativ-Kennzeichen    Superlativ

    ' Special Letters from Orion Esperanto
    Public Const strklCdach = ChrW(164)
    Public Const strklGdach = ChrW(223)
    Public Const strklHdach = ChrW(167)
    Public Const strklJdach = ChrW(162)
    Public Const strklSdach = ChrW(217)
    Public Const strklUdach = ChrW(170)
    Public Const strgrCdach = ChrW(195)
    Public Const strgrGdach = ChrW(207)
    Public Const strgrHdach = ChrW(176)
    Public Const strgrJdach = ChrW(165)
    Public Const strgrSdach = ChrW(163)
    Public Const strgrUdach = ChrW(186)
    ' unzip eve-ttf.zip and copy the four Orion-TTFs on C:\Windows\Fonts
    Public Const pubFontRoot = "C:\Windows\Fonts\"
    Public Const pubFont1 = "Orion.ttf"
    Public Const pubFont2 = "Oriond.ttf"
    Public Const pubFont3 = "Oriondk.ttf"
    Public Const pubFont4 = "Orionk.ttf"

    ' Grammar Terms in the Languages
    Public pubTermSentence(13) As String
    Public pubTermJunction(13) As String
    Public pubTermParticle(13) As String
    Public pubTermSubject(13) As String
    Public pubTermPredicate(13) As String
    Public pubTermObject(13) As String
    Public pubTermInterpunction(13) As String
    Public pubTermQualities(13) As String
    Public pubTermType(13) As String
    Public pubTermGender(13) As String
    Public pubTermNumber(13) As String
    Public pubTermCase(13) As String
    Public pubTermArticle(13) As String
    Public pubTermPreposition(13) As String
    Public pubTermDouble(13) As String
    Public pubTermAdjective(13) As String
    Public pubTermAdverb(13) As String
    Public pubTermComparison(13) As String
    Public pubTermParticipe(13) As String
    Public pubTermPerson(13) As String
    Public pubTermTime(13) As String
    Public pubTermMode(13) As String
    Public pubTermGenusVerbi(13) As String
    Public pubTermSpecValence(13) As String

    ' Affixes in the Languages
    Public pubLanguage(13) As String
    ' Deutsch
    Public pubDeuNomen(20) As String
    Public pubDeuVerb(10) As String
    Public pubDeuAdj(20) As String
    ' English
    Public pubEngNomen(20) As String
    Public pubEngVerb(10) As String
    Public pubEngAdj(20) As String
    ' Francais
    Public pubFraNomen(20) As String
    Public pubFraVerb(10) As String
    Public pubFraAdj(20) As String
    ' Espanol
    Public pubSpaNomen(20) As String
    Public pubSpaVerb(10) As String
    Public pubSpaAdj(20) As String
    ' Italiano
    Public pubItaNomen(20) As String
    Public pubItaVerb(10) As String
    Public pubItaAdj(20) As String
    ' Portoguese
    Public pubPorNomen(20) As String
    Public pubPorVerb(10) As String
    Public pubPorAdj(20) As String
    ' Dansk
    Public pubDanNomen(20) As String
    Public pubDanVerb(10) As String
    Public pubDanAdj(20) As String
    ' Svenska
    Public pubSweNomen(20) As String
    Public pubSweVerb(10) As String
    Public pubSweAdj(20) As String
    ' Ellenika
    Public pubGreNomen(20) As String
    Public pubGreVerb(10) As String
    Public pubGreAdj(20) As String
    ' Russkij
    Public pubRusNomen(20) As String
    Public pubRusVerb(10) As String
    Public pubRusAdj(20) As String
    ' Polski
    Public pubPolNomen(20) As String
    Public pubPolVerb(10) As String
    Public pubPolAdj(20) As String
    ' Hrvatski
    Public pubCroNomen(20) As String
    Public pubCroVerb(10) As String
    Public pubCroAdj(20) As String

    ' TreeView Nodes
    Public pubActiveNumber As Integer
    Public pubActiveNode As TreeNode
    Public pubActiveNodeType As EleType
    Public sentenceNode(pubSizeSentence) As TreeNode
    Public subjectNode(pubSizeSubject) As TreeNode
    Public predicateNode(pubSizePredicate) As TreeNode
    Public objectNode(pubSizeObject) As TreeNode
    Public gJunctionNode(pubSizeGJunction) As TreeNode
    Public gParticleNode(pubSizeGParticle) As TreeNode
    Public interpunctNode(pubSizeInterpunct) As TreeNode
    Public sComponentNode(pubSizeSubject, 5) As TreeNode
    Public pComponentNode(pubSizePredicate, 5) As TreeNode
    Public oComponentNode(pubSizeObject, 5) As TreeNode

    ' Directories
    Public pubDirFlagIcons = Application.StartupPath & "\" & "FlagIcons"
    Public pubDirImportFiles = Application.StartupPath & "\" & "ImportFiles"

    ' Import/Flag Information
    Public pubImpLang As String
    Public pubFlagInfo(2, 99) As String

    ' Vocabulary Extensions
    Public pubVocabularyExt = "VocaExtensions.xml"
    Public pubVocExtAvail(20) As Integer
    Public pubVocExtNames(20) As String
    Public pubSizeBasPronomen As Integer
    Public pubSizeBasNomen As Integer
    Public pubSizeBasVerb As Integer
    Public pubSizeBasAdverb As Integer
    Public pubSizeBasAdjective As Integer
    Public pubSizeBasPreposition As Integer
    Public pubSizeBasParticle As Integer
    Public pubSizeBasJunction As Integer
    Public pubSizeBasExpression As Integer
    Public pubSizeBasCooccurrence As Integer

    ' Enumerations
    ' Word-Types
    Enum WordType
        Nomen = 11
        Pronomen = 12
        Name = 13
        Verb = 20
        Article = 30
        Adjective = 40
        Preposition = 50
        Adverb = 60
        Particle = 70
        Junction = 80
        Expression = 90
        Cooccurrence = 100
    End Enum

    ' Languages
    Enum LangName
        Esperanto = 0
        Deutsch = 1
        English = 2
        Francais = 3
        Espanol = 4
        Italiano = 5
        Portoguese = 6
        Dansk = 7
        Svenska = 8
        Ellenika = 9
        Russkij = 10
        Polski = 11
        Hrvatski = 12
        AnyLang = 13
    End Enum

    ' Element-Types
    Enum EleType
        Sentence = 0
        Subject = 1
        SubjectProperties = 10
        SubjectAdjective = 11
        SubjectAdverb = 12
        SubjectParticipe = 13
        Predicate = 2
        PredicateProperties = 20
        PredicateAdverb = 21
        Objekt = 3
        ObjectProperties = 30
        ObjectAdjective = 31
        ObjectAdverb = 32
        ObjectParticipe = 33
        Junction = 4
        Particle = 5
        Interpunctuation = 6
    End Enum

    ' Vocabulary Extensions
    Enum VocExt
        EA = 1
        EB = 2
        EC = 3
        ED = 4
        EE = 5
        EG = 6
        EH = 7
        EI = 8
        EJ = 9
        EK = 10
        EL = 11
        EM = 12
        EP = 13
        ER = 14
        ES = 15
        ET = 16
        EU = 17
        EW = 18
        EY = 19
        EZ = 20
    End Enum


    ' Vocabulary Trainer
    Public pubTrainerStart As Boolean

    ' Additional Vocabulary
    Public pubVocabularyAdd As New List(Of clsVocabularyAdd)

    Public countVocAdditional As Long
    Public Class clsVocabularyAdd
        Public _NivAdditional As String
        Public _ThmAdditional As String
        Public _GerAdditional As String
        Public _EspAdditional As String
        Public _EngAdditional As String
        Public _FraAdditional As String
        Public _SpaAdditional As String
        Public _ItaAdditional As String
        Public _PorAdditional As String
        Public _DanAdditional As String
        Public _SweAdditional As String
        Public _GreAdditional As String
        Public _RusAdditional As String
        Public _PolAdditional As String
        Public _CroAdditional As String
        Public _SynAdditional As String
        Public _KonAdditional As String
        Public _AnyAdditional As String
    End Class

End Module
