/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus;

import com.extendedclip.deluxemenus.DeluxeMenusCommands;
import com.extendedclip.deluxemenus.Expansion;
import com.extendedclip.deluxemenus.NewerPlayerListener;
import com.extendedclip.deluxemenus.PlayerListener;
import com.extendedclip.deluxemenus.config.DeluxeMenusConfig;
import com.extendedclip.deluxemenus.hooks.BaseHeadHook;
import com.extendedclip.deluxemenus.hooks.HeadDatabaseHook;
import com.extendedclip.deluxemenus.hooks.HeadsHook;
import com.extendedclip.deluxemenus.hooks.ItemHook;
import com.extendedclip.deluxemenus.hooks.VaultHook;
import com.extendedclip.deluxemenus.menu.Menu;
import com.extendedclip.deluxemenus.menu.requirement.JavascriptRequirement;
import com.extendedclip.deluxemenus.metrics.Metrics;
import com.extendedclip.deluxemenus.nms.NMS;
import com.extendedclip.deluxemenus.updatechecker.UpdateChecker;
import com.extendedclip.deluxemenus.utils.StringUtils;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DeluxeMenus
extends JavaPlugin {
    private static DeluxeMenus instance;
    private DeluxeMenusConfig menuConfig;
    private UpdateChecker updateChecker;
    private NMS nms;
    private DecimalFormat df;
    private Map<String, ItemHook> itemHooks;
    private static boolean debug;
    private VaultHook vaultHook;
    private boolean checkUpdates;
    private ItemStack head;

    public void onLoad() {
        this.nms = new NMS();
        this.nms.setupAccessor();
    }

    public void onEnable() {
        if (this.hookPlaceholderAPI()) {
            try {
                this.head = new ItemStack(Material.PLAYER_HEAD, 1);
            }
            catch (Throwable t) {
                this.head = new ItemStack(Material.valueOf((String)"SKULL_ITEM"), 1, 3);
            }
            this.getLogger().info("Hooked into PlaceholderAPI!");
            instance = this;
            this.menuConfig = new DeluxeMenusConfig(this);
            if (this.menuConfig.loadDefConfig()) {
                debug = this.menuConfig.debug();
                this.getLogger().info(this.menuConfig.loadGUIMenus() + " GUI menus loaded!");
                this.checkUpdates = this.getConfig().getBoolean("check_updates");
            } else {
                this.getLogger().warning("Failed to load from config.yml. Use /dm reload after fixing your errors.");
            }
            new PlayerListener(this);
            new DeluxeMenusCommands(this);
            Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "BungeeCord");
            if (this.checkUpdates) {
                this.updateChecker = new UpdateChecker(this);
                if (this.updateChecker.updateAvailable()) {
                    this.getLogger().info("An update for DeluxeMenus (DeluxeMenus v" + this.updateChecker.getLatestVersion() + ")");
                    this.getLogger().info("is available at https://www.spigotmc.org/resources/deluxemenus.11734/");
                } else {
                    this.getLogger().info("You are running the latest version of DeluxeMenus!");
                }
            }
            this.setupItemHooks();
            if (Bukkit.getPluginManager().getPlugin("Vault") != null) {
                this.vaultHook = new VaultHook();
                if (this.vaultHook.hooked()) {
                    this.getLogger().info("Successfully hooked into Vault for economy requirement!");
                }
            }
            this.getLogger().info(this.nms.isAvailable() ? "NMS hook has been setup" : "Could not setup a NMS hook for your server version!");
            this.startMetrics();
            if (this.nms.isAvailable()) {
                new NewerPlayerListener(this);
            }
            new Expansion(this).register();
        } else {
            this.getLogger().severe("Could not hook into PlaceholderAPI!");
            this.getLogger().severe("DeluxeMenus will now disable!");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
    }

    private void setupItemHooks() {
        this.itemHooks = new HashMap<String, ItemHook>();
        if (PlaceholderAPIPlugin.getServerVersion().isSpigot()) {
            this.itemHooks.put("basehead", new BaseHeadHook());
        }
        if (Bukkit.getPluginManager().getPlugin("HeadDatabase") != null) {
            this.itemHooks.put("hdb", new HeadDatabaseHook());
        }
        if (Bukkit.getPluginManager().getPlugin("Heads") != null) {
            this.itemHooks.put("heads", new HeadsHook());
        }
    }

    public void addItemHook(String id, ItemHook hook) {
        this.itemHooks.put(id, hook);
    }

    public boolean removeItemHook(String id) {
        return this.itemHooks.remove(id) != null;
    }

    public ItemHook getItemHook(String id) {
        return this.itemHooks.get(id);
    }

    public ItemStack getHead() {
        return this.head != null ? this.head : new ItemStack(Material.DIRT, 1);
    }

    private void startMetrics() {
        Metrics metrics = new Metrics((Plugin)this, 445);
        metrics.addCustomChart(new Metrics.SingleLineChart("menus", Menu::getLoadedMenuSize));
    }

    public void onDisable() {
        Bukkit.getMessenger().unregisterOutgoingPluginChannel((Plugin)this, "BungeeCord");
        Bukkit.getScheduler().cancelTasks((Plugin)this);
        Menu.unloadForShutdown();
        JavascriptRequirement.setEngine(null);
        this.itemHooks.clear();
        instance = null;
        this.df = null;
    }

    public void connect(Player p, String server) {
        ByteArrayDataOutput out = ByteStreams.newDataOutput();
        try {
            out.writeUTF("Connect");
            out.writeUTF(server);
        }
        catch (Exception e) {
            this.getLogger().warning("There was a problem attempting to send " + p.getName() + " to server " + server + "!");
        }
        p.sendPluginMessage((Plugin)this, "BungeeCord", out.toByteArray());
    }

    public static DeluxeMenus getInstance() {
        return instance;
    }

    private boolean hookPlaceholderAPI() {
        return Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI");
    }

    protected DeluxeMenusConfig getConfiguration() {
        return this.menuConfig;
    }

    public void sms(CommandSender s, String msg) {
        s.sendMessage(StringUtils.color(msg));
    }

    public UpdateChecker getUpdateChecker() {
        return this.updateChecker;
    }

    public NMS getNms() {
        return this.nms;
    }

    public DecimalFormat getDecimalFormat() {
        if (this.df != null) {
            return this.df;
        }
        this.df = new DecimalFormat("#.##");
        this.df.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.US));
        return this.df;
    }

    public static boolean isDebug() {
        return debug;
    }

    public static void setDebug(boolean debug) {
        DeluxeMenus.debug = debug;
    }

    public VaultHook getVault() {
        return this.vaultHook;
    }
}

