/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus;

import com.extendedclip.deluxemenus.ClickActionTask;
import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.config.DeluxeMenusConfig;
import com.extendedclip.deluxemenus.menu.ActionType;
import com.extendedclip.deluxemenus.menu.ClickAction;
import com.extendedclip.deluxemenus.menu.Menu;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class DeluxeMenusCommands
implements CommandExecutor {
    private final DeluxeMenus plugin;

    public DeluxeMenusCommands(DeluxeMenus plugin) {
        this.plugin = plugin;
        this.plugin.getCommand("deluxemenus").setExecutor((CommandExecutor)this);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 0) {
            this.plugin.sms(sender, "&6&lDeluxe&eMenus &fversion &e" + this.plugin.getDescription().getVersion());
            this.plugin.sms(sender, "&7Created by &f" + String.join((CharSequence)"&7,&f", this.plugin.getDescription().getAuthors()));
            return true;
        }
        if (args[0].equalsIgnoreCase("help")) {
            this.plugin.sms(sender, "&6&lDeluxe&eMenus &fhelp");
            this.plugin.sms(sender, "&b>  &f/dm open <menuName> (player)");
            this.plugin.sms(sender, "&b>  &f/dm list");
            if (sender.hasPermission("deluxemenus.admin")) {
                this.plugin.sms(sender, "&b>  &f/dm execute <player> <action>");
                this.plugin.sms(sender, "&b>  &f/dm reload");
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("execute")) {
            if (!sender.isOp()) {
                this.plugin.sms(sender, "&cYou don't have permission to do that!");
                return true;
            }
            if (args.length < 3) {
                this.plugin.sms(sender, "/dm execute <player> <action>");
                return true;
            }
            if (Bukkit.getPlayer((String)args[1]) == null) {
                this.plugin.sms(sender, "&cPlayer: &f" + args[1] + " &cis not online!");
                return true;
            }
            String executable = String.join((CharSequence)" ", Arrays.asList(args).subList(2, args.length));
            Player target = Bukkit.getPlayer((String)args[1]);
            ActionType type = ActionType.getType(executable);
            if (type == null) {
                this.plugin.sms(sender, "&cAction type specified does not exist!");
                return true;
            }
            if ((executable = executable.replace(type.getIdentifier(), "")).startsWith(" ")) {
                executable = executable.trim();
            }
            int delay = 0;
            Matcher d = DeluxeMenusConfig.DELAY_MATCHER.matcher(executable);
            if (d.find()) {
                delay = Integer.parseInt(d.group(3));
                executable = executable.replaceAll(d.group(), "");
            }
            ClickAction action = delay > 0 ? new ClickAction(type, executable, delay) : new ClickAction(type, executable);
            Matcher ch = DeluxeMenusConfig.CHANCE_MATCHER.matcher(executable);
            if (ch.find()) {
                action.setChance(Double.parseDouble(ch.group(3)));
                executable = executable.replaceAll(ch.group(), "");
                action.setExecutable(executable);
            }
            if (!action.checkChance()) {
                this.plugin.sms(sender, "&cThe chance for this action determined the action should not execute!");
                return true;
            }
            String ex = PlaceholderAPI.setPlaceholders((Player)target, (String)action.getExecutable());
            if (action.hasDelay()) {
                new ClickActionTask(target.getName(), action.getType(), ex).runTaskLater((Plugin)this.plugin, action.getDelay());
                this.plugin.sms(sender, "&aAction set to be executed in " + action.getDelay() + " ms.");
                return true;
            }
            new ClickActionTask(target.getName(), action.getType(), ex).runTask((Plugin)this.plugin);
            this.plugin.sms(sender, "&aAction executed for player: " + target.getName());
            return true;
        }
        if (args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("deluxemenus.reload")) {
                this.plugin.sms(sender, "&cYou don't have permission to do that!");
                return true;
            }
            if (this.plugin.getConfiguration().checkConfig(null, "config.yml", false) == null) {
                this.plugin.sms(sender, "&cErrors detected in config.yml. Failed to reload.");
                return true;
            }
            this.plugin.reloadConfig();
            this.plugin.saveConfig();
            Menu.unload();
            this.plugin.getConfiguration().loadGUIMenus();
            this.plugin.sms(sender, "&6&lDeluxe&eMenus &asuccessfully reloaded!");
            int gLoaded = Menu.getLoadedMenuSize();
            if (gLoaded == 1) {
                this.plugin.sms(sender, gLoaded + " &emenu loaded...");
            } else {
                this.plugin.sms(sender, gLoaded + " &emenus loaded...");
            }
        } else {
            if (args[0].equalsIgnoreCase("list")) {
                if (!sender.hasPermission("deluxemenus.list")) {
                    this.plugin.sms(sender, "&cYou don't have permission to do that!");
                    return true;
                }
                Collection<Menu> menus = Menu.getAllMenus();
                if (menus == null || menus.isEmpty()) {
                    this.plugin.sms(sender, "&7No menus loaded..");
                    return true;
                }
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (Menu menu : menus) {
                    if (first) {
                        first = false;
                        sb.append("&f");
                        sb.append(menu.getName());
                        continue;
                    }
                    sb.append("&b, &f");
                    sb.append(menu.getName());
                }
                this.plugin.sms(sender, sb.toString());
                return true;
            }
            if (args[0].equalsIgnoreCase("open")) {
                Menu menu;
                boolean player = sender instanceof Player;
                if (args.length < 2) {
                    this.plugin.sms(sender, "&cIncorrect usage! &7/dm open <menuName> (player)");
                    return true;
                }
                if (Menu.getAllMenus() == null || Menu.getAllMenus().isEmpty()) {
                    this.plugin.sms(sender, "&cThere are no menus loaded!");
                    return true;
                }
                Player viewer = null;
                String placeholderPlayer = null;
                for (String arg : args) {
                    if (!arg.startsWith("-p:")) continue;
                    if (!sender.hasPermission("deluxemenus.placeholdersfor")) {
                        this.plugin.sms(sender, "&cYou don't have permission to use the argument -p:<player>!");
                        return true;
                    }
                    placeholderPlayer = arg.replace("-p:", "");
                }
                if (args.length >= 3) {
                    if (placeholderPlayer == null) {
                        if (player && !sender.hasPermission("deluxemenus.open.others")) {
                            this.plugin.sms(sender, "&cYou don't have permission to do that!");
                            return true;
                        }
                        viewer = Bukkit.getPlayer((String)args[2]);
                    } else {
                        if (!player) {
                            this.plugin.sms(sender, "&cYou must specify a player to open a menu for!");
                            return true;
                        }
                        viewer = (Player)sender;
                    }
                } else {
                    if (!player) {
                        this.plugin.sms(sender, "&cYou must specify a player to open a menu for!");
                        return true;
                    }
                    viewer = (Player)sender;
                }
                if (viewer == null) {
                    this.plugin.sms(sender, args[2] + " &cis not online!");
                    return true;
                }
                if (placeholderPlayer != null) {
                    Player placeholder = Bukkit.getServer().getPlayer(placeholderPlayer);
                    if (placeholder == null) {
                        this.plugin.sms(sender, placeholderPlayer + " &cis not online!");
                        return true;
                    }
                    if (placeholder.hasPermission("deluxemenus.placeholdersfor.exempt")) {
                        this.plugin.sms(sender, placeholder.getName() + " &7is exempt from placeholder target arguments");
                        return true;
                    }
                }
                if ((menu = Menu.getMenu(args[1])) == null) {
                    this.plugin.sms(sender, args[1] + " &cis not a valid menu!");
                    return true;
                }
                menu.openMenu(viewer);
                return true;
            }
            this.plugin.sms(sender, "&cIncorrect usage! Use &7/dm help");
        }
        return true;
    }
}

