/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.menu.Menu;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.menu.MenuItem;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class PlayerListener
implements Listener {
    private final DeluxeMenus plugin;

    public PlayerListener(DeluxeMenus plugin) {
        this.plugin = plugin;
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onCommandExecute(PlayerCommandPreprocessEvent event) {
        String cmd = event.getMessage().substring(1);
        Menu menu = Menu.getMenuByCommand(cmd.toLowerCase());
        if (menu == null) {
            return;
        }
        if (menu.registersCommand()) {
            return;
        }
        Player player = event.getPlayer();
        menu.openMenu(player);
        event.setCancelled(true);
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (Menu.inMenu(player)) {
            Menu.closeMenu(player, false);
        }
    }

    @EventHandler
    public void onOpen(InventoryOpenEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (player.isSleeping()) {
            event.setCancelled(true);
        }
        if (Menu.inMenu(player)) {
            Menu.closeMenu(player, true);
        }
    }

    @EventHandler
    public void onDrop(PlayerDropItemEvent event) {
        if (DeluxeMenus.getInstance().getNms().isAvailable() && DeluxeMenus.getInstance().getNms().getAccessor().hasTag(event.getItemDrop().getItemStack(), "DM")) {
            event.getItemDrop().remove();
        }
    }

    @EventHandler
    public void onClose(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        if (Menu.inMenu(player)) {
            Menu.closeMenu(player, false);
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                Menu.cleanInventory(player);
                player.updateInventory();
            }, 3L);
        }
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onClick(InventoryClickEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        MenuHolder holder = Menu.getMenuHolder(player);
        if (holder == null) {
            return;
        }
        if (holder.getMenu() == null) {
            Menu.closeMenu(player, true);
        }
        event.setCancelled(true);
        if (holder.isUpdating()) {
            return;
        }
        int slot = event.getRawSlot();
        MenuItem item = holder.getItem(slot);
        if (item == null || holder.getInventory().getItem(slot) == null) {
            return;
        }
        if (event.isShiftClick() && event.isLeftClick() && item.getShiftLeftClickHandler() != null) {
            if (item.getShiftLeftClickRequirements() != null && !item.getShiftLeftClickRequirements().evaluate(holder)) {
                if (item.getShiftLeftClickRequirements().getDenyHandler() != null) {
                    item.getShiftLeftClickRequirements().getDenyHandler().onClick(holder);
                }
                return;
            }
            item.getShiftLeftClickHandler().onClick(holder);
        } else if (event.isShiftClick() && event.isRightClick() && item.getShiftRightClickHandler() != null) {
            if (item.getShiftRightClickRequirements() != null && !item.getShiftRightClickRequirements().evaluate(holder)) {
                if (item.getShiftRightClickRequirements().getDenyHandler() != null) {
                    item.getShiftRightClickRequirements().getDenyHandler().onClick(holder);
                }
                return;
            }
            item.getShiftRightClickHandler().onClick(holder);
        } else if (event.getClick() == ClickType.LEFT && item.getLeftClickHandler() != null) {
            if (item.getLeftClickRequirements() != null && !item.getLeftClickRequirements().evaluate(holder)) {
                if (item.getLeftClickRequirements().getDenyHandler() != null) {
                    item.getLeftClickRequirements().getDenyHandler().onClick(holder);
                }
                return;
            }
            item.getLeftClickHandler().onClick(holder);
        } else if (event.getClick() == ClickType.RIGHT && item.getRightClickHandler() != null) {
            if (item.getRightClickRequirements() != null && !item.getRightClickRequirements().evaluate(holder)) {
                if (item.getRightClickRequirements().getDenyHandler() != null) {
                    item.getRightClickRequirements().getDenyHandler().onClick(holder);
                }
                return;
            }
            item.getRightClickHandler().onClick(holder);
        } else if (event.getClick() == ClickType.MIDDLE && item.getMiddleClickHandler() != null) {
            if (item.getMiddleClickRequirements() != null && !item.getMiddleClickRequirements().evaluate(holder)) {
                if (item.getMiddleClickRequirements().getDenyHandler() != null) {
                    item.getMiddleClickRequirements().getDenyHandler().onClick(holder);
                }
                return;
            }
            item.getMiddleClickHandler().onClick(holder);
        }
    }
}

