/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.config;

import com.extendedclip.deluxemenus.ClickActionTask;
import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.menu.ActionType;
import com.extendedclip.deluxemenus.menu.ClickAction;
import com.extendedclip.deluxemenus.menu.ClickHandler;
import com.extendedclip.deluxemenus.menu.Menu;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.menu.MenuItem;
import com.extendedclip.deluxemenus.menu.requirement.HasItemRequirement;
import com.extendedclip.deluxemenus.menu.requirement.HasMetaRequirement;
import com.extendedclip.deluxemenus.menu.requirement.HasMoneyRequirement;
import com.extendedclip.deluxemenus.menu.requirement.HasPermissionRequirement;
import com.extendedclip.deluxemenus.menu.requirement.InputResultRequirement;
import com.extendedclip.deluxemenus.menu.requirement.IsNearRequirement;
import com.extendedclip.deluxemenus.menu.requirement.JavascriptRequirement;
import com.extendedclip.deluxemenus.menu.requirement.RegexMatchesRequirement;
import com.extendedclip.deluxemenus.menu.requirement.Requirement;
import com.extendedclip.deluxemenus.menu.requirement.RequirementList;
import com.extendedclip.deluxemenus.menu.requirement.RequirementType;
import com.extendedclip.deluxemenus.utils.LocationUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class DeluxeMenusConfig {
    public static final java.util.regex.Pattern DELAY_MATCHER = java.util.regex.Pattern.compile("([<])([delay=]+)([0-9]+)([>])");
    public static final java.util.regex.Pattern CHANCE_MATCHER = java.util.regex.Pattern.compile("([<])([chance=]+)([0-9]+[.]?[0-9]*)([>])");
    private final File menuDirectory;
    private final DeluxeMenus plugin;
    private final List<String> exampleMenus = Arrays.asList("basics_menu", "advanced_menu", "requirements_menu");

    public DeluxeMenusConfig(DeluxeMenus plugin) {
        this.plugin = plugin;
        this.menuDirectory = new File(this.plugin.getDataFolder() + File.separator + "gui_menus");
        try {
            if (!this.menuDirectory.exists()) {
                this.menuDirectory.mkdirs();
                this.plugin.getLogger().warning("Directory did not exist for loading menus from individual files!");
                this.plugin.getLogger().info("Creating directory: plugins" + File.separator + "DeluxeMenus" + File.separator + "gui_menus");
            }
        }
        catch (SecurityException e) {
            this.plugin.getLogger().severe("Could not create directory: plugins" + File.separator + "DeluxeMenus" + File.separator + "gui_menus");
        }
    }

    public boolean loadDefConfig() {
        if (this.checkConfig(null, "config.yml", true) == null) {
            return false;
        }
        FileConfiguration c = this.plugin.getConfig();
        c.options().header("DeluxeMenus " + this.plugin.getDescription().getVersion() + " main configuration file\n\nA full wiki on how to use this plugin can be found at:\nhttps://github.com/help-chat/DeluxeMenus/wiki\n");
        c.addDefault("debug", (Object)false);
        c.addDefault("check_updates", (Object)true);
        c.options().copyDefaults(true);
        if (!c.contains("gui_menus")) {
            this.createMenuExamples(c);
        } else {
            this.plugin.saveConfig();
            this.plugin.reloadConfig();
        }
        return true;
    }

    private void createMenuExamples(FileConfiguration c) {
        for (String name : this.exampleMenus) {
            File menuFile = new File(this.menuDirectory.getPath(), name + ".yml");
            try {
                menuFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            this.saveResourceToFile(name + ".yml", menuFile);
            c.set("gui_menus." + name + ".file", (Object)menuFile.getName());
        }
        this.plugin.saveConfig();
        this.plugin.reloadConfig();
    }

    private boolean saveResourceToFile(String resource, File file) {
        try {
            InputStream is = this.plugin.getResource(resource);
            byte[] buffer = new byte[is.available()];
            is.read(buffer);
            FileOutputStream os = new FileOutputStream(file);
            ((OutputStream)os).write(buffer);
            return true;
        }
        catch (IOException | NullPointerException ex) {
            ex.printStackTrace();
            this.plugin.getLogger().severe("Failed to save default settings for:" + file.getName() + " from resource:" + resource);
            return false;
        }
    }

    public FileConfiguration checkConfig(String folder, String fileName, boolean create) {
        File dir = folder != null ? new File(this.plugin.getDataFolder() + File.separator + folder + File.separator) : new File(this.plugin.getDataFolder() + File.separator);
        try {
            if (!dir.exists()) {
                return null;
            }
        }
        catch (SecurityException e) {
            return null;
        }
        File configFile = new File(dir.getPath(), fileName);
        if (create) {
            try {
                configFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (!configFile.exists()) {
            return null;
        }
        return this.checkConfig(configFile);
    }

    private FileConfiguration checkConfig(File f) {
        YamlConfiguration config = new YamlConfiguration();
        try {
            config.load(f);
            return config;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        catch (InvalidConfigurationException e) {
            this.plugin.getLogger().warning("Detected invalid configuration in file: " + f.getName());
            e.printStackTrace();
            return null;
        }
    }

    public int loadGUIMenus() {
        if (this.checkConfig(null, "config.yml", false) == null) {
            return 0;
        }
        FileConfiguration c = this.plugin.getConfig();
        if (!c.contains("gui_menus")) {
            return 0;
        }
        if (!c.isConfigurationSection("gui_menus")) {
            return 0;
        }
        Set keys = c.getConfigurationSection("gui_menus").getKeys(false);
        if (keys == null || keys.isEmpty()) {
            return 0;
        }
        for (String key : keys) {
            if (c.contains("gui_menus." + key + ".file")) {
                this.loadMenuFromFile(key);
                continue;
            }
            this.loadMenu(c, key, true);
        }
        return Menu.getLoadedMenuSize();
    }

    public boolean loadMenuFromFile(String menuName) {
        FileConfiguration cfg;
        String fileName = this.plugin.getConfig().getString("gui_menus." + menuName + ".file");
        if (!fileName.endsWith(".yml")) {
            this.plugin.getLogger().warning("Filename specified for menu: " + menuName + " is not a .yml file!");
            this.plugin.getLogger().info("Make sure that the file name to load this menu from is specified as a .yml file!");
            this.plugin.getLogger().info("Skipping loading of menu: " + menuName);
            return false;
        }
        File f = new File(this.menuDirectory.getPath(), fileName);
        if (!f.exists()) {
            this.plugin.getLogger().warning(f.getName() + " does not exist!");
            try {
                f.createNewFile();
                if (!this.saveResourceToFile("default_menu.yml", f)) {
                    this.plugin.getLogger().warning("Failed to create a default menu file for menu: " + menuName);
                    this.plugin.getLogger().info("Skipping loading menu: " + menuName);
                }
                this.plugin.getLogger().info(f.getName() + " created! Add your menu options to this file and use /dm reload to load it!");
            }
            catch (IOException e) {
                this.plugin.getLogger().severe("Could not create menu file: plugins" + File.separator + "DeluxeMenus" + File.separator + "gui_menus" + File.separator + fileName);
            }
        }
        if ((cfg = this.checkConfig(f)) == null) {
            this.plugin.getLogger().warning("Menu: " + menuName + " in file: " + fileName + " not loaded.");
        }
        if (cfg.getKeys(false) == null || cfg.getKeys(false).isEmpty()) {
            this.plugin.getLogger().info("Menu config: " + f.getName() + " is empty! Creating default config example...");
            this.saveResourceToFile("default_menu.yml", f);
            return false;
        }
        this.loadMenu(cfg, menuName, false);
        return Menu.getMenu(menuName) != null;
    }

    public void loadMenu(FileConfiguration c, String key, boolean mainConfig) {
        int update;
        ClickHandler closeHandler;
        ClickHandler openHandler;
        Menu menu;
        Map<Integer, TreeMap<Integer, MenuItem>> items;
        String pre = "gui_menus." + key + ".";
        if (!mainConfig) {
            pre = "";
        }
        if (!c.contains(pre + "menu_title")) {
            this.plugin.getLogger().warning("Menu title for menu: " + key + " is not present!");
            this.plugin.getLogger().warning("Skipping menu: " + key);
            return;
        }
        String title = null;
        if (c.isString(pre + "menu_title")) {
            title = c.getString(pre + "menu_title");
        } else if (c.isList(pre + "menu_title")) {
            title = (String)c.getStringList(pre + "menu_title").get(0);
        }
        if (title == null || title.isEmpty()) {
            this.plugin.getLogger().warning("Menu title for menu: " + key + " is invalid!");
            this.plugin.getLogger().warning("Skipping menu: " + key);
            return;
        }
        InventoryType type = null;
        if (c.contains(pre + "inventory_type")) {
            try {
                type = InventoryType.valueOf((String)c.getString(pre + "inventory_type"));
            }
            catch (Exception ex) {
                this.plugin.getLogger().warning("Inventory type for menu: " + key + " is invalid!");
                this.plugin.getLogger().warning("Valid Inventory types: " + InventoryType.values().toString());
            }
        }
        if (c.isString(pre + "menu_title")) {
            title = c.getString(pre + "menu_title");
        } else if (c.isList(pre + "menu_title")) {
            title = (String)c.getStringList(pre + "menu_title").get(0);
        }
        ArrayList<String> openCommands = new ArrayList<String>();
        if (c.contains(pre + "open_command")) {
            if (c.isString(pre + "open_command")) {
                String cmd = c.getString(pre + "open_command");
                if (cmd == null || cmd.isEmpty()) {
                    this.plugin.getLogger().warning("open_command specified for menu: " + key + " is empty!");
                    this.plugin.getLogger().warning("Skipping menu: " + key);
                    return;
                }
                if (Menu.isMenuCommand(cmd)) {
                    this.plugin.getLogger().warning("open_command specified for menu: " + key + " already exists for another menu!");
                    this.plugin.getLogger().warning("Skipping menu: " + key);
                    return;
                }
                openCommands.add(cmd.toLowerCase());
            } else if (c.isList(pre + "open_command")) {
                List cmds = c.getStringList(pre + "open_command");
                if (cmds == null || cmds.isEmpty()) {
                    this.plugin.getLogger().warning("open_command list specified for GUI menu: " + key + " is empty!");
                    this.plugin.getLogger().warning("Skipping GUI menu: " + key);
                    return;
                }
                for (String cmd : cmds) {
                    if (Menu.isMenuCommand(cmd)) {
                        this.plugin.getLogger().warning("command: " + cmd + " specified for GUI menu: " + key + " already exists for another menu!");
                        this.plugin.getLogger().warning("Skipping command: " + cmd + " in GUI menu: " + key);
                        continue;
                    }
                    openCommands.add(cmd.toLowerCase());
                }
            }
        }
        int size = 54;
        if (!c.contains(pre + "size")) {
            this.plugin.getLogger().warning("Menu size for GUI menu: " + key + " is not present!");
            this.plugin.getLogger().warning("Using default size of 54");
        } else {
            size = c.getInt(pre + "size");
            if (size < 9) {
                size = 54;
            }
            if (size > 54) {
                size = 54;
            } else {
                int remainder = size % 9;
                if (remainder > 0) {
                    ++size;
                }
                size = Math.min(size, 54);
            }
        }
        RequirementList orl = null;
        if (c.contains(pre + "open_requirement")) {
            orl = this.getRequirements(c, pre + "open_requirement");
        }
        if ((items = this.loadMenuItems(c, key, mainConfig)) == null || items.isEmpty()) {
            this.plugin.getLogger().warning("Failed to load menu items for GUI menu: " + key);
            this.plugin.getLogger().warning("Skipping loading of GUI menu: " + key);
            return;
        }
        if (openCommands.isEmpty()) {
            menu = new Menu(key, title, items, size);
        } else {
            boolean registerCommand = c.getBoolean(pre + "register_command", false);
            List args = null;
            if (c.contains(pre + "args") && c.isList(pre + "args")) {
                args = c.getStringList(pre + "args");
            }
            menu = new Menu(key, title, items, size, openCommands, registerCommand, args);
            menu.setArgUsageMessage(c.getString(pre + "args_usage_message", null));
        }
        if (type != null) {
            menu.setInventoryType(type);
        }
        if (orl != null && orl.getRequirements() != null) {
            menu.setOpenRequirements(orl);
        }
        if (c.contains(pre + "open_commands") && (openHandler = this.getClickHandler(c, pre + "open_commands")) != null) {
            menu.setOpenHandler(openHandler);
        }
        if (c.contains(pre + "close_commands") && (closeHandler = this.getClickHandler(c, pre + "close_commands")) != null) {
            menu.setCloseHandler(closeHandler);
        }
        int updateInterval = 10;
        if (c.contains(pre + "update_interval") && (update = c.getInt(pre + "update_interval")) >= 1) {
            updateInterval = update;
        }
        menu.setUpdateInterval(updateInterval);
    }

    private Map<Integer, TreeMap<Integer, MenuItem>> loadMenuItems(FileConfiguration c, String name, boolean mainConfig) {
        String itemsPath = "gui_menus." + name + ".items";
        if (!mainConfig) {
            itemsPath = "items";
        }
        if (!c.contains(itemsPath) || !c.isConfigurationSection(itemsPath)) {
            return null;
        }
        Set itemKeys = c.getConfigurationSection(itemsPath).getKeys(false);
        if (itemKeys == null || itemKeys.isEmpty()) {
            return null;
        }
        HashMap<Integer, TreeMap<Integer, MenuItem>> menuItems = new HashMap<Integer, TreeMap<Integer, MenuItem>>();
        for (String key : itemKeys) {
            List enchantments;
            String[] parts;
            String currentPath = itemsPath + "." + key + ".";
            if (!c.contains(currentPath + "material")) {
                this.plugin.getLogger().warning("Material for item: " + key + " in menu: " + name + " is not present!");
                this.plugin.getLogger().warning("Skipping item: " + key);
                continue;
            }
            MenuItem menuItem = new MenuItem();
            String mat = c.getString(currentPath + "material");
            if (mat.startsWith("placeholder-")) {
                parts = mat.split("-");
                if (parts.length < 2) {
                    this.plugin.getLogger().warning("Placeholder for material in item: " + key + " in menu " + name + " is not the valid format!");
                    this.plugin.getLogger().warning("Valid format: placeholder-<placeholder>");
                    this.plugin.getLogger().warning("Skipping item: " + key);
                    continue;
                }
                if (PlaceholderAPI.containsPlaceholders((String)parts[1])) {
                    menuItem.setPlaceholderMaterial(parts[1]);
                }
            } else if (mat.startsWith("heads-")) {
                parts = mat.split("-");
                if (parts.length < 2) {
                    this.plugin.getLogger().warning("Heads head for item: " + key + " in menu: " + name + " is not the valid format!");
                    this.plugin.getLogger().warning("Valid format: heads-<headId>");
                    this.plugin.getLogger().warning("Skipping item: " + key);
                    continue;
                }
                menuItem.setHeadOwner(parts[1]);
                menuItem.setIsHead(true);
                menuItem.setIsHeadsHead(true);
            } else if (mat.startsWith("hdb-")) {
                parts = mat.split("-");
                if (parts.length != 2) {
                    this.plugin.getLogger().warning("HeadDatabase head for item: " + key + " in menu: " + name + " is not the valid format!");
                    this.plugin.getLogger().warning("Valid format: hdb-<headId>");
                    this.plugin.getLogger().warning("Skipping item: " + key);
                    continue;
                }
                menuItem.setHeadOwner(parts[1]);
                menuItem.setIsHead(true);
                menuItem.setHeadDbHead(true);
            } else if (mat.startsWith("basehead-")) {
                parts = mat.split("-");
                if (parts.length != 2) {
                    this.plugin.getLogger().warning("basehead for item: " + key + " in menu: " + name + " is not the valid format!");
                    this.plugin.getLogger().warning("Valid format: basehead-<base64>");
                    this.plugin.getLogger().warning("Skipping item: " + key);
                    continue;
                }
                menuItem.setHeadOwner(parts[1]);
                menuItem.setIsHead(true);
                menuItem.setBaseHead(true);
            } else if (mat.startsWith("head")) {
                parts = mat.split("-");
                if (!mat.contains("-") || parts.length != 2) {
                    this.plugin.getLogger().warning("Player head for item: " + key + " in menu: " + name + " is not the valid format!");
                    this.plugin.getLogger().warning("Valid format: head-<playername/%player_name%>");
                    this.plugin.getLogger().warning("Skipping item: " + key);
                    continue;
                }
                menuItem.setHeadOwner(parts[1]);
                menuItem.setIsHead(true);
            } else if (mat.equalsIgnoreCase("main_hand") || mat.equalsIgnoreCase("off_hand")) {
                menuItem.setHandItem(mat);
            } else {
                Material m = Material.getMaterial((String)mat.toUpperCase());
                if (m == null) {
                    this.plugin.getLogger().warning("Material for item: " + key + " in menu: " + name + " is not a valid material name / id!");
                    this.plugin.getLogger().warning("Skipping item: " + key);
                    continue;
                }
                menuItem.setMaterial(m);
            }
            menuItem.setSlot(c.getInt(currentPath + "slot", 0));
            menuItem.setAmount(c.getInt(currentPath + "amount", 1));
            menuItem.setDynamicAmount(c.getString(currentPath + "dynamic_amount", null));
            menuItem.setDisplayName(c.getString(currentPath + "display_name"));
            if (c.isList(currentPath + "lore")) {
                menuItem.setLore(c.getStringList(currentPath + "lore"));
            }
            menuItem.setRGB(c.getString(currentPath + "rgb", null));
            menuItem.setUnbreakable(c.getBoolean(currentPath + "unbreakable", false));
            menuItem.setUpdatePlaceholders(c.getBoolean(currentPath + "update", false));
            menuItem.setHideAttributes(c.getBoolean(currentPath + "hide_attributes", false));
            menuItem.setHideUnbreakable(c.getBoolean(currentPath + "hide_unbreakable", false));
            menuItem.setHideEnchants(c.getBoolean(currentPath + "hide_enchantments", false));
            menuItem.setHidePotionEffects(c.getBoolean(currentPath + "hide_effects", false));
            menuItem.setNbtString(c.getString(currentPath + "nbt_string", null));
            menuItem.setNbtInt(c.getString(currentPath + "nbt_int", null));
            menuItem.setPriority(c.getInt(currentPath + "priority", 1));
            if (c.contains(currentPath + "data")) {
                if (c.isInt(currentPath + "data")) {
                    menuItem.setData((short)c.getInt(currentPath + "data"));
                } else {
                    String dataString = c.getString(currentPath + "data", "");
                    if (dataString.startsWith("placeholder-")) {
                        String[] parts2 = dataString.split("-");
                        if (parts2.length < 2) {
                            this.plugin.getLogger().warning("Placeholder for data in item: " + key + " in menu " + name + " is not the valid format!");
                            this.plugin.getLogger().warning("Valid format: placeholder-<placeholder>");
                            this.plugin.getLogger().warning("Skipping item: " + key);
                            continue;
                        }
                        if (PlaceholderAPI.containsPlaceholders((String)parts2[1])) {
                            menuItem.setPlaceholderData((String)parts2[1]);
                        }
                    }
                }
            }
            if (c.contains(currentPath + "banner_meta") && c.isList(currentPath + "banner_meta")) {
                ArrayList<Pattern> bannerMeta = new ArrayList<Pattern>();
                for (Object e : c.getStringList(currentPath + "banner_meta")) {
                    try {
                        if (!((String)e).contains(";")) {
                            this.plugin.getLogger().warning("banner meta for item: " + key + ", meta entry: " + (String)e + " is invalid! Skipping this entry!");
                            continue;
                        }
                        String[] metaParts = ((String)e).split(";");
                        if (metaParts.length != 2) {
                            this.plugin.getLogger().warning("banner meta for item: " + key + ", meta entry: " + (String)e + " is invalid! Skipping this entry!");
                            continue;
                        }
                        DyeColor color = DyeColor.valueOf((String)metaParts[0]);
                        PatternType type = PatternType.valueOf((String)metaParts[1]);
                        if (color == null || type == null) {
                            this.plugin.getLogger().warning("banner meta DyeColor or PatternType for item: " + key + ", meta entry: " + (String)e + " is invalid! Skipping this entry!");
                            continue;
                        }
                        bannerMeta.add(new Pattern(color, type));
                    }
                    catch (Exception ex) {
                        this.plugin.getLogger().warning("banner meta for item: " + key + ", meta entry: " + (String)e + " is invalid! Skipping loading of this entry!");
                    }
                }
                if (!bannerMeta.isEmpty()) {
                    menuItem.setIsBanner(true);
                    menuItem.setBannerMeta(bannerMeta);
                    menuItem.setHidePotionEffects(true);
                }
            }
            if (c.contains(currentPath + "enchantments") && (enchantments = c.getStringList(currentPath + "enchantments")) != null && !enchantments.isEmpty()) {
                Object e;
                HashMap<Enchantment, Integer> enchants = new HashMap<Enchantment, Integer>();
                e = enchantments.iterator();
                while (e.hasNext()) {
                    String e2 = (String)e.next();
                    if (e2.contains(";")) {
                        String[] parts3 = e2.split(";");
                        if (parts3.length == 2) {
                            Enchantment enc = Enchantment.getByName((String)parts3[0].toUpperCase());
                            int level = 1;
                            if (enc != null) {
                                try {
                                    level = Integer.parseInt(parts3[1]);
                                }
                                catch (NumberFormatException ex) {
                                    this.plugin.getLogger().warning("Enchantment level is incorrect for item " + key + " in menu " + name + "!");
                                }
                                enchants.put(enc, level);
                                continue;
                            }
                            this.plugin.getLogger().warning("Enchantment " + parts3[0] + " for item " + key + " in menu " + name + " is not a valid enchantment name!");
                            continue;
                        }
                        this.plugin.getLogger().warning("Enchantment format is incorrect for item " + key + " in GUI " + name + "!");
                        this.plugin.getLogger().warning("Correct format: - '<Enchantment name>;<level>");
                        continue;
                    }
                    this.plugin.getLogger().warning("Enchantment format is incorrect for item " + key + " in GUI " + name + "!");
                    this.plugin.getLogger().warning("Correct format: - '<Enchantment name>;<level>");
                }
                if (!enchants.isEmpty()) {
                    menuItem.setEnchantments(enchants);
                }
            }
            if (c.contains(currentPath + "view_requirement")) {
                menuItem.setViewRequirements(this.getRequirements(c, currentPath + "view_requirement"));
            }
            if (c.contains(currentPath + "left_click_commands")) {
                menuItem.setLeftClickHandler(this.getClickHandler(c, currentPath + "left_click_commands"));
                if (c.contains(currentPath + "left_click_requirement")) {
                    menuItem.setLeftClickRequirements(this.getRequirements(c, currentPath + "left_click_requirement"));
                }
            }
            if (c.contains(currentPath + "right_click_commands")) {
                menuItem.setRightClickHandler(this.getClickHandler(c, currentPath + "right_click_commands"));
                if (c.contains(currentPath + "right_click_requirement")) {
                    menuItem.setRightClickRequirements(this.getRequirements(c, currentPath + "right_click_requirement"));
                }
            }
            if (c.contains(currentPath + "shift_left_click_commands")) {
                menuItem.setShiftLeftClickHandler(this.getClickHandler(c, currentPath + "shift_left_click_commands"));
                if (c.contains(currentPath + "shift_left_click_requirement")) {
                    menuItem.setShiftLeftClickRequirements(this.getRequirements(c, currentPath + "shift_left_click_requirement"));
                }
            }
            if (c.contains(currentPath + "shift_right_click_commands")) {
                menuItem.setShiftRightClickHandler(this.getClickHandler(c, currentPath + "shift_right_click_commands"));
                if (c.contains(currentPath + "shift_right_click_requirement")) {
                    menuItem.setShiftRightClickRequirements(this.getRequirements(c, currentPath + "shift_right_click_requirement"));
                }
            }
            if (c.contains(currentPath + "middle_click_commands")) {
                menuItem.setMiddleClickHandler(this.getClickHandler(c, currentPath + "middle_click_commands"));
                if (c.contains(currentPath + "middle_click_requirement")) {
                    menuItem.setMiddleClickRequirements(this.getRequirements(c, currentPath + "middle_click_requirement"));
                }
            }
            List<Integer> slots = new ArrayList<Integer>();
            if (c.contains(currentPath + "slots") && c.isList(currentPath + "slots")) {
                slots = c.getList(currentPath + "slots");
            } else {
                slots.add(c.getInt(currentPath + "slot", 0));
            }
            Iterator iterator = slots.iterator();
            while (iterator.hasNext()) {
                TreeMap slotPriorityMap;
                int slot = (Integer)iterator.next();
                if (!menuItems.containsKey(slot) || menuItems.get(slot) == null) {
                    slotPriorityMap = new TreeMap();
                    menuItems.put(slot, slotPriorityMap);
                } else {
                    slotPriorityMap = (TreeMap)menuItems.get(slot);
                }
                MenuItem clone = menuItem.clone();
                clone.setSlot(slot);
                slotPriorityMap.put(menuItem.getPriority(), clone);
            }
        }
        return menuItems;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private RequirementList getRequirements(FileConfiguration c, String path) {
        gdh = null;
        this.d("requirement path: " + path);
        if (c.contains(path + ".deny_commands")) {
            this.d("global deny handler found");
            gdh = this.getClickHandler(c, path + ".deny_commands");
        }
        r = new ArrayList<Requirement>();
        if (!c.contains(path + ".requirements")) {
            this.d("requirements list was not found");
            if (c.contains(path + ".expression")) {
                this.d("found legacy javascript requirement.");
                req = new JavascriptRequirement(null, c.getString(path + ".expression"));
                r.add(req);
                list = new RequirementList(r);
                list.setDenyHandler(gdh);
                return list;
            }
            return null;
        }
        this.d("found requirements list");
        for (String key : c.getConfigurationSection(path + ".requirements").getKeys(false)) {
            this.d("requirement: " + key + " from requirements list");
            rPath = path + ".requirements." + key;
            if (!c.contains(rPath + ".type")) {
                this.plugin.getLogger().warning("No type set for requirement: " + key);
                continue;
            }
            type = RequirementType.getType(c.getString(rPath + ".type"));
            if (type == null) {
                this.plugin.getLogger().warning("Requirement type at path: " + rPath + " is not a valid requirement type!");
                continue;
            }
            this.d("Requirement type: " + type.name());
            req /* !! */  = null;
            requirementDenyHandler = null;
            if (c.contains(rPath + ".deny_commands")) {
                this.d("Requirement has deny commands");
                requirementDenyHandler = this.getClickHandler(c, rPath + ".deny_commands");
            }
            invert = false;
            switch (2.$SwitchMap$com$extendedclip$deluxemenus$menu$requirement$RequirementType[type.ordinal()]) {
                case 1: 
                case 2: {
                    item = null;
                    if (!c.contains(rPath + ".material")) ** GOTO lbl46
                    try {
                        item = new ItemStack(Material.getMaterial((String)c.getString(rPath + ".material")));
                        ** GOTO lbl48
                    }
                    catch (Exception ex) {
                        this.plugin.getLogger().warning("has item requirement at path: " + rPath + " does not specify a valid Material name");
                        break;
                    }
lbl46:
                    // 1 sources

                    this.plugin.getLogger().warning("has item requirement at path: " + rPath + " does not contain a material: entry");
                    break;
lbl48:
                    // 1 sources

                    if (!c.contains(rPath + ".amount")) {
                        this.plugin.getLogger().warning("has item requirement at path: " + rPath + " does not contain an amount: entry");
                        break;
                    }
                    item.setAmount(c.getInt(rPath + ".amount"));
                    if (c.contains(rPath + ".data")) {
                        item.setDurability((short)c.getInt(rPath + ".data"));
                    }
                    meta = item.getItemMeta();
                    if (c.contains(rPath + ".name")) {
                        meta.setDisplayName(c.getString(rPath + ".name"));
                    }
                    if (c.contains(rPath + ".lore")) {
                        meta.setLore(c.getStringList(rPath + ".lore"));
                    }
                    item.setItemMeta(meta);
                    invert = type == RequirementType.DOES_NOT_HAVE_ITEM;
                    req /* !! */  = new HasItemRequirement(requirementDenyHandler, item, invert);
                    break;
                }
                case 3: 
                case 4: {
                    if (c.contains(rPath + ".permission")) {
                        invert = type == RequirementType.DOES_NOT_HAVE_PERMISSION;
                        req /* !! */  = new HasPermissionRequirement(requirementDenyHandler, c.getString(rPath + ".permission"), invert);
                        break;
                    }
                    this.plugin.getLogger().warning("has permission requirement at path: " + rPath + " does not contain a permission: entry");
                    break;
                }
                case 5: {
                    if (c.contains(rPath + ".expression")) {
                        req /* !! */  = new JavascriptRequirement(requirementDenyHandler, c.getString(rPath + ".expression"));
                        break;
                    }
                    this.plugin.getLogger().warning("javascript requirement at path: " + rPath + " does not contain an expression: entry");
                    break;
                }
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: {
                    if (c.contains(rPath + ".input") && c.contains(rPath + ".output")) {
                        req /* !! */  = new InputResultRequirement(requirementDenyHandler, type, c.getString(rPath + ".input"), c.getString(rPath + ".output"));
                        break;
                    }
                    this.plugin.getLogger().warning("requirement at path: " + rPath + " does not contain both input: and output: entries");
                    break;
                }
                case 17: 
                case 18: {
                    if (c.contains(rPath + ".amount")) {
                        invert = type == RequirementType.DOES_NOT_HAVE_MONEY;
                        req /* !! */  = new HasMoneyRequirement(requirementDenyHandler, c.getLong(rPath + ".amount"), invert, c.getString("placeholder", null));
                        break;
                    }
                    this.plugin.getLogger().warning("requirement at path: " + rPath + " does not contain an amount: entry");
                    break;
                }
                case 19: 
                case 20: {
                    if (c.contains(rPath + ".input") && c.contains(rPath + ".regex")) {
                        p = java.util.regex.Pattern.compile(c.getString(rPath + ".regex"));
                        invert = type == RequirementType.REGEX_DOES_NOT_MATCH;
                        req /* !! */  = new RegexMatchesRequirement(requirementDenyHandler, p, c.getString(rPath + ".input"), invert);
                    } else {
                        this.plugin.getLogger().warning("requirement at path: " + rPath + " does not contain a input: or regex: entry");
                    }
                }
                case 21: 
                case 22: {
                    if (c.contains(rPath + ".location") && c.contains(rPath + ".distance")) {
                        invert = type == RequirementType.IS_NOT_NEAR;
                        loc = LocationUtils.deserializeLocation(c.getString(rPath + ".location"));
                        if (loc == null) {
                            this.plugin.getLogger().warning("requirement at path: " + rPath + " has an invalid location. Format is location: <world>,<x>,<y>,<z>");
                        }
                        req /* !! */  = new IsNearRequirement(requirementDenyHandler, loc, c.getInt(rPath + ".distance"), invert);
                        break;
                    }
                    this.plugin.getLogger().warning("requirement at path: " + rPath + " does not contain a location: or distance: entry");
                    break;
                }
                case 23: 
                case 24: {
                    if (!this.plugin.getNms().hasPersistentMetaAPI()) {
                        this.plugin.getLogger().warning("has meta requirement is not available for your server version!");
                        break;
                    }
                    if (c.contains(rPath + ".key") && c.contains(rPath + ".meta_type") && c.contains(rPath + ".value")) {
                        metaKey = c.getString(rPath + ".key");
                        invert = type == RequirementType.DOES_NOT_HAVE_META;
                        req /* !! */  = new HasMetaRequirement(requirementDenyHandler, metaKey, c.getString(rPath + ".meta_type"), c.getString(rPath + ".value"), invert);
                        break;
                    }
                    this.plugin.getLogger().warning("requirement at path: " + rPath + " does not contain a key:, meta_type:, or value: entry");
                    break;
                }
            }
            if (req /* !! */  == null) continue;
            r.add(req /* !! */ );
        }
        if (r.isEmpty()) {
            return null;
        }
        list = new RequirementList(r);
        list.setDenyHandler(gdh);
        return list;
    }

    private ClickHandler getClickHandler(FileConfiguration c, String configPath) {
        List commands = c.getStringList(configPath);
        if (commands == null || commands.isEmpty()) {
            return null;
        }
        final ArrayList<ClickAction> actions = new ArrayList<ClickAction>();
        for (String command : commands) {
            ActionType type;
            if (command == null || command.isEmpty() || (type = ActionType.getType(command)) == null) continue;
            if ((command = command.replace(type.getIdentifier(), "")).startsWith(" ")) {
                command = command.trim();
            }
            int delay = 0;
            Matcher d = DELAY_MATCHER.matcher(command);
            if (d.find()) {
                delay = Integer.parseInt(d.group(3));
                command = command.replaceAll(d.group(), "");
            }
            ClickAction action = delay > 0 ? new ClickAction(type, command, delay) : new ClickAction(type, command);
            Matcher ch = CHANCE_MATCHER.matcher(command);
            if (ch.find()) {
                action.setChance(Double.parseDouble(ch.group(3)));
                command = command.replaceAll(ch.group(), "");
                action.setExecutable(command);
            }
            actions.add(action);
        }
        ClickHandler handler = null;
        if (!actions.isEmpty()) {
            handler = new ClickHandler(){

                @Override
                public void onClick(MenuHolder holder) {
                    for (ClickAction action : actions) {
                        if (!action.checkChance()) continue;
                        String ex = PlaceholderAPI.setPlaceholders((Player)holder.getViewer(), (String)action.getExecutable());
                        ex = ex.replace("%viewer%", holder.getViewer().getName());
                        ex = holder.setArgPlaceholders(ex);
                        if (action.hasDelay()) {
                            new ClickActionTask(holder.getViewer().getName(), action.getType(), ex).runTaskLater((Plugin)DeluxeMenusConfig.this.plugin, action.getDelay());
                            continue;
                        }
                        new ClickActionTask(holder.getViewer().getName(), action.getType(), ex).runTask((Plugin)DeluxeMenusConfig.this.plugin);
                    }
                }
            };
        }
        return handler;
    }

    public void d(String msg) {
        DeluxeMenusConfig deluxeMenusConfig = this;
        if (deluxeMenusConfig.plugin.isDebug()) {
            this.plugin.getLogger().info(msg);
        }
    }

    public boolean debug() {
        return this.plugin.getConfig().getBoolean("debug", false);
    }
}

