/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.menu;

public enum ActionType {
    META("[meta]", "Handle meta for a player", "- '[meta] <set/remove/add/subtract/switch> <key> <value type> <value>'"),
    CONSOLE("[console]", "Execute a command from the console", "- '[console] <command with no slash>'"),
    PLAYER("[player]", "Execute a command for the menu viewer", "- '[player] <command with no slash>'"),
    PLAYER_COMMAND_EVENT("[commandevent]", "Fire a PlayerCommandPreprocessEvent for commands that do not use the bukkit command system", "- '[commandevent] <command with no slash>'"),
    MESSAGE("[message]", "Send a message to the menu viewer", "- [message] <message to send to the player"),
    BROADCAST("[broadcast]", "Broadcast a message to the server", "- '[broadcast] <message>"),
    CHAT("[chat]", "Send a chat message as the player performing the action", "- '[chat] <message>"),
    OPEN_GUI_MENU("[openguimenu]", "Open a GUI menu (can only be used in GUI menu click_commands)", "- '[openguimenu] <guiMenuName>'"),
    CONNECT("[connect]", "Connect to the specified bungee server", "- '[connect] <serverName>'"),
    CLOSE("[close]", "Close the viewers open menu", "- '[close]"),
    REFRESH("[refresh]", "Refresh items in the current menu view", "- '[refresh]"),
    BROADCAST_SOUND("[broadcastsound]", "Broadcast a sound to the server", "- '[broadcastsound]"),
    PLAY_SOUND("[sound]", "Play a sound for a the specific player", "- '[sound]"),
    TAKE_MONEY("[takemoney]", "Take money from a player (requires Vault)", "- '[takemoney] <amount>"),
    GIVE_MONEY("[givemoney]", "Give money to a player (requires Vault)", "- '[givemoney] <amount>"),
    JSON_MESSAGE("[json]", "Send a json message to the menu viewer", "- '[json] {\"text\":\"message\"}'");

    private final String identifier;
    private final String description;
    private final String usage;

    private ActionType(String identifier, String description, String usage) {
        this.identifier = identifier;
        this.description = description;
        this.usage = usage;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getDescription() {
        return this.description;
    }

    public String getUsage() {
        return this.usage;
    }

    public static ActionType getType(String s) {
        for (ActionType type : ActionType.values()) {
            if (!s.startsWith(type.getIdentifier())) continue;
            return type;
        }
        return null;
    }

    public static String getAllClickTypes() {
        StringBuilder sb = new StringBuilder();
        for (ActionType type : ActionType.values()) {
            sb.append("\n" + type.getIdentifier() + " - " + type.getDescription() + "\nUsage: " + type.getUsage() + "\n");
        }
        return sb.toString();
    }
}

