/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.menu;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.menu.ActionType;
import java.util.concurrent.ThreadLocalRandom;

public class ClickAction {
    private ActionType type;
    private String executable;
    private long delay;
    private double chance;

    public ClickAction(ActionType type, String executable) {
        this.setType(type);
        this.setExecutable(executable);
        this.setDelay(-1L);
        this.setChance(100.0);
    }

    public ClickAction(ActionType type, String executable, long delay) {
        this.setType(type);
        this.setExecutable(executable);
        this.setDelay(delay > 0L ? delay : -1L);
        this.setChance(100.0);
    }

    public ClickAction(ActionType type, String executable, double chance) {
        this.setType(type);
        this.setExecutable(executable);
        this.setDelay(-1L);
        this.setChance(100.0);
    }

    public ClickAction(ActionType type, String executable, long delay, double chance) {
        this.setType(type);
        this.setExecutable(executable);
        this.setDelay(delay > 0L ? delay : -1L);
        this.setChance(chance);
    }

    public ActionType getType() {
        return this.type;
    }

    public void setType(ActionType type) {
        this.type = type;
    }

    public String getExecutable() {
        return this.executable;
    }

    public void setExecutable(String executable) {
        this.executable = executable;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public boolean hasDelay() {
        return this.delay > 0L;
    }

    public double getChance() {
        return this.chance;
    }

    public void setChance(double chance) {
        this.chance = chance > 0.0 && chance <= 100.0 ? chance : 100.0;
    }

    public boolean checkChance() {
        if (this.chance >= 100.0) {
            return true;
        }
        double random = ThreadLocalRandom.current().nextDouble() * 100.0;
        random = Double.parseDouble(DeluxeMenus.getInstance().getDecimalFormat().format(random));
        return random <= this.chance;
    }
}

