/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.menu;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.menu.Menu;
import com.extendedclip.deluxemenus.menu.MenuItem;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class MenuHolder
implements InventoryHolder {
    private final Player viewer;
    private String menuName;
    private Set<MenuItem> activeItems;
    private BukkitTask updateTask = null;
    private Inventory inventory;
    private boolean updating;
    private Map<String, String> typedArgs;

    public MenuHolder(Player viewer) {
        this.viewer = viewer;
    }

    public MenuHolder(Player viewer, String menuName, Set<MenuItem> activeItems, Inventory inventory) {
        this.viewer = viewer;
        this.menuName = menuName;
        this.activeItems = activeItems;
        this.inventory = inventory;
    }

    public void setInventory(Inventory i) {
        this.inventory = i;
    }

    public String getViewerName() {
        return this.viewer.getName();
    }

    public BukkitTask getUpdateTask() {
        return this.updateTask;
    }

    public Player getViewer() {
        return this.viewer;
    }

    public String getMenuName() {
        return this.menuName;
    }

    public void setMenuName(String menuName) {
        this.menuName = menuName;
    }

    public Set<MenuItem> getActiveItems() {
        return this.activeItems;
    }

    public void setActiveItems(Set<MenuItem> items) {
        this.activeItems = items;
    }

    public MenuHolder getHolder() {
        return this;
    }

    public MenuItem getItem(int slot) {
        for (MenuItem item : this.activeItems) {
            if (item.getSlot() != slot) continue;
            return item;
        }
        return null;
    }

    public Menu getMenu() {
        return Menu.getMenu(this.menuName);
    }

    public String setArgPlaceholders(String string) {
        if (this.typedArgs == null || this.typedArgs.isEmpty()) {
            return string;
        }
        for (Map.Entry<String, String> entry : this.typedArgs.entrySet()) {
            string = string.replace("{" + entry.getKey() + "}", entry.getValue());
        }
        return string;
    }

    public void refreshMenu() {
        Menu menu = this.getMenu();
        if (menu == null || menu.getMenuItems() == null || menu.getMenuItems().size() <= 0) {
            return;
        }
        this.setUpdating(true);
        this.stopPlaceholderUpdate();
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)DeluxeMenus.getInstance(), () -> {
            HashSet<MenuItem> active = new HashSet<MenuItem>();
            for (int i = 0; i < this.getInventory().getSize(); ++i) {
                TreeMap<Integer, MenuItem> e = menu.getMenuItems().get(i);
                if (e == null) {
                    this.getInventory().setItem(i, null);
                    continue;
                }
                boolean m = false;
                for (MenuItem item : e.values()) {
                    if (item.hasViewRequirement()) {
                        if (!item.getViewRequirements().evaluate(this)) continue;
                        m = true;
                        active.add(item);
                        break;
                    }
                    m = true;
                    active.add(item);
                    break;
                }
                if (m) continue;
                this.getInventory().setItem(i, null);
            }
            if (active.isEmpty()) {
                Menu.closeMenu(this.getViewer(), true);
            }
            Bukkit.getScheduler().runTask((Plugin)DeluxeMenus.getInstance(), () -> {
                boolean update = false;
                for (MenuItem item : active) {
                    ItemStack iStack = item.getItemStack(this);
                    int slot = item.getSlot();
                    if (slot >= menu.getSize()) continue;
                    if (item.updatePlaceholders()) {
                        update = true;
                    }
                    this.getInventory().setItem(item.getSlot(), iStack);
                }
                this.setActiveItems(active);
                if (update) {
                    this.startUpdatePlaceholdersTask();
                }
                this.setUpdating(false);
            });
        });
    }

    public void stopPlaceholderUpdate() {
        if (this.updateTask != null) {
            try {
                this.updateTask.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.updateTask = null;
        }
    }

    public void startUpdatePlaceholdersTask() {
        if (this.updateTask != null) {
            this.stopPlaceholderUpdate();
        }
        this.updateTask = new BukkitRunnable(){

            public void run() {
                if (MenuHolder.this.updating) {
                    return;
                }
                Set<MenuItem> items = MenuHolder.this.getActiveItems();
                if (items == null) {
                    return;
                }
                for (MenuItem item : items) {
                    int amt;
                    ItemStack i;
                    block10: {
                        if (!item.updatePlaceholders() || (i = MenuHolder.this.inventory.getItem(item.getSlot())) == null) continue;
                        amt = i.getAmount();
                        if (item.getDynamicAmount() != null) {
                            try {
                                amt = Integer.parseInt(PlaceholderAPI.setPlaceholders((Player)MenuHolder.this.getViewer(), (String)item.getDynamicAmount()));
                                if (amt <= 0) {
                                    amt = 1;
                                }
                            }
                            catch (Exception ex) {
                                if (!DeluxeMenus.isDebug()) break block10;
                                ex.printStackTrace();
                            }
                        }
                    }
                    ItemMeta meta = i.getItemMeta();
                    if (item.displayNameHasPlaceholders()) {
                        meta.setDisplayName(PlaceholderAPI.setPlaceholders((Player)MenuHolder.this.getViewer(), (String)meta.getDisplayName()));
                    }
                    if (item.loreHasPlaceholders()) {
                        ArrayList<String> updated = new ArrayList<String>();
                        for (String line : item.getLore()) {
                            updated.add(PlaceholderAPI.setPlaceholders((Player)MenuHolder.this.getViewer(), (String)line));
                        }
                        meta.setLore(updated);
                    }
                    i.setItemMeta(meta);
                    i.setAmount(amt);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)DeluxeMenus.getInstance(), 20L, 20L * (long)Menu.getMenu(this.menuName).getUpdateInterval());
    }

    public boolean isUpdating() {
        return this.updating;
    }

    public void setUpdating(boolean updating) {
        this.updating = updating;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public Map<String, String> getTypedArgs() {
        return this.typedArgs;
    }

    public void setTypedArgs(Map<String, String> typedArgs) {
        this.typedArgs = typedArgs;
    }
}

