/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.menu;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.menu.ClickHandler;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.menu.requirement.RequirementList;
import com.extendedclip.deluxemenus.utils.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.banner.Pattern;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class MenuItem
implements Cloneable {
    private Material material;
    private short data;
    private int amount;
    private String dynamicAmount = null;
    private String displayName;
    private boolean displayNameHasPlaceholders;
    private List<String> lore;
    private boolean loreHasPlaceholders;
    private int slot;
    private int priority;
    private RequirementList viewRequirements;
    private boolean unbreakable;
    private boolean hideAttributes;
    private boolean hideEnchants;
    private boolean hidePotionEffects;
    private boolean hideUnbreakable;
    private boolean updatePlaceholders;
    private Map<Enchantment, Integer> enchantments;
    private boolean isHead;
    private boolean isHeadsHead;
    private boolean isHeadDbHead;
    private boolean isBaseHead;
    private String handItem;
    private String rgb;
    private String placeholderMaterial;
    private String placeholderData;
    private String headOwner;
    private EntityType entityType;
    private boolean isBanner;
    private List<Pattern> bannerMeta;
    private String nbtString;
    private String nbtInt;
    private ClickHandler leftClickHandler;
    private ClickHandler rightClickHandler;
    private ClickHandler shiftLeftClickHandler;
    private ClickHandler shiftRightClickHandler;
    private ClickHandler middleClickHandler;
    private RequirementList leftClickRequirements;
    private RequirementList rightClickRequirements;
    private RequirementList shiftLeftClickRequirements;
    private RequirementList shiftRightClickRequirements;
    private RequirementList middleClickRequirements;

    public MenuItem clone() {
        try {
            return (MenuItem)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            if (DeluxeMenus.isDebug()) {
                ex.printStackTrace();
            }
            return new MenuItem();
        }
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public short getData() {
        return this.data;
    }

    public void setData(Short data) {
        this.data = data;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
        if (this.displayName != null) {
            this.displayNameHasPlaceholders = PlaceholderAPI.getPlaceholderPattern().matcher(this.displayName).find();
        }
    }

    public List<String> getLore() {
        return this.lore;
    }

    public void setLore(List<String> lore) {
        this.lore = lore;
        if (this.lore != null) {
            boolean has = false;
            for (String line : lore) {
                if (!PlaceholderAPI.getPlaceholderPattern().matcher(line).find()) continue;
                has = true;
                break;
            }
            this.loreHasPlaceholders = has;
        }
    }

    public ClickHandler getLeftClickHandler() {
        return this.leftClickHandler;
    }

    public void setLeftClickHandler(ClickHandler clickHandler) {
        this.leftClickHandler = clickHandler;
    }

    public ClickHandler getRightClickHandler() {
        return this.rightClickHandler;
    }

    public void setRightClickHandler(ClickHandler clickHandler) {
        this.rightClickHandler = clickHandler;
    }

    public int getSlot() {
        return this.slot;
    }

    public void setSlot(int slot) {
        this.slot = slot;
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public boolean hasViewRequirement() {
        return this.viewRequirements != null && this.viewRequirements.getRequirements() != null;
    }

    public RequirementList getViewRequirements() {
        return this.viewRequirements;
    }

    public void setViewRequirements(RequirementList r) {
        this.viewRequirements = r;
    }

    public boolean displayNameHasPlaceholders() {
        return this.displayNameHasPlaceholders;
    }

    public boolean loreHasPlaceholders() {
        return this.loreHasPlaceholders;
    }

    public boolean updatePlaceholders() {
        return this.updatePlaceholders;
    }

    public void setUpdatePlaceholders(boolean updatePlaceholders) {
        this.updatePlaceholders = updatePlaceholders;
    }

    public boolean hideAttributes() {
        return this.hideAttributes;
    }

    public void setHideAttributes(boolean hide) {
        this.hideAttributes = hide;
    }

    public boolean hideEnchants() {
        return this.hideEnchants;
    }

    public void setHideEnchants(boolean hideEnchants) {
        this.hideEnchants = hideEnchants;
    }

    public boolean hidePotionEffects() {
        return this.hidePotionEffects;
    }

    public void setHidePotionEffects(boolean hidePotionEffects) {
        this.hidePotionEffects = hidePotionEffects;
    }

    public void setEnchantments(Map<Enchantment, Integer> enchantments) {
        this.enchantments = enchantments;
    }

    public boolean isHead() {
        return this.isHead;
    }

    public void setIsHead(boolean isHead) {
        this.isHead = isHead;
    }

    public String getHeadOwner() {
        return this.headOwner;
    }

    public void setHeadOwner(String headOwner) {
        this.headOwner = headOwner;
    }

    public RequirementList getLeftClickRequirements() {
        return this.leftClickRequirements;
    }

    public void setLeftClickRequirements(RequirementList leftClickRequirements) {
        this.leftClickRequirements = leftClickRequirements;
    }

    public RequirementList getRightClickRequirements() {
        return this.rightClickRequirements;
    }

    public void setRightClickRequirements(RequirementList rightClickRequirements) {
        this.rightClickRequirements = rightClickRequirements;
    }

    public boolean isBanner() {
        return this.isBanner;
    }

    public void setIsBanner(boolean isBanner) {
        this.isBanner = isBanner;
    }

    public List<Pattern> getBannerMeta() {
        return this.bannerMeta;
    }

    public void setBannerMeta(List<Pattern> bannerMeta) {
        this.bannerMeta = bannerMeta;
    }

    public String getDynamicAmount() {
        return this.dynamicAmount;
    }

    public void setDynamicAmount(String dynamicAmount) {
        this.dynamicAmount = dynamicAmount;
    }

    public boolean hideUnbreakable() {
        return this.hideUnbreakable;
    }

    public void setHideUnbreakable(boolean b) {
        this.hideUnbreakable = b;
    }

    public String getRGB() {
        return this.rgb;
    }

    public void setRGB(String rgb) {
        this.rgb = rgb;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public void setEntityType(EntityType entityType) {
        this.entityType = entityType;
    }

    public boolean isUnbreakable() {
        return this.unbreakable;
    }

    public void setUnbreakable(boolean unbreakable) {
        this.unbreakable = unbreakable;
    }

    public boolean isHeadDbHead() {
        return this.isHeadDbHead;
    }

    public void setHeadDbHead(boolean isHeadDbHead) {
        this.isHeadDbHead = isHeadDbHead;
    }

    public boolean isBaseHead() {
        return this.isBaseHead;
    }

    public void setBaseHead(boolean isBaseHead) {
        this.isBaseHead = isBaseHead;
    }

    public boolean isHeadsHead() {
        return this.isHeadsHead;
    }

    public void setIsHeadsHead(boolean isHeadsHead) {
        this.isHeadsHead = isHeadsHead;
    }

    public boolean isPlaceholderMaterial() {
        return this.placeholderMaterial != null;
    }

    public String getPlaceholderMaterial() {
        return this.placeholderMaterial;
    }

    public void setPlaceholderMaterial(String placeholderMaterial) {
        this.placeholderMaterial = placeholderMaterial;
    }

    public String getPlaceholderData() {
        return this.placeholderData;
    }

    public void setPlaceholderData(String placeholderData) {
        this.placeholderData = placeholderData;
    }

    public ClickHandler getShiftLeftClickHandler() {
        return this.shiftLeftClickHandler;
    }

    public void setShiftLeftClickHandler(ClickHandler shiftLeftClickHandler) {
        this.shiftLeftClickHandler = shiftLeftClickHandler;
    }

    public ClickHandler getShiftRightClickHandler() {
        return this.shiftRightClickHandler;
    }

    public void setShiftRightClickHandler(ClickHandler shiftRightClickHandler) {
        this.shiftRightClickHandler = shiftRightClickHandler;
    }

    public RequirementList getShiftLeftClickRequirements() {
        return this.shiftLeftClickRequirements;
    }

    public void setShiftLeftClickRequirements(RequirementList shiftLeftClickRequirements) {
        this.shiftLeftClickRequirements = shiftLeftClickRequirements;
    }

    public RequirementList getShiftRightClickRequirements() {
        return this.shiftRightClickRequirements;
    }

    public void setShiftRightClickRequirements(RequirementList shiftRightClickRequirements) {
        this.shiftRightClickRequirements = shiftRightClickRequirements;
    }

    public ClickHandler getMiddleClickHandler() {
        return this.middleClickHandler;
    }

    public void setMiddleClickHandler(ClickHandler middleClickHandler) {
        this.middleClickHandler = middleClickHandler;
    }

    public RequirementList getMiddleClickRequirements() {
        return this.middleClickRequirements;
    }

    public void setMiddleClickRequirements(RequirementList middleClickRequirements) {
        this.middleClickRequirements = middleClickRequirements;
    }

    public String getNbtString() {
        return this.nbtString;
    }

    public void setNbtString(String nbtString) {
        this.nbtString = nbtString;
    }

    public String getNbtInt() {
        return this.nbtInt;
    }

    public void setNbtInt(String nbtInt) {
        this.nbtInt = nbtInt;
    }

    public String getHandItem() {
        return this.handItem;
    }

    public void setHandItem(String handItem) {
        this.handItem = handItem;
    }

    public ItemStack getItemStack(MenuHolder mp) {
        String[] parts;
        BannerMeta meta;
        Player viewer = mp.getViewer();
        ItemStack itemStack = null;
        int amt = 1;
        if (this.isHead && this.headOwner != null) {
            String ownerName = PlaceholderAPI.setPlaceholders((Player)viewer, (String)this.headOwner);
            ownerName = mp.setArgPlaceholders(ownerName);
            if (this.isHeadDbHead && DeluxeMenus.getInstance().getItemHook("hdb") != null) {
                itemStack = DeluxeMenus.getInstance().getItemHook("hdb").getItem(ownerName);
            } else if (this.isBaseHead && DeluxeMenus.getInstance().getItemHook("basehead") != null) {
                itemStack = DeluxeMenus.getInstance().getItemHook("basehead").getItem(ownerName);
            } else if (this.isHeadsHead && DeluxeMenus.getInstance().getItemHook("heads") != null) {
                itemStack = DeluxeMenus.getInstance().getItemHook("heads").getItem(ownerName);
            } else {
                itemStack = DeluxeMenus.getInstance().getHead().clone();
                if (!ownerName.isEmpty()) {
                    SkullMeta skullMeta = (SkullMeta)itemStack.getItemMeta();
                    OfflinePlayer pl = Bukkit.getOfflinePlayer((String)ownerName);
                    if (pl != null) {
                        try {
                            skullMeta.setOwningPlayer(pl);
                        }
                        catch (Throwable t) {
                            skullMeta.setOwner(pl.getName());
                        }
                        itemStack.setItemMeta((ItemMeta)skullMeta);
                    }
                }
            }
        } else if (this.isBanner && this.bannerMeta != null) {
            itemStack = new ItemStack(this.material, amt);
            meta = (BannerMeta)itemStack.getItemMeta();
            meta.setPatterns(this.bannerMeta);
            itemStack.setItemMeta((ItemMeta)meta);
        } else if (this.placeholderMaterial != null) {
            Material material;
            block58: {
                String pMat = mp.setArgPlaceholders(this.placeholderMaterial);
                material = null;
                try {
                    material = Material.valueOf((String)PlaceholderAPI.setPlaceholders((Player)viewer, (String)pMat));
                }
                catch (Exception pl) {
                    // empty catch block
                }
                if (material == null || material == Material.AIR) {
                    return new ItemStack(Material.STONE, 1);
                }
                if (this.placeholderData != null) {
                    try {
                        String pData = mp.setArgPlaceholders(this.placeholderData);
                        this.data = Short.parseShort(PlaceholderAPI.setPlaceholders((Player)viewer, (String)pData));
                    }
                    catch (Exception ex) {
                        if (!DeluxeMenus.isDebug()) break block58;
                        ex.printStackTrace();
                    }
                }
            }
            itemStack = new ItemStack(material, amt);
            if (this.data > 0) {
                itemStack.setDurability(this.data);
            }
        } else if (this.material != null) {
            itemStack = new ItemStack(this.material, amt);
            if (this.data > 0) {
                itemStack.setDurability(this.data);
            }
        } else if (this.handItem != null) {
            if (this.handItem.equalsIgnoreCase("main_hand")) {
                if (viewer.getInventory().getItemInMainHand() != null) {
                    return viewer.getInventory().getItemInMainHand().clone();
                }
                return null;
            }
            if (this.handItem.equalsIgnoreCase("off_hand")) {
                if (viewer.getInventory().getItemInOffHand() != null) {
                    return viewer.getInventory().getItemInOffHand().clone();
                }
                return null;
            }
        } else {
            itemStack = new ItemStack(Material.STONE, amt);
        }
        if (itemStack == null) {
            itemStack = new ItemStack(Material.STONE, 1);
        }
        if (this.getDynamicAmount() != null) {
            try {
                String dAmt = mp.setArgPlaceholders(this.dynamicAmount);
                amt = Integer.parseInt(PlaceholderAPI.setPlaceholders((Player)viewer, (String)dAmt));
                if (amt <= 0) {
                    amt = 1;
                }
            }
            catch (Exception ex) {
                amt = this.amount;
            }
        } else {
            amt = this.amount;
        }
        meta = itemStack.getItemMeta();
        if (this.displayName != null) {
            String dName = mp.setArgPlaceholders(this.displayName);
            if (this.displayNameHasPlaceholders) {
                meta.setDisplayName(PlaceholderAPI.setPlaceholders((Player)viewer, (String)dName));
            } else {
                meta.setDisplayName(StringUtils.color(dName));
            }
        }
        if (this.lore != null) {
            ArrayList<String> l = new ArrayList<String>();
            for (String line : this.lore) {
                String loreLine = mp.setArgPlaceholders(line);
                loreLine = this.loreHasPlaceholders ? PlaceholderAPI.setPlaceholders((Player)viewer, (String)loreLine) : StringUtils.color(loreLine);
                if (loreLine.contains("\n")) {
                    String[] parts2 = loreLine.split("\n");
                    Arrays.stream(parts2).forEach(part -> l.add((String)part));
                    continue;
                }
                l.add(loreLine);
            }
            meta.setLore(l);
        }
        if (this.hideAttributes) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        }
        if (this.hideEnchants) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        }
        if (this.hidePotionEffects) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_POTION_EFFECTS});
        }
        if (this.unbreakable) {
            meta.setUnbreakable(true);
        }
        if (this.hideUnbreakable) {
            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        }
        if (meta instanceof LeatherArmorMeta && this.rgb != null) {
            String rgbString = PlaceholderAPI.setPlaceholders((Player)viewer, (String)this.rgb);
            rgbString = mp.setArgPlaceholders(rgbString);
            String[] parts3 = rgbString.split(",");
            LeatherArmorMeta lam = (LeatherArmorMeta)meta;
            try {
                lam.setColor(Color.fromRGB((int)Integer.parseInt(parts3[0]), (int)Integer.parseInt(parts3[1]), (int)Integer.parseInt(parts3[2])));
                itemStack.setItemMeta((ItemMeta)lam);
            }
            catch (Exception ex) {
                if (DeluxeMenus.isDebug()) {
                    ex.printStackTrace();
                }
            }
        } else {
            itemStack.setItemMeta((ItemMeta)meta);
        }
        if (this.enchantments != null) {
            itemStack.addUnsafeEnchantments(this.enchantments);
        }
        if (amt > 64) {
            amt = 64;
        }
        if (this.getNbtString() != null && DeluxeMenus.getInstance().getNms().getAccessor() != null && this.getNbtString().contains(":")) {
            parts = this.getNbtString().split(":");
            itemStack = DeluxeMenus.getInstance().getNms().getAccessor().setTag(itemStack, parts[0], parts[1]);
        }
        if (this.getNbtInt() != null && DeluxeMenus.getInstance().getNms().getAccessor() != null && this.getNbtInt().contains(":")) {
            parts = this.getNbtInt().split(":");
            itemStack = DeluxeMenus.getInstance().getNms().getAccessor().setTag(itemStack, parts[0], Integer.parseInt(parts[1]));
        }
        itemStack.setAmount(amt);
        return itemStack;
    }
}

