/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.menu.requirement;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.menu.ClickHandler;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.menu.requirement.Requirement;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;

public class HasMetaRequirement
extends Requirement {
    private final String key;
    private final String value;
    private final String type;
    private final boolean invert;

    public HasMetaRequirement(ClickHandler handler, String key, String type, String value, boolean invert) {
        super(handler);
        this.key = key;
        this.type = type.toUpperCase();
        this.value = value;
        this.invert = invert;
    }

    @Override
    public boolean evaluate(MenuHolder holder) {
        Player player = holder.getViewer();
        if (player == null) {
            return false;
        }
        String parsedKey = PlaceholderAPI.setPlaceholders((Player)player, (String)this.key);
        String metaVal = DeluxeMenus.getInstance().getNms().getPersistentDataUtils().getMeta(player, parsedKey, this.type, null);
        if (metaVal == null) {
            return this.invert;
        }
        String val = PlaceholderAPI.setPlaceholders((Player)player, (String)this.value);
        metaVal = PlaceholderAPI.setPlaceholders((Player)player, (String)metaVal);
        switch (this.type) {
            case "STRING": 
            case "BOOLEAN": {
                return this.invert ? !metaVal.equalsIgnoreCase(val) : metaVal.equalsIgnoreCase(val);
            }
            case "INTEGER": 
            case "LONG": {
                try {
                    boolean pass;
                    long netaNum = Long.parseLong(metaVal);
                    long toCheck = Long.parseLong(val);
                    boolean bl = pass = netaNum >= toCheck;
                    return this.invert ? !pass : pass;
                }
                catch (Exception netaNum) {
                    // empty catch block
                }
            }
            case "DOUBLE": {
                try {
                    boolean pass;
                    double netaNum = Double.parseDouble(metaVal);
                    double toCheck = Double.parseDouble(val);
                    boolean bl = pass = netaNum >= toCheck;
                    return this.invert ? !pass : pass;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return this.invert;
    }
}

