/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.menu.requirement;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.menu.ClickHandler;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.menu.requirement.Requirement;
import com.extendedclip.deluxemenus.menu.requirement.RequirementType;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.entity.Player;

public class InputResultRequirement
extends Requirement {
    private final String input;
    private final String result;
    private final RequirementType type;

    public InputResultRequirement(ClickHandler handler, RequirementType type, String input, String result) {
        super(handler);
        this.input = input;
        this.result = result;
        this.type = type;
    }

    @Override
    public boolean evaluate(MenuHolder holder) {
        int res;
        int in;
        String input = PlaceholderAPI.setPlaceholders((Player)holder.getViewer(), (String)this.input);
        String result = PlaceholderAPI.setPlaceholders((Player)holder.getViewer(), (String)this.result);
        switch (this.type) {
            case STRING_CONTAINS: {
                return input.contains(result);
            }
            case STRING_EQUALS: {
                return input.equals(result);
            }
            case STRING_EQUALS_IGNORECASE: {
                return input.equalsIgnoreCase(result);
            }
            case STRING_DOES_NOT_CONTAIN: {
                return !input.contains(result);
            }
            case STRING_DOES_NOT_EQUAL: {
                return !input.equals(result);
            }
            case STRING_DOES_NOT_EQUAL_IGNORECASE: {
                return !input.equalsIgnoreCase(result);
            }
        }
        try {
            in = Integer.parseInt(input);
            res = Integer.parseInt(result);
        }
        catch (NumberFormatException ex) {
            if (DeluxeMenus.isDebug()) {
                ex.printStackTrace();
            }
            return false;
        }
        switch (this.type) {
            case GREATER_THAN: {
                return in > res;
            }
            case GREATER_THAN_EQUAL_TO: {
                return in >= res;
            }
            case EQUAL_TO: {
                return in == res;
            }
            case LESS_THAN_EQUAL_TO: {
                return in <= res;
            }
            case LESS_THAN: {
                return in < res;
            }
        }
        return false;
    }
}

