/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.menu.requirement;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.extendedclip.deluxemenus.menu.ClickHandler;
import com.extendedclip.deluxemenus.menu.MenuHolder;
import com.extendedclip.deluxemenus.menu.requirement.Requirement;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class JavascriptRequirement
extends Requirement {
    private final String expression;
    private static ScriptEngine engine = null;

    public JavascriptRequirement(ClickHandler denyHandler, String expression) {
        super(denyHandler);
        this.expression = expression;
        if (engine == null) {
            engine = new ScriptEngineManager().getEngineByName("javascript");
            engine.put("BukkitServer", Bukkit.getServer());
        }
    }

    @Override
    public boolean evaluate(MenuHolder holder) {
        String exp = PlaceholderAPI.setPlaceholders((Player)holder.getViewer(), (String)this.expression);
        try {
            engine.put("BukkitPlayer", holder.getViewer());
            Object result = engine.eval(exp);
            if (!(result instanceof Boolean)) {
                this.getInstance().getLogger().severe("Requirement javascript <" + this.expression + "> is invalid and does not return a boolean!");
                return false;
            }
            return (Boolean)result;
        }
        catch (NullPointerException | ScriptException ex) {
            this.getInstance().getLogger().severe("Error in requirement javascript syntax - " + this.expression);
            if (DeluxeMenus.isDebug()) {
                ex.printStackTrace();
            }
            return false;
        }
    }

    public static ScriptEngine getEngine() {
        return engine;
    }

    public static void setEngine(ScriptEngine engine) {
        JavascriptRequirement.engine = engine;
    }
}

