/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.nms.persistentmeta;

import com.extendedclip.deluxemenus.DeluxeMenus;
import java.util.Arrays;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class PersistentDataUtils {
    public PersistentDataType getSupportedType(String name) {
        switch (name) {
            case "DOUBLE": {
                return PersistentDataType.DOUBLE;
            }
            case "INTEGER": 
            case "LONG": {
                return PersistentDataType.LONG;
            }
            case "STRING": 
            case "BOOLEAN": {
                return PersistentDataType.STRING;
            }
        }
        return null;
    }

    private NamespacedKey getKey(String key) {
        NamespacedKey nsk = null;
        nsk = key.contains(":") ? new NamespacedKey(key.split(":")[0], key.split(":")[1]) : new NamespacedKey((Plugin)DeluxeMenus.getInstance(), key);
        return nsk;
    }

    public String getMeta(Player player, String key, String typeName, String def) {
        if (key == null) {
            return def;
        }
        NamespacedKey namespacedKey = this.getKey(key);
        if (namespacedKey == null) {
            return def;
        }
        PersistentDataType type = this.getSupportedType(typeName);
        if (type == null) {
            return def;
        }
        return String.valueOf(player.getPersistentDataContainer().getOrDefault(namespacedKey, type, (Object)def));
    }

    public boolean setMeta(Player player, String input) {
        String[] args = input.split(" ");
        if (args.length < 4) {
            return false;
        }
        DataAction action = DataAction.from(args[0]);
        if (action == null) {
            return false;
        }
        PersistentDataType persistentDataType = this.getSupportedType(args[2]);
        if (persistentDataType == null) {
            return false;
        }
        NamespacedKey nsk = this.getKey(args[1]);
        if (nsk == null) {
            return false;
        }
        String value = String.join((CharSequence)" ", Arrays.asList(args).subList(3, args.length));
        if (value.toString().equalsIgnoreCase("null")) {
            player.getPersistentDataContainer().remove(nsk);
            return true;
        }
        switch (action) {
            case SET: {
                if (persistentDataType == PersistentDataType.STRING) {
                    player.getPersistentDataContainer().set(nsk, persistentDataType, (Object)value);
                } else if (persistentDataType == PersistentDataType.DOUBLE) {
                    player.getPersistentDataContainer().set(nsk, persistentDataType, (Object)Double.parseDouble(value));
                } else if (persistentDataType == PersistentDataType.LONG) {
                    player.getPersistentDataContainer().set(nsk, persistentDataType, (Object)Long.parseLong(value));
                } else {
                    return false;
                }
                return true;
            }
            case REMOVE: {
                player.getPersistentDataContainer().remove(nsk);
                return true;
            }
            case SWITCH: {
                boolean isTrue = ((String)player.getPersistentDataContainer().getOrDefault(nsk, persistentDataType, (Object)value.toString())).equalsIgnoreCase("TRUE");
                player.getPersistentDataContainer().set(nsk, persistentDataType, (Object)String.valueOf(!isTrue));
                return true;
            }
            case ADD: {
                if (persistentDataType == PersistentDataType.STRING) {
                    return false;
                }
                Object current = player.getPersistentDataContainer().getOrDefault(nsk, persistentDataType, (Object)0);
                if (persistentDataType == PersistentDataType.DOUBLE) {
                    double toAdd = (Double)current + Double.parseDouble(value);
                    player.getPersistentDataContainer().set(nsk, persistentDataType, (Object)toAdd);
                    return true;
                }
                long lToAdd = Long.parseLong(current.toString()) + Long.parseLong(value);
                player.getPersistentDataContainer().set(nsk, persistentDataType, (Object)lToAdd);
                return true;
            }
            case SUBTRACT: {
                if (persistentDataType == PersistentDataType.STRING) {
                    return false;
                }
                Object sCurrent = player.getPersistentDataContainer().getOrDefault(nsk, persistentDataType, (Object)0);
                if (persistentDataType == PersistentDataType.DOUBLE) {
                    double toSet = (Double)sCurrent - Double.parseDouble(value);
                    player.getPersistentDataContainer().set(nsk, persistentDataType, (Object)toSet);
                    return true;
                }
                long lToSub = Long.parseLong(sCurrent.toString()) - Long.parseLong(value);
                player.getPersistentDataContainer().set(nsk, persistentDataType, (Object)lToSub);
            }
        }
        return true;
    }

    public static enum DataAction {
        SET,
        REMOVE,
        ADD,
        SUBTRACT,
        SWITCH;


        public static DataAction from(String string) {
            for (DataAction type : DataAction.values()) {
                if (!string.equalsIgnoreCase(type.name())) continue;
                return type;
            }
            return null;
        }
    }
}

