/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.updatechecker;

import com.extendedclip.deluxemenus.DeluxeMenus;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.regex.Pattern;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class UpdateChecker
implements Listener {
    private final DeluxeMenus plugin;
    final int resourceId = 11734;
    private String latestVersion = null;
    private boolean updateAvailable = false;

    public UpdateChecker(DeluxeMenus i) {
        this.plugin = i;
        new BukkitRunnable(){

            public void run() {
                if (UpdateChecker.this.check()) {
                    new BukkitRunnable(){

                        public void run() {
                            UpdateChecker.this.register();
                        }
                    }.runTask((Plugin)UpdateChecker.this.plugin);
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private void register() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this.plugin);
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onJoin(PlayerJoinEvent e) {
        Player p = e.getPlayer();
        if (p.isOp() && this.updateAvailable()) {
            this.plugin.sms((CommandSender)p, "&aAn update for &6&lDeluxe&eMenus &ais available. Version &f" + this.getLatestVersion() + "&a, You are running &f" + this.plugin.getDescription().getVersion());
            this.plugin.sms((CommandSender)p, "&aDownload the latest version at: &fhttps://www.spigotmc.org/resources/deluxemenus.11734/");
        }
    }

    private String getSpigotVersion() {
        try {
            HttpURLConnection connection = (HttpURLConnection)new URL("https://api.spigotmc.org/legacy/update.php?resource=11734").openConnection();
            connection.setDoOutput(true);
            connection.setRequestMethod("GET");
            return new BufferedReader(new InputStreamReader(connection.getInputStream())).readLine();
        }
        catch (Exception ex) {
            this.plugin.getLogger().info("Failed to check for a update on spigot.");
            return null;
        }
    }

    public boolean check() {
        String version = this.getSpigotVersion();
        if (version != null) {
            if (this.checkHigher(this.plugin.getDescription().getVersion(), version)) {
                this.latestVersion = version;
                this.updateAvailable = true;
                return true;
            }
            this.latestVersion = this.plugin.getDescription().getVersion();
            this.updateAvailable = false;
        }
        return false;
    }

    public boolean updateAvailable() {
        return this.updateAvailable;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    private boolean checkHigher(String currentVersion, String newVersion) {
        String newVers;
        String current = this.toReadable(currentVersion);
        return current.compareTo(newVers = this.toReadable(newVersion)) < 0;
    }

    private String toReadable(String version) {
        String[] split = Pattern.compile(".", 16).split(version.replace("v", ""));
        version = "";
        for (String s : split) {
            version = version + String.format("%4s", s);
        }
        return version;
    }
}

