;(function($) {
  'use strict'

  var DesignHunt = function DesignHunt(el) {
    var url = window.location.href
    var captured = /search=([^&]+)/.exec(url) // Value is in [1] ('384' in our case)

    var result = captured ? captured : ''
    this.searchTerm = result[1]
    this.skipNumber = 0
    this.el = $(el) // container element

    this.searchTerm
    this.feedURL = 'https://designhunt.us/api/'
    this.searchURL = 'https://designhunt.us/api/'
    this.currentFeed = null
    this.user = null
  }

  DesignHunt.prototype = {
    init: function init() {
      if (this.searchTerm !== undefined) {
        var decodedSearchString = decodeURIComponent(
          this.searchTerm.replace(/\+/g, ' ')
        )
        $('#search-input').val(decodedSearchString)

        this.getFeed(this.feedURL + 'search?q=' + this.searchTerm)
        _gaq.push(['_trackEvent', 'Feed', 'search', this.searchTerm])
      } else {
        this.getFeed(this.feedURL + 'feed/')
      }

      // this.getFeed(this.feedURL + this.skipNumber)
      this.windowListen(this)
    },
    windowListen: function windowListen(self) {
      var self = self

      window.onscroll = function(ev) {
        if (
          window.innerHeight + window.scrollY >=
          document.body.scrollHeight - 300
        ) {
          var $this = $('#grid')

          if (!$this.data('loading')) {
            $this.data('loading', true)
            if (self.searchTerm !== undefined) {
              self.skipNumber = self.skipNumber + 300
            } else {
              self.skipNumber = self.skipNumber + 25
            }
            if (self.searchTerm !== undefined) {
            } else {
              self.getFeed(self.feedURL + 'feed?skip=' + self.skipNumber)
            }

            $this.removeData('loading')
          } else {
          }
        }
      }
    },
    getFeed: function getFeed(feed, type) {
      var self = this
      $.getJSON(feed, function(data) {
        var user = data['user']
        self.user = user
        self.renderFeed(data['posts'])
      })
    },
    appendToFeed: function appendToFeed(feed, type) {
      var self = this
      $.getJSON(feed, function(data) {
        var user = data['user']
        self.user = user
        self.renderFeed(data['posts'])
        _gaq.push(['_trackEvent', 'Feed', 'append'])
      })
    },
    addElementsToPage: function addElementsToPage() {
      $('.masonry')
        .imagesLoaded()
        .always(function(instance) {})
        .done(function(instance) {})
        .fail(function() {})
        .progress(function(instance, image) {
          var result = image.isLoaded ? 'loaded' : 'broken'
          var $item = $(image.img).parent()
          $item.removeClass('is-loading')

          if (!image.isLoaded) {
            $item.addClass('is-broken')
            $item.remove()
          }
        })
    },
    renderFeed: function renderFeed(results) {
      var self = this

      for (var i in results) {
        var obj = results[i],
          id = obj.objectId,
          img = obj.image_url,
          width = obj.imageWidth,
          height = obj.imageHeight,
          colors = obj.colors,
          short_url = obj.short_url,
          title = obj.title,
          url = obj.source_url

        if (!(img == undefined || url == undefined)) {
          var aspect = ''
          var aspectNumber = width / height

          if (height > width) {
            aspect = 'tall'
          } else {
            if (aspectNumber == 1) {
              aspect = 'square'
            }
            if (aspectNumber >= 1.3) {
              aspect = 'wide'
            }

            if (aspectNumber >= 1.6) {
              aspect = 'mid-wide'
            }

            if (aspectNumber >= 1.8) {
              aspect = 'ultra-wide'
            }
          }

          var html = $(
            '<div class="masonry-brick masonry-brick--h is-loading ' +
              aspect +
              '" data-link="' +
              url +
              '"><img class="masonry-img" src="' +
              img +
              '"/></div>'
          )
          $('.masonry').append(html) // position them within the existing grid
        }
      }

      self.addElementsToPage()
      _gaq.push(['_trackEvent', 'Feed', 'refresh'])
    }
  }
  $(document).ready(function() {
    // initialize app
    var DesignHuntApp = new DesignHunt('.grid')
    DesignHuntApp.init()

    $('.masonry--h').on('click', '.masonry-brick--h', function() {
      var currentLink = $(this).attr('data-link')
      _gaq.push(['_trackEvent', 'Image', 'click'])
      window.open(currentLink)
      // Do something on an existent or future .dynamicElement
    })
  })
})(jQuery)
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
