--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 07.04.2019
Version: 1.0.0.0

History:
V 1.0.0.0 @ 07.04.2019 - Release Version

Contact:
GtX_Andy@protonmail.com

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefgt oder von der aktuellen Release-Form gendert werden.
An diesem Skript drfen ohne Genehmigung von GtX | Andy keine nderungen vorgenommen werden
]]


DebugConsoleCommands = {}
local DebugConsoleCommands_mt = Class(DebugConsoleCommands)

function DebugConsoleCommands:new(owner)
    if g_easyDevControls == nil then
        return
    end

    local self = {}
    setmetatable(self, DebugConsoleCommands_mt)

    self.owner = owner

    self.isServer = owner.isServer
    self.isClient = owner.isClient

    addConsoleCommand("leaveCurrentGame", "Exit to the main menu quickly without saving.", "consoleCommandLeave", self)

    -- These commands are for debugging. Limitation is providing a pointer that includes an 'integer' as these are seen as floats in lua 5.2 and below.
    addConsoleCommand("printVariable", "Print the given variable to the log and console. [variable] [environment](optional).", "consoleCommandPrintVariable", self)
    addConsoleCommand("printTable", "Print the given table to the log and console. [table] [depth] [maxDepth] [environment](optional).", "consoleCommandPrintTable", self)

    return self
end

function DebugConsoleCommands:delete()
    removeConsoleCommand("leaveCurrentGame")

    removeConsoleCommand("printVariable")
    removeConsoleCommand("printTable")

    if g_easyDevControls ~= nil then
        g_easyDevControls.debugConsoleCommands = nil
    end
end

function DebugConsoleCommands:consoleCommandLeave()
    print("  Info: [Easy Development Controls] - Exiting to main menu.")
    g_currentMission.inGameMenu:leaveCurrentGame()
end

function DebugConsoleCommands:consoleCommandPrintVariable(variable, environment)
    local enviromentToSearch = self:getEnviromentFromString(environment)

    local name = "GLOBAL VARIABLE PRINT"

    if variable ~= nil and variable:upper() ~= "GLOBAL" then
        local path, warning = self:getPathFromString(enviromentToSearch, variable)
        if path ~= nil then
            name = inputTable
            enviromentToSearch = path
        else
            return warning
        end

        if type(enviromentToSearch) ~= "table" and type(enviromentToSearch) ~= "function" then
            print(tostring(variable) .. " = " .. tostring(enviromentToSearch))
        else
            return "printVariable failed! ' " .. variable .. "'  is an unsupported type ' " .. type(enviromentToSearch) .. " '."
        end
    else
        print("-- (START) --")

        for k, v in pairs (enviromentToSearch) do
            if type(v) ~= "table" and type(v) ~= "function" then
                print(tostring(k) .. " = " .. tostring(v))
            end
        end

        print("-- (END) --")
    end
end

function DebugConsoleCommands:consoleCommandPrintTable(inputTable, depth, maxDepth, environment)
    local maxDepth = tonumber(Utils.getNoNil(maxDepth, 3))
    local depth = math.min(tonumber(Utils.getNoNil(depth, 1)), maxDepth)

    local name = "GLOBAL TABLE PRINT"
    local enviromentToSearch = self:getEnviromentFromString(environment)

    if inputTable ~= nil then
        if inputTable:upper() ~= "GLOBAL" then
            local path, warning = self:getPathFromString(enviromentToSearch, inputTable)
            if path ~= nil then
                name = inputTable
                enviromentToSearch = path
            else
                return warning
            end
        end

        if type(enviromentToSearch) == "table" then
            print("", "-- " .. name .. " (START) --")
            DebugUtil.printTableRecursively(enviromentToSearch, " ", depth, maxDepth)
            print("", "-- " .. name .. " ( END ) --")
        else
            return "printTable failed! ' " .. inputTable .. "' type is not ' table ' it is a ' " .. type(inputTable) .. " '."
        end

    end
end

function DebugConsoleCommands:getEnviromentFromString(environment)
    if environment ~= nil then
        if environment == "fenv0" then
            return getfenv(0)
        elseif environment == "_G" then
            return _G
        else
            print(environment .. " Is not a valid option. Use: fenv0 or _G", "Using default 'fenv0' instead.")
        end
    end

    return getfenv(0)
end

function DebugConsoleCommands:getPathFromString(toSearch, value)
    local warning = ""

    if string.find(value, "%.") ~= nil then
        local splitValues = StringUtil.splitString(".", value)
        local numSplits = #splitValues
        if numSplits > 1 then
            local env = toSearch

            if numSplits < 10 then
                if numSplits == 10 then
                    toSearch = env[splitValues[1]][splitValues[2]][splitValues[3]][splitValues[4]][splitValues[5]][splitValues[6]][splitValues[7]][splitValues[8]][splitValues[9]][splitValues[10]]
                elseif numSplits == 9 then
                    toSearch = env[splitValues[1]][splitValues[2]][splitValues[3]][splitValues[4]][splitValues[5]][splitValues[6]][splitValues[7]][splitValues[8]][splitValues[9]]
                elseif numSplits == 8 then
                    toSearch = env[splitValues[1]][splitValues[2]][splitValues[3]][splitValues[4]][splitValues[5]][splitValues[6]][splitValues[7]][splitValues[8]]
                elseif numSplits == 7 then
                    toSearch = env[splitValues[1]][splitValues[2]][splitValues[3]][splitValues[4]][splitValues[5]][splitValues[6]][splitValues[7]]
                elseif numSplits == 6 then
                    toSearch = env[splitValues[1]][splitValues[2]][splitValues[3]][splitValues[4]][splitValues[5]][splitValues[6]]
                elseif numSplits == 5 then
                    toSearch = env[splitValues[1]][splitValues[2]][splitValues[3]][splitValues[4]][splitValues[5]]
                elseif numSplits == 4 then
                    toSearch = env[splitValues[1]][splitValues[2]][splitValues[3]][splitValues[4]]
                elseif numSplits == 3 then
                    toSearch = env[splitValues[1]][splitValues[2]][splitValues[3]]
                elseif numSplits == 2 then
                    toSearch = env[splitValues[1]][splitValues[2]]
                end
            else
                warning = "Attempt to call '" .. value .. "' not possible. Max call depth is 10"
            end
        end
    else
        toSearch = toSearch[value]
    end

    return toSearch, warning
end