--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 07.04.2019
Version: 1.0.0.0

History:
V 1.0.0.0 @ 07.04.2019 - Release Version

Contact:
GtX_Andy@protonmail.com

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefgt oder von der aktuellen Release-Form gendert werden.
An diesem Skript drfen ohne Genehmigung von GtX | Andy keine nderungen vorgenommen werden
]]


EasyDevControls = {}
local EasyDevControls_mt = Class(EasyDevControls)

EasyDevControls.buildId = 1
EasyDevControls.versionString = "1.0.0.0"

EasyDevControls.ENABLE_DEVELOPMENT_MODE = false -- GtX only.
EasyDevControls.ENABLE_CONSOLE_COMMANDS = true -- Leave enabled on release. Player should only use if they understand.

-- Limit to 4000. This is a very high value.
-- If it is too fast it will BREAK some mods and base game functions.
EasyDevControls.MAX_TIME_SCALE = 4000
EasyDevControls.DEFAULT_TIME_SCALE = 2000

EasyDevControls.DEFAULT_SPEED_MULTIPLIER = 4

EasyDevControls.GROUND_NAME_FROM_INDEX = {
    "cultivator", "plow", "sowing", "sowing_width"
}

function EasyDevControls:new(isServer, isClient, customEnvironment, baseDirectory)
    if g_easyDevControls ~= nil then
        return
    end

    local self = {}
    setmetatable(self, EasyDevControls_mt)

    self.isServer = isServer
    self.isClient = isClient

    self.isDeveloper = false

    -- Need to be global for GUI. Only with the 'EDC_' prefix though.
    local globalTexts = getfenv(0).g_i18n.texts
    for k, v in pairs (g_i18n.texts) do
        local prefix, _ = k:find("EDC_", 1, true)
        if prefix ~= nil then
            globalTexts[k] = v
        else
            if EasyDevControls.ENABLE_DEVELOPMENT_MODE then
                g_logManager:warning("  [EasyDevControls]  ' %s ' does not have a valid prefix.", k)
            end
        end
    end

    self.playerSpeedText = g_i18n:getText("EDC_playerSpeedText")
    self.timeScaleText = g_i18n:getText("EDC_timeScaleText")

    self.isEnabled = false
    self.printToLog = false

    self.customEnvironment = customEnvironment
    self.baseDirectory = baseDirectory

    self.speedMultiplier = 1
    self.showSpeedMultiplier = true
    self.speedMultiplierActive = false

    self.playerMotionInformation = {
        maxWalkingSpeed = 6.0,
        maxRunningSpeed = 9.0,
        maxSwimmingSpeed = 3.0,
        maxCrouchingSpeed = 2.0,
        maxFallingSpeed = 6.0
    }

    self.timeScale = 0
    self.showTimeScale = true

    self.lastFoundObject = nil
    self.deleteInputActive = false
    self.lastFoundIsSplitShape = false

    addModEventListener(self)

    return self
end

function EasyDevControls:load(isReload)

    -- Do this late so we can make sure it is not active by another mod.
    self.disableExtraTimeScale = Utils.getNumTimeScales() ~= 6
    if not self.disableExtraTimeScale then
        Utils.getTimeScaleString = Utils.overwrittenFunction(Utils.getTimeScaleString, getTimeScaleString)
        Utils.getTimeScaleIndex = Utils.overwrittenFunction(Utils.getTimeScaleIndex, getTimeScaleIndex)
        Utils.getTimeScaleFromIndex = Utils.overwrittenFunction(Utils.getTimeScaleFromIndex, getTimeScaleFromIndex)
        Utils.getNumTimeScales = Utils.overwrittenFunction(Utils.getNumTimeScales, getNumTimeScales)
    else
        print("  Info: [Easy Development Controls]  Extra Time Scale has been disabled by another mod or developer mode.")
    end

    if self.isClient then
        g_gui:loadProfiles(self.baseDirectory .. "gui/guiProfiles.xml")

        local tabbedMenu = EasyDevControlsTabbedMenu:new(nil, g_messageCenter, g_i18n, g_gui.inputManager, self.printToLog)

        local generalFrame = EasyDevControlsGeneralFrame:new()
        local environmentFrame = EasyDevControlsEnvironmentFrame:new()
        local playerFrame = EasyDevControlsPlayerFrame:new()
        local vehiclesFrame = EasyDevControlsVehiclesFrame:new()
        local fieldFrame = EasyDevControlsFieldFrame:new()

        g_gui:loadGui(self.baseDirectory .. "gui/EasyDevControlsGeneralFrame.xml", "EasyDevControlsGeneralFrame", generalFrame, true)
        g_gui:loadGui(self.baseDirectory .. "gui/EasyDevControlsEnvironmentFrame.xml", "EasyDevControlsEnvironmentFrame", environmentFrame, true)
        g_gui:loadGui(self.baseDirectory .. "gui/EasyDevControlsPlayerFrame.xml", "EasyDevControlsPlayerFrame", playerFrame, true)
        g_gui:loadGui(self.baseDirectory .. "gui/EasyDevControlsFieldFrame.xml", "EasyDevControlsFieldFrame", fieldFrame, true)
        g_gui:loadGui(self.baseDirectory .. "gui/EasyDevControlsVehiclesFrame.xml", "EasyDevControlsVehiclesFrame", vehiclesFrame, true)

        g_gui:loadGui(self.baseDirectory .. "gui/EasyDevControlsTabbedMenu.xml", "EasyDevControlsTabbedMenu", tabbedMenu)

        if not isReload then
            if g_currentMission ~= nil and not g_currentMission.missionDynamicInfo.isMultiplayer then
                self.timeScale = EasyDevControls.DEFAULT_TIME_SCALE
                self.speedMultiplier = EasyDevControls.DEFAULT_SPEED_MULTIPLIER
            end
        end

        self.isEnabled = true
    end
end

function EasyDevControls:deleteMap()
    self.lastFoundObject = nil
    self.lastFoundIsSplitShape = false
    self.deleteInputActive = false

    if self.guiCreator ~= nil then
        self.guiCreator:delete()
    end

    if self.debugConsoleCommands ~= nil then
        self.debugConsoleCommands:delete()
    end

    getfenv(0)["g_easyDevControls"] = nil
end

function EasyDevControls:draw()
    if g_dedicatedServerInfo ~= nil or g_currentMission.player == nil or g_currentMission.controlledVehicle ~= nil then
        return
    end

    if self.isClient then
        if self.showSpeedMultiplier and self.speedMultiplierActive then
            g_currentMission:addExtraPrintText(string.format(self.playerSpeedText, self.speedMultiplier))
        end

        if self.showTimeScale and g_currentMission.missionInfo.timeScale == self.timeScale then
            g_currentMission:addExtraPrintText(string.format(self.timeScaleText, self.timeScale))
        end
    end

    -- Only with 'Super Strength' and only for SP or Hosting Player.
    if self.isServer and g_currentMission.player.superStrengthEnabled == true then
        local player = g_currentMission.player

        if player.isObjectInRange and not player.isCarryingObject then
            if player.lastFoundObject ~= nil and entityExists(player.lastFoundObject) then
                local text
                local object = g_currentMission:getNodeObject(player.lastFoundObject)

                if object ~= nil and object.isa ~= nil then
                    if object:isa(Vehicle) and object.typeName == "pallet" then
                        local fillUnit = object:getFillUnitByIndex(1)
                        if fillUnit ~= nil then
                            self.lastFoundObject = object
                            self.lastFoundIsSplitShape = false

                            local fillType = g_fillTypeManager:getFillTypeByIndex(fillUnit.fillType)
                            text = string.format("%s:  %d / %d %s", fillType.title, fillUnit.fillLevel, fillUnit.capacity, g_i18n:getVolumeUnit(true))
                        end
                    elseif object:isa(Bale) then
                        local fillTypeIndex = object:getFillType()
                        if fillTypeIndex ~= nil and fillTypeIndex ~= FillType.UNKNOWN then
                            self.lastFoundObject = object
                            self.lastFoundIsSplitShape = false

                            local fillType = g_fillTypeManager:getFillTypeByIndex(fillTypeIndex)
                            local fillLevel = object:getFillLevel() or 0
                            text = string.format("%s:  %s %s", fillType.title, g_i18n:formatNumber(fillLevel, 0), g_i18n:getVolumeUnit(true))
                        end
                    end
                elseif getHasClassId(player.lastFoundObject, ClassIds.MESH_SPLIT_SHAPE) then
                    object = player.lastFoundObject
                    local splitType = g_splitTypeManager.typesByIndex[getSplitType(object)]
                    if splitType ~= nil and splitType.woodChipsPerLiter > 0 then
                        self.lastFoundObject = object
                        self.lastFoundIsSplitShape = true

                        local name = splitType.name or "Split Shape"
                        local volume = getVolume(object) or 0
                        local fillLevelDelta = volume * 1000 * splitType.woodChipsPerLiter
                        text = string.format("%s:  %s %s", name:upper(), g_i18n:formatNumber(fillLevelDelta, 0), g_i18n:getVolumeUnit(true))
                    end
                end

                if text ~= nil then
                    g_currentMission:addExtraPrintText(text)
                end
            end

            if not self.deleteInputActive and g_easyDevControls.eventIdObjectDelete ~= nil then
                self.deleteInputActive = true

                g_inputBinding:setActionEventActive(g_easyDevControls.eventIdObjectDelete, self.lastFoundObject ~= nil)
                g_inputBinding:setActionEventTextVisibility(g_easyDevControls.eventIdObjectDelete, self.lastFoundObject ~= nil)
            end
        else
            self.lastFoundObject = nil
            self.lastFoundIsSplitShape = false

            if self.deleteInputActive then
                self.deleteInputActive = false

                if g_easyDevControls.eventIdObjectDelete ~= nil then
                    g_inputBinding:setActionEventActive(g_easyDevControls.eventIdObjectDelete, false)
                    g_inputBinding:setActionEventTextVisibility(g_easyDevControls.eventIdObjectDelete, false)
                end
            end
        end
    end
end

function EasyDevControls:setTimeScale(scale)
    if self.disableExtraTimeScale then
        return
    end

    if self.isServer or g_currentMission.isMasterUser then
        scale = MathUtil.clamp(Utils.getNoNil(scale, 0), 0, EasyDevControls.MAX_TIME_SCALE)

        if Utils.getTimeScaleIndex(g_currentMission.missionInfo.timeScale) == 7 then
            if scale > 0 then
                g_currentMission:setTimeScale(scale)
            else
                g_currentMission:setTimeScale(1)
            end
        end

        self.timeScale = scale

        if self.timeScale > 0 then
            return string.format(g_i18n:getText("EDC_setTimeScaleOn"), self.timeScale)
        else
            return g_i18n:getText("EDC_setTimeScaleOff")
        end
    end
end

function EasyDevControls:setSpeedMultiplierState(state, returnStateText)
    if state ~= nil then
        self.speedMultiplierActive = state
    else
        self.speedMultiplierActive = not self.speedMultiplierActive
    end

    if self.speedMultiplierActive then
        self:setSpeedMultiplier(self.speedMultiplier, false)

        if returnStateText then
            return g_i18n:getText("EDC_setPlayerSpeedOn")
        end
    else
        self:setSpeedMultiplier(1, false)

        if returnStateText then
            return g_i18n:getText("EDC_setPlayerSpeedOff")
        end
    end
end

function EasyDevControls:setSpeedMultiplier(multiplier, changeMultiplier)
    if multiplier == nil then
        multiplier = 1
    end

    if self.speedMultiplierActive or multiplier == 1 then
        local motionInformation = g_currentMission.player.motionInformation
        motionInformation.maxWalkingSpeed = self.playerMotionInformation.maxWalkingSpeed * multiplier
        motionInformation.maxRunningSpeed = self.playerMotionInformation.maxRunningSpeed * multiplier
        motionInformation.maxSwimmingSpeed = self.playerMotionInformation.maxSwimmingSpeed * multiplier
        motionInformation.maxCrouchingSpeed = self.playerMotionInformation.maxCrouchingSpeed * multiplier
        motionInformation.maxFallingSpeed = self.playerMotionInformation.maxFallingSpeed * multiplier
    end

    if changeMultiplier == true then
        self.speedMultiplier = multiplier
        return string.format(g_i18n:getText("EDC_changePlayerSpeed"), multiplier)
    end

    return
end

function EasyDevControls:setFieldFruit(fieldIndex, fruitIndex, growthState, groundLayer, fertilizerState, plowingState, weedState, limeState, sprayState, buyFarmland)
    if self.isServer then
        local fruitName = g_fruitTypeManager:getFruitTypeNameByIndex(fruitIndex)
        if fruitName == nil then
            fruitName = "WHEAT"
        end

        local title = fruitName
        local fillType = g_fruitTypeManager:getFillTypeByFruitTypeIndex(fruitIndex)
        if fillType ~= nil then
            title = fillType.title
        end

        growthState = tostring(growthState)
        groundLayer = tostring(groundLayer)
        fertilizerState = tostring(fertilizerState)
        plowingState = tostring(plowingState)
        weedState = tostring(weedState)
        limeState = tostring(limeState)
        sprayState = tostring(sprayState)

        if fieldIndex == nil or fieldIndex > #g_fieldManager.fields then
            local text = g_fieldManager:consoleCommandSetFieldFruitAll(fruitName, growthState, groundLayer, fertilizerState, plowingState, weedState, limeState, sprayState, "false")

            if text == "Updated field" then
                if buyFarmland then
                    g_farmlandManager:consoleCommandBuyAllFarmlands()

                    local text1 = string.format(g_i18n:getText("EDC_growthAllFields"), title, growthState)
                    local text2 = g_i18n:getText("EDC_allPurchaseComplete")
                    return text1 .. "  " .. text2
                else
                    return string.format(g_i18n:getText("EDC_growthAllFields"), title, growthState)
                end
            end
        else
            local fieldIndexStr = tostring(fieldIndex)
            local text = g_fieldManager:consoleCommandSetFieldFruit(fieldIndexStr, fruitName, growthState, groundLayer, fertilizerState, plowingState, weedState, limeState, sprayState, "false")

            if text == "Updated field" then
                local didPurchase = false
                if buyFarmland then
                    local fieldToBuy = g_fieldManager.fields[fieldIndex]
                    if fieldToBuy ~= nil then
                        local worldPosX, worldPosZ = fieldToBuy:getCenterOfFieldWorldPosition()
                        if worldPosX ~= nil and worldPosZ ~= nil then
                            local farmlandId = g_farmlandManager:getFarmlandIdAtWorldPosition(worldPosX, worldPosZ)
                            if g_farmlandManager:getIsValidFarmlandId(farmlandId) then
                                g_farmlandManager:consoleCommandBuyFarmland(farmlandId)
                                didPurchase = true
                            end
                        end
                    end
                end

                if didPurchase then
                    local text1 = string.format(g_i18n:getText("EDC_growthSingleField"), fieldIndexStr, title, growthState)
                    local text2 = g_i18n:getText("EDC_singlePurchaseComplete")
                    return text1 .. "  " .. text2
                else
                    return string.format(g_i18n:getText("EDC_growthSingleField"), fieldIndexStr, title, growthState)
                end
            end
        end
    else
        g_client:getServerConnection():sendEvent(EasyDevControlsFieldFruitEvent:new(fieldIndex, fruitIndex, growthState, groundLayer, fertilizerState, plowingState, weedState, limeState, sprayState))

        if fieldIndex > #g_fieldManager.fields then
            if buyFarmland then
                g_farmlandManager:consoleCommandBuyAllFarmlands()
            end

            return g_i18n:getText("EDC_serverUpdateRequest")
        else
           if buyFarmland then
                local fieldToBuy = g_fieldManager.fields[fieldIndex]
                if fieldToBuy ~= nil then
                    local worldPosX, worldPosZ = fieldToBuy:getCenterOfFieldWorldPosition()
                    if worldPosX ~= nil and worldPosZ ~= nil then
                        local farmlandId = g_farmlandManager:getFarmlandIdAtWorldPosition(worldPosX, worldPosZ)
                        if g_farmlandManager:getIsValidFarmlandId(farmlandId) then
                            g_farmlandManager:consoleCommandBuyFarmland(farmlandId)
                        end
                    end
                end
            end

            return g_i18n:getText("EDC_serverUpdateRequest")
        end
    end
end

function EasyDevControls:setFieldGround(fieldIndex, groundNameIndex, angle, groundLayer, fertilizerState, plowingState, weedState, limeState, buyFarmland)
    if self.isServer then
        local groundName = EasyDevControls.GROUND_NAME_FROM_INDEX[groundNameIndex]
        if groundName == nil then
            groundName = "cultivator"
        end

        angle = tostring(angle)
        groundLayer = tostring(groundLayer)
        fertilizerState = tostring(fertilizerState)
        plowingState = tostring(plowingState)
        weedState = tostring(weedState)
        limeState = tostring(limeState)

        if fieldIndex == nil or fieldIndex > #g_fieldManager.fields then
            local text = g_fieldManager:consoleCommandSetFieldGroundAll(groundName, angle, groundLayer, fertilizerState, plowingState, weedState, limeState, "false", nil)

            if text == "Updated fields" then
                if buyFarmland then
                    g_farmlandManager:consoleCommandBuyAllFarmlands()

                    local text1 = string.format(g_i18n:getText("EDC_groundAllFields"), groundName)
                    local text2 = g_i18n:getText("EDC_allPurchaseComplete")
                    return text1 .. "  " .. text2
                else
                    return string.format(g_i18n:getText("EDC_groundAllFields"), groundName)
                end
            end
        else
            local fieldIndexStr = tostring(fieldIndex)
            local text = g_fieldManager:consoleCommandSetFieldGround(fieldIndexStr, groundName, angle, groundLayer, fertilizerState, plowingState, weedState, limeState, "false", nil)

            if text == "Updated field" then
                local didPurchase = false
                if buyFarmland then
                    local fieldToBuy = g_fieldManager.fields[fieldIndex]
                    if fieldToBuy ~= nil then
                        local worldPosX, worldPosZ = fieldToBuy:getCenterOfFieldWorldPosition()
                        if worldPosX ~= nil and worldPosZ ~= nil then
                            local farmlandId = g_farmlandManager:getFarmlandIdAtWorldPosition(worldPosX, worldPosZ)
                            if g_farmlandManager:getIsValidFarmlandId(farmlandId) then
                                g_farmlandManager:consoleCommandBuyFarmland(farmlandId)
                                didPurchase = true
                            end
                        end
                    end
                end

                if didPurchase then
                    local text1 = string.format(g_i18n:getText("EDC_groundSingleField"), fieldIndexStr, groundName)
                    local text2 = g_i18n:getText("EDC_singlePurchaseComplete")
                    return text1 .. "  " .. text2
                else
                    return string.format(g_i18n:getText("EDC_groundSingleField"), fieldIndexStr, groundName)
                end
            end
        end
    else
        g_client:getServerConnection():sendEvent(EasyDevControlsFieldGroundEvent:new(fieldIndex, groundNameIndex, angle, groundLayer, fertilizerState, plowingState, weedState, limeState))

        if fieldIndex > #g_fieldManager.fields then
            if buyFarmland then
                g_farmlandManager:consoleCommandBuyAllFarmlands()
            end

            return g_i18n:getText("EDC_serverUpdateRequest")
        else
           if buyFarmland then
                local fieldToBuy = g_fieldManager.fields[fieldIndex]
                if fieldToBuy ~= nil then
                    local worldPosX, worldPosZ = fieldToBuy:getCenterOfFieldWorldPosition()
                    if worldPosX ~= nil and worldPosZ ~= nil then
                        local farmlandId = g_farmlandManager:getFarmlandIdAtWorldPosition(worldPosX, worldPosZ)
                        if g_farmlandManager:getIsValidFarmlandId(farmlandId) then
                            g_farmlandManager:consoleCommandBuyFarmland(farmlandId)
                        end
                    end
                end
            end

            return g_i18n:getText("EDC_serverUpdateRequest")
        end
    end
end

function EasyDevControls:addLevelToSilos(fillTypeIndex, volumeToAdd, farmId)
    if fillTypeIndex ~= nil then
        if self.isServer then
            local numSilos, added = 0, 0
            local doEmpty = volumeToAdd == 0

            local storageSystem = g_currentMission.storageSystem
            for _, storage in pairs(storageSystem.storages) do
                if g_currentMission.accessHandler:canFarmAccess(farmId, storage) then
                    if storage:getIsFillTypeSupported(fillTypeIndex) then
                        if doEmpty then
                            storage:setFillLevel(0, fillTypeIndex)
                            numSilos = numSilos + 1
                        else
                            local freeCapacity = storage:getFreeCapacity(fillTypeIndex)
                            if freeCapacity > 0 then
                                local amountToAdd = math.min(volumeToAdd, freeCapacity)
                                added = added + amountToAdd

                                volumeToAdd = volumeToAdd - amountToAdd
                                storage:setFillLevel(storage:getFillLevel(fillTypeIndex) + amountToAdd, fillTypeIndex)
                                numSilos = numSilos + 1

                                if volumeToAdd == 0 then
                                    break
                                end
                            end
                        end
                    end
                end
            end

            if numSilos > 0 then
                local title = tostring(g_fillTypeManager:getFillTypeByIndex(fillTypeIndex).title)
                if doEmpty then
                    return string.format(g_i18n:getText("EDC_emptySilos"), title, numSilos)
                else
                    return string.format(g_i18n:getText("EDC_addToSilos"), added, title, numSilos)
                end
            end
        else
            g_client:getServerConnection():sendEvent(EasyDevControlsSiloCheatEvent:new(fillTypeIndex, volumeToAdd, farmId))

            return g_i18n:getText("EDC_serverUpdateRequest")
        end
    end
end

function EasyDevControls:onInputOpenMenu(_, inputValue)
    if self.isEnabled and not g_gui:getIsGuiVisible() then
        self.easyDevGui = g_gui:showGui("EasyDevControlsTabbedMenu")
    end
end

function EasyDevControls:onInputPlayerSpeed(_, inputValue)
    if self.isEnabled and self.speedMultiplier ~= 1 and not g_gui:getIsGuiVisible() then
        self:setSpeedMultiplierState(not self.speedMultiplierActive, false)
    end
end

function EasyDevControls:onInputObjectDelete(_, inputValue)
    if not self.isServer then
        return
    end

    if self.isEnabled and self.lastFoundObject ~= nil and not g_gui:getIsGuiVisible() then
        if self.lastFoundIsSplitShape then
            delete(self.lastFoundObject)
        else
            self.lastFoundObject:delete()
        end
    end
end

function easyDevControlsInit(name, c)
    if name == nil or c == nil then
        return
    end

    if g_easyDevControls == nil then
        if (name == "FS19_EasyDevControls" or name == "FS19_EasyDevControls_update") and c:len() == 3 then
            local modDir = g_currentModDirectory
            local easyDevControls = EasyDevControls:new(g_server ~= nil, g_dedicatedServerInfo == nil, name, modDir)
            if easyDevControls ~= nil then
                getfenv(0)["g_easyDevControls"] = easyDevControls

                if easyDevControls.isClient then
                    -- GtX only. Not included in release.
                    if EasyDevControls.ENABLE_DEVELOPMENT_MODE then
                        easyDevControls.isDeveloper = true

                        if easyDevControls.isServer then
                            --source(modDir .. "scripts/developer/GuiCreator.lua")
                            --easyDevControls.guiCreator = GuiCreator:new(easyDevControls)
                        end
                    end

                    if EasyDevControls.ENABLE_CONSOLE_COMMANDS or easyDevControls.isDeveloper then
                        source(modDir .. "scripts/DebugConsoleCommands.lua")
                        easyDevControls.debugConsoleCommands = DebugConsoleCommands:new(easyDevControls)
                    end
                end

                source(modDir .. "scripts/gui/EasyDevControlsTabbedMenu.lua")
                source(modDir .. "scripts/gui/EasyDevControlsGeneralFrame.lua")
                source(modDir .. "scripts/gui/EasyDevControlsEnvironmentFrame.lua")
                source(modDir .. "scripts/gui/EasyDevControlsPlayerFrame.lua")
                source(modDir .. "scripts/gui/EasyDevControlsFieldFrame.lua")
                source(modDir .. "scripts/gui/EasyDevControlsVehiclesFrame.lua")

                -- Add events for dedicated server testing also as some commands are server only.
                source(modDir .. "scripts/events/EasyDevControlsSiloCheatEvent.lua")
                source(modDir .. "scripts/events/EasyDevControlsFieldFruitEvent.lua")
                source(modDir .. "scripts/events/EasyDevControlsFieldGroundEvent.lua")
                source(modDir .. "scripts/events/EasyDevControlsSuperStrengthEvent.lua")

                FSBaseMission.loadMapFinished = Utils.prependedFunction(FSBaseMission.loadMapFinished, loadMapFinished)
				FSBaseMission.onConnectionFinishedLoading = Utils.appendedFunction(FSBaseMission.onConnectionFinishedLoading, onConnectionFinishedLoading)

                FSBaseMission.registerActionEvents = Utils.appendedFunction(FSBaseMission.registerActionEvents, registerActionEvents)
                BaseMission.unregisterActionEvents = Utils.appendedFunction(BaseMission.unregisterActionEvents, unregisterActionEvents)

                Player.registerActionEvents = Utils.appendedFunction(Player.registerActionEvents, registerPlayerActionEvents)
                Player.removeActionEvents = Utils.appendedFunction(Player.removeActionEvents, removePlayerActionEvents)				

                Vehicle.drawUIInfo = Utils.overwrittenFunction(Vehicle.drawUIInfo, vehicleDrawUIInfo)

                print("  Loaded Easy Development Controls")
            end
        else
            getfenv(0)["g_easyDevControlsError"] = {c = c, name = name, startUpdateTime = 2000}

            g_easyDevControlsError.update = function(g_easyDevControlsError, dt)
                if g_easyDevControlsError ~= nil then
                    if g_easyDevControlsError.startUpdateTime > 0 then
                        g_easyDevControlsError.startUpdateTime = g_easyDevControlsError.startUpdateTime - dt
                    else
                        local title = "Easy Development Controls - Version " .. EasyDevControls.versionString
                        local text = string.format(g_i18n:getText("EDC_loadError"), g_easyDevControlsError.name, g_easyDevControlsError.c)
                        if g_dedicatedServerInfo == nil then
                            if not g_gui:getIsGuiVisible() then
                                g_gui:showYesNoDialog({
                                    title = title,
                                    text = text,
                                    dialogType = DialogElement.TYPE_LOADING,
                                    callback = g_easyDevControlsError.openModHubLink,
                                    target = nil,
                                    yesText = g_i18n:getText("button_ok"),
                                    noText = g_i18n:getText("button_modHubDownload")
                                })
                            end
                        else
                            print(title .. "  " .. text .. "\n    - https://farming-simulator.com/mods.php?lang=en&country=be&title=fs2019&filter=org&org_id=129652&page=0")
                            g_easyDevControlsError:openModHubLink(true)
                        end
                    end
                end
            end

            g_easyDevControlsError.openModHubLink = function(isYes)
                if isYes == false then
                    local language = g_languageShort
                    local link = "mods.php?lang=en&country=be&title=fs2019&filter=org&org_id=129652&page=0"
                    if language == "de" or language == "fr" then
                        link = "mods.php?lang=" .. language .. "&country=be&title=fs2019&filter=org&org_id=129652&page=0"
                    end

                    openWebFile(link, "")
                end

                removeModEventListener(g_easyDevControlsError)
                getfenv(0)["g_easyDevControlsError"] = nil
            end

            g_easyDevControlsError.delete = function()
                if g_easyDevControlsError ~= nil then
                    removeModEventListener(g_easyDevControlsError)
                    getfenv(0)["g_easyDevControlsError"] = nil
                end
            end

            addModEventListener(g_easyDevControlsError)
        end
    end
end

function loadMapFinished()
    if g_easyDevControls ~= nil then
        g_easyDevControls:load(false)
    end
end

function onConnectionFinishedLoading(mission, connection, x, y, z, viewDistanceCoeff)
    if g_easyDevControls ~= nil then
        g_easyDevControls:onConnectionFinishedLoading(connection)
    end
end

function EasyDevControls:onConnectionFinishedLoading(connection)
    if g_currentMission.player == nil then
		return
	end
	
	local state = Utils.getNoNil(g_currentMission.player.superStrengthEnabled, false)
	connection:sendEvent(EasyDevControlsSuperStrengthEvent:new(state))
end

function registerPlayerActionEvents()
    if g_dedicatedServerInfo == nil and g_easyDevControls ~= nil then
        g_inputBinding:beginActionEventsModification(Player.INPUT_CONTEXT_NAME)

        _, eventId = g_inputBinding:registerActionEvent(InputAction.EDC_playerSpeed, g_easyDevControls, g_easyDevControls.onInputPlayerSpeed, false, true, false, true)
        g_inputBinding:setActionEventTextVisibility(eventId, false)
        g_easyDevControls.eventIdTogglePlayerSpeed = eventId

        if g_currentMission:getIsServer() then
            _, eventId = g_inputBinding:registerActionEvent(InputAction.EDC_objectDelete, g_easyDevControls, g_easyDevControls.onInputObjectDelete, false, true, false, true)
            g_inputBinding:setActionEventTextVisibility(eventId, false)
            g_inputBinding:setActionEventActive(eventId, false)
            g_easyDevControls.eventIdObjectDelete = eventId
        end

        g_inputBinding:endActionEventsModification()
    end
end

function removePlayerActionEvents()
    g_inputBinding:beginActionEventsModification(Player.INPUT_CONTEXT_NAME)

    if g_easyDevControls.eventIdTogglePlayerSpeed ~= nil then
        g_inputBinding:removeActionEvent(g_easyDevControls.eventIdTogglePlayerSpeed)
    end

    if g_easyDevControls.eventIdObjectDelete ~= nil then
        g_inputBinding:removeActionEvent(g_easyDevControls.eventIdObjectDelete)
    end

    g_inputBinding:endActionEventsModification()
end

function registerActionEvents()
    if g_dedicatedServerInfo == nil and g_easyDevControls ~= nil then
        local _, eventId = g_inputBinding:registerActionEvent(InputAction.EDC_openMenu, g_easyDevControls, g_easyDevControls.onInputOpenMenu, false, true, false, true)
        g_inputBinding:setActionEventTextVisibility(eventId, false)
        g_easyDevControls.eventIdOpenMenu = eventId
    end
end

function unregisterActionEvents()
    if g_easyDevControls ~= nil then
        g_inputBinding:removeActionEventsByTarget(g_easyDevControls)
    end
end

-- Needed as there is an error in the Base code. We never return 'superFunc' for this reason.
-- https://gdn.giants-software.com/documentation_scripting_fs19.php?version=script&category=69&class=10614#drawUIInfo168018
function vehicleDrawUIInfo(self, superFunc)
    if g_showVehicleDistance then
        local dist = calcDistanceFrom(self.rootNode, getCamera())
        if dist <= 350 then
            local x,y,z = getWorldTranslation(self.rootNode)
            Utils.renderTextAtWorldPosition(x, y+1, z, string.format("%.0f", dist), getCorrectTextSize(0.02), 0)
        end
    end
end

-- Not working in 19 like my 15 version. GUI also does not seem to be reading this.
function getTimeScaleString(timeScaleIndex, superFunc)
    if timeScaleIndex > 6 and g_easyDevControls ~= nil and g_easyDevControls.timeScale > 0 then
        return tostring(g_easyDevControls.timeScale) .. "(EDC)"
    end

    return superFunc(timeScaleIndex)
end

function getTimeScaleIndex(timeScale, superFunc)
    if timeScale > 120 and g_easyDevControls ~= nil then
        if g_easyDevControls.timeScale > 0  and g_easyDevControls.timeScale == timeScale then
            return 7
        end
    end

    return superFunc(timeScale)
end

function getTimeScaleFromIndex(timeScaleIndex, superFunc)
    if timeScaleIndex >= 7 and g_easyDevControls ~= nil and g_easyDevControls.timeScale > 0 then
        return g_easyDevControls.timeScale
    end

    return superFunc(timeScaleIndex)
end

function getNumTimeScales(superFunc)
    if g_easyDevControls ~= nil and g_easyDevControls.timeScale > 0 then
        return 7
    end

    return superFunc()
end

easyDevControlsInit(g_currentModName, g_modManager:getModByName(g_currentModName).author)
