--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 09.06.2019
Version: 1.0.0.0

History:
V 1.0.0.0 @ 09.06.2019 - Release Version

Contact:
GtX_Andy@protonmail.com

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


EasyDevControlsFieldFruitEvent = {}
EasyDevControlsFieldFruitEvent_mt = Class(EasyDevControlsFieldFruitEvent, Event)
InitEventClass(EasyDevControlsFieldFruitEvent, "EasyDevControlsFieldFruitEvent")

function EasyDevControlsFieldFruitEvent:emptyNew()
    local self = Event:new(EasyDevControlsFieldFruitEvent_mt)
    return self
end

function EasyDevControlsFieldFruitEvent:new(fieldIndex, fruitIndex, growthState, groundLayer, fertilizerState, plowingState, weedState, limeState, sprayState)
    local self = EasyDevControlsFieldFruitEvent:emptyNew()

    self.fieldIndex = fieldIndex
    self.fruitIndex = fruitIndex
    self.growthState = growthState
    self.groundLayer = groundLayer
    self.fertilizerState = fertilizerState
    self.plowingState = plowingState
    self.weedState = weedState
    self.limeState = limeState
    self.sprayState = sprayState

    return self
end

function EasyDevControlsFieldFruitEvent:readStream(streamId, connection)
    local fieldIndex = streamReadUInt8(streamId)
    local fruitIndex = streamReadUInt8(streamId)
    local growthState = streamReadUInt8(streamId)
    local groundLayer = streamReadUInt8(streamId)
    local fertilizerState = streamReadUInt8(streamId)
    local plowingState = streamReadUInt8(streamId)
    local weedState = streamReadUInt8(streamId)
    local limeState = streamReadUInt8(streamId)
    local sprayState = streamReadUInt8(streamId)

    if g_easyDevControls ~= nil then
        if g_currentMission:getIsServer() then
            local result = g_easyDevControls:setFieldFruit(fieldIndex, fruitIndex, growthState, groundLayer, fertilizerState, plowingState, weedState, limeState, sprayState, false)
            print("  EDC:  " .. result)
        else
            print("Client > Server only event!")
        end
    end
end

function EasyDevControlsFieldFruitEvent:writeStream(streamId, connection)
    streamWriteUInt8(streamId, self.fieldIndex)
    streamWriteUInt8(streamId, self.fruitIndex)
    streamWriteUInt8(streamId, self.growthState)
    streamWriteUInt8(streamId, self.groundLayer)
    streamWriteUInt8(streamId, self.fertilizerState)
    streamWriteUInt8(streamId, self.plowingState)
    streamWriteUInt8(streamId, self.weedState)
    streamWriteUInt8(streamId, self.limeState)
    streamWriteUInt8(streamId, self.sprayState)
end
