--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 09.06.2019
Version: 1.0.0.0

History:
V 1.0.0.0 @ 09.06.2019 - Release Version

Contact:
GtX_Andy@protonmail.com

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


EasyDevControlsFieldGroundEvent = {}
EasyDevControlsFieldGroundEvent_mt = Class(EasyDevControlsFieldGroundEvent, Event)
InitEventClass(EasyDevControlsFieldGroundEvent, "EasyDevControlsFieldGroundEvent")

function EasyDevControlsFieldGroundEvent:emptyNew()
    local self = Event:new(EasyDevControlsFieldGroundEvent_mt)
    return self
end

function EasyDevControlsFieldGroundEvent:new(fieldIndex, groundNameIndex, angle, groundLayer, fertilizerState, plowingState, weedState, limeState)
    local self = EasyDevControlsFieldGroundEvent:emptyNew()

    self.fieldIndex = fieldIndex
    self.groundNameIndex = groundNameIndex
    self.angle = angle
    self.groundLayer = groundLayer
    self.fertilizerState = fertilizerState
    self.plowingState = plowingState
    self.weedState = weedState
    self.limeState = limeState

    return self
end

function EasyDevControlsFieldGroundEvent:readStream(streamId, connection)
    local fieldIndex = streamReadUInt8(streamId)
    local groundNameIndex = streamReadUInt8(streamId)
    local angle = streamReadUInt8(streamId)
    local groundLayer = streamReadUInt8(streamId)
    local fertilizerState = streamReadUInt8(streamId)
    local plowingState = streamReadUInt8(streamId)
    local weedState = streamReadUInt8(streamId)
    local limeState = streamReadUInt8(streamId)

    if g_easyDevControls ~= nil then
        if g_currentMission:getIsServer() then
            local result = g_easyDevControls:setFieldGround(fieldIndex, groundNameIndex, angle, groundLayer, fertilizerState, plowingState, weedState, limeState, false)
            print("  EDC: " .. result)
        else
            print("Client > Server only event!")
        end
    end
end

function EasyDevControlsFieldGroundEvent:writeStream(streamId, connection)
    streamWriteUInt8(streamId, self.fieldIndex)
    streamWriteUInt8(streamId, self.groundNameIndex)
    streamWriteUInt8(streamId, self.angle)
    streamWriteUInt8(streamId, self.groundLayer)
    streamWriteUInt8(streamId, self.fertilizerState)
    streamWriteUInt8(streamId, self.plowingState)
    streamWriteUInt8(streamId, self.weedState)
    streamWriteUInt8(streamId, self.limeState)
end
