--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 09.06.2019
Version: 1.0.0.0

History:
V 1.0.0.0 @ 09.06.2019 - Release Version

Contact:
GtX_Andy@protonmail.com

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


EasyDevControlsSiloCheatEvent = {}
EasyDevControlsSiloCheatEvent_mt = Class(EasyDevControlsSiloCheatEvent, Event)
InitEventClass(EasyDevControlsSiloCheatEvent, "EasyDevControlsSiloCheatEvent")

function EasyDevControlsSiloCheatEvent:emptyNew()
    local self = Event:new(EasyDevControlsSiloCheatEvent_mt)
    return self
end

function EasyDevControlsSiloCheatEvent:new(fillTypeIndex, volumeToAdd, farmId)
    local self = EasyDevControlsSiloCheatEvent:emptyNew()

    self.fillTypeIndex = fillTypeIndex
    self.volumeToAdd = volumeToAdd
    self.farmId = farmId

    return self
end

function EasyDevControlsSiloCheatEvent:readStream(streamId, connection)
    local fillTypeIndex = streamReadUIntN(streamId, FillTypeManager.SEND_NUM_BITS)
    local volumeToAdd = streamReadInt32(streamId)
    local farmId = streamReadUIntN(streamId, FarmManager.FARM_ID_SEND_NUM_BITS)

    if g_easyDevControls ~= nil then
        if g_currentMission:getIsServer() then
            local result = g_easyDevControls:addLevelToSilos(fillTypeIndex, volumeToAdd, farmId)
            print("  EDC:  " .. result)
        else
            print("Client > Server only event!")
        end
    end
end

function EasyDevControlsSiloCheatEvent:writeStream(streamId, connection)
    streamWriteUIntN(streamId, self.fillTypeIndex, FillTypeManager.SEND_NUM_BITS)
    streamWriteInt32(streamId, self.volumeToAdd)
    streamWriteUIntN(streamId, self.farmId, FarmManager.FARM_ID_SEND_NUM_BITS)
end
