--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 09.06.2019
Version: 1.0.0.0

History:
V 1.0.0.0 @ 09.06.2019 - Release Version

Contact:
GtX_Andy@protonmail.com

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


EasyDevControlsSuperStrengthEvent = {}
EasyDevControlsSuperStrengthEvent_mt = Class(EasyDevControlsSuperStrengthEvent, Event)
InitEventClass(EasyDevControlsSuperStrengthEvent, "EasyDevControlsSuperStrengthEvent")

function EasyDevControlsSuperStrengthEvent:emptyNew()
    local self = Event:new(EasyDevControlsSuperStrengthEvent_mt)
    return self
end

function EasyDevControlsSuperStrengthEvent:new(hasSuperStrength)
    self.hasSuperStrength = hasSuperStrength
    return self
end

function EasyDevControlsSuperStrengthEvent:readStream(streamId, connection)
    self.hasSuperStrength = streamReadBool(streamId)
    self:run(connection)
end

function EasyDevControlsSuperStrengthEvent:writeStream(streamId, connection)
    streamWriteBool(streamId, self.hasSuperStrength)
end

function EasyDevControlsSuperStrengthEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(EasyDevControlsSuperStrengthEvent:new(self.hasSuperStrength), false, connection)
    end

    if g_currentMission ~= nil and g_currentMission.player ~= nil then
        if self.hasSuperStrength ~= Utils.getNoNil(g_currentMission.player.superStrengthEnabled, false) then
            local result = g_currentMission.player:consoleCommandToggleSuperStrongMode()
            print("  EDC: " .. result)
        end
    end
end
