--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 07.04.2019
Version: 1.0.0.0

History:
V 1.0.0.0 @ 07.04.2019 - Release Version

Contact:
GtX_Andy@protonmail.com

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


EasyDevControlsEnvironmentFrame = {}
local EasyDevControlsEnvironmentFrame_mt = Class(EasyDevControlsEnvironmentFrame, TabbedMenuFrameElement)

EasyDevControlsEnvironmentFrame.L10N_SYMBOL = {}

EasyDevControlsEnvironmentFrame.CONTROLS = {
    ENVIRONMENT_CONTAINER = "environmentContainer",
    HELP_BOX_TEXT = "environmentHelpBoxText",
    HELP_BOX = "environmentHelpBox",
    SET_SET_DAY_TIME = "setDayTime",
    BUTTON_SET_DAY_TIME = "buttonSetDayTime",
    SET_WEATHER_TYPE_CHANGE = "setWeatherTypeChange",
    BUTTON_WEATHER_ADD = "buttonWeatherAdd",
    SET_WEATHER_TOGGLE_DEBUG = "setWeatherToggleDebug",
    BUTTON_WEATHER_RELOAD_DATA = "buttonWeatherReloadData",
    BUTTON_RELOAD_ENVIRONMENT = "buttonReloadEnvironment",
    SET_AMBIENT_SOUNDS_DEBUG = "setAmbientSoundsDebug",
    BUTTON_RELOAD_AMBIENT_SOUNDS = "buttonReloadAmbientSounds",
    SET_TOGGLE_SHOW_WILDLIFE = "setToggleShowWildlife"
}

EasyDevControlsEnvironmentFrame.DAY_TIMES = {
    "01:00", "02:00", "03:00", "04:00", "05:00",
    "06:00", "07:00", "08:00", "09:00", "10:00",
    "11:00", "12:00", "13:00", "14:00", "15:00",
    "16:00", "17:00", "18:00", "19:00", "20:00",
    "21:00", "22:00", "23:00", "24:00"
}

local function getIsTrueString(index)
    if index ~= nil and index > 1 then
        return "true"
    end

    return "false"
end

function EasyDevControlsEnvironmentFrame:new()
    local self = TabbedMenuFrameElement:new(nil, EasyDevControlsEnvironmentFrame_mt)

    self.l10n = nil
    self.printToLog = nil

    self.allowCommandStatePrint = true

    self.currentTimeIndex = 8
    self.currentWeatherIndex = 1

    self:registerControls(EasyDevControlsEnvironmentFrame.CONTROLS)

    return self
end

function EasyDevControlsEnvironmentFrame:initialize(l10n, printToLog)
    self.l10n = l10n
    self.printToLog = printToLog
end

function EasyDevControlsEnvironmentFrame:onFrameOpen()
    EasyDevControlsEnvironmentFrame:superClass().onFrameOpen(self)

    local notServer = not g_currentMission:getIsServer()
    local noEnvironment = g_currentMission.environment == nil
    local changedEnvironment = g_seasons ~= nil or noEnvironment

    self.setDayTime:setTexts(EasyDevControlsEnvironmentFrame.DAY_TIMES)
    local hourToSet = g_currentMission.environment.currentHour + 1
    if hourToSet > 24 then
        hourToSet = 1
    end

    self.setDayTime:setState(hourToSet, true)
    self.setDayTime:setDisabled(notServer)
    self.buttonSetDayTime:setDisabled(notServer)

    self.setWeatherTypeChange:setTexts(g_weatherTypeManager.indexToName)
    self.setWeatherTypeChange:setState(1, true)
    self.setWeatherTypeChange:setDisabled(notServer or changedEnvironment)
    self.buttonWeatherAdd:setDisabled(notServer or changedEnvironment)

    self.setWeatherToggleDebug:setIsChecked(Weather.DEBUG_ENABLED)
    self.setWeatherToggleDebug:setDisabled(changedEnvironment)

    self.buttonWeatherReloadData:setDisabled(notServer or changedEnvironment)
    self.buttonReloadEnvironment:setDisabled(notServer or noEnvironment)

    self.setAmbientSoundsDebug:setIsChecked(AmbientSoundManager.DEBUG)
    self.buttonReloadAmbientSounds:setDisabled(false)

    if g_wildlifeSpawnerManager ~= nil then
        self.setToggleShowWildlife:setDisabled(false)
        self.setToggleShowWildlife:setIsChecked(g_wildlifeSpawnerManager.debugShow)
    else
        self.setToggleShowWildlife:setDisabled(true)
    end
end

function EasyDevControlsEnvironmentFrame:onClickSelectDayTime(index)
    self.currentTimeIndex = index
    self.buttonSetDayTime:setDisabled(false)
end

function EasyDevControlsEnvironmentFrame:onClickSetDayTime()
    self:printCommandState(g_currentMission.environment:consoleCommandSetDayTime(self.currentTimeIndex) .. ":00")
    self.buttonSetDayTime:setDisabled(true)
end

function EasyDevControlsEnvironmentFrame:onClickWeatherTypeChange(index)
    self.currentWeatherIndex = index
    self.buttonWeatherAdd:setDisabled(false)
end

function EasyDevControlsEnvironmentFrame:onClickWeatherAdd()
    local weatherType = g_weatherTypeManager.indexToName[self.currentWeatherIndex]
    if g_currentMission.environment.weather ~= nil and weatherType ~= nil then
        self:printCommandState(g_currentMission.environment.weather:consoleCommandWeatherAdd(weatherType))
        self.buttonWeatherAdd:setDisabled(true)
    end
end

function EasyDevControlsEnvironmentFrame:onClickWeatherToggleDebug(index)
    if g_currentMission.environment ~= nil and g_currentMission.environment.weather ~= nil then
        self:printCommandState(g_currentMission.environment.weather:consoleCommandWeatherToggleDebug())
    end
end

function EasyDevControlsEnvironmentFrame:onClickWeatherReloadData(index)
    if g_currentMission.environment ~= nil and g_currentMission.environment.weather ~= nil then
        self:printCommandState(g_currentMission.environment.weather:consoleCommandWeatherReloadData())
        self.buttonWeatherReloadData:setDisabled(true)
    end
end

function EasyDevControlsEnvironmentFrame:onClickReloadEnvironment()
    g_currentMission.environment:consoleCommandReloadEnvironment()
    self:printCommandState("Environment reloaded successfully.")
    self.buttonReloadEnvironment:setDisabled(true)
end

function EasyDevControlsEnvironmentFrame:onClickAmbientSoundsDebug(index)
    g_ambientSoundManager:consoleCommandToggleAmbientSoundsDebug(getIsTrueString(index))
    self:printCommandState("Ambient Sound Manager Debug = " .. string.upper(tostring(AmbientSoundManager.DEBUG)))
end

function EasyDevControlsEnvironmentFrame:onClickReloadAmbientSounds()
    g_ambientSoundManager:consoleCommandReloadAmbientSound()
    self.buttonReloadAmbientSounds:setDisabled(true)
    self:printCommandState("Ambient Sounds have been reloaded.")
end

function EasyDevControlsEnvironmentFrame:onClickToggleShowWildlife(index)
    g_wildlifeSpawnerManager:consoleCommandToggleShowWildlife()
    self:printCommandState("Show Wildlife Info = " .. string.upper(tostring(g_wildlifeSpawnerManager.debugShow)))
end

function EasyDevControlsEnvironmentFrame:onResetConfirm(doReset)
    if not doReset then
        return
    end

    self.allowCommandStatePrint = false

    self.setWeatherTypeChange:setState(1, true)

    Weather.DEBUG_ENABLED = false
    self.setWeatherToggleDebug:setIsChecked(Weather.DEBUG_ENABLED)

    AmbientSoundManager.DEBUG = false
    self.setAmbientSoundsDebug:setIsChecked(AmbientSoundManager.DEBUG)

    if g_wildlifeSpawnerManager ~= nil then
        self.setToggleShowWildlife:setIsChecked(false)
    end

    self.allowCommandStatePrint = true
    self:printCommandState(self.l10n:getText("EDC_resetPageComplete"))
end

function EasyDevControlsEnvironmentFrame:onToolTipBoxTextChanged(toolTipBox)
    local showText = (toolTipBox.text ~= nil and toolTipBox.text ~= "")
    self.environmentHelpBox:setVisible(showText)
end

function EasyDevControlsEnvironmentFrame:getMainElementSize()
    return self.environmentContainer.size
end

function EasyDevControlsEnvironmentFrame:getMainElementPosition()
    return self.environmentContainer.absPosition
end

function EasyDevControlsEnvironmentFrame:printCommandState(text)
    if self.allowCommandStatePrint and (text ~= nil and text ~= "") then

        self.environmentHelpBoxText:setText(text)
        self.environmentHelpBox:setVisible(true)

        if self.printToLog then
            print("EDC - Environment: " .. text)
        end
    end
end
