--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 07.04.2019
Version: 1.0.0.0

History:
V 1.0.0.0 @ 07.04.2019 - Release Version

Contact:
GtX_Andy@protonmail.com

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


EasyDevControlsFieldFrame = {}
local EasyDevControlsFieldFrame_mt = Class(EasyDevControlsFieldFrame, TabbedMenuFrameElement)

EasyDevControlsFieldFrame.CONTROLS = {
    FIELDS_CONTAINER = "fieldsContainer",
    HELP_BOX_TEXT = "fieldsHelpBoxText",
    HELP_BOX = "fieldsHelpBox",
    SET_FIELD_INDEX_FRUIT = "setFieldIndexFruit",
    SET_FRUIT_NAME = "setFruitName",
    SET_GROWTH_STATE = "setGrowthState",
    SET_FERTILIZER_STATE_FRUIT = "setFertilizerStateFruit",
    SET_PLOWING_STATE_FRUIT = "setPlowingStateFruit",
    BUTTON_SET_FIELD_FRUIT = "buttonSetFieldFruit",
    SET_WEED_STATE_FRUIT = "setWeedStateFruit",
    SET_LIME_STATE_FRUIT = "setLimeStateFruit",
    SET_SPRAY_STATE = "setSprayState",
    SET_BUY_FIELD_FRUIT = "setBuyFieldFruit",
    SET_FIELD_INDEX_GROUND = "setFieldIndexGround",
    SET_GROUND_NAME = "setGroundName",
    SET_ANGLE = "setAngle",
    SET_FERTILIZER_STATE_GROUND = "setFertilizerStateGround",
    SET_PLOWING_STATE_GROUND = "setPlowingStateGround",
    BUTTON_SET_FIELD_GROUND = "buttonSetFieldGround",
    SET_WEED_STATE_GROUND = "setWeedStateGround",
    SET_LIME_STATE_GROUND = "setLimeStateGround",
    SET_REMOVE_FOLIAGE = "setRemoveFoliage",
    SET_BUY_FIELD_GROUND = "setBuyFieldGround"
}

EasyDevControlsFieldFrame.FERTILIZER_STATES = {
    "0%", "50%", "100%"
}

EasyDevControlsFieldFrame.GROUND_ANGLE = {
    "0", "45", "90", "315"
}

EasyDevControlsFieldFrame.GROUND_NAME = {
    "cultivator", "plow", "sowing", "sowing_width"
}

EasyDevControlsFieldFrame.L10N_SYMBOL = {}

function EasyDevControlsFieldFrame:new()
    local self = TabbedMenuFrameElement:new(nil, EasyDevControlsFieldFrame_mt)

    self.l10n = nil
    self.printToLog = nil

    self.allowCommandStatePrint = true

    local weeds1 = g_i18n:getText("ui_growthMapGrowing") .. " 1"
    local weeds2 = g_i18n:getText("ui_growthMapGrowing") .. " 2"
    local withered1 = g_i18n:getText("ui_growthMapWithered") .. " 1"
    local withered2 = g_i18n:getText("ui_growthMapWithered") .. " 2"

    self.weedStateTexts = {
        g_i18n:getText("ui_off"),
        weeds1,
        weeds2,
        withered1,
        withered2
    }

    self.fieldFruit = {
        fieldIndex = 1,
        fruitIndex = 1,
        growthState = 1,
        fertilizerState = 0,
        plowingState = 0,
        weedState = 0,
        limeState = 0,
        sprayState = 0,
        buyField = false
    }

    self.fieldGround = {
        fieldIndex = 1,
        groundNameIndex = 1,
        angleIndex = 0,
        fertilizerState = 0,
        plowingState = 0,
        weedState = 0,
        limeState = 0,
        removeFoliage = true,
        buyField = false
    }

    self:registerControls(EasyDevControlsFieldFrame.CONTROLS)

    return self
end

function EasyDevControlsFieldFrame:initialize(l10n, printToLog)
    self.l10n = l10n
    self.printToLog = printToLog

    for i, angle in pairs ({0, 45, 90, 315}) do
        EasyDevControlsFieldFrame.GROUND_ANGLE[i] = string.format(self.l10n:getText("setting_fovyDegree"), angle)
    end
end

function EasyDevControlsFieldFrame:onFrameOpen()
    EasyDevControlsFieldFrame:superClass().onFrameOpen(self)

    local disableCommand = true
    if g_currentMission:getIsServer() or g_currentMission.isMasterUser then
        disableCommand = false
    end

    local fieldFruit = self.fieldFruit
    local fieldGround = self.fieldGround
    local player = g_currentMission.player

    local posX, posZ = self:getCurrentPosition(player)

    local fieldId
    local farmland = g_farmlandManager:getFarmlandAtWorldPosition(posX, posZ)
    if farmland ~= nil then
        local fieldMapping = g_fieldManager.farmlandIdFieldMapping[farmland.id]
        if fieldMapping ~= nil and fieldMapping[1] ~= nil then
            fieldId = fieldMapping[1].fieldId
        end
    end

    if self.fields == nil then
        self.fields = {}
        for i, _ in ipairs (g_fieldManager.fields) do
            self.fields[i] = tostring(i)
        end

        table.insert(self.fields, "All")
        self.fieldFruit.fieldIndex = #self.fields
    end

    self.setFieldIndexFruit:setTexts(self.fields)
    self.setFieldIndexFruit:setState(Utils.getNoNil(fieldId, fieldFruit.fieldIndex), true)

    if self.fruits == nil or self.fruitTitles == nil then
        self.fruits = {}
        self.fruitTitles = {}
        self.fruitIndexToGrowthStatesTexts = {}

        for index, fruitType in pairs (g_fruitTypeManager.indexToFruitType) do
            if fruitType.cutState > 1 and fruitType.witheringNumGrowthStates > 0 then
                table.insert(self.fruits, fruitType.name)

                local fillType = g_fruitTypeManager:getFillTypeByFruitTypeIndex(index)
                table.insert(self.fruitTitles, fillType.title)

                local fruitsCount = #self.fruits
                if self.fruitIndexToGrowthStatesTexts[fruitsCount] == nil then
                    self.fruitIndexToGrowthStatesTexts[fruitsCount] = {}

                    for i = 1, fruitType.witheringNumGrowthStates do
                        self.fruitIndexToGrowthStatesTexts[fruitsCount][i] = tostring(i)
                    end
                end
            end
        end
    end

    local previousGrowthState = fieldFruit.growthState

    self.setFruitName:setTexts(self.fruitTitles)
    self.setFruitName:setState(fieldFruit.fruitIndex, true)

    local maxGrowthState = #self.fruitIndexToGrowthStatesTexts[fieldFruit.fruitIndex]
    self.setGrowthState:setState(math.min(previousGrowthState, maxGrowthState), true)

    self.setFertilizerStateFruit:setTexts(EasyDevControlsFieldFrame.FERTILIZER_STATES)
    self.setFertilizerStateFruit:setState(fieldFruit.fertilizerState + 1, true)

    self.setPlowingStateFruit:setIsChecked(fieldFruit.plowingState > 0)

    self.setWeedStateFruit:setTexts(self.weedStateTexts)
    self.setWeedStateFruit:setState(fieldFruit.weedState, true)

    self.setLimeStateFruit:setIsChecked(fieldFruit.limeState > 0)
    self.setSprayState:setIsChecked(fieldFruit.sprayState > 0)

    self.setBuyFieldFruit:setState(1, true)

    self.setFieldIndexGround:setTexts(self.fields)
    self.setFieldIndexGround:setState(Utils.getNoNil(fieldId, fieldGround.fieldIndex), true)

    self.setGroundName:setTexts(EasyDevControlsFieldFrame.GROUND_NAME)
    self.setGroundName:setState(fieldGround.groundNameIndex, true)

    self.setAngle:setTexts(EasyDevControlsFieldFrame.GROUND_ANGLE)
    self.setAngle:setState(fieldGround.angleIndex, true)

    self.setFertilizerStateGround:setTexts(EasyDevControlsFieldFrame.FERTILIZER_STATES)
    self.setFertilizerStateGround:setState(fieldGround.fertilizerState + 1, true)

    self.setPlowingStateGround:setIsChecked(fieldGround.plowingState > 0)

    self.setWeedStateGround:setTexts(self.weedStateTexts)
    self.setWeedStateGround:setState(fieldGround.weedState, true)

    self.setLimeStateGround:setIsChecked(fieldGround.limeState > 0)

    -- Not working so not used yet.
    self.setRemoveFoliage:setIsChecked(fieldGround.removeFoliage)
    self.setRemoveFoliage:setDisabled(true)

    self.setBuyFieldGround:setState(1, true)

    self.buttonSetFieldFruit:setDisabled(disableCommand)
    self.buttonSetFieldGround:setDisabled(disableCommand)
end

function EasyDevControlsFieldFrame:getCurrentPosition(player)
    local posX, posZ

    if g_currentMission.controlledVehicle ~= nil then
        posX, _, posZ = getWorldTranslation(g_currentMission.controlledVehicle.rootNode)
    elseif player ~= nil then
        posX, _, posZ, _ = player:getPositionData()
    end

    return posX, posZ
end

function EasyDevControlsFieldFrame:onClickFieldIndexFruit(fieldIndex)
    self.fieldFruit.fieldIndex = fieldIndex

    if fieldIndex == #self.fields then
        self.setBuyFieldFruit:setIsChecked(false)
    end
end

function EasyDevControlsFieldFrame:onClickFruitName(fruitIndex)
    self.fieldFruit.fruitIndex = fruitIndex

    if self.fruitIndexToGrowthStatesTexts ~= nil then
        self.setGrowthState:setTexts(self.fruitIndexToGrowthStatesTexts[fruitIndex])
        self.setGrowthState:setState(1, true)
    end
end

function EasyDevControlsFieldFrame:onClickGrowthState(index)
    self.fieldFruit.growthState = index
end

function EasyDevControlsFieldFrame:onClickFertilizerStateFruit(index)
    self.fieldFruit.fertilizerState = index - 1
end

function EasyDevControlsFieldFrame:onClickPlowingStateFruit(index)
    self.fieldFruit.plowingState = index - 1
end

function EasyDevControlsFieldFrame:onClickWeedStateFruit(index)
    self.fieldFruit.weedState = index
end

function EasyDevControlsFieldFrame:onClickLimeStateFruit(index)
    self.fieldFruit.limeState = index - 1
end

function EasyDevControlsFieldFrame:onClickSprayState(index)
    self.fieldFruit.sprayState = index - 1
end

function EasyDevControlsFieldFrame:onClickBuyFieldFruit(index)
    self.fieldFruit.buyField = index > 1
end

function EasyDevControlsFieldFrame:onClickSetFieldFruit()
    local field = self.fieldFruit

    local fieldIndex = field.fieldIndex or #g_fieldManager.fields

    local fruitName = self.fruits[field.fruitIndex]
    local fruitIndex = g_fruitTypeManager.nameToIndex[fruitName] or 1

    local growthState = field.growthState
    local groundLayer = 0
    local fertilizerState = field.fertilizerState
    local plowingState = field.plowingState
    local weedState = field.weedState
    local limeState = field.limeState
    local sprayState = field.sprayState
    local buyFarmland = field.buyField

    self:printCommandState(g_easyDevControls:setFieldFruit(fieldIndex, fruitIndex, growthState, groundLayer, fertilizerState, plowingState, weedState, limeState, sprayState, buyFarmland))
end

function EasyDevControlsFieldFrame:onClickFieldIndexGround(fieldIndex)
    self.fieldGround.fieldIndex = fieldIndex

    if fieldIndex == #self.fields then
        self.setBuyFieldGround:setIsChecked(false)
    end
end

function EasyDevControlsFieldFrame:onClickGroundName(groundNameIndex)
    self.fieldGround.groundNameIndex = groundNameIndex
end

function EasyDevControlsFieldFrame:onClickAngle(angleIndex)
    self.fieldGround.angleIndex = angleIndex
end

function EasyDevControlsFieldFrame:onClickFertilizerStateGround(index)
    self.fieldGround.fertilizerState = index - 1
end

function EasyDevControlsFieldFrame:onClickPlowingStateGround(index)
    self.fieldGround.plowingState = index - 1
end

function EasyDevControlsFieldFrame:onClickWeedStateGround(index)
    self.fieldGround.weedState = index
end

function EasyDevControlsFieldFrame:onClickLimeStateGround(index)
    self.fieldGround.limeState = index
end

function EasyDevControlsFieldFrame:onClickRemoveFoliage(index)
    self.fieldGround.removeFoliage = index > 1
end

function EasyDevControlsFieldFrame:onClickBuyFieldGround(index)
    self.fieldGround.buyField = index > 1
end

function EasyDevControlsFieldFrame:onClickSetFieldGround()
    local field = self.fieldGround

    local fieldIndex = field.fieldIndex or #g_fieldManager.fields

    local angle = 0
    if field.angleIndex == 2 then
        angle = 3
    elseif field.angleIndex == 3 then
        angle = 2
    elseif field.angleIndex == 4 then
        angle = 1
    end

    local groundLayer = 0
    local fertilizerState = field.fertilizerState
    local plowingState = field.plowingState
    local weedState = field.weedState
    local limeState = field.limeState
    local buyFarmland = field.buyField

    self:printCommandState(g_easyDevControls:setFieldGround(fieldIndex, field.groundNameIndex, angle, groundLayer, fertilizerState, plowingState, weedState, limeState, buyFarmland))
end

function EasyDevControlsFieldFrame:onResetConfirm(doReset)
    if not doReset then
        return
    end

    self.allowCommandStatePrint = false

    local numTexts = #self.setFieldIndexFruit.texts
    self.setFieldIndexFruit:setState(numTexts, true)

    self.setFruitName:setState(1, true)
    self.setGrowthState:setState(1, true)
    self.setFertilizerStateFruit:setState(1, true)
    self.setPlowingStateFruit:setState(1, true)
    self.setWeedStateFruit:setState(1, true)
    self.setLimeStateFruit:setState(1, true)
    self.setSprayState:setState(1, true)
    self.setBuyFieldFruit:setIsChecked(false)

    numTexts = #self.setFieldIndexGround.texts
    self.setFieldIndexGround:setState(numTexts, true)

    self.setGroundName:setState(1, true)
    self.setAngle:setState(1, true)
    self.setFertilizerStateGround:setState(1, true)
    self.setPlowingStateGround:setState(1, true)
    self.setWeedStateGround:setState(1, true)
    self.setLimeStateGround:setState(1, true)
    self.setRemoveFoliage:setState(1, true)
    self.setBuyFieldGround:setIsChecked(false)

    self.allowCommandStatePrint = true
    self:printCommandState(self.l10n:getText("EDC_resetPageComplete"))
end

function EasyDevControlsFieldFrame:onToolTipBoxTextChanged(toolTipBox)
    local showText = (toolTipBox.text ~= nil and toolTipBox.text ~= "")
    self.fieldsHelpBox:setVisible(showText)
end

function EasyDevControlsFieldFrame:getMainElementSize()
    return self.fieldsContainer.size
end

function EasyDevControlsFieldFrame:getMainElementPosition()
    return self.fieldsContainer.absPosition
end

function EasyDevControlsFieldFrame:printCommandState(text)
    if self.allowCommandStatePrint and (text ~= nil and text ~= "") then

        self.fieldsHelpBoxText:setText(text)
        self.fieldsHelpBox:setVisible(true)

        if self.printToLog then
            print("EDC - Fields: " .. text)
        end
    end
end
