--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 07.04.2019
Version: 1.0.0.0

History:
V 1.0.0.0 @ 07.04.2019 - Release Version

Contact:
GtX_Andy@protonmail.com

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


EasyDevControlsPlayerFrame = {}
local EasyDevControlsPlayerFrame_mt = Class(EasyDevControlsPlayerFrame, TabbedMenuFrameElement)

EasyDevControlsPlayerFrame.L10N_SYMBOL = {}

EasyDevControlsPlayerFrame.CONTROLS = {
    PLAYER_CONTAINER = "playerContainer",
    HELP_BOX_TEXT = "playerHelpBoxText",
    HELP_BOX = "playerHelpBox",
    SET_FLIGHT_AND_NO_HUD_MODE = "setFlightAndNoHUDMode",
    SET_FLIGHT_MODE = "setFlightMode",
    SET_NO_HUD_MODE = "setNoHUDMode",
    SET_SUPER_STRENGTH_STATE = "setSuperStrengthState",
    SET_WOOD_CUTTING_MARKER = "setWoodCuttingMarker",
    SET_PLAYER_DEBUG = "setPlayerDebug",
    SET_PLAYER_STATE_MACHINE_DEBUG = "setPlayerStateMachineDebug",
    SET_PLAYER_STATE_JUMP = "setPlayerStateJump",
    SET_SELECT_BUY_SELL = "setSelectBuySell",
    SET_FARMLAND_INDEX = "setFarmlandIndex",
    BUTTON_BUY_SELL_FARMLAND = "buttonBuySellFarmland",
    SET_PLAYER_SPEED = "setPlayerSpeedMultiplier",
    SET_PLAYER_SPEED_STATE = "setPlayerSpeedState",
    SET_SHOW_SPEED_MULTIPLIER = "setShowSpeedMultiplier",
    SET_TIME_SPEED_VALUE = "setTimeSpeedValue",
    SET_SHOW_TIME_SCALE = "setShowTimeScale"
}

EasyDevControlsPlayerFrame.BUY_FARMLAND = 2
EasyDevControlsPlayerFrame.SELL_FARMLAND = 3

EasyDevControlsPlayerFrame.PLAYER_SPEED_STEPS = {
    0.1, 0.5, 1, 2, 3, 4, 5, 6, 7, 8
}

EasyDevControlsPlayerFrame.PLAYER_SPEED_MULTIPLIER_TO_STEP = {
    ["0.1"] = 1, ["0.5"] = 2, ["1"] = 3, ["2"] = 4, ["3"] = 5,
    ["4"] = 6, ["5"] = 7, ["6"] = 8, ["7"] = 9, ["8"] = 10}

EasyDevControlsPlayerFrame.TIME_SPEED_VALUES = {
    0, 250, 500, 750, 1000, 1500, 2000, 2500, 3000, 3500, 4000
}

EasyDevControlsPlayerFrame.TIME_SPEED_VALUES_TO_STEP = {
    ["0"] = 1, ["250"] = 2, ["500"] = 3, ["750"] = 4, ["1000"] = 5, ["1500"] = 6,
    ["2000"] = 7, ["2500"] = 8, ["3000"] = 9, ["3500"] = 10, ["4000"] = 11
}

function EasyDevControlsPlayerFrame:new()
    local self = TabbedMenuFrameElement:new(nil, EasyDevControlsPlayerFrame_mt)

    self.l10n = nil
    self.printToLog = nil

    self.currentPlayerSpeedStep = 3
    self.allowCommandStatePrint = true

    self.buySellTexts = {g_i18n:getText("ui_off"), g_i18n:getText("button_buy"), g_i18n:getText("button_sell")}

    self.playerSpeedTexts = {"0.1x", "0.5x", "1x", "2x", "3x", "4x", "5x", "6x", "7x", "8x"}

    self.timeSpeedTexts = {g_i18n:getText("ui_off")}
    for i = 2, #EasyDevControlsPlayerFrame.TIME_SPEED_VALUES do
        self.timeSpeedTexts[i] = tostring(EasyDevControlsPlayerFrame.TIME_SPEED_VALUES[i]) .. "x"
    end

    self:registerControls(EasyDevControlsPlayerFrame.CONTROLS)

    return self
end

function EasyDevControlsPlayerFrame:initialize(l10n, printToLog)
    self.l10n = l10n
    self.printToLog = printToLog
end

function EasyDevControlsPlayerFrame:onFrameOpen()
    EasyDevControlsPlayerFrame:superClass().onFrameOpen(self)

    self.allowCommandStatePrint = false

    local player = g_currentMission.player

    local disableCommand = true
    if g_currentMission:getIsServer() or g_currentMission.isMasterUser then
        disableCommand = false
    end

    local enabled = g_flightAndNoHUDKeysEnabled
    self.setFlightAndNoHUDMode:setIsChecked(enabled)
    self.setFlightMode:setDisabled(not enabled)
    self.setNoHUDMode:setDisabled(not enabled)

    self.setFlightMode:setIsChecked(player.debugFlightMode)
    self.setNoHUDMode:setIsChecked(g_currentMission.hud ~= nil and g_currentMission.hud:getIsVisible())

    local superStrengthState = Utils.getNoNil(player.superStrengthEnabled, false)
    self.setSuperStrengthState:setIsChecked(superStrengthState)
    self.setSuperStrengthState:setDisabled(disableCommand)

    self.setWoodCuttingMarker:setIsChecked(g_woodCuttingMarkerEnabled)

    self.setPlayerDebug:setIsChecked(player.baseInformation.isInDebug)

    if player.playerStateMachine ~= nil then
        self.setPlayerStateMachineDebug:setIsChecked(player.playerStateMachine.debugMode)
        if player.playerStateMachine.playerStateJump ~= nil then
            self.setPlayerStateJump:setIsChecked(player.playerStateMachine.playerStateJump:inDebugMode())
        else
            self.setPlayerStateJump:setDisabled(true)
        end
    else
        self.setPlayerStateMachineDebug:setDisabled(true)
        self.setPlayerStateJump:setDisabled(true)
    end

    self.farmlandIds = {}
    self.setSelectBuySell:setTexts(self.buySellTexts)
    self.setSelectBuySell:setState(1, true)
    self.setSelectBuySell:setDisabled(disableCommand)

    local numIds = 0
    local farmlands = g_farmlandManager:getFarmlands()
    if farmlands ~= nil then
        for id, farmland in pairs(farmlands) do
            table.insert(self.farmlandIds, tostring(farmland.id))
        end

        numIds = #self.farmlandIds + 1
        self.farmlandIds[numIds] = "All"
    end

    self.setFarmlandIndex:setTexts(self.farmlandIds)
    self.setFarmlandIndex:setState(numIds, true)
    self.setFarmlandIndex:setDisabled(true)

    self.buttonBuySellFarmland:setDisabled(true)

    self.setPlayerSpeedMultiplier:setTexts(self.playerSpeedTexts)
    local multi = tostring(g_easyDevControls.speedMultiplier)
    local step = EasyDevControlsPlayerFrame.PLAYER_SPEED_MULTIPLIER_TO_STEP[multi] or 3
    self.setPlayerSpeedMultiplier:setState(step, false)

    self.setPlayerSpeedState:setIsChecked(g_easyDevControls.speedMultiplierActive)
    self.setPlayerSpeedState:setDisabled(not g_easyDevControls.speedMultiplierActive and g_easyDevControls.speedMultiplier == 1)

    local keyString = ""
    local inputAction = g_inputBinding:getActionByName("EDC_playerSpeed")
    if inputAction ~= nil and inputAction.displayNamePositive ~= nil then
        keyString = inputAction.displayNamePositive
    end

    self.setPlayerSpeedState.toolTipText = string.format(g_i18n:getText("EDC_speedMultiplierStateToolTip"), keyString)
    self.setShowSpeedMultiplier:setIsChecked(g_easyDevControls.showSpeedMultiplier)

    self.setTimeSpeedValue:setTexts(self.timeSpeedTexts)
    multi = tostring(g_easyDevControls.timeScale)
    step = EasyDevControlsPlayerFrame.TIME_SPEED_VALUES_TO_STEP[multi] or 1
    self.setTimeSpeedValue:setState(step, false)

    local timeDisable = disableCommand or g_easyDevControls.disableExtraTimeScale
    self.setTimeSpeedValue:setDisabled(timeDisable)

    self.setShowTimeScale:setIsChecked(g_easyDevControls.showTimeScale)
    self.setShowTimeScale:setDisabled(timeDisable)

    self.allowCommandStatePrint = true
end

function EasyDevControlsPlayerFrame:onClickFlightAndNoHUDMode()
    self:printCommandState(g_currentMission.player:consoleCommandToggleFlightAndNoHUDMode())

    local disable = not g_flightAndNoHUDKeysEnabled
    if disable then
        self.setFlightMode:setIsChecked(false)
    end

    self.setFlightMode:setDisabled(disable)
    self.setNoHUDMode:setDisabled(disable)
end

function EasyDevControlsPlayerFrame:onClickFlightMode()
    g_currentMission.player:onInputDebugFlyToggle()

    -- Reset this as it will be 0 by the time player leaves UI.
    g_currentMission.player.debugFlightCoolDown = 0
    -- Make sure 'walkingIsDisabled' did not stop this. Adjust if needed.
    self.setFlightMode:setIsChecked(g_currentMission.player.debugFlightMode)
end

function EasyDevControlsPlayerFrame:onClickNoHUDMode()
    if g_currentMission.hud ~= nil then
        g_currentMission.hud:setIsVisible(not g_currentMission.hud:getIsVisible())
    end
end

function EasyDevControlsPlayerFrame:onClickSuperStrength(index)
    local state = index > 1
	
	local isServer = g_currentMission:getIsServer()
    if isServer or g_currentMission.isMasterUser then		
		if state ~= nil and state ~= Utils.getNoNil(g_currentMission.player.superStrengthEnabled, false) then
			self:printCommandState(g_currentMission.player:consoleCommandToggleSuperStrongMode())

			-- In MP need an Event so throwing works correct for all players and Server if Dedi.
			-- I just copy the server / admin current setting.
			if isServer then
				g_server:broadcastEvent(EasyDevControlsSuperStrengthEvent:new(state), false, nil)
			else
				g_client:getServerConnection():sendEvent(EasyDevControlsSuperStrengthEvent:new(state))
			end
		end
    end
end

function EasyDevControlsPlayerFrame:onClickWoodCuttingMaker()
    self:printCommandState(g_currentMission.player.consoleCommandToggleWoodCuttingMaker())
end

function EasyDevControlsPlayerFrame:onClickTogglePlayerDebug()
    self:printCommandState(g_currentMission.player:consoleCommandTogglePlayerDebug())
end

function EasyDevControlsPlayerFrame:onClickTogglePlayerStateMachineDebug(index)
    local player = g_currentMission.player
    if player.playerStateMachine ~= nil then
        local state = index > 1
        player.playerStateMachine.debugMode = state

        self:printCommandState("Player Debug State Machine = " .. tostring(state))
    end
end

function EasyDevControlsPlayerFrame:onClickTogglePlayerStateJump()
    local player = g_currentMission.player
    if player.playerStateMachine ~= nil and player.playerStateMachine.playerStateJump ~= nil then
        player.playerStateMachine.playerStateJump:consoleCommandDebugStateJump()

        self:printCommandState("Player Debug Jump = " .. tostring(player.playerStateMachine.playerStateJump:inDebugMode()))
    end
end

function EasyDevControlsPlayerFrame:onClickBuySell(index)
    self.buySellSelection = index

    self.setFarmlandIndex:setDisabled(index == 1)
    self.buttonBuySellFarmland:setDisabled(self:getBuySellButtonState())
end

function EasyDevControlsPlayerFrame:onClickFarmlandIndex(index)
    self.farmlandIndexSelected = index

    local disable = self:getBuySellButtonState()
    self.buttonBuySellFarmland:setDisabled(disable)
end

function EasyDevControlsPlayerFrame:onClickBuySellFarmland()
    if self.buySellSelection == EasyDevControlsPlayerFrame.BUY_FARMLAND then
        if self.farmlandIndexSelected == #self.farmlandIds then
            self:printCommandState(g_farmlandManager:consoleCommandBuyAllFarmlands())
        else
            self:printCommandState(g_farmlandManager:consoleCommandBuyFarmland(self.farmlandIndexSelected))
        end

        self.buttonBuySellFarmland:setDisabled(true)
    elseif self.buySellSelection == EasyDevControlsPlayerFrame.SELL_FARMLAND then
        if self.farmlandIndexSelected == #self.farmlandIds then
            self:printCommandState(g_farmlandManager:consoleCommandSellAllFarmlands())
        else
            self:printCommandState(g_farmlandManager:consoleCommandSellFarmland(self.farmlandIndexSelected))
        end

        self.buttonBuySellFarmland:setDisabled(true)
    end
end

function EasyDevControlsPlayerFrame:getBuySellButtonState()
    if self.buySellSelection == 1 then
        return true
    end

    if self.farmlandIndexSelected < #self.farmlandIds then
        local ownerId = g_farmlandManager:getFarmlandOwner(self.farmlandIndexSelected)

        if self.buySellSelection == EasyDevControlsPlayerFrame.BUY_FARMLAND then
            if ownerId ~= FarmlandManager.NO_OWNER_FARM_ID then
                return true
            end
        elseif self.buySellSelection == EasyDevControlsPlayerFrame.SELL_FARMLAND then
            if ownerId ~= g_currentMission:getFarmId() then
                return true
            end
        end
    end

    return false
end

function EasyDevControlsPlayerFrame:onClickSpeedMultiplier(step)
    self.currentPlayerSpeedStep = step

    local multiplier = EasyDevControlsPlayerFrame.PLAYER_SPEED_STEPS[step] or 1
    self:printCommandState(g_easyDevControls:setSpeedMultiplier(multiplier, true))

    if multiplier == 1 then
        self.setPlayerSpeedState:setDisabled(true)
        self.setPlayerSpeedState:setIsChecked(false)
        g_easyDevControls.speedMultiplierActive = false
    else
        self.setPlayerSpeedState:setDisabled(false)
    end
end

function EasyDevControlsPlayerFrame:onClickSpeedMultiplierState(index)
    self:printCommandState(g_easyDevControls:setSpeedMultiplierState(index > 1, true))
end

function EasyDevControlsPlayerFrame:onClickShowSpeedMultiplier(index)
    g_easyDevControls.showSpeedMultiplier = index > 1
end

function EasyDevControlsPlayerFrame:onClickShowTimeScale(index)
    g_easyDevControls.showTimeScale = index > 1
end

function EasyDevControlsPlayerFrame:onClickTimeSpeedValue(index)
    local scale = 0
    if index > 1 then
        scale = EasyDevControlsPlayerFrame.TIME_SPEED_VALUES[index] or 0
    end

    self:printCommandState(g_easyDevControls:setTimeScale(scale))
end

function EasyDevControlsPlayerFrame:onResetConfirm(doReset)
    if not doReset then
        return
    end

    self.allowCommandStatePrint = false

    local player = g_currentMission.player
    local checked = CheckedOptionElement.STATE_CHECKED
    local unchecked = CheckedOptionElement.STATE_UNCHECKED

    self.setFlightAndNoHUDMode:setState(unchecked, g_flightAndNoHUDKeysEnabled)
	if g_currentMission.hud ~= nil then
        g_currentMission.hud:setIsVisible(true)
    end

	if g_currentMission:getIsServer() or g_currentMission.isMasterUser then
		self.setSuperStrengthState:setState(unchecked, player.superStrengthEnabled == true)
	end

    if not g_woodCuttingMarkerEnabled then
        self.setWoodCuttingMarker:setState(checked, true)
    end

    self.setPlayerDebug:setState(unchecked, player.baseInformation.isInDebug)

    if player.playerStateMachine ~= nil then
        self.setPlayerStateMachineDebug:setState(unchecked, player.playerStateMachine.debugMode)
        if player.playerStateMachine.playerStateJump ~= nil then
            self.setPlayerStateJump:setState(unchecked, player.playerStateMachine.playerStateJump:inDebugMode())
        else
            self.setPlayerStateJump:setDisabled(true)
        end
    else
        self.setPlayerStateMachineDebug:setDisabled(true)
        self.setPlayerStateJump:setDisabled(true)
    end

    self.setPlayerSpeedMultiplier:setState(3, true)
    self.setPlayerSpeedState:setState(unchecked, g_easyDevControls.speedMultiplierActive)

    self.setShowSpeedMultiplier:setState(checked, not g_easyDevControls.showSpeedMultiplier)

    self.allowCommandStatePrint = true
    self:printCommandState(self.l10n:getText("EDC_resetPageComplete"))
end

function EasyDevControlsPlayerFrame:onToolTipBoxTextChanged(toolTipBox)
    local showText = (toolTipBox.text ~= nil and toolTipBox.text ~= "")
    self.playerHelpBox:setVisible(showText)
end

function EasyDevControlsPlayerFrame:getMainElementSize()
    return self.playerContainer.size
end

function EasyDevControlsPlayerFrame:getMainElementPosition()
    return self.playerContainer.absPosition
end

function EasyDevControlsPlayerFrame:printCommandState(text)
    if self.allowCommandStatePrint and (text ~= nil and text ~= "") then

        self.playerHelpBoxText:setText(text)
        self.playerHelpBox:setVisible(true)

        if self.printToLog then
            print("EDC - Player: " .. text)
        end
    end
end