--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 07.04.2019
Version: 1.0.0.0

History:
V 1.0.0.0 @ 07.04.2019 - Release Version

Contact:
GtX_Andy@protonmail.com

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


EasyDevControlsTabbedMenu = {}
local EasyDevControlsTabbedMenu_mt = Class(EasyDevControlsTabbedMenu, TabbedMenu)

-- Mapping of page controller instances to enabling predicate functions (if return true -> enable)
local function predicate()
    return true
end

EasyDevControlsTabbedMenu.CONTROLS = {
    BACKGROUND = "inGameBackgroundElement",
    PAGE_GENERAL = "pageGeneral",
    PAGE_ENVIRONMENT = "pageEnvironment",
    PAGE_PLAYER = "pagePlayer",
    PAGE_FIELDS = "pageFields",
    PAGE_VEHICLES = "pageVehicles"
}

EasyDevControlsTabbedMenu.TAB_UV = {
    GENERAL = {844, 144, 65, 65},
    ENVIRONMENT = {65, 144, 65, 65},
    PLAYER = {454, 209, 65, 65},
    FIELD = {432, 96, 48, 48},
    VEHICLES = {130, 144, 65, 65}
}

EasyDevControlsTabbedMenu.BUTTONS = {
    BACK = "button_back",
    RESET = "button_reset",
    BACKGROUND_REMOVE = "EDC_button_removeBlur",
    BACKGROUND_ADD = "EDC_button_addBlur"
}

EasyDevControlsTabbedMenu.PAGE_ID_TO_TITLE = {
    [1] = "EDC_generalPage",
    [2] = "EDC_environmentPage",
    [3] = "EDC_playerPage",
    [4] = "EDC_fieldsPage",
    [5] = "EDC_vehiclesPage"
}

function EasyDevControlsTabbedMenu:new(target, messageCenter, l10n, inputManager, printToLog)
    local self = TabbedMenu:new(target, EasyDevControlsTabbedMenu_mt, messageCenter, l10n, inputManager)

    self.backgroundActive = true
    self.performBackgroundBlur = true

    self.pageSetupIndex = 1
    self.allowPageSetup = false

    self.l10n = l10n
    self.printToLog = printToLog

    self:registerControls(EasyDevControlsTabbedMenu.CONTROLS)

    return self
end

function EasyDevControlsTabbedMenu:onOpen(element)
    EasyDevControlsTabbedMenu:superClass().onOpen(self, element)

    self.backgroundActive = true
    self.inGameBackgroundElement:setVisible(true)
end

function EasyDevControlsTabbedMenu:onGuiSetupFinished()
    EasyDevControlsTabbedMenu:superClass().onGuiSetupFinished(self)

    self.pageSetupIndex = 1
    self.allowPageSetup = true

    self:setupPage(self.pageGeneral, EasyDevControlsTabbedMenu.TAB_UV.GENERAL)
    self:setupPage(self.pageEnvironment, EasyDevControlsTabbedMenu.TAB_UV.ENVIRONMENT)
    self:setupPage(self.pagePlayer, EasyDevControlsTabbedMenu.TAB_UV.PLAYER)
    self:setupPage(self.pageFields, EasyDevControlsTabbedMenu.TAB_UV.FIELD)
    self:setupPage(self.pageVehicles, EasyDevControlsTabbedMenu.TAB_UV.VEHICLES)

    if g_universalPassenger ~= nil then
        --self:setupPage(page, icon, iconFilename)
    end

    if g_seasons ~= nil then
        --self:setupPage(page, icon, iconFilename)
    end

    self.allowPageSetup = false
end

function EasyDevControlsTabbedMenu:setupPage(page, icon, iconFilename)
    if self.allowPageSetup then
        if iconFilename == nil then
            iconFilename = g_baseUIFilename
        end

        page:initialize(self.l10n, self.printToLog)

        self:registerPage(page, self.pageSetupIndex, predicate)

        local normalizedUVs = getNormalizedUVs(icon)
        self:addPageTab(page, iconFilename, normalizedUVs)

        self.pageSetupIndex = self.pageSetupIndex + 1
    end
end

function EasyDevControlsTabbedMenu:setupMenuButtonInfo()
    local clickBackCallback = self:makeSelfCallback(self.clickBackCallback)
    local resetCallback = self:makeSelfCallback(self.clickResetCallback)
    local clickRemoveBackground = self:makeSelfCallback(self.clickRemoveBackground)

    self.defaultMenuButtonInfo = {
        {inputAction = InputAction.MENU_BACK, text = self.l10n:getText(EasyDevControlsTabbedMenu.BUTTONS.BACK), callback = clickBackCallback},
        {inputAction = InputAction.MENU_ACTIVATE, text = self.l10n:getText(EasyDevControlsTabbedMenu.BUTTONS.RESET), callback = resetCallback},
        {inputAction = InputAction.MENU_EXTRA_1, text = self.l10n:getText(EasyDevControlsTabbedMenu.BUTTONS.BACKGROUND_REMOVE), callback = clickRemoveBackground}
    }

    self.defaultMenuButtonInfoByActions[InputAction.MENU_BACK] = self.defaultMenuButtonInfo[1]
    self.defaultMenuButtonInfoByActions[InputAction.MENU_ACTIVATE] = self.defaultMenuButtonInfo[2]
    self.defaultMenuButtonInfoByActions[InputAction.MENU_EXTRA_1] = self.defaultMenuButtonInfo[3]

    self.defaultButtonActionCallbacks = {
        [InputAction.MENU_BACK] = clickBackCallback,
        [InputAction.MENU_ACTIVATE] = resetCallback,
        [InputAction.MENU_EXTRA_1] = clickRemoveBackground
    }
end

function EasyDevControlsTabbedMenu:clickResetCallback()
    if self.currentPage ~= nil and self.currentPageId ~= nil then
        local title = self.l10n:getText(EasyDevControlsTabbedMenu.PAGE_ID_TO_TITLE[self.currentPageId])
        local text = self.l10n:getText("EDC_resetPage")

        -- Handled by each frame.
        g_gui:showYesNoDialog({text = text, title = title, callback = self.currentPage.onResetConfirm, target = self.currentPage})
    end
end

function EasyDevControlsTabbedMenu:onPageClicked(oldPage)
    if not self.backgroundActive then
        self:clickRemoveBackground()
    end
end

function EasyDevControlsTabbedMenu:clickRemoveBackground()
    local state = not self.backgroundActive

    self.backgroundActive = state

    self.inGameBackgroundElement:setVisible(state)
    g_depthOfFieldManager:setBlurState(state)

    if self.backgroundActive then
        self.menuButton[3]:setText(self.l10n:getText(EasyDevControlsTabbedMenu.BUTTONS.BACKGROUND_REMOVE))
    else
        self.menuButton[3]:setText(self.l10n:getText(EasyDevControlsTabbedMenu.BUTTONS.BACKGROUND_ADD))
    end
end