--[[
Interface: 1.4.1.0 b5334

Copyright (C) GtX (Andy), 2019

Author: GtX | Andy
Date: 07.04.2019
Version: 1.0.0.0

History:
V 1.0.0.0 @ 07.04.2019 - Release Version

Contact:
GtX_Andy@protonmail.com

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


EasyDevControlsVehiclesFrame = {}
local EasyDevControlsVehiclesFrame_mt = Class(EasyDevControlsVehiclesFrame, TabbedMenuFrameElement)

EasyDevControlsVehiclesFrame.CONTROLS = {
    VEHICLE_CONTAINER = "vehiclesContainer",
    VEHICLES_HELP_BOX_TEXT = "vehiclesHelpBoxText",
    VEHICLES_HELP_BOX = "vehiclesHelpBox",
    SET_VEHICLE_BEBUG_STATE = "setVehicleDebugState",
    SET_TENSION_BELT_DEBUG = "setTensionBeltDebugRendering",
    SET_SHOW_VEHICLE_DISTANCE = "setShowVehicleDistance",
    BUTTON_DELETE_ALL_VEHICLES = "buttonDeleteAllVehicles",
    BUTTON_REMOVE_TYRE_TRACKS = "buttonRemoveAllTireTracks",
    SET_OPERATING_TIME = "setOperatingTime",
    BUTTON_VEHICLE_ANALYSE = "buttonVehicleAnalyse",
    SET_RESET_VEHICLE = "setResetVehicle",
    BUTTON_RELOAD_VEHICLE = "buttonReloadVehicle",
    SELECT_WIPER_STATE = "selectWiperState",
    BUTTON_SET_WIPER_STATE = "buttonSetWiperState",
    SELECT_MOTOR_TEMPERATURE = "selectMotorTemperature",
    BUTTON_SET_MOTOR_TEMPERATURE = "buttonSetMotorTemperature",
    SET_CHANGE_DIRT_AMOUNT = "setChangeDirtAmount",
    BUTTON_ADD_DIRT_AMOUNT = "buttonAddDirtAmount",
    SET_CHANGE_WEAR_AMOUNT = "setChangeWearAmount",
    BUTTON_ADD_WEAR_AMOUNT = "buttonAddWearAmount",
    SET_FILL_UNIT_ADD_INDEX = "setFillUnitAddIndex",
    SET_FILL_UNIT_ADD_NAME = "setFillUnitAddName",
    FILL_UNIT_ADD_TEXT = "fillUnitAddText",
    EMPTY_SELECTED_TEXT = "emptySelectedText",
    SET_FILL_UNIT_ADD_VOLUME = "setFillUnitAddVolume",
    BUTTON_FILL_UNIT_ADD = "buttonFillUnitAdd",
    BUTTON_EMPTY_ALL = "buttonEmptySelected"
}

EasyDevControlsVehiclesFrame.DEBUG_STATES = {
    "OFF", "PHYSICS", "DEBUG", "ATTRIBUTES",
    "ATTACHER JOINTS", "AI", "SOUNDS", "TIPPING"
}

EasyDevControlsVehiclesFrame.DIRT_WEAR_SCALE = {
    "-1", "-0.9", "-0.8", "-0.7", "-0.6", "-0.5", "-0.4", "-0.3", "-0.2", "-0.1",
    "0", "0.1", "0.2", "0.3", "0.4", "0.5", "0.6", "0.7", "0.8", "0.9", "1"
}

EasyDevControlsVehiclesFrame.TEMPERATURE = {
    "20", "30", "40", "50", "60", "70",
    "80", "90", "100", "110", "120"
}

EasyDevControlsVehiclesFrame.TEMPERATURE_TO_INDEX = {
    ["20"] = 1, ["30"] = 2, ["40"] = 3, ["50"] = 4, ["60"] = 5, ["70"] = 6,
    ["80"] = 7, ["90"] = 8, ["100"] = 9, ["110"] = 10, ["120"] = 11
}

EasyDevControlsVehiclesFrame.WIPER_STATES = {
    "OFF", "1", "2", "3", "4", "5"
}

EasyDevControlsVehiclesFrame.L10N_SYMBOL = {}

local function boolToString(bool)
    if bool ~= nil and bool then
        return "true"
    end

    return "false"
end

function EasyDevControlsVehiclesFrame:new()
    local self = TabbedMenuFrameElement:new(nil, EasyDevControlsVehiclesFrame_mt)

    self.l10n = nil
    self.printToLog = nil

    self.allowCommandStatePrint = true

    self.dirtIndex = 11
    self.wearIndex = 11

    self.fillUnitAdding = {fillUnitIndex = 1, fillTypeName = "WHEAT", lastText = ""}

    self.wiperStateSelected = 1
    self.selectedMotorTempIndex = 1

    self:registerControls(EasyDevControlsVehiclesFrame.CONTROLS)

    return self
end

function EasyDevControlsVehiclesFrame:initialize(l10n, printToLog)
    self.l10n = l10n
    self.printToLog = printToLog
end

function EasyDevControlsVehiclesFrame:onFrameOpen()
    EasyDevControlsVehiclesFrame:superClass().onFrameOpen(self)

    local isClient = not g_currentMission:getIsServer()

    local vehicle = g_currentMission.controlledVehicle
    local noVehicle = isClient or vehicle == nil

    self.setVehicleDebugState:setTexts(EasyDevControlsVehiclesFrame.DEBUG_STATES)
    self.setVehicleDebugState:setState(VehicleDebug.state + 1, true)

    self.buttonVehicleAnalyse:setDisabled(noVehicle)

    self.setTensionBeltDebugRendering:setIsChecked(TensionBelts.debugRendering)

    self.lastOperatingTimeValue = ""
    self.setOperatingTime:setText(self.lastOperatingTimeValue)
    self.setOperatingTime:setDisabled(noVehicle)

    self.setShowVehicleDistance:setIsChecked(g_showVehicleDistance)
    self.buttonDeleteAllVehicles:setDisabled(isClient)
    self.buttonRemoveAllTireTracks:setDisabled(isClient)

    self.setResetVehicle:setTexts({g_i18n:getText("configuration_valueDefault"), g_i18n:getText("button_reset")})
    self.setResetVehicle:setState(1, true)
    self.setResetVehicle:setDisabled(noVehicle)
    self.buttonReloadVehicle:setDisabled(noVehicle)

    self.selectWiperState:setTexts(EasyDevControlsVehiclesFrame.WIPER_STATES)
    self.selectWiperState:setState(math.min(5, Wipers.forcedState + 1), true)

    local tempIndex = self:getValidTempStep()
    self.selectMotorTemperature:setTexts(EasyDevControlsVehiclesFrame.TEMPERATURE)
    self.selectMotorTemperature:setState(tempIndex, false)
    self.selectMotorTemperature:setDisabled(noVehicle)
    self.buttonSetMotorTemperature:setDisabled(true)

    self.setChangeDirtAmount:setTexts(EasyDevControlsVehiclesFrame.DIRT_WEAR_SCALE)
    self.setChangeDirtAmount:setState(11, true)
    self.setChangeDirtAmount:setDisabled(noVehicle)
    self.buttonAddDirtAmount:setDisabled(noVehicle)

    self.setChangeWearAmount:setTexts(EasyDevControlsVehiclesFrame.DIRT_WEAR_SCALE)
    self.setChangeWearAmount:setState(11, true)
    self.setChangeWearAmount:setDisabled(noVehicle)
    self.buttonAddWearAmount:setDisabled(noVehicle)

    local object, invalidObject
    if vehicle ~= nil and  not vehicle:getIsAIActive() then
        local selectedVehicle = vehicle:getSelectedVehicle()
        if selectedVehicle ~= nil then
            if selectedVehicle.spec_fillUnit ~= nil then
                object = selectedVehicle
            else
                invalidObject = selectedVehicle
            end
        else
            if vehicle.spec_fillUnit ~= nil then
                object = vehicle
            end
        end
    end

    local indexs = {}
    self.indexToFillTypes = {}
    self.selectedVehicleName = nil

    if object ~= nil then
        for i, fillUnit in ipairs(object.spec_fillUnit.fillUnits) do
            indexs[i] = "Fill Unit " .. tostring(i)

            self.indexToFillTypes[i] = {}
            for fillTypeIndex, _ in pairs (fillUnit.supportedFillTypes) do
                local fillTypeName = g_fillTypeManager:getFillTypeNameByIndex(fillTypeIndex)
                table.insert(self.indexToFillTypes[i], fillTypeName)
            end
        end

        self.selectedVehicleName = object:getFullName()
        self.fillUnitAddText:setText("Fill:  " .. self.selectedVehicleName)

        self.setFillUnitAddIndex:setTexts(indexs)
        self.setFillUnitAddIndex:setState(1, true)

        self.setFillUnitAddName:setTexts(self.indexToFillTypes[1])
        self.setFillUnitAddName:setState(1, true)

        self.selectedVehicle = object
    else
        local name = ""
        if invalidObject ~= nil and invalidObject.getFullName ~= nil then
            name = invalidObject:getFullName()
        end

        self.fillUnitAddText:setText("Fill:  " .. name)
        self.emptySelectedText:setText("EMPTY:  " .. name)

        self.setFillUnitAddIndex:setTexts({"N/A"})
        self.setFillUnitAddName:setTexts({"N/A"})
    end

    local noObject = isClient or object == nil
    self.setFillUnitAddIndex:setDisabled(noObject or #indexs < 2)
    self.setFillUnitAddName:setDisabled(noObject or #self.indexToFillTypes[1] < 2)
    self.buttonFillUnitAdd:setDisabled(noObject)
    self.buttonEmptySelected:setDisabled(noObject)
end

function EasyDevControlsVehiclesFrame:getValidTempStep()
    local vehicle = g_currentMission.controlledVehicle
    if vehicle ~= nil and vehicle.spec_motorized ~= nil then
        local trueValue = math.floor(vehicle.spec_motorized.motorTemperature.value)

        local mod = trueValue % 10
        if mod >= 5 then
            mod = trueValue + (10 - mod)
        elseif mod < 5 then
            mod = trueValue - mod
        end

        return EasyDevControlsVehiclesFrame.TEMPERATURE_TO_INDEX[tostring(mod)] or 1
    end

    return 1
end

function EasyDevControlsVehiclesFrame:onClickVehicleDebugState(debugIndex)
    VehicleDebug.state = math.max(debugIndex - 1, 0)
end

function EasyDevControlsVehiclesFrame:onClickVehicleAnalyse()
    local text = VehicleDebug.consoleCommandAnalyze()
    if text == "Analyzed vehicle" then
        self:printCommandState(text .. ".  Check console or log file for more details.")
    else
        self:printCommandState(text)
    end
end

function EasyDevControlsVehiclesFrame:onClickTensionBeltDebugRendering(debugIndex)
    TensionBelts.debugRendering = (debugIndex > 1)
    self:printCommandState("Tension Belts Debug Rendering = " .. tostring(TensionBelts.debugRendering))
end

function EasyDevControlsVehiclesFrame:onSetOperatingTimeEnterPressed()
    if self.setOperatingTime.text ~= "" then
        local valueToSet = tonumber(self.setOperatingTime.text)
        if valueToSet ~= nil then
            local text = g_currentMission:consoleCommandSetOperatingTime(self.setOperatingTime.text)
            if text ~= nil then
                self:printCommandState(text)
            else
                self:printCommandState("Vehicle operating time changed to " .. self.setOperatingTime.text .."h.")
            end
        else
            self:printCommandState("[Set Operating Time] '" .. self.setOperatingTime.text .. "' is not a valid value!")
        end

        self.setOperatingTime:setText("")
    end

    self.lastOperatingTimeValue = ""
end

function EasyDevControlsVehiclesFrame:onSetOperatingTimeEscPressed()
    if self.setOperatingTime.text ~= "" then
        self.setOperatingTime:setText("")
    end
end

function EasyDevControlsVehiclesFrame:onSetOperatingTimeTextChanged()
    local text = self.setOperatingTime.text
    if text ~= "" then
        if tonumber(text) ~= nil then
            self.lastOperatingTimeValue = text
        else
            self.setOperatingTime:setText(self.lastOperatingTimeValue)
        end
    else
        self.lastOperatingTimeValue = ""
    end
end

function EasyDevControlsVehiclesFrame:onClickResetVehicle(index)
    self.resetVehicle = index > 1
end

function EasyDevControlsVehiclesFrame:onClickReloadVehicle()
    if g_currentMission.controlledVehicle ~= nil then
        local reset = boolToString(self.resetVehicle)

        g_gui:showGui("")
        g_currentMission:consoleCommandReloadVehicle(reset)
        g_easyDevControls:onInputOpenMenu()

        self:printCommandState("Vehicle reloaded successfully. Vehicle reset = " .. reset)

        self.setResetVehicle:setDisabled(true)
        self.buttonReloadVehicle:setDisabled(true)
    else
        self:printCommandState("First enter a vehicle.")
    end
end

function EasyDevControlsVehiclesFrame:onClickSelectWiperState(index)
    self.wiperStateSelected = index - 1
    self.buttonSetWiperState:setDisabled(self.wiperStateSelected == Wipers.forcedState)
end

function EasyDevControlsVehiclesFrame:onClickSetWiperState()
    self:printCommandState(consoleSetWiperState(tostring(self.wiperStateSelected)))
    self.buttonSetWiperState:setDisabled(true)
end

function EasyDevControlsVehiclesFrame:onClickSelectMotorTemperature(index)
    self.selectedMotorTempIndex = index

    local tempIndex = self:getValidTempStep()
    self.buttonSetMotorTemperature:setDisabled(tempIndex == index)
end

function EasyDevControlsVehiclesFrame:onClickSetMotorTemperature()
    if g_currentMission.controlledVehicle ~= nil then
        local temperature = EasyDevControlsVehiclesFrame.TEMPERATURE[self.selectedMotorTempIndex]
        self:printCommandState(g_currentMission:consoleCommandSetMotorTemperature(temperature))
        self.buttonSetMotorTemperature:setDisabled(true)
    else
        self:printCommandState("First enter a vehicle.")
    end
end

function EasyDevControlsVehiclesFrame:onClickChangeDirtAmount(dirtIndex)
    self.dirtIndex = dirtIndex
end

function EasyDevControlsVehiclesFrame:onClickAddDirtAmount()
    local dirtAmount = EasyDevControlsVehiclesFrame.DIRT_WEAR_SCALE[self.dirtIndex]

    local value = "-1"
    if dirtAmount ~= "0" then
        value = dirtAmount
    end

    local text = g_currentMission:consoleCommandAddDirtAmount(value)
    if text ~= nil then
        self:printCommandState(text)
    else
        if dirtAmount ~= "0" then
            self:printCommandState("Dirt amount adjusted by " .. dirtAmount)
        else
            self:printCommandState("Dirt amount has been reset.")
        end
    end
end

function EasyDevControlsVehiclesFrame:onClickChangeWearAmount(wearIndex)
    self.wearIndex = wearIndex
end

function EasyDevControlsVehiclesFrame:onClickAddWearAmount()
    local wearAmount = EasyDevControlsVehiclesFrame.DIRT_WEAR_SCALE[self.wearIndex]

    local value = "-1"
    if wearAmount ~= "0" then
        value = wearAmount
    end

    local text = g_currentMission:consoleCommandAddWearAmount(value)
    if text ~= nil then
        self:printCommandState(text)
    else
        if wearAmount ~= "0" then
            self:printCommandState("Wear amount adjusted by " .. wearAmount)
        else
            self:printCommandState("Wear amount has been reset.")
        end
    end
end

function EasyDevControlsVehiclesFrame:onClickVehicleDistance(index)
    g_currentMission:consoleCommandShowVehicleDistance(index > 1)
    self:printCommandState("Vehicle distance debug = " .. string.upper(tostring(g_showVehicleDistance)))
end

function EasyDevControlsVehiclesFrame:onClickDeleteAllVehicles()
    local text = self.l10n:getText("EDC_deleteAllVehiclesWarning")
    g_gui:showYesNoDialog({text = text, title = "", callback = self.doDeleteAllVehicles, target = self})
end

function EasyDevControlsVehiclesFrame:doDeleteAllVehicles(delete)
    if delete then
        self.buttonDeleteAllVehicles:setDisabled(true)
        self:printCommandState(g_currentMission:consoleCommandDeleteAllVehicles())
    end
end

function EasyDevControlsVehiclesFrame:onClickRemoveAllTireTracks()
    if g_currentMission.tireTrackSystem ~= nil then
        self.buttonRemoveAllTireTracks:setDisabled(true)
        self:printCommandState(g_currentMission.tireTrackSystem:consoleCommandRemoveAllTireTracks())
    end
end


function EasyDevControlsVehiclesFrame:onClickFillUnitAddIndex(fillUnitIndex)
    self.fillUnitAdding.fillUnitIndex = fillUnitIndex

    self.setFillUnitAddName:setTexts(self.indexToFillTypes[fillUnitIndex])
    self.setFillUnitAddName:setState(1, true)

    self.setFillUnitAddName:setDisabled(#self.indexToFillTypes[fillUnitIndex] < 2)

    if self.selectedVehicleName ~= nil then
        self.emptySelectedText:setText("EMPTY (" .. fillUnitIndex .. "):  " .. self.selectedVehicleName)
    end
end

function EasyDevControlsVehiclesFrame:onClickFillUnitAddName(nameIndex)
    local fillUnitIndex = self.fillUnitAdding.fillUnitIndex
    local fillTypeName = self.indexToFillTypes[fillUnitIndex][nameIndex]
    self.fillUnitAdding.fillTypeName = fillTypeName
end

function EasyDevControlsVehiclesFrame:onClickFillUnitAdd()
    if g_currentMission:getIsServer() and self.selectedVehicle ~= nil then
        local fillUnitIndex = self.fillUnitAdding.fillUnitIndex

        if self.selectedVehicle:getFillUnitFillLevel(fillUnitIndex) > 0 then
            local currentFillTypeIndex = self.selectedVehicle:getFillUnitFillType(fillUnitIndex)
            g_currentMission:consoleCommandFillUnitAdd(tostring(fillUnitIndex), g_fillTypeManager:getFillTypeNameByIndex(currentFillTypeIndex), 0)
        end

        self:printCommandState(g_currentMission:consoleCommandFillUnitAdd(tostring(fillUnitIndex), self.fillUnitAdding.fillTypeName))
    end
end

function EasyDevControlsVehiclesFrame:onClickEmptySelected()
    if g_currentMission:getIsServer() and self.selectedVehicle ~= nil then
        local fillUnitIndex = self.fillUnitAdding.fillUnitIndex

        if self.selectedVehicle:getFillUnitFillLevel(fillUnitIndex) > 0 then
            local currentFillTypeIndex = self.selectedVehicle:getFillUnitFillType(fillUnitIndex)
            g_currentMission:consoleCommandFillUnitAdd(tostring(fillUnitIndex), g_fillTypeManager:getFillTypeNameByIndex(currentFillTypeIndex), 0)
        end
    end
end

function EasyDevControlsVehiclesFrame:onResetConfirm(doReset)
    if not doReset then
        return
    end

    self.allowCommandStatePrint = false

    self.setVehicleDebugState:setState(1, true)
    self.setTensionBeltDebugRendering:setState(1, true)

    self.setShowVehicleDistance:setState(1, true)
    self.setResetVehicle:setState(1, true)

    self.selectWiperState:setState(math.min(5, Wipers.forcedState + 1), true)

    if self.selectedVehicle ~= nil then
        local tempIndex = self:getValidTempStep()
        self.selectMotorTemperature:setState(tempIndex, false)

        self.setChangeDirtAmount:setState(11, true)

        self.setChangeWearAmount:setState(11, true)

        self.setFillUnitAddIndex:setState(1, true)
        self.setFillUnitAddName:setState(1, true)
    end

    self.allowCommandStatePrint = true
    self:printCommandState(self.l10n:getText("EDC_resetPageComplete"))
end

function EasyDevControlsVehiclesFrame:onToolTipBoxTextChanged(toolTipBox)
    local showText = (toolTipBox.text ~= nil and toolTipBox.text ~= "")
    self.vehiclesHelpBox:setVisible(showText)
end

function EasyDevControlsVehiclesFrame:getMainElementSize()
    return self.vehiclesContainer.size
end

function EasyDevControlsVehiclesFrame:getMainElementPosition()
    return self.vehiclesContainer.absPosition
end

function EasyDevControlsVehiclesFrame:printCommandState(text)
    if self.allowCommandStatePrint and (text ~= nil and text ~= "") then

        self.vehiclesHelpBoxText:setText(text)
        self.vehiclesHelpBox:setVisible(true)

        if self.printToLog then
            print("EDC - Vehicle: " .. text)
        end
    end
end
