﻿<%@ WebHandler Language="C#" Class="Upload" %>

using System;
using System.Web;
using System.IO;
using D.BLL;
using D.Model;
using System.Collections.Generic;
using System.Web.SessionState;
using D.Common;

public class Upload : IHttpHandler, IRequiresSessionState
{
	private B_Site bllSite = new B_Site();
	private M_Site modelSite = new M_Site();
	private B_UpLoadPic bllUpLoadPic = new B_UpLoadPic();
	private B_UpLoadFile bllUpLoadFile = new B_UpLoadFile();

	public void ProcessRequest(HttpContext context)
	{
		//接受Cookies

		var Response = context.Response;
		var Request = context.Request;
		var Session = context.Session;

		string adminCookies = Request.Form["AdminCookies"];
		if (adminCookies.Length == 0)
		{
			Response.StatusCode = 500;
			Response.Write("An error occured");
			Response.End();
		}
		else
		{
			modelSite = bllSite.GetModel();
			MemoryStream ms = new MemoryStream();
			string FilePicPath = Request.Form["FilePicPath"];
			string FolderName = DateTime.Now.ToString("yyyyMM") + "/" + DateTime.Now.ToString("dd");

			HttpPostedFile jpeg_image_upload = Request.Files["Filedata"];
			//string s_rpath = "F:\\Projects\\UploadDemo\\UploadDemo\\" + FilePicPath.Split('|')[0] + "\\";
			string FolderPath = HttpContext.Current.Server.MapPath(D.Common.Param.ApplicationRootPath + "/" + modelSite.UploadFolder + "/" + FilePicPath.Split('|')[0] + "/" + FolderName + "/");

			string Datedir = DateTime.Now.ToString("yy-MM-dd");

			Response.CacheControl = "no-cache";
			if (Request.Files.Count > 0)
			{
				try
				{

					for (var j = 0; j < Request.Files.Count; j++)
					{
						var uploadFile = Request.Files[j];
						if (uploadFile.ContentLength <= 0) continue;
						if (!Directory.Exists(FolderPath))
						{
							Directory.CreateDirectory(FolderPath);
						}
						var extension = Path.GetExtension(uploadFile.FileName);
						//var fullname = DateTime.Now.Year.ToString() + DateTime.Now.Month.ToString() + DateTime.Now.Day.ToString() + DateTime.Now.Hour.ToString() + DateTime.Now.Minute.ToString() + DateTime.Now.Second.ToString();
						var filename = uploadFile.FileName;
						if (modelSite.UploadAutoName)
						{
							filename = Function.GetFileName();
						}
						else
						{
							filename = bllUpLoadPic.GetFileName(FolderPath, Path.GetFileNameWithoutExtension(jpeg_image_upload.FileName).Replace(".", "_").Replace(";", "_"), extension, 0);
						}

						//
						string returnFileName = bllUpLoadFile.GetUpLoadFile(uploadFile, FilePicPath.Split('|')[0], int.Parse(FilePicPath.Split('|')[1]));

						//uploadFile.SaveAs(string.Format("{0}\\{1}", FolderPath, filename + extension));

						B_SWF_Thumbnail thumb = new B_SWF_Thumbnail(returnFileName, ms.GetBuffer(), jpeg_image_upload);

						// Put it all in the Session (initialize the session if necessary)			
						List<B_SWF_Thumbnail> thumbnails = Session["file_info2"] as List<B_SWF_Thumbnail>;
						if (thumbnails == null)
						{
							thumbnails = new List<B_SWF_Thumbnail>();
							Session["file_info2"] = thumbnails;
						}
						thumbnails.Add(thumb);
					}
				}
				catch (Exception ex)
				{
					Response.Write("Message" + ex.ToString());
				}
			}
		}
	}

	public bool IsReusable
	{
		get
		{
			return false;
		}
	}

}