﻿<%@ WebService Language="C#" Class="NumericUpDownService" %>

using System;
using System.Web;
using System.Web.Services;
using System.Web.Services.Protocols;

[WebService(Namespace = "http://www.dflying.net/")]
[WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
[System.Web.Script.Services.ScriptService()]
public class NumericUpDownService  : System.Web.Services.WebService {

    private const int MAXVALUE = 100;
    private const int MINVALUE = 0;
    private const int DELTA = 1;
    
    [WebMethod]
    public int GetNextValue(int current, string tag)
    {
        if (current + NumericUpDownService.DELTA < NumericUpDownService.MAXVALUE)
            return current + NumericUpDownService.DELTA;
        else
            return NumericUpDownService.MAXVALUE;
    }
    
    [WebMethod]
    public int GetPreviousValue(int current, string tag)
    {
        if (current - NumericUpDownService.DELTA > NumericUpDownService.MINVALUE)
            return current - NumericUpDownService.DELTA;
        else
            return NumericUpDownService.MINVALUE;
    }
    
}

