﻿<%@ page language="C#" autoeventwireup="true" inherits="house_map, DianCMS" enableviewstatemac="false" enableEventValidation="false" viewStateEncryptionMode="Never" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>百度地图标注</title>
    <asp:Literal ID="LitJs" runat="server"></asp:Literal>
    <style type="text/css">
        body, html { margin:0px;padding:0px;}
        #container { width: 99%; height: 396px; overflow: hidden; margin: 0; font-family: "微软雅黑"; }
        .queren { padding: 4px; display: block; text-decoration: none; }
    </style>
    <script type="text/javascript">
        var api = frameElement.api, W = api.opener;
    </script>
</head>
<body>
    <form id="form1" runat="server">
        <div>
            <input type="text" id="input" size="30" />
            <input type="button" onclick="searchMap();" value="搜索地图" />
        </div>
        <div id="container">
        </div>
        <asp:Literal ID="Literal1" runat="server"></asp:Literal>
        <script type="text/javascript">
            map.addControl(new BMap.MapTypeControl());   //添加地图类型控件
            var top_left_navigation = new BMap.NavigationControl();  //左上角，添加默认缩放平移控件
            map.addControl(top_left_navigation);
            map.enableScrollWheelZoom();
            var oldmarker;
            map.addEventListener("click", function (e) {
                parent.document.getElementById("BaiDuMap").value = e.point.lng;
                parent.document.getElementById("BaiDuMap_y").value = e.point.lat;
                if (oldmarker != null) {
                    map.removeOverlay(oldmarker);
                }
                var marker = new BMap.Marker(e.point);        // 创建标注
                map.addOverlay(marker);                     // 将标注添加到地图中
                oldmarker = marker;

                var label = new BMap.Label("<a href='javascript:' onclick='api.close()' class='queren'>提交标注</a>", { offset: new BMap.Size(20, 0) });
                marker.setLabel(label);
            });

            function searchMap() {
                var area = document.getElementById("input").value; //得到地区
                var ls = new BMap.LocalSearch(map);
                ls.setSearchCompleteCallback(function (rs) {
                    if (ls.getStatus() == BMAP_STATUS_SUCCESS) {
                        var poi = rs.getPoi(0);
                        if (poi) {
                            createMap(poi.point.lng, poi.point.lat);//创建地图(经度poi.point.lng,纬度poi.point.lat)
                            //setMapEvent();//设置地图事件
                            //addMapControl();//向地图添加控件
                        }
                    }
                });
                ls.search(area);
            }

            //创建地图函数：
            function createMap(x, y) {
                //var map = new BMap.Map("container");//在百度地图容器中创建一个地图
                var point = new BMap.Point(x, y);//定义一个中心点坐标
                map.centerAndZoom(point, 18);//设定地图的中心点和坐标并将地图显示在地图容器中
                window.map = map;//将map变量存储在全局
            }
        </script>

    </form>
</body>
</html>
