﻿<%@ WebHandler Language="C#" Class="imagemore" %>

using System;
using System.Web;
using D.BLL;
using D.Model;
using D.Common;
using System.IO;

public class imagemore : IHttpHandler
{
    private B_Site bllSite = new B_Site();
    private M_Site modelSite = new M_Site();
    private B_UpLoadPic bllUploadPic = new B_UpLoadPic();
    private B_Common bllCommon = new B_Common();

    public void ProcessRequest(HttpContext context)
    {
        modelSite = bllSite.GetModel();
        string[] path = context.Request.QueryString["path"].Split('|');

        //上传文件路径
        string filepath = path[0];
        //上传文件大小
        int filesize = int.Parse(path[1]);

        //context.Response.ContentType = "text/plain";
        //context.Response.Write("Hello World");
        //接收上传文件
        HttpPostedFile MyFile = context.Request.Files[0];
        string[] Mystr = MyFile.FileName.Split('.');


        //获取扩展名
        string extension = Path.GetExtension(MyFile.FileName).ToString();
        string ymd = DateTime.Now.ToString("yyyyMM") + "/" + DateTime.Now.ToString("dd");
        string folder = Param.ApplicationRootPath + "/" + modelSite.UploadFolder + "/" + filepath + "/" + ymd + "/";

        string MdoelPath = context.Server.MapPath(folder);
        if (!System.IO.Directory.Exists(MdoelPath))//如果不存在就创建file文件夹
        {
            System.IO.Directory.CreateDirectory(MdoelPath);
        }

        string FileName = string.Empty;
        if (modelSite.UploadAutoName)
        {
            FileName = Function.GetFileName();
        }
        else
        {
            FileName = Path.GetFileNameWithoutExtension(MyFile.FileName).Replace(".", "_").Replace(";", "_");
            FileName = bllUploadPic.GetFileName(MdoelPath, FileName, extension, 0);
        }

        //判断文件夹目录，防止Webshell
        if (filepath.ToLower().IndexOf("asp") != -1 || filepath.ToLower().IndexOf("php") != -1 || filepath.ToLower().IndexOf("aspx") != -1 || filepath.ToLower().IndexOf("jsp") != -1)
        {
            bllCommon.CreateLog("" + Function.GetIp() + "----" + filepath.Split('|')[0] + "----ckeditor----" + DateTime.Now.ToString() + "", "uploadpic");
            context.Response.Write("{\"result\":\"400\",\"msg\":\"非法操作！\"}");
            return;
        }

        //检测上传文件的MIME类型 
        string sFileMIME = MyFile.ContentType;
        //判断文件的实际类型
        string fileExt = "," + Function.GetContentType(extension) + ",";
        if (fileExt.ToLower().IndexOf("," + sFileMIME.ToLower() + ",") == -1)
        {
            bllCommon.CreateLog("文件格式错误：" + extension + "----" + Function.GetIp() + "----" + sFileMIME.ToLower() + "----" + DateTime.Now.ToString() + "", "imagemore");
            context.Response.Write("{\"result\":\"400\",\"msg\":\"上传文件格式不正确！\"}");
            return;
        }

        //获得上传图片的类型
        bool SiteInfo = false;
        string ImgUploadType = modelSite.UpLoadPic;
        string[] MyImgUploadType = ImgUploadType.Split(new Char[] { '|' });
        for (int i = 0; i < MyImgUploadType.Length; i++)
        {
            if (MyImgUploadType[i].ToLower() == extension.ToLower())
            {
                SiteInfo = true;
                break;
            }
        }

        //判断上传文件类型是否满足管理设置需求
        if (!SiteInfo)
        {
            context.Response.Write("{\"result\":\"400\",\"msg\":\"图片类型错误！\"}");
            return;
        }

        //图片大小判断
        if (filesize != 0)
        {
            if (MyFile.ContentLength > filesize * 1024)
            {
                context.Response.Write("{\"result\":\"400\",\"msg\":\"上传图片大小超出了限制！\"}");
                return;
            }
        }

        MyFile.SaveAs(MdoelPath + FileName + extension);

        //增加水印
        switch (extension.ToLower())
        {
            case ".gif":
            case ".jpg":
            case ".bmp":
            case ".png":
                bllUploadPic.EditorWaterMark(filepath, ymd + "/" + FileName + extension);
                break;
            default:
                break;
        }

        context.Response.Write("{\"result\":\"200\",\"imgurl\":\"" + folder + FileName + extension + "\"}");
    }

    public bool IsReusable
    {
        get
        {
            return false;
        }
    }

}