﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using D.Model;
using D.BLL;
using D.Common;
using System.Text;
using System.Text.RegularExpressions;
using System.Data;
using System.Web.Configuration;
using System.IO;
using D.Conn;

public partial class user_reg : System.Web.UI.Page
{
    private B_User bllUser = new B_User();
    private M_User modelUser = new M_User();
    private B_SiteUser bllSiteUser = new B_SiteUser();
    private M_SiteUser modelSiteUser = new M_SiteUser();
    private int ModelId = 0;
    /// <summary>
    /// 用户组ID
    /// </summary>
    private int UserGroupId = 0;
    /// <summary>
    /// 推广的用户ID
    /// </summary>
    private int UserId = 0;
    /// <summary>
    /// 新注册的用户ID
    /// </summary>
    private int _UserId = 0;
    private B_Site bllSite = new B_Site();
    private M_Site modelSite = new M_Site();
    private B_UserModel bllUserModel = new B_UserModel();
    private M_UserModel modelUserModel = new M_UserModel();
    private B_UserGroup bllUserGroup = new B_UserGroup();
    private M_UserGroup modelUserGroup = new M_UserGroup();
    private B_Mail bllMail = new B_Mail();
    private B_Model bllModel = new B_Model();
    private B_UserLog bllUserLog = new B_UserLog();
    private B_UserFriend bllUserFriend = new B_UserFriend();
    private B_UserAccount bllUserAccount = new B_UserAccount();
    private B_Field bllField = new B_Field();
    private B_FilterWord bllFilterWord = new B_FilterWord();
    private B_InsideLink bllInsideLink = new B_InsideLink();
    private B_Column bllColumn = new B_Column();
    private M_Column modelColumn = new M_Column();
    private M_Dictionary modelDictionary = new M_Dictionary();
    private B_Dictionary bllDictionary = new B_Dictionary();
    private B_Regex bllRegex = new B_Regex();
    private M_Regex modelRegex = new M_Regex();
    private B_Bbs bllBbs = new B_Bbs();
    private B_UpLoadPic bllUploadPic = new B_UpLoadPic();
    /// <summary>
    /// 站点物理路径
    /// 后面带有"\"
    /// </summary>
    private string BaseDirectory = System.AppDomain.CurrentDomain.BaseDirectory;
    /// <summary>
    /// 平台分隔字符
    /// "\"
    /// </summary>
    private string SeparatorChar = Path.DirectorySeparatorChar.ToString();

    protected void Page_Load(object sender, EventArgs e)
    {
        AjaxPro.Utility.RegisterTypeForAjax(typeof(B_Common));
        modelSite = bllSite.GetModel();
        modelSiteUser = bllSiteUser.GetModel();
        #region
        if (modelSiteUser == null)
        {
            Function.UserMsg(0, "<li>用户参数文件错误</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
        }
        if (!modelSiteUser.IsReg)
        {
            Function.UserMsg(0, "<li>对不起,本站暂时关闭了新用户注册</li><li><a href='" + Param.ApplicationRootPath + "/'>返回首页</a> <a href='javascript:window.history.back()'>返回上一步</a></li>");
        }
        #endregion

        #region
        if (!string.IsNullOrEmpty(Request.QueryString["ModelId"]))
        {
            try
            {
                ModelId = int.Parse(Request.QueryString["ModelId"]);
            }
            catch
            {
                ModelId = int.Parse(Request.QueryString["ModelId"].Split(',')[0]);
            }
        }

        if (ModelId == 0)
        {
            Function.UserMsg(0, "<li>模型参数有错</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
        }

        modelUserModel = bllUserModel.GetModel(ModelId);
        if (modelUserModel == null)
        {
            Function.UserMsg(0, "<li>该注册模型不存在或已被删除</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
        }

        //判断该注册模型是否允许注册
        //2011-1-10增加注册模型可以单独控制是否允许注册
        if (!modelUserModel.IsReg)
        {
            Function.UserMsg(0, "<li>该注册模型不允许用户注册</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
        }

        if (modelUserModel.UserGroupId == 0)
        {
            Function.UserMsg(0, "<li>该注册模型还未指定用户组</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
        }

        modelUserGroup = bllUserGroup.GetModel(modelUserModel.UserGroupId);
        if (modelUserGroup == null)
        {
            Function.UserMsg(0, "<li>该注册模型指定用户组不存在</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
        }

        if (!string.IsNullOrEmpty(Request.QueryString["UserGroupId"]))
        {
            try
            {
                UserGroupId = int.Parse(Request.QueryString["UserGroupId"]);
            }
            catch { }
        }

        if (UserGroupId != 0)
        {
            M_UserGroup _modelUserGroup = new M_UserGroup();
            _modelUserGroup = bllUserGroup.GetModel(UserGroupId);
            if (_modelUserGroup == null)
            {
                Function.UserMsg(0, "<li>指定用户组不存在</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
            }
        }

        if (!string.IsNullOrEmpty(Request.QueryString["UserId"]))
        {
            try
            {
                UserId = int.Parse(Request.QueryString["UserId"]);
            }
            catch { }
        }
        #endregion

        if (!Page.IsPostBack)
        {
            if (Function.IsMobile())
            {
                Response.Redirect("m/reg.aspx?ModelId=" + ModelId + "&UserGroupId=" + UserGroupId + "");
                Response.End();
            }

            Page.Title = modelSite.SiteName;

            LitUserLength.Text = modelSiteUser.UserNameStartLength + "～" + modelSiteUser.UserNameEndLength;
            #region
            string[] question = modelSiteUser.Question.Split(',');
            for (int i = 0; i < question.Length; i++)
            {
                DropQuestion.Items.Add(new ListItem(question[i], question[i]));
            }
            DropQuestion.Items.Add(new ListItem("我的自定义问题", "-1"));

            if (!modelUserModel.IsValidate)
            {
                IsVer.Visible = false;
            }

            //服务条款
            CheckAgree.Text = "";
            LitAgree.Text = "<a href=\"Agreement.aspx\" target=\"_blank\">我已看过并同意《" + modelSite.SiteName + "服务条款》</a>";
            #endregion

            //没有开启统一注册，则密码加密传输
            #region 没有开启统一注册，则密码加密传输
            if (!modelSite.IsBbsLogin)
            {
                StringBuilder sb = new StringBuilder();
                sb.AppendLine("<script type=\"text/javascript\">");
                sb.AppendLine("$(function () {");
                sb.AppendLine("$(\"#RegImgageButton\").click(function () {");
                sb.AppendLine("$(\"#txtPassWord\").val($.md5($('#txtPassWord').val()));");
                sb.AppendLine("$(\"#txtPassWord2\").val($.md5($('#txtPassWord2').val()));");
                sb.AppendLine("});");
                sb.AppendLine("})");
                sb.AppendLine("</script>");

                LitMd5Pwd.Text = sb.ToString();
            }
            #endregion

            if (modelSiteUser.IsExpandInfo)
            {
                RegExpand();
            }
        }
    }

    private void RegExpand()
    {
        StringBuilder sb = new StringBuilder();
        B_FieldStyle bllFieldStyle = new B_FieldStyle();
        sb.AppendLine(bllUserModel.GetExpandHtml(modelUserModel.ModelId));
        LitExpand.Text = sb.ToString();
    }

    protected void RegImgageButton_Click(object sender, ImageClickEventArgs e)
    {
        Exists();

        string _username = Function.Encode(Function.Filter(txtUserName.Text.Trim()));
        modelUser.UserName = _username;
        string password = txtPassWord.Text.Trim();
        if (modelSite.IsBbsLogin)
        {
            modelUser.PassWord = Function.Encrypt(password, 1);
        }
        else
        {
            modelUser.PassWord = password;
        }

        if (DropQuestion.SelectedValue == "-1")
        {
            modelUser.Question = Function.Encode(Function.Filter(txtmyQuestion.Text.Trim()));
        }
        else
        {
            modelUser.Question = DropQuestion.SelectedValue;

        }

        modelUser.Answer = Function.Encrypt(txtAnswer.Text.Trim(), 1);
        modelUser.NickName = Function.Encode(Function.Filter(txtNickName.Text.Trim()));
        modelUser.Email = Function.Encode(txtEmail.Text.Trim());
        modelUser.IsEmail = 0;
        modelUser.Mobile = string.Empty;
        modelUser.IsMobile = 0;
        modelUser.ParentId = UserId;

        //用户组控制(注册增加积分、点券、有效期)
        int _Integral = int.Parse(bllUserGroup.GroupPower("RegIntegral", 0, modelUserGroup.GroupPower));
        modelUser.Integral = _Integral;

        decimal _Point = decimal.Parse(bllUserGroup.GroupPower("RegPoint", 0, modelUserGroup.GroupPower));
        modelUser.Point = _Point;

        int _Expire = int.Parse(bllUserGroup.GroupPower("RegExpire", 0, modelUserGroup.GroupPower));
        modelUser.Expire = DateTime.Now.AddDays(_Expire);
        modelUser.Money = 0;
        //
        switch (modelSiteUser.RegLogin)
        {
            case 1:
                modelUser.LoginNum = 1;
                break;
            case 2:
                modelUser.LoginNum = 0;
                break;
        }
        modelUser.IsLock = false;   //
        modelUser.LastLoginIP = Function.GetIp();
        modelUser.LastLoginTime = DateTime.Now;
        modelUser.RegTime = DateTime.Now;
        modelUser.ErrorNum = 0;
        modelUser.ErrorTime = DateTime.Now;
        string guid = Guid.NewGuid().ToString();
        modelUser.RegConfirm = guid;
        int Status = int.Parse(bllUserGroup.GroupPower("Status", 0, modelUserGroup.GroupPower));
        modelUser.Status = Status;        //用户组控制
        modelUser.OpenLogin = string.Empty;
        modelUser.LoginType = 0;
        modelUser.Session = string.Empty;

        if (UserGroupId != 0)
        {
            modelUser.UserGroupId = UserGroupId;
        }
        else
        {
            modelUser.UserGroupId = modelUserModel.UserGroupId;
        }
        modelUser.ModelId = ModelId;
        modelUser.UserFace = "1.gif";
        //注册新用户
        _UserId = bllUser.Add(modelUser);

        //往相应注册模型中写入数据
        bllModel.AddInfoModel(modelUserModel.TableName, getUserModelTable(_UserId));

        //增加默认用户组
        bllUserFriend.AddFriendGroup(_UserId);

        //记录用户注册积分账户
        bllUserAccount.AddLoginAccount(_UserId, _username, _Integral, _Integral, _Point, _Point, 0, 0, _Expire, "注册赠送", "Reg", DateTime.Now);

        try
        {
            int _bbs_userid = bllBbs.Register(_username, txtPassWord.Text.Trim(), txtEmail.Text.Trim(), false);
        }
        catch { }


        //注册成功判断是否为有效邀请
        if (UserId != 0)
        {
            try
            {
                M_User _modelUser = new M_User();
                M_UserGroup _modelUserGroup = new M_UserGroup();
                _modelUser = bllUser.GetModel(UserId);
                _modelUserGroup = bllUserGroup.GetModel(_modelUser.UserGroupId);
                int Invite = int.Parse(bllUserGroup.GroupPower("Invite", 0, _modelUserGroup.GroupPower));
                int Point = int.Parse(bllUserGroup.GroupPower("Point", 0, _modelUserGroup.GroupPower));

                bllUser.AddIntegral(Invite, Point, UserId);
                bllUserAccount.AddLoginAccount(UserId, _modelUser.UserName, Invite, _modelUser.Integral + Invite, Point, _modelUser.Point + Point, 0, _modelUser.Money, 0, "推广奖励", "Invite", DateTime.Now);
            }
            catch { }
        }

        //下面使用邮箱验证注册
        //当用户组设置为认证时，则发送认证邮件
        if (Status == 0)
        {
            if (modelSiteUser.IsEmailVer)
            {
                #region
                try
                {
                    string url = modelSite.Domain + "/user/RegConfirm.aspx?UserId=" + _UserId + "&UserName=" + Function.Encrypt(txtUserName.Text.Trim(), 1) + "&RegConfirm=" + Function.Encrypt(guid, 1) + "";
                    string Body = modelSiteUser.EmailVerContent;
                    Body = Regex.Replace(Body, @"{UserName}", txtUserName.Text.Trim(), RegexOptions.IgnoreCase);
                    Body = Regex.Replace(Body, @"{SiteName}", modelSite.SiteName, RegexOptions.IgnoreCase);
                    Body = Regex.Replace(Body, @"{Domain}", modelSite.Domain, RegexOptions.IgnoreCase);
                    Body = Regex.Replace(Body, @"{Logo}", modelSite.Domain + modelSite.LogoURL, RegexOptions.IgnoreCase);
                    Body = Regex.Replace(Body, @"{Url}", url, RegexOptions.IgnoreCase);
                    bllMail.Body = Body;
                    bllMail.Subject = "您在" + modelSite.SiteName + "注册的邮件确认信";
                    bllMail.ToMail = txtEmail.Text.Trim();
                    bllMail.Send();

                    Function.UserMsg(1, "<li>成功注册：" + txtUserName.Text.Trim() + "</li><li>我们给您发送了激活邮件：" + txtEmail.Text.Trim() + "</li><li>点击激活邮件中的链接,即可激活您的帐号</li><li><a href='main.aspx'>登录用户中心</a></li><li><a href='" + Param.ApplicationRootPath + "/'>返回网站首页</a></li>", false);
                }
                catch
                {
                    Function.UserMsg(1, "<li>成功注册：" + txtUserName.Text.Trim() + "</li><li>邮件发送失败，请联系" + modelSite.SiteName + "客服中心</li><li><a href='main.aspx'>登录用户中心</a></li><li><a href='" + Param.ApplicationRootPath + "/'>返回网站首页</a></li>");
                }
                #endregion
            }
            else
            {
                Function.UserMsg(1, "<li>成功注册：" + txtUserName.Text.Trim() + "</li><li>系统关闭了发送邮件认证功能。</li><li>请联系管理员开通认证。</li><li><a href='" + Param.ApplicationRootPath + "/'>返回网站首页</a></li>");
            }
        }
        else
        {
            try
            {
                switch (modelSiteUser.RegLogin)
                {
                    case 1:     //开启登录状态
                        //设置登录信息
                        if (Status == 1)
                        {
                            if (modelSite.IsBbsLogin)
                            {
                                //统一论坛注册，传入明文
                                bllUser.SetLoginStatusToMingWen(_UserId, _username, txtNickName.Text.Trim(), txtPassWord.Text.Trim(), txtEmail.Text.Trim(), "no");
                            }
                            else
                            {
                                bllUser.SetLoginStatus(_UserId, _username, txtNickName.Text.Trim(), txtPassWord.Text.Trim(), txtEmail.Text.Trim(), "no");
                            }
                        }
                        break;
                }

                Function.UserMsgToURL(1, "<li>成功注册：" + txtUserName.Text.Trim() + "</li><li>请选择您需要的操作：</li><li><a href='Main.aspx'>登录用户中心</a></li><li><a href='" + Param.ApplicationRootPath + "/'>返回网站首页</a></li>", false);
            }
            catch (Exception _e)
            {
                Function.UserMsg(0, "<li>" + _e.Message + "</li><li><a href='Main.aspx'>登录用户中心</a></li><li><a href='" + Param.ApplicationRootPath + "/'>返回网站首页</a></li>");
            }
        }
    }

    private void Exists()
    {
        if (modelUserModel.IsValidate)
        {
            if (Session["CheckCode"] == null)
            {
                Function.UserMsg(0, "<li>验证码失效</li><li><a href='javascript:history.back()'>返回上一页</a></li>");
            }
            //验证码错误
            if (Session["CheckCode"].ToString() != Function.Encrypt(txtVerCode.Text.Trim().ToLower(), 0))
            {
                Function.UserMsg(0, "<li>验证码错误</li><li><a href='javascript:history.back()'>返回上一页</a></li>");
            }
        }

        if (txtUserName.Text.Trim().Length == 0)
        {
            Function.UserMsg(0, "<li>请输入用户名</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
        }

        if (Encoding.Default.GetByteCount(txtUserName.Text.Trim()) < modelSiteUser.UserNameStartLength || Encoding.Default.GetByteCount(txtUserName.Text.Trim()) > modelSiteUser.UserNameEndLength)
        {
            Function.UserMsg(0, "<li>用户名长度为" + modelSiteUser.UserNameStartLength + "～" + modelSiteUser.UserNameEndLength + "个字符</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
        }

        if (!Function.CheckUserName(txtUserName.Text.Trim()))
        {
            Function.UserMsg(0, "<li>用户名只含有汉字、数字、字母、下划线，不能以下划线开头和结尾</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
        }

        string _username = "|" + modelSiteUser.UserNameDisabled + "|";
        if (_username.IndexOf("|" + txtUserName.Text.Trim() + "|") != -1)
        {
            Function.UserMsg(0, "<li>该用户名被禁止注册</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
        }

        if (bllUser.Exists(txtUserName.Text.Trim()))
        {
            Function.UserMsg(0, "<li>很遗憾，该帐号已经被注册</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
        }

        if (txtPassWord.Text.Trim().Length == 0)
        {
            Function.UserMsg(0, "<li>请填写密码</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
        }

        if (txtPassWord2.Text.Trim().Length == 0)
        {
            Function.UserMsg(0, "<li>请填写确认密码</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
        }

        if (txtPassWord.Text.Trim() != txtPassWord2.Text.Trim())
        {
            Function.UserMsg(0, "<li>两次输入的密码不一样</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
        }

        if (modelSite.IsBbsLogin)
        {
            if (Encoding.Default.GetByteCount(txtPassWord.Text.Trim()) < 6 || Encoding.Default.GetByteCount(txtPassWord.Text.Trim()) > 30)
            {
                Function.UserMsg(0, "<li>密码长度6～30位，字母区分大小写</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
            }
        }

        if (DropQuestion.SelectedValue == "0")
        {
            Function.UserMsg(0, "<li>请选择提示问题</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
        }

        if (DropQuestion.SelectedValue == "-1")
        {
            if (txtmyQuestion.Text.Trim().Length == 0)
            {
                Function.UserMsg(0, "<li>请输入自定义提示问题</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
            }
        }

        if (txtAnswer.Text.Trim().Length == 0)
        {
            Function.UserMsg(0, "<li>请输入示答案</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
        }

        if (Encoding.Default.GetByteCount(txtAnswer.Text.Trim()) < 6 || Encoding.Default.GetByteCount(txtAnswer.Text.Trim()) > 30)
        {
            Function.UserMsg(0, "<li>提示答案长度6～30位，字母区分大小写</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
        }

        if (txtNickName.Text.Trim().Length == 0)
        {
            Function.UserMsg(0, "<li>请输入用户昵称</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
        }

        string _nickname = "|" + modelSiteUser.UserNameDisabled + "|";
        if (_nickname.IndexOf("|" + txtNickName.Text.Trim() + "|") != -1)
        {
            Function.UserMsg(0, "<li>该昵称被禁止注册</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
        }

        if (txtEmail.Text.Trim().Length == 0)
        {
            Function.UserMsg(0, "<li>请输入电子邮件地址</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
        }
        if (!Function.CheckEmail(txtEmail.Text.Trim()))
        {
            Function.UserMsg(0, "<li>电子邮件格式不正确</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
        }

        if (modelSiteUser.IsEmailOne)
        {
            if (bllUser.ExistsEmail(txtEmail.Text.Trim()))
            {
                Function.UserMsg(0, "<li>该电子邮件已被使用,请另外输入</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
            }
        }

        if (!CheckAgree.Checked)
        {
            Function.UserMsg(0, "<li>没有接受服务条款不能注册</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
        }

        if (modelSiteUser.IsExpandInfo)
        {
            B_InsertWeb bllInsertWeb = new B_InsertWeb();
            DataTable dtField = new DataTable();
            dtField = bllInsertWeb.WebUseField(modelUserModel.ExpandHtml, modelUserModel.TableName);
            for (int i = 0; i < dtField.Rows.Count; i++)
            {
                //不能够为空验证
                if (dtField.Rows[i]["IsNotNull"].ToString().ToLower() == "true")
                {
                    if (Request.Form["" + B_FieldStyle.Prefix + dtField.Rows[i]["Name"].ToString()] == "" || Request.Form["" + B_FieldStyle.Prefix + dtField.Rows[i]["Name"].ToString()] == null)
                    {
                        Function.UserMsg(0, "<li>" + dtField.Rows[i]["Alias"].ToString() + "不能够为空</li><li><a href='javascript:window.history.back()'>返回上一步</a></li>");
                    }
                }

                //正则验证
                if (dtField.Rows[i]["RegexId"].ToString() != "0")   //使用了正则验证
                {
                    modelRegex = bllRegex.GetModel(int.Parse(dtField.Rows[i]["RegexId"].ToString()));
                    if (!Regex.IsMatch(Request.Form["" + B_FieldStyle.Prefix + dtField.Rows[i]["Name"].ToString()], @"" + modelRegex.Value + ""))
                    {
                        Function.UserMsg(0, "<li>" + dtField.Rows[i]["Alias"].ToString() + "输入错误</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
                    }
                }
            }
        }
    }

    private DataTable getUserModelTable(int __UserId)
    {
        DataTable dt = new DataTable();
        dt.Columns.Add(new DataColumn("FieldName", typeof(string)));
        dt.Columns.Add(new DataColumn("FieldValue", typeof(string)));
        dt.Columns.Add(new DataColumn("FieldData", typeof(string)));
        DataRow drUser = null;

        drUser = dt.NewRow();
        drUser[0] = "UserId";
        drUser[1] = __UserId;
        drUser[2] = "Integer";
        dt.Rows.Add(drUser);


        if (modelSiteUser.IsExpandInfo)
        {
            B_InsertWeb bllInsertWeb = new B_InsertWeb();
            DataTable dtField = new DataTable();
            dtField = bllInsertWeb.WebUseField(modelUserModel.ExpandHtml, modelUserModel.TableName);
            if (dtField.Rows.Count > 0)
            {
                string FieldName = string.Empty;
                string FieldContent = string.Empty;

                for (int i = 0; i < dtField.Rows.Count; i++)
                {
                    FieldName = dtField.Rows[i]["Name"].ToString();
                    FieldContent = dtField.Rows[i]["Content"].ToString();
                    bool IsFilterWord = bool.Parse(dtField.Rows[i]["IsFilterWord"].ToString());
                    bool IsInsideLink = bool.Parse(dtField.Rows[i]["IsInsideLink"].ToString());

                    string FieldValue = string.Empty;
                    switch (dtField.Rows[i]["FieldData"].ToString().ToLower())
                    {
                        case "text":
                            #region
                            if (!string.IsNullOrEmpty(Request.Form["" + B_FieldStyle.Prefix + FieldName + ""]))
                            {
                                try
                                {
                                    FieldValue = Function.Encode(GetContent(Request.Form["" + B_FieldStyle.Prefix + FieldName + ""], IsFilterWord, IsInsideLink));
                                }
                                catch { }
                            }


                            drUser = dt.NewRow();
                            drUser[0] = "" + FieldName + "";
                            drUser[1] = FieldValue;
                            drUser[2] = "VarChar";
                            dt.Rows.Add(drUser);
                            #endregion
                            break;
                        case "multiple":
                            #region
                            if (FieldContent.Split(',')[0].Split('=')[1] == "0")
                            {
                                if (!string.IsNullOrEmpty(Request.Form["" + B_FieldStyle.Prefix + FieldName + ""]))
                                {
                                    try
                                    {
                                        FieldValue = GetContent(Request.Form["" + B_FieldStyle.Prefix + FieldName + ""], IsFilterWord, IsInsideLink);
                                    }
                                    catch { }
                                }
                            }
                            else
                            {
                                if (!string.IsNullOrEmpty(Request.Form["" + B_FieldStyle.Prefix + FieldName + ""]))
                                {
                                    try
                                    {
                                        FieldValue = GetContent(Request.Form["" + B_FieldStyle.Prefix + FieldName + ""].Replace(@"<div style=""page-break-after: always""><span style=""display: none"">&nbsp;</span></div>", "{D:PAGE}"), IsFilterWord, IsInsideLink);
                                    }
                                    catch { }
                                }
                            }

                            drUser = dt.NewRow();
                            drUser[0] = "" + FieldName + "";
                            drUser[1] = FieldValue;
                            drUser[2] = "LongVarChar";
                            dt.Rows.Add(drUser);
                            #endregion
                            break;
                        case "radio":
                            #region
                            if (FieldContent.Split(',')[2].Split('=')[1] == "3")
                            {
                                #region
                                drUser = dt.NewRow();
                                drUser[0] = "" + FieldName + "_Id";
                                if (!string.IsNullOrEmpty(Request.Form["" + B_FieldStyle.Prefix + FieldName + "_Id"]))
                                {
                                    drUser[1] = Request.Form["" + B_FieldStyle.Prefix + FieldName + "_Id"];
                                }
                                else
                                {
                                    drUser[1] = "0";
                                }
                                drUser[2] = "Integer";
                                dt.Rows.Add(drUser);

                                drUser = dt.NewRow();
                                drUser[0] = "" + FieldName + "";
                                drUser[1] = Request.Form["" + B_FieldStyle.Prefix + FieldName + ""];
                                drUser[2] = "VarChar";
                                dt.Rows.Add(drUser);
                                #endregion
                            }
                            else
                            {
                                #region
                                if (!string.IsNullOrEmpty(Request.Form["" + B_FieldStyle.Prefix + FieldName + ""]))
                                {
                                    try
                                    {
                                        #region
                                        FieldValue = Request.Form["" + B_FieldStyle.Prefix + FieldName + ""];
                                        drUser = dt.NewRow();
                                        drUser[0] = "" + FieldName + "_Id";
                                        drUser[1] = FieldValue.Split('☂')[0];

                                        if (dtField.Rows[i]["Content"].ToString().Split(',')[5].Split('=')[1] == "1")
                                        {
                                            drUser[2] = "Integer";
                                        }
                                        else
                                        {
                                            drUser[2] = "VarChar";
                                        }
                                        dt.Rows.Add(drUser);

                                        drUser = dt.NewRow();
                                        drUser[0] = "" + FieldName + "";
                                        drUser[1] = FieldValue.Split('☂')[1];
                                        drUser[2] = "VarChar";
                                        dt.Rows.Add(drUser);

                                        #endregion
                                    }
                                    catch
                                    {
                                    }
                                }
                                else
                                {
                                    #region
                                    drUser = dt.NewRow();
                                    drUser[0] = "" + FieldName + "_Id";
                                    drUser[1] = "0";
                                    drUser[2] = "Integer";
                                    dt.Rows.Add(drUser);

                                    drUser = dt.NewRow();
                                    drUser[0] = "" + FieldName + "";
                                    drUser[1] = FieldContent.Split(',')[1].Split('=')[1];
                                    drUser[2] = "VarChar";
                                    dt.Rows.Add(drUser);
                                    #endregion
                                }
                                #endregion
                            }
                            #endregion
                            break;
                        case "listbox":
                            #region
                            //弹出窗口
                            if (FieldContent.Split(',')[1].Split('=')[1] == "3")
                            {
                                #region
                                drUser = dt.NewRow();
                                drUser[0] = "" + FieldName + "_Id";
                                drUser[1] = Request.Form["" + B_FieldStyle.Prefix + FieldName + "_Id"];
                                drUser[2] = "LongVarChar";
                                dt.Rows.Add(drUser);

                                drUser = dt.NewRow();
                                drUser[0] = "" + FieldName + "";
                                drUser[1] = Request.Form["" + B_FieldStyle.Prefix + FieldName + ""];
                                drUser[2] = "LongVarChar";
                                dt.Rows.Add(drUser);
                                #endregion
                            }
                            else
                            {
                                if (!string.IsNullOrEmpty(Request.Form["" + B_FieldStyle.Prefix + FieldName + ""]))
                                {
                                    try
                                    {
                                        FieldValue = Request.Form["" + B_FieldStyle.Prefix + FieldName + ""];
                                    }
                                    catch { }
                                }
                                string listboxText = string.Empty;
                                string listboxValue = "|";
                                if (FieldValue.Length > 0)
                                {
                                    string[] _listboxValue = FieldValue.Split(',');
                                    for (int p = 0; p < _listboxValue.Length; p++)
                                    {
                                        listboxValue += _listboxValue[p].Split('☂')[0] + "|";
                                        listboxText += _listboxValue[p].Split('☂')[1] + ",";
                                    }

                                    if (listboxText.EndsWith(","))
                                    {
                                        listboxText = listboxText.Substring(0, listboxText.Length - 1);
                                    }
                                }
                                drUser = dt.NewRow();
                                drUser[0] = "" + FieldName + "_Id";
                                drUser[1] = listboxValue;
                                drUser[2] = "LongVarChar";
                                dt.Rows.Add(drUser);

                                drUser = dt.NewRow();
                                drUser[0] = "" + FieldName + "";
                                drUser[1] = listboxText;
                                drUser[2] = "LongVarChar";
                                dt.Rows.Add(drUser);
                            }
                            #endregion
                            break;
                        case "date":
                            #region
                            if (!string.IsNullOrEmpty(Request.Form["" + B_FieldStyle.Prefix + FieldName + ""]))
                            {
                                try
                                {
                                    FieldValue = Function.Encode(Request.Form["" + B_FieldStyle.Prefix + FieldName + ""]);
                                }
                                catch { }
                            }
                            else
                            {
                                //如果没有使用，则读取默认值
                                FieldValue = DateTime.Now.ToString();
                            }

                            drUser = dt.NewRow();
                            drUser[0] = "" + FieldName + "";
                            drUser[1] = FieldValue;
                            if (FieldContent.Split(',')[0].Split('=')[1] == "char")
                            {
                                drUser[2] = "VarChar";
                            }
                            else
                            {
                                drUser[2] = "Date";
                            }
                            dt.Rows.Add(drUser);
                            #endregion
                            break;
                        case "color":
                            #region
                            if (!string.IsNullOrEmpty(Request.Form["" + B_FieldStyle.Prefix + FieldName + ""]))
                            {
                                try
                                {
                                    FieldValue = Function.Encode(Request.Form["" + B_FieldStyle.Prefix + FieldName + ""]);
                                }
                                catch { }
                            }
                            else
                            {
                                //如果没有使用，则读取默认值
                                FieldValue = FieldContent.Split(',')[0].Split('=')[1];
                            }

                            drUser = dt.NewRow();
                            drUser[0] = "" + FieldName + "";
                            drUser[1] = FieldValue;
                            drUser[2] = "VarChar";
                            dt.Rows.Add(drUser);
                            #endregion
                            break;
                        case "radom":
                            #region
                            if (!string.IsNullOrEmpty(Request.Form["" + B_FieldStyle.Prefix + FieldName + ""]))
                            {
                                try
                                {
                                    FieldValue = Function.Encode(Request.Form["" + B_FieldStyle.Prefix + FieldName + ""]);
                                }
                                catch { }
                            }

                            drUser = dt.NewRow();
                            drUser[0] = "" + FieldName + "";
                            drUser[1] = FieldValue;
                            drUser[2] = "VarChar";
                            dt.Rows.Add(drUser);
                            #endregion
                            break;
                        case "pic":
                            #region
                            int picms = 1;
                            try
                            {
                                picms = int.Parse(dtField.Rows[i]["Content"].ToString().Split(',')[6].Split('=')[1]);
                            }
                            catch { }
                            switch (picms)
                            {
                                case 1:
                                    if (!string.IsNullOrEmpty(Request.Form["" + B_FieldStyle.Prefix + FieldName + ""]))
                                    {
                                        try
                                        {
                                            FieldValue = Request.Form["" + B_FieldStyle.Prefix + FieldName + ""];
                                        }
                                        catch { }
                                    }
                                    break;
                                case 2:
                                    if (Request.Files["" + B_FieldStyle.Prefix + FieldName + ""].FileName.Length > 0)
                                    {
                                        FieldValue = bllUploadPic.UploadJianJiePic(Request.Files["" + B_FieldStyle.Prefix + FieldName + ""], int.Parse(dtField.Rows[i]["FieldId"].ToString()), "user|0");
                                    }
                                    break;
                            }

                            drUser = dt.NewRow();
                            drUser[0] = "" + FieldName + "";
                            drUser[1] = FieldValue;
                            drUser[2] = "VarChar";
                            dt.Rows.Add(drUser);
                            #endregion
                            break;
                        case "bit":
                            #region
                            if (!string.IsNullOrEmpty(Request.Form["" + B_FieldStyle.Prefix + FieldName + ""]))
                            {
                                try
                                {
                                    FieldValue = Request.Form["" + B_FieldStyle.Prefix + FieldName + ""];
                                }
                                catch { }
                            }

                            if (FieldValue.ToLower() == "true" || FieldValue.ToLower() == "on")
                            {
                                FieldValue = "True";
                            }
                            else
                            {
                                FieldValue = "False";
                            }

                            drUser = dt.NewRow();
                            drUser[0] = "" + FieldName + "";
                            drUser[1] = FieldValue;
                            drUser[2] = "Boolean";
                            dt.Rows.Add(drUser);
                            #endregion
                            break;
                        case "querystring":
                            #region
                            if (!string.IsNullOrEmpty(Request.Form["" + B_FieldStyle.Prefix + FieldName + ""]))
                            {
                                try
                                {
                                    FieldValue = Function.Encode(GetContent(Request.Form["" + B_FieldStyle.Prefix + FieldName + ""], IsFilterWord, IsInsideLink));
                                }
                                catch { }
                            }

                            if (FieldValue.ToLower() == "null" || FieldValue == "")
                            {
                                if (FieldContent.Split(',')[1].Split('=')[1] == "Integer")
                                {
                                    FieldValue = "0";
                                }
                                else
                                {
                                    FieldValue = string.Empty;
                                }
                            }

                            drUser = dt.NewRow();
                            drUser[0] = "" + FieldName + "";
                            drUser[1] = FieldValue;
                            drUser[2] = FieldContent.Split(',')[1].Split('=')[1];
                            dt.Rows.Add(drUser);
                            #endregion
                            break;
                        case "erlink":
                            #region
                            if (!string.IsNullOrEmpty(Request.Form["" + B_FieldStyle.Prefix + FieldName + ""]))
                            {
                                #region
                                try
                                {
                                    FieldValue = Request.Form["" + B_FieldStyle.Prefix + FieldName + ""];

                                    if (!Function.CheckNumber(FieldValue))
                                    {
                                        FieldValue = "0";
                                    }

                                    //大类
                                    drUser = dt.NewRow();
                                    drUser[0] = "" + FieldName + "_Id";
                                    drUser[1] = FieldValue;
                                    drUser[2] = "Integer";
                                    dt.Rows.Add(drUser);

                                    drUser = dt.NewRow();
                                    drUser[0] = "" + FieldName + "";
                                    if (dtField.Rows[i]["Content"].ToString().Split(',')[3].Split('=')[1] == "1")
                                    {
                                        modelColumn = bllColumn.GetModel(int.Parse(FieldValue));
                                        if (modelColumn == null)
                                        {
                                            drUser[1] = string.Empty;
                                        }
                                        else
                                        {
                                            drUser[1] = modelColumn.CnName;
                                        }
                                    }
                                    else
                                    {
                                        modelDictionary = bllDictionary.GetModel(int.Parse(FieldValue));
                                        if (modelDictionary == null)
                                        {
                                            drUser[1] = string.Empty;
                                        }
                                        else
                                        {
                                            drUser[1] = modelDictionary.Text;
                                        }
                                    }

                                    drUser[2] = "VarChar";
                                    dt.Rows.Add(drUser);

                                    //小类
                                    FieldName = FieldContent.Split(',')[2].Split('=')[1];
                                    FieldValue = Request.Form["" + B_FieldStyle.Prefix + FieldName + ""];

                                    if (!Function.CheckNumber(FieldValue))
                                    {
                                        FieldValue = "0";
                                    }

                                    drUser = dt.NewRow();
                                    drUser[0] = "" + FieldName + "_Id";
                                    drUser[1] = FieldValue;
                                    drUser[2] = "Integer";
                                    dt.Rows.Add(drUser);

                                    modelColumn = bllColumn.GetModel(int.Parse(FieldValue));
                                    drUser = dt.NewRow();
                                    drUser[0] = "" + FieldName + "";
                                    if (dtField.Rows[i]["Content"].ToString().Split(',')[3].Split('=')[1] == "1")
                                    {
                                        modelColumn = bllColumn.GetModel(int.Parse(FieldValue));
                                        if (modelColumn == null)
                                        {
                                            drUser[1] = string.Empty;
                                        }
                                        else
                                        {
                                            drUser[1] = modelColumn.CnName;
                                        }
                                    }
                                    else
                                    {
                                        modelDictionary = bllDictionary.GetModel(int.Parse(FieldValue));
                                        if (modelDictionary == null)
                                        {
                                            drUser[1] = string.Empty;
                                        }
                                        else
                                        {
                                            drUser[1] = modelDictionary.Text;
                                        }
                                    }
                                    drUser[2] = "VarChar";
                                    dt.Rows.Add(drUser);
                                }
                                catch { }
                                #endregion
                            }
                            else
                            {
                                #region
                                //大类
                                drUser = dt.NewRow();
                                drUser[0] = "" + FieldName + "_Id";
                                drUser[1] = "0";
                                drUser[2] = "Integer";
                                dt.Rows.Add(drUser);

                                drUser = dt.NewRow();
                                drUser[0] = "" + FieldName + "";
                                drUser[1] = string.Empty;
                                drUser[2] = "VarChar";
                                dt.Rows.Add(drUser);

                                //小类
                                FieldName = FieldContent.Split(',')[2].Split('=')[1];

                                drUser = dt.NewRow();
                                drUser[0] = "" + FieldName + "_Id";
                                drUser[1] = "0";
                                drUser[2] = "Integer";
                                dt.Rows.Add(drUser);

                                drUser = dt.NewRow();
                                drUser[0] = "" + FieldName + "";
                                drUser[1] = string.Empty;
                                drUser[2] = "VarChar";
                                dt.Rows.Add(drUser);
                                #endregion
                            }
                            #endregion
                            break;
                        case "sanlink":
                            #region
                            if (!string.IsNullOrEmpty(Request.Form["" + B_FieldStyle.Prefix + FieldName + ""]))
                            {
                                #region
                                try
                                {
                                    FieldValue = Request.Form["" + B_FieldStyle.Prefix + FieldName + ""];

                                    if (!Function.CheckNumber(FieldValue))
                                    {
                                        FieldValue = "0";
                                    }

                                    //大类
                                    drUser = dt.NewRow();
                                    drUser[0] = "" + FieldName + "_Id";
                                    drUser[1] = FieldValue;
                                    drUser[2] = "Integer";
                                    dt.Rows.Add(drUser);

                                    drUser = dt.NewRow();
                                    drUser[0] = "" + FieldName + "";
                                    if (dtField.Rows[i]["Content"].ToString().Split(',')[5].Split('=')[1] == "1")
                                    {
                                        modelColumn = bllColumn.GetModel(int.Parse(FieldValue));
                                        if (modelColumn == null)
                                        {
                                            drUser[1] = string.Empty;
                                        }
                                        else
                                        {
                                            drUser[1] = modelColumn.CnName;
                                        }
                                    }
                                    else
                                    {
                                        modelDictionary = bllDictionary.GetModel(int.Parse(FieldValue));
                                        if (modelDictionary == null)
                                        {
                                            drUser[1] = string.Empty;
                                        }
                                        else
                                        {
                                            drUser[1] = modelDictionary.Text;
                                        }
                                    }
                                    drUser[2] = "VarChar";
                                    dt.Rows.Add(drUser);

                                    //中类
                                    FieldName = FieldContent.Split(',')[2].Split('=')[1];
                                    FieldValue = Request.Form["" + B_FieldStyle.Prefix + FieldName + ""];

                                    if (!Function.CheckNumber(FieldValue))
                                    {
                                        FieldValue = "0";
                                    }

                                    drUser = dt.NewRow();
                                    drUser[0] = "" + FieldName + "_Id";
                                    drUser[1] = FieldValue;
                                    drUser[2] = "Integer";
                                    dt.Rows.Add(drUser);

                                    drUser = dt.NewRow();
                                    drUser[0] = "" + FieldName + "";
                                    if (dtField.Rows[i]["Content"].ToString().Split(',')[5].Split('=')[1] == "1")
                                    {
                                        modelColumn = bllColumn.GetModel(int.Parse(FieldValue));
                                        if (modelColumn == null)
                                        {
                                            drUser[1] = string.Empty;
                                        }
                                        else
                                        {
                                            drUser[1] = modelColumn.CnName;
                                        }
                                    }
                                    else
                                    {
                                        modelDictionary = bllDictionary.GetModel(int.Parse(FieldValue));
                                        if (modelDictionary == null)
                                        {
                                            drUser[1] = string.Empty;
                                        }
                                        else
                                        {
                                            drUser[1] = modelDictionary.Text;
                                        }
                                    }
                                    drUser[2] = "VarChar";
                                    dt.Rows.Add(drUser);

                                    //小类
                                    FieldName = FieldContent.Split(',')[4].Split('=')[1];
                                    FieldValue = Request.Form["" + B_FieldStyle.Prefix + FieldName + ""];

                                    if (!Function.CheckNumber(FieldValue))
                                    {
                                        FieldValue = "0";
                                    }

                                    drUser = dt.NewRow();
                                    drUser[0] = "" + FieldName + "_Id";
                                    drUser[1] = FieldValue;
                                    drUser[2] = "Integer";
                                    dt.Rows.Add(drUser);

                                    drUser = dt.NewRow();
                                    drUser[0] = "" + FieldName + "";
                                    if (dtField.Rows[i]["Content"].ToString().Split(',')[3].Split('=')[1] == "1")
                                    {
                                        modelColumn = bllColumn.GetModel(int.Parse(FieldValue));
                                        if (modelColumn == null)
                                        {
                                            drUser[1] = string.Empty;
                                        }
                                        else
                                        {
                                            drUser[1] = modelColumn.CnName;
                                        }
                                    }
                                    else
                                    {
                                        modelDictionary = bllDictionary.GetModel(int.Parse(FieldValue));
                                        if (modelDictionary == null)
                                        {
                                            drUser[1] = string.Empty;
                                        }
                                        else
                                        {
                                            drUser[1] = modelDictionary.Text;
                                        }
                                    }
                                    drUser[2] = "VarChar";
                                    dt.Rows.Add(drUser);
                                }
                                catch { }
                                #endregion
                            }
                            else
                            {
                                #region
                                //大类
                                drUser = dt.NewRow();
                                drUser[0] = "" + FieldName + "_Id";
                                drUser[1] = "0";
                                drUser[2] = "Integer";
                                dt.Rows.Add(drUser);

                                drUser = dt.NewRow();
                                drUser[0] = "" + FieldName + "";
                                drUser[1] = string.Empty;
                                drUser[2] = "VarChar";
                                dt.Rows.Add(drUser);

                                //中类
                                FieldName = FieldContent.Split(',')[2].Split('=')[1];

                                drUser = dt.NewRow();
                                drUser[0] = "" + FieldName + "_Id";
                                drUser[1] = "0";
                                drUser[2] = "Integer";
                                dt.Rows.Add(drUser);

                                drUser = dt.NewRow();
                                drUser[0] = "" + FieldName + "";
                                drUser[1] = string.Empty;
                                drUser[2] = "VarChar";
                                dt.Rows.Add(drUser);

                                //小类
                                FieldName = FieldContent.Split(',')[4].Split('=')[1];

                                drUser = dt.NewRow();
                                drUser[0] = "" + FieldName + "_Id";
                                drUser[1] = "0";
                                drUser[2] = "Integer";
                                dt.Rows.Add(drUser);

                                drUser = dt.NewRow();
                                drUser[0] = "" + FieldName + "";
                                drUser[1] = string.Empty;
                                drUser[2] = "VarChar";
                                dt.Rows.Add(drUser);
                                #endregion
                            }
                            #endregion
                            break;
                        case "file":
                            #region
                            if (!string.IsNullOrEmpty(Request.Form["" + B_FieldStyle.Prefix + FieldName + ""]))
                            {
                                try
                                {
                                    FieldValue = Request.Form["" + B_FieldStyle.Prefix + FieldName + ""];
                                }
                                catch { }
                            }

                            drUser = dt.NewRow();
                            drUser[0] = "" + FieldName + "";
                            drUser[1] = Function.Encode(FieldValue);
                            drUser[2] = "VarChar";
                            dt.Rows.Add(drUser);

                            drUser = dt.NewRow();
                            drUser[0] = "" + FieldName + "_Click";
                            drUser[1] = "0";
                            drUser[2] = "VarChar";
                            dt.Rows.Add(drUser);
                            #endregion
                            break;
                        case "decimal":
                            #region
                            if (!string.IsNullOrEmpty(Request.Form["" + B_FieldStyle.Prefix + FieldName + ""]))
                            {
                                try
                                {
                                    FieldValue = GetContent(Request.Form["" + B_FieldStyle.Prefix + FieldName + ""], IsFilterWord, IsInsideLink);
                                }
                                catch { }
                            }


                            drUser = dt.NewRow();
                            drUser[0] = "" + FieldName + "";
                            drUser[1] = Function.Encode(FieldValue);
                            drUser[2] = "Decimal";
                            dt.Rows.Add(drUser);
                            #endregion
                            break;
                    }
                }
            }
        }

        return dt;
    }

    public string GetContent(string str, bool IsFilterWord, bool IsInsideLink)
    {
        if (IsFilterWord)
        {
            str = bllFilterWord.GetFilterContent(str);
        }

        if (IsInsideLink)
        {
            str = bllInsideLink.GetLinkContent(str);
        }

        return str;
    }
}