﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using D.BLL;
using D.Common;
using D.Model;
using System.Web.Configuration;
using System.Text;

public partial class user_login : System.Web.UI.Page
{
    private B_User bllUser = new B_User();
    private M_User modelUser = new M_User();
    private B_UserLog bllUserLog = new B_UserLog();
    private B_SiteUser bllSiteUser = new B_SiteUser();
    private M_SiteUser modelSiteUser = new M_SiteUser();
    private B_Model bllModel = new B_Model();
    private B_UserAccount bllUserAccount = new B_UserAccount();
    protected string ReturnUrl = string.Empty;
    private B_Site bllSite = new B_Site();
    private M_Site modelSite = new M_Site();

    protected void Page_Load(object sender, EventArgs e)
    {
        modelSiteUser = bllSiteUser.GetModel();
        modelSite = bllSite.GetModel();
        if (!string.IsNullOrEmpty(Request.QueryString["ReturnUrl"]))
        {
            try
            {
                ReturnUrl = Request.QueryString["ReturnUrl"];
            }
            catch { }
        }

        if (!Page.IsPostBack)
        {
            if (Function.IsMobile())
            {
                Response.Redirect("m/login.aspx?ReturnUrl=" + ReturnUrl + "");
                Response.End();
            }
            if (!modelSiteUser.IsLoginVer)
            {
                DivVerCode.Visible = false;
            }

            //没有开启统一注册，则密码加密传输
            #region 没有开启统一注册，则密码加密传输
            if (!modelSite.IsBbsLogin)
            {
                StringBuilder sb = new StringBuilder();
                sb.AppendLine("<script type=\"text/javascript\">");
                sb.AppendLine("$(function () {");
                sb.AppendLine("$(\"#UserLoginButtonImg\").click(function () {");
                sb.AppendLine("$(\"#txtPassWord\").val($.md5($('#txtPassWord').val()));");
                sb.AppendLine("});");
                sb.AppendLine("})");
                sb.AppendLine("</script>");

                LitMd5Pwd.Text = sb.ToString();
            }
            #endregion

            Page.Title = modelSite.SiteName;

            LitFooter.Text = "Copyright &copy; 2009-" + DateTime.Now.ToString("yyyy") + " DianCMS. All rights reserved. 易点内容管理系统网站建设更容易";
        }
    }

    protected void UserLoginButtonImg_Click(object sender, ImageClickEventArgs e)
    {
        Exists();
        Session["CheckCode"] = null;

        string UserName = txtUserName.Text.Trim();
        string PassWord = txtPassWord.Text.Trim();

        int UserId = 0;
        if (modelSite.IsBbsLogin)
        {
            UserId = bllUser.LoginToMingWen(UserName, PassWord);
        }
        else
        {
            UserId = bllUser.Login(UserName, PassWord);
        }

        if (UserId == 0)
        {
            modelUser = bllUser.GetModel(UserName);

            if (modelUser != null)
            {
                if (modelUser.ErrorTime > DateTime.Now)
                {
                    bllUserLog.Add(UserId, UserName, "Login", "登录失败:还在禁止登录时间内", 0);
                    TimeSpan time = modelUser.ErrorTime.Subtract(DateTime.Now);
                    Function.UserMsg(0, "<li>对不起,您已经登录错误 " + modelSiteUser.LoginErrorNum + " 次,将被禁止登录 " + modelSiteUser.EnjoinTime + " 分钟</li><li>请等待" + time.Minutes.ToString() + "分钟后重试</li><li><a href='login.aspx'>重新登录</a>  <a href='" + Param.ApplicationRootPath + "/'>返回首页</a></li>");
                }

                //登录失败，禁止该账户
                if (modelUser.ErrorNum < modelSiteUser.LoginErrorNum - 1)
                {
                    bllUser.ErrorNum(UserName);
                }
                else
                {
                    bllUser.ErrorTime(DateTime.Now.AddMinutes(modelSiteUser.EnjoinTime), modelUser.UserId);
                }

                bllUserLog.Add(UserId, UserName, "Login", "登录失败:用户名:" + UserName + "密码:" + PassWord + "", 0);

                Function.UserMsg(0, "<li>登录失败，请检测用户名和密码</li><li><a href='login.aspx'>重新登录</a>  <a href='" + Param.ApplicationRootPath + "/'>返回首页</a></li>");
            }
            else
            {

                Function.UserMsg(0, "<li>登录失败，请检测用户名和密码</li><li><a href='login.aspx'>重新登录</a>  <a href='" + Param.ApplicationRootPath + "/'>返回首页</a></li>");
            }

            //Function.UserMsg(0, "<li>对不起,登录失败!请检查您的用户名和密码.</li><li><a href='Login.aspx'>重新登录</a>(您还有" + (siteModel.LogErrorNum - model.ErrorNum) + "次机会)</li><li><a href='" + Param.ApplicationRootPath + "/'>返回网站首页</a></li>");
        }
        else//登录验证
        {
            modelUser = bllUser.GetModel(UserId);

            //判断是否在禁止的时间内
            if (modelUser.ErrorTime > DateTime.Now)
            {
                bllUserLog.Add(UserId, UserName, "Login", "登录失败:还在禁止登录时间内", 0);
                TimeSpan time = modelUser.ErrorTime.Subtract(DateTime.Now);
                Function.UserMsg(0, "<li>对不起,您已经登录错误 " + modelSiteUser.LoginErrorNum + " 次,将被禁止登录 " + modelSiteUser.EnjoinTime + " 分钟</li><li>请等待" + time.Minutes.ToString() + "分钟后重试</li><li><a href='login.aspx'>重新登录</a>  <a href='" + Param.ApplicationRootPath + "/'>返回首页</a></li>");
            }

            //判断该用户是否被锁定
            if (modelUser.IsLock)
            {
                bllUserLog.Add(UserId, UserName, "Login", "登录失败:账号被锁定", 0);
                Function.UserMsg(0, "<li>对不起,您的账号已被锁定,不能登录</li><li><a href='login.aspx'>重新登录</a>  <a href='" + Param.ApplicationRootPath + "/'>返回首页</a></li>");
            }

            //判断该用户是否通过认证
            if (modelUser.Status == 0)
            {
                bllUserLog.Add(UserId, UserName, "Login", "登录失败:账号未通过认证", 0);
                if (modelSiteUser.IsEmailVer)
                {
                    Function.UserMsg(0, "<li>对不起,您的账户还未通过认证,不能登录</li><li>本站点开通了邮箱注册认证，请到注册邮箱收取确认信，并点击连接确认</li><li>如果您没有收到邮件，请联系我们的客服</li><li><a href='login.aspx'>重新登录</a>  <a href='" + Param.ApplicationRootPath + "/'>返回网站首页</a></li>");
                }
                else
                {
                    Function.UserMsg(0, "<li>对不起,您的账户还未通过认证,不能登录</li><li>请等待管理员认证</li><li><a href='login.aspx'>重新登录</a>  <a href='" + Param.ApplicationRootPath + "/'>返回网站首页</a></li>");
                }
            }

            //判断当天登录次数
            if (modelSiteUser.DayLoginNum == -1)//不限制次数
            {
                bllUser.AddIntegral(modelSiteUser.LoginAddIntegral, modelSiteUser.LoginAddPoint, UserId);
                bllUserAccount.AddLoginAccount(UserId, UserName, modelSiteUser.LoginAddIntegral, modelSiteUser.LoginAddIntegral + modelUser.Integral, modelSiteUser.LoginAddPoint, modelUser.Point + modelSiteUser.LoginAddPoint, 0, modelUser.Money, 0, "登录成功", "Login", DateTime.Now);
                bllUserLog.Add(UserId, UserName, "Login", "登录成功", modelSiteUser.LoginAddIntegral);
            }
            else
            {
                int loginNum = bllUserAccount.ToDayLoginNum(UserId);
                if (loginNum < modelSiteUser.DayLoginNum)
                {
                    bllUser.AddIntegral(modelSiteUser.LoginAddIntegral, modelSiteUser.LoginAddPoint, UserId);
                    bllUserAccount.AddLoginAccount(UserId, UserName, modelSiteUser.LoginAddIntegral, modelSiteUser.LoginAddIntegral + modelUser.Integral, modelSiteUser.LoginAddPoint, modelSiteUser.LoginAddPoint + modelUser.Point, 0, modelUser.Money, 0, "登录成功", "Login", DateTime.Now);
                    bllUserLog.Add(UserId, UserName, "Login", "登录成功", modelSiteUser.LoginAddIntegral);
                }
                else
                {
                    bllUserLog.Add(UserId, UserName, "Login", "登录成功", 0);
                }
            }
            //论坛登录
            //B_bbs_dz.Login(UserName, PassWord);

            //更新登录
            bllUser.UpdateLogin(DateTime.Now, Request.UserHostAddress, UserId);

            //设置登录信息
            if (modelSite.IsBbsLogin)
            {
                //统一注册，传入明文
                bllUser.SetLoginStatusToMingWen(UserId, UserName, modelUser.NickName, PassWord, modelUser.Email, DropCookie.SelectedValue);
            }
            else
            {
                bllUser.SetLoginStatus(UserId, UserName, modelUser.NickName, PassWord, modelUser.Email, DropCookie.SelectedValue);
            }

            if (ReturnUrl.Length != 0)
            {
                Response.Redirect(ReturnUrl);
            }
            else
            {
                Response.Redirect("main.aspx");
            }
        }
    }

    private void Exists()
    {
        if (txtUserName.Text.Trim().Length == 0)
        {
            Function.UserMsg(0, "<li>请输入用户名</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
        }

        if (txtPassWord.Text.Trim().Length == 0)
        {
            Function.UserMsg(0, "<li>请输入密码</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
        }

        if (modelSiteUser.IsLoginVer)
        {
            if (txtVerCode.Text.Trim().Length == 0)
            {
                Function.UserMsg(0, "<li>请输入验证码</li><li><a href='javascript:window.history.back()'>返回上一页</a></li>");
            }

            if (Session["CheckCode"] == null)
            {
                Function.UserMsg(0, "<li>验证码失效</li><li><a href='javascript:history.back()'>返回上一页</a></li>");
            }
            //验证码错误
            if (Session["CheckCode"].ToString() != Function.Encrypt(txtVerCode.Text.Trim().ToLower(), 0))
            {
                Function.UserMsg(0, "<li>验证码输入错误</li><li><a href='javascript:history.back()'>返回上一页</a></li>");
            }
        }
    }
}
